
'module' misc

'export'
-- Initialization
     InitMisc
-- predefineds IDs
     ErrorId DummyId UnspecId ReturnId CurrentId
-- predefined TYPEINDEX
     UnspecTypeIndex ErrorTypeIndex VoidTypeIndex
-- Tables
     NewId NewTypeIndex
-- Id list
     IDLIST IsQualifiedIdInList IsIdInList ConcatIdList
-- Equal predicates
     EqId EqQualifiedId NeId NeQualifiedId
-- Actual module     
     ActModuleQualifier IsDefinedInActualModule
-- Id meaning     
     GetIDString GetDefiningId GetIdMeaning GetDefinitionMeaning
     DefineMeaning
-- output predicates     
     GenerateClassName 
     GenerateMTabTypeName GenerateMTabVarName GenerateIVRecName
     GenerateExportedName GenerateQualifiedCooLName GenerateCooLName
     GenerateCName
     GenerateModuleName
     GenerateHiddenName
     GenerateIfdefPrelude
     
'use' ast extspecs

-------------------------------------------------------------------------------

'var' ErrorId  : ID  -- predefined ID for error situations
'var' DummyId  : ID  -- predefined ID for dummy ids
'var' UnspecId : ID  -- predefined ID for uninitialized meanings
'var' ReturnId : ID  -- predefined ID for C3IC3IRETURN
'var' CurrentId : ID -- predefined ID for C3ICURRENT

'var' UnspecTypeIndex : TYPEINDEX -- predefined TYPEINDEX for unspecified Types
'var' ErrorTypeIndex : TYPEINDEX  -- predefined TYPEINDEX for error Types
'var' VoidTypeIndex : TYPEINDEX

-------------------------------------------------------------------------------
-- Initialization
-------------------------------------------------------------------------------
     
'action' InitMisc

     'rule' InitMisc
	  DefaultPos (-> DfltPos)
	  
	  string_to_id ("_E_R_R_O_R_" -> ErrorIdent)
	  NewId (DfltPos, ErrorIdent, actual -> Error)
	  Error'State <- checked
	  Error'Meaning <- error
	  ErrorId <- Error
	  
	  string_to_id ("_D_U_M_M_Y_" -> DummyIdent)
	  NewId (DfltPos, DummyIdent, actual -> Dummy)
	  Dummy'State <- checked
	  Dummy'Meaning <- internal
	  DummyId <- Dummy
	  
	  string_to_id ("_U_N_S_P_E_C_" -> UnspecIdent)
	  NewId (DfltPos, UnspecIdent, actual -> Unspec)
	  Unspec'State <- checked
	  Unspec'Meaning <- unspec
	  UnspecId <- Unspec

	  string_to_id ("C3IRETURN" -> ReturnIdent)
	  NewId (DfltPos, ReturnIdent, actual -> Return)
	  Return'State <- checked
	  Return'Meaning <- internal
	  ReturnId <- Return
	  
	  string_to_id( "CURRENT" -> CurrentIdent)
	  NewId (DfltPos, CurrentIdent, actual -> Current)
	  Current'State <- checked
	  Current'Meaning <- internal
	  CurrentId <- Current
	  
	  NewTypeIndex (DfltPos, unspec -> UnspecTypeI)
	  UnspecTypeIndex <- UnspecTypeI
	  
	  NewTypeIndex (DfltPos, error -> ErrorTypeI)
	  ErrorTypeIndex <- ErrorTypeI
	  
	  NewTypeIndex (DfltPos, simple (void) -> VoidTypeI)
	  VoidTypeIndex <- VoidTypeI
	  
------------------------------------------------------------------------------
-- Identifier table
-------------------------------------------------------------------------------
     
'action' NewId (POS, Ident, QUALIFIER -> ID)
     
     'rule' NewId (Pos, I, Qualifier -> New) :
	  New::ID
	  New'Pos     <- Pos
	  New'Ident   <- I
	  New'Module  <- Qualifier
	  New'State   <- undeclared
	  New'Meaning <- unspec

-------------------------------------------------------------------------------
-- Type table
-------------------------------------------------------------------------------

'action' NewTypeIndex (POS, TYPE -> TYPEINDEX)

     'rule' NewTypeIndex (Pos, Type -> TypeIndex) :
	  TypeIndex::TYPEINDEX
	  TypeIndex'Pos  <- Pos
	  TypeIndex'Type <- Type
	  (|
	       where (Type -> generic (_))
	       TypeIndex'State <- undeclared
	       TypeIndex'Flag  <- unspecified
	  ||
	       where (Type -> composite (_))
	       TypeIndex'State <- undeclared
	       TypeIndex'Flag  <- unspecified
	  || 
	       TypeIndex'State <- checked
	       TypeIndex'Flag  <- specified
	  |) 
	  
-------------------------------------------------------------------------------
-- Id list
-------------------------------------------------------------------------------
	
'type' IDLIST
     idlist (Id : ID, IDLIST)
     nil

-------------------------------------------------------------------------------
     
'condition' IsQualifiedIdInList (Name : ID, List : IDLIST)

     'rule' IsQualifiedIdInList (Id1, idlist (Id2, _)) :
	  EqQualifiedId (Id1, Id2)
	  
     'rule' IsQualifiedIdInList (Id, idlist (_, Tail)) :
	  IsQualifiedIdInList (Id, Tail) 

-------------------------------------------------------------------------------
     
'condition' IsIdInList (Name : ID, List : IDLIST -> IdInList : ID)

     'rule' IsIdInList (Id1, idlist (Id2, _) -> Id2) :
	  EqId (Id1, Id2)
	  
     'rule' IsIdInList (Id, idlist (_, Tail) -> Id2) :
	  IsIdInList (Id, Tail -> Id2) 

---------------------------------------------------------------------------

'action' ConcatIdList (IDLIST, IDLIST -> IDLIST)
     
     'rule' ConcatIdList (idlist (Head, Tail), List -> idlist (Head, Tail2)) :
	  ConcatIdList (Tail, List -> Tail2)
	  
     'rule' ConcatIdList (nil, List -> List) :
	  
-------------------------------------------------------------------------------
-- Equal predicates
-------------------------------------------------------------------------------
	
'condition' EqId (ID, ID)
     
     'rule' EqId (Id1, Id2) :
	  Id1'Ident -> Ident1
	  Id2'Ident -> Ident2
	  eq (Ident1, Ident2)
	  
-------------------------------------------------------------------------------

'condition' EqQualifiedId (ID, ID)
     
     'rule' EqQualifiedId (Id1, Id2) :
	  EqId (Id1, Id2)
	  Id1'Module -> Qualifier1
	  Id2'Module -> Qualifier2
	  EqQualifier (Qualifier1, Qualifier2)
	  
-------------------------------------------------------------------------------

'type' MISCBOOL
     true
     false

-------------------------------------------------------------------------------

'condition' NeId (ID, ID)

     'rule' NeId (Id1, Id2)
	  Id1'Ident -> Ident1
	  Id2'Ident -> Ident2
	  ne (Ident1, Ident2)

-------------------------------------------------------------------------------

'condition' NeQualifiedId (ID, ID)

     'rule' NeQualifiedId (Id1, Id2) :
	  Id1'Module -> Qualifier1
	  Id2'Module -> Qualifier2
	  NeQualifier (Qualifier1, Qualifier2 -> true)
	  
     'rule' NeQualifiedId (Id1, Id2) :
	  NeId (Id1, Id2)
	  
-------------------------------------------------------------------------------

'condition' EqQualifier (QUALIFIER, QUALIFIER)	  
	  
     'rule' EqQualifier (actual, actual) :
	  
     'rule' EqQualifier (actual, module (Id2)) :
	  ActModuleQualifier -> module (Id1)
	  EqId (Id1, Id2)

     'rule' EqQualifier (module (Id1), actual) :
	  ActModuleQualifier -> module (Id2)
	  EqId (Id1, Id2)

     'rule' EqQualifier (module (Id1), module (Id2)) :
	  EqId (Id1, Id2)
	  
-------------------------------------------------------------------------------

'action' NeQualifier (QUALIFIER, QUALIFIER -> MISCBOOL)
     
     'rule' NeQualifier (Q1, Q2 -> false) :
	  EqQualifier (Q1, Q2)
	  
     'rule' NeQualifier (Q1, Q2 -> true) :
	  
-------------------------------------------------------------------------------
-- Actual module
-------------------------------------------------------------------------------

'var' ActModuleQualifier : QUALIFIER
	  
---------------------------------------------------------------------------
	  
'condition' IsDefinedInActualModule (ID)
     
     'rule' IsDefinedInActualModule (Id) :
	  Id'Module -> actual
	  
     'rule' IsDefinedInActualModule (Id) :
	  Id'Module -> module (MId)
	  ActModuleQualifier -> module (ActModule)
	  EqId (ActModule, MId)
	  
-------------------------------------------------------------------------------
-- Id meaning
-------------------------------------------------------------------------------

'action' GetIDString (ID -> STRING)

     'rule' GetIDString (Id -> String)
	  Id'Ident -> I
	  id_to_string (I -> String)

-------------------------------------------------------------------------------
	  
'action' GetDefiningId (ID -> ID)

     'rule' GetDefiningId (Id1 -> Id3)
	  Id1'Meaning ->definingid (Id2)
	  GetDefiningId (Id2 -> Id3)
 
     'rule' GetDefiningId (Id1 -> Id1)

-------------------------------------------------------------------------------
	  
'action' GetIdMeaning (ID -> MEANING)
	  
     'rule' GetIdMeaning (Id1 -> Meaning) :
	  GetDefiningId (Id1 -> Id2)
	  Id2'Meaning -> Meaning

-------------------------------------------------------------------------------
	  
'action' GetDefinitionMeaning (MEANING -> MEANING)
	  
     'rule' GetDefinitionMeaning (definingid (Id) -> Meaning) :
	  GetIdMeaning (Id -> Meaning)
	  
     'rule' GetDefinitionMeaning (Meaning -> Meaning) :
	  
-------------------------------------------------------------------------------

'action' DefineMeaning (ID, MEANING)
     
     'rule' DefineMeaning (Id, Meaning) :
	  Id'State   <- declared
	  Id'Meaning <- Meaning
	  ActModuleQualifier -> ModuleQualifier
	  Id'Module  <- ModuleQualifier

-------------------------------------------------------------------------------
-- output predicates
-------------------------------------------------------------------------------

'action' GenerateClassName (ID)
     
     'rule' GenerateClassName (Id) :
	  Write ("OBJECTC3I")
	  GenerateQualifiedCooLName (Id)
	  
-- GenerateMTabTypeName -----------------------------------------------------

'action' GenerateMTabTypeName (ID)
     
     'rule' GenerateMTabTypeName (Id) :
	  GenerateHiddenName ("MTAB")
	  GenerateQualifiedCooLName (Id)
	  
-- GenerateMTabVarName ------------------------------------------------------

'action' GenerateMTabVarName (ID)
     
     'rule' GenerateMTabVarName (Id) :
	  GenerateHiddenName ("MTABR")
	  GenerateQualifiedCooLName (Id)
	  
-- GenerateIVRecName --------------------------------------------------------

'action' GenerateIVRecName (ID)
     
     'rule' GenerateIVRecName (Id) :
	  GenerateHiddenName ("IV")
	  GenerateQualifiedCooLName (Id)
	  
-- GenerateExportedName -----------------------------------------------------

'action' GenerateExportedName (EXPORTFLAG, ID)
     
     'rule' GenerateExportedName (root, Id) :
	  GenerateCName (Id)

     'rule' GenerateExportedName (foreign , Id) :
	  GenerateCName (Id)
     
     'rule' GenerateExportedName (cool, Id) :
	  GenerateQualifiedCooLName (Id)
	  
-- GenerateQualifiedCooLName ------------------------------------------------

'action' GenerateQualifiedCooLName (ID)

     'rule' GenerateQualifiedCooLName (Id)
	  GenerateModuleName (Id)
	  GenerateCooLName (Id)

-- GenerateCooLName ---------------------------------------------------------

'action' GenerateCooLName (ID)

     'rule' GenerateCooLName (Id)
	  GetIDString (Id -> Repr)
	  Write( "C3I" )
	  Write (Repr)

-- GenerateCName ---------------------------------------------------------

'action' GenerateCName (ID)

    'rule' GenerateCName (Id)
	 GetIDString (Id -> Repr)
	 Write (Repr)

-- GenerateModuleName -------------------------------------------------------

'action' GenerateModuleName (ID)

     'rule' GenerateModuleName (Id)
	  Id'Module -> module (ModuleId)
	  GetIDString (ModuleId -> ModuleRepr)
	  Write (ModuleRepr)

-- GenerateHiddenName -------------------------------------------------------

'action' GenerateHiddenName( STRING )

    'rule' GenerateHiddenName( NameString )
        Write( "C3IC3I" )
        Write( NameString )

-- GenerateIfdefPrelude -----------------------------------------------------

'action' GenerateIfdefPrelude
     
     'rule' GenerateIfdefPrelude :
        Write( "C3IC3IC3I" )
	 
-------------------------------------------------------------------------------

'end'
