#
# RMS Makefile for CooL Compiler
#
# $__Header$
#

# --------------------------------------------------------------------
#		system specification 
# --------------------------------------------------------------------

# Path to this node system relative to the root of the
# repository area defined above (e.g. src/vc/save).

NODEPATH = cool/src

# A short name for this node system

NODENAME = Compiler

# --------------------------------------------------------------------
#		the system's components
# --------------------------------------------------------------------

#
# The system (program, library, etc.) to be built. If you want to
# manage multiple programs, you should introduce multiple targets
# (like BIN1TARGET BIN2TARGET or any better names). In this case you 
# have to adjust the system building actions accordingly.

BINTARGET = cool.exe
LIBTARGET =
SHAREDLIBTARGET =

# The release number generator. The version number of this file will
# be used as release identifier for the whole system.

VERSIONFILE   = Release.c	   # source
VERSIONOBJECT =	Release.$(OBJSUFF) # derived (if source contains program code)

# The names of the subdirectories containing subsystems which are also
# to be built.

SUBSYSTEMS =

# The regular source and header files.
#
# PUBLIC headers (of a library) would be delivered (INCLUDEPATH) to the user.
# GLOBAL and LOCAL headers wouldn't be installed.

# GENTLE Sources

GENTLE_SRC = ast.g extspecs.g misc.g print.g \
	     grammar.g \
	     context.g const.g decls.g expr.g scopes.g stmts.g types.g \
	     coder.g mapping.g codetype.g codeexpr.g codestmt.g codedecl.g
LEX_SRC    = COMMENTS.b LAYOUT.b LITBLOCK.b LEXDEF.b LEXFUNC.b SETPOS.b \
	     IDENTIFIER.t INTCONST.t DOUBLECONST.t CHARCONST.t STRINGCONST.t \
	     NEXTUNIT.t EOFILE.t

# C Sources

PUBLIC_C_HDR =
GLOBAL_C_HDR =
LOCAL_C_HDR  =         errmsg.h files.h idents.h output.h pos.h strlit.h
C_SRC        = arith.c errmsg.c files.c idents.c output.c pos.c strlit.c \
	       main.c grts.c

# Templates

PUBLIC_TMPL =
GLOBAL_TMPL =
LOCAL_TMPL  =

# All sources

HEADERS = $(PUBLIC_C_HDR) $(GLOBAL_C_HDR) $(LOCAL_C_HDR) \
          $(PUBLIC_TMPL) $(GLOBAL_TMPL) $(LOCAL_TMPL)
SOURCES = $(GENTLE_SRC) $(LEX_SRC) $(C_SRC)

# Special derived sources

DERIVED_C = $(GENTLE_SRC:.g=.c) gen.c lex.c
DERIVED_H = gen.h
DERIVED_O = $(GENTLE_SRC:.g=.obj) gen.$(OBJSUFF) lex.$(OBJSUFF)

# The manuals

MANUALS = $(MAN1) $(MAN3) $(MAN4) $(MAN5) $(MAN7)
MAN1 = cool.1
MAN3 =
MAN4 =
MAN5 =
MAN7 =

# All source components of the system (should not be changed)

COMPONENTS = $(MANUALS) $(HEADERS) $(SOURCES) Shapefile Makefile Dependencies

# The derived files. All files, that are automatically produced during
# a build process should be listed here.

OBJSUFF = obj
OBJECTS = $(VERSIONOBJECT) $(DERIVED_O) $(C_SRC:.c=.obj)

PUBLIC_HEADERS = $(PUBLIC_C_HDR) $(PUBLIC_TMPL)
GLOBAL_HEADERS = $(GLOBAL_C_HDR) $(GLOBAL_TMPL)

TMPS    = 

# --------------------------------------------------------------------
#		environment specifications and locations
# --------------------------------------------------------------------

# The operating system, $(_TARGET) shall be built for.

SYSTEM = s_win_nt

# The processor type.

MACHINE = m_i386

# The object file format

OFILEFMT = 

# The C Compiler

CCOMP = ms
#CCOMP = att

# Locations and modes for the installation of executables, header
# files, libraries and manuals.

INSTALLBASE    = h:/$(CCOMP)
INSTALLBINPATH = $(INSTALLBASE)/bin
INSTALLINCPATH = $(INSTALLBASE)/include
INSTALLLIBPATH = $(INSTALLBASE)/lib
INSTALLMANPATH = $(INSTALLBASE)/man

# --------------------------------------------------------------------
#		tools, flags, libraries etc.
# --------------------------------------------------------------------

# The following macros will be overwritten by the system root makefile

MAKE  = make
SHELL = cmd.exe

CC  = cl
#CC  = gcc
CPP = $(CC) -E
LD  = link32

MAKECPPFLAGS  = -P
MAKECOOLFLAGS =
MAKECFLAGS    = -nologo -W0 -YX -Ox -DYY_USE_PROTOS -DMSDOS 
#MAKECFLAGS    = -fno-builtin -O -D__stdcall= -D__cdecl= 
MAKELDFLAGS   = -nologo
#MAKELDFLAGS   = -nologo -stack:0x400000,0x400000

# Gentle

GENTLE      = gentle
GENTLEFLAGS = 
CHANGEPRINT = $(BASE)/bin/changePrint
REFLEX      = reflex

# Yacc (debug : CFLAGS += -DYYDEBUG, bison : YFLAGS += -t)
#       if bison use gcc

YACC   = bison
YFLAGS = -yl
#YACC   = yacc
#YFLAGS = -l

# Lex

LEX    = flex
LFLAGS = -L

SYSLIBS  = libc.lib oldnames.lib
#SYSLIBS  = libgcc2.lib libc.lib oldnames.lib

RANLIB   = 

# The following macros will NOT be overwritten by the system root makefile

# Preprocessor switches. (eg. -DDEBUG)

SWITCHES  = -DNDEBUG -D_X86_ -D_CONSOLE -D$(MACHINE) -D$(SYSTEM)

INCLUDES  = 

LOCALLIBS = 

CFLAGS     = $(INCLUDES) $(MAKECFLAGS) $(SWITCHES)
LDFLAGS    = $(MAKELDFLAGS)

# --------------------------------------------------------------------
#			default targets
# --------------------------------------------------------------------

# The default action (do not change)

all: build

# --------------------------------------------------------------------
#		Dependencies
# --------------------------------------------------------------------

include Dependencies

# --------------------------------------------------------------------
#		implicit rules 
# --------------------------------------------------------------------

.SUFFIXES: .g

.g.c:
	$(GENTLE) $(GENTLEFLAGS) $*.g

.c.obj:
	$(CC) $(CFLAGS) -c $*.c

# --------------------------------------------------------------------
#		special rules 
# --------------------------------------------------------------------

ast.c : ast.g extspecs.g
	$(GENTLE) $(GENTLEFLAGS) ast.g

gen.c : gen.y
	$(YACC) $(YFLAGS) gen.y
	sed -e "s@#include <values\.h>@/* #include <values\.h> */@" < y.tab.c > $@
	rm -f y.tab.c

lex.l : $(LEX_SRC) gen.lit gen.tkn gen.h
	$(REFLEX)
	mv gen.l $@

lex.c : lex.l
	$(LEX) $(LFLAGS) -t lex.l > $@

# --------------------------------------------------------------------
#		other targets
# --------------------------------------------------------------------

# The final system building action.

targets: $(BINTARGET)

# Construction of a binary would look like:
$(BINTARGET): $(OBJECTS)
	$(LD) $(LDFLAGS) -out:$(BINTARGET) $(OBJECTS) \
              $(LOCALLIBS) $(SYSLIBS)

# Contruction of derived sources (portable binaries)

preinstall: $(DERIVED_C)

# The cleanup action. Removes all automatically rederivable files.

cleanall : doclean
	rm -f $(DERIVED_C) $(DERIVED_H) lex.l gen.* y.output

doclean:
	rm -f $(BINTARGET) $(ALIASES) $(LIBTARGET) $(SHAREDLIBTARGET) \
	      $(OBJECTS) $(TMPS)

build : targets

clean : doclean

install : installbin installman

installbin : $(BINTARGET)
	cp $(BINTARGET) $(INSTALLBINPATH)

installman :
	cp $(MANUALS) $(INSTALLMANPATH)
