(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : Doublefield
-- Author   : Gold, Herbert
-- angelegt : 1993-12-02
---------------------------------------------------------------------*)
SPECIFICATION Doublefield

IMPORT Format       FROM Format;
IMPORT WindowObject FROM WindowObj;

TYPE Doublefield = Format 
     OBJECT( IN theOwner : WindowObject, IN name : STRING )

PUBLIC

  METHOD GetValue : DOUBLE;
  METHOD PutValue( IN value : DOUBLE );

  METHOD OnGetContent( IN action : METHOD() : DOUBLE ) : Doublefield;
  METHOD OnPutContent( IN action : METHOD( IN DOUBLE ) ) : Doublefield;

PROTECTED

  METHOD get;
  METHOD put;

STATE
  getAction : METHOD() : DOUBLE;
  putAction : METHOD(IN DOUBLE);

END OBJECT;

END SPECIFICATION;    (* Doublefield *)

