(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : Label
-- Author   : Gold, Herbert
-- angelegt : 1993-12-02
---------------------------------------------------------------------*)
SPECIFICATION Label

IMPORT Control      FROM Control;
IMPORT WindowObject FROM WindowObj;

TYPE Label = Control 
     OBJECT( IN theOwner : WindowObject, IN name : STRING )

PUBLIC

  METHOD ClearOn : Label;
-- clears title if method "Clear" is invoked.
  METHOD ClearOff : Label;
-- does not clear title if method "Clear" is invoked.

  METHOD PutValue( IN value : STRING );
  
  METHOD OnGetContent( IN action : METHOD() : STRING ) : Label;

PROTECTED

  METHOD get;
  METHOD put;
  METHOD getValue : STRING;      -- from Screen dummy, since doesn't apply

STATE
  getAction : METHOD() : STRING;
  DoNotClear: BOOL;              -- do not clear  a Label

END OBJECT;

END SPECIFICATION;         (* Label *)

