(*---------------------------------------------------------------------
-- Dialog Interface Objects
-----------------------------------------------------------------------
-- Copyright: (c) Sietec GmbH & Co oHG
--            All rights reserved 1993
-----------------------------------------------------------------------
-- Modul    : Table
-- Author   : Gold, Herbert
-- angelegt : 1993-12-02
---------------------------------------------------------------------*)
SPECIFICATION Table

IMPORT WindowObject    FROM WindowObj;
IMPORT Control         FROM Control;
IMPORT PushButton      FROM Push;
IMPORT ToggleButton    FROM Toggle;
IMPORT RadioButton     FROM Radio;
IMPORT ComboBox        FROM ComboBox;
IMPORT Bcdfield        FROM Bcdfield;
IMPORT Datefield       FROM Datefield;
IMPORT Doublefield     FROM Doublefield;
IMPORT Intfield        FROM Intfield;
IMPORT Stringfield     FROM Stringfield;
IMPORT Label           FROM Label;
IMPORT Textfield       FROM Textfield;
IMPORT BCD	       FROM Bcd;
IMPORT Date            FROM Date;

TYPE Table = Control
             OBJECT( IN theOwner : WindowObject, IN name : STRING )

PUBLIC

  METHOD AddPushButton( IN name : STRING, 
                        IN action : METHOD ) : PushButton;
  METHOD AddToggleButton( IN name : STRING,
                          IN getV : METHOD() : BOOL,
                          IN putV : METHOD( IN BOOL ),
                          IN exep : METHOD( IN METHOD ) : BOOL
                        ) : ToggleButton;
  METHOD AddRadioButton(  IN name : STRING,
                          IN getV : METHOD() : BOOL,
                          IN putV : METHOD( IN BOOL ),
                          IN exep : METHOD( IN METHOD ) : BOOL
                        ) : RadioButton;

  METHOD AddComboBox( IN name : STRING,
                      IN getV : METHOD() : STRING,
                      IN putV : METHOD( IN STRING ),
                      IN exep : METHOD( IN METHOD ) : BOOL,
                      IN getItem : METHOD( IN INT ) : STRING
                    ) : ComboBox;

  METHOD AddBcdfield( IN name : STRING,
                      IN getV : METHOD() : BCD,
                      IN putV : METHOD( IN BCD ),
                      IN exep : METHOD( IN METHOD ) : BOOL
                    ) : Bcdfield;
  METHOD AddDatefield( IN name : STRING,
                       IN getV : METHOD() : Date,
                       IN putV : METHOD( IN Date ),
                       IN exep : METHOD( IN METHOD ) : BOOL
                     ) : Datefield;
  METHOD AddDoublefield( IN name : STRING,
                         IN getV : METHOD() : DOUBLE,
                         IN putV : METHOD( IN DOUBLE ),
                         IN exep : METHOD( IN METHOD ) : BOOL
                       ) : Doublefield;
  METHOD AddIntfield( IN name : STRING,
                      IN getV : METHOD() : INT,
                      IN putV : METHOD( IN INT ),
                      IN exep : METHOD( IN METHOD ) : BOOL
                    ) : Intfield;
  METHOD AddStringfield( IN name : STRING,
                         IN getV : METHOD() : STRING,
                         IN putV : METHOD( IN STRING ),
                         IN exep : METHOD( IN METHOD ) : BOOL
                       ) : Stringfield;

  METHOD AddLabel( IN name : STRING, 
                   IN getV : METHOD() : STRING ) : Label;

  METHOD AddTextfield( IN name : STRING,
                       IN getV : METHOD() : REF ARRAY OF CHAR,
                       IN putV : METHOD( IN REF ARRAY OF CHAR ),
                       IN exep : METHOD( IN METHOD ) : BOOL
                     ) : Textfield;

  METHOD OnGetContent( IN action : METHOD( IN INT, IN INT ) ) : Table;

  METHOD SetTop( IN row : INT ) : Table;
-- make row the visible top row. 

PROTECTED

  METHOD visibleRowsCount : INT;  -- doi: getVisibleRows
 
  METHOD get;
  METHOD put;
  METHOD getValue : STRING;       -- from Screen


STATE
  ColumnsLink : Control;  -- for parts=columns of a table
  getAction : METHOD( IN INT, IN INT );

END OBJECT;

END SPECIFICATION;    (* Table *)

