/*--------------------------------------------------------------------
 *
 *              C - Interface for CooL - Doi
 *
 *  This module contains the Motif extension of Doi
 *
 *------------------------------------------------------------------
 *------- external used functions ----------------------------------
 *------------------------------------------------------------------
 *    void   DoiSetListPosition    (Widget,int);
 *    void   DoiSelectListPos      (Widget,int);
 *    void   DoiDeselectListPos    (Widget,int);
 *    void   DoiAddListItem        (Widget,char*,int);
 *    void   DoiDeleteListItem     (Widget,int);
 *    int    DoiGetListCount       (Widget,int*);
 *    void   DoiEmptyList          (Widget);
 *    void   DoiDeselectAllItems   (Widget);
 *    int    DoiGetSelectedItem    (Widget,int*,char**);
 *    void   DoiAddTabGroup        (Widget);
 *    void   DoiRemoveTabGroup     (Widget);
 *    void   DoiCommandAppendValue (Widget,char*);
 *    void   DoiCommandError       (Widget,char*);
 *    void   DoiCommandSetValue    (Widget,char*);
 *    int    DoiGetRows            (Widget,int*);
 *    int    DoiGetColumns         (Widget,int*);
 *    int    DoiGetVisibleRows     (Widget,int*);
 *    void   DoiSetTopRow          (Widget,int);
 *    int    DoiGetSelectedRow     (Widget,int*);
 *    void   DoiEmptyTable         (Widget);
 *    void   DoiAddRows            (Widget,int,int);
 *    void   DoiDeleteRow          (Widget,int);
 *    void   DoiSelectRow          (Widget,int);
 *    void   DoiDeselectRow        (Widget,int);
 *    void   DoiDeselectTable      (Widget);
 *    void   DoiSetInputFocus      (Widget);
 *    void   DoiSetInputFocusTable (Widget,int,int);
 *------------------------------------------------------------------*/

#ifndef FORMAT
void DoiSelectRow          (){return   ;}
int  DoiGetColumns         (){return -1;}
int  DoiGetSelectedRow     (){return -1;}
void DoiSetTopRow          (){return   ;}
void DoiAddRows            (){return   ;}
void DoiDeleteRow          (){return   ;}
void DoiEmptyTable         (){return   ;}
int  DoiGetVisibleRows     (){return -1;}
void DoiDeselectRow        (){return   ;}
int  DoiGetRows            (){return -1;}
void DoiDeselectTable      (){return   ;}
void DoiSetInputFocusTable (){return   ;}
#endif

/*------------------------------------------------------------------*/
#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/Command.h>
#include <Xm/List.h>
#include <Xm/ScrolledW.h>
#ifdef FORMAT
#include <Xc/FormatAlph.h>
#include <Xc/FormatNum.h>
#include <Xc/Format.h>
#include <Xc/FormatDate.h>
#include <Xc/Table.h>
#endif

/*------------------------------------------------------------------*/
extern int DoiDebugFlag;

/*------------------------------------------------------------------*/
void DoiSetInputFocus(
  /* sets the input focus */
  Widget PRwidget
  )
{
  if (DoiDebugFlag) printf("DoiSetInputFocus\n");

  if (PRwidget == NULL) return;

  XmProcessTraversal (PRwidget,XmTRAVERSE_CURRENT);
}

/*------------------------------------------------------------------*/
/* special functions for List widgets */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
void DoiSetListPosition(
  /* sets the list position */
  Widget PRlist,
  int PRpos
  )
{
  if (DoiDebugFlag) printf("DoiSetListPosition\n");

  if (PRlist == NULL) return;
  if (XtClass(PRlist) != xmListWidgetClass)
      return;
  XmListSetPos (PRlist,PRpos);
}

/*------------------------------------------------------------------*/
void DoiSelectListPos(
  /* selects a list item */
  Widget PRlist,
  int PRpos
  )
{
  if (DoiDebugFlag) printf("DoiSelectListPos\n");

  if (PRlist == NULL) return;
  if (XtClass(PRlist) != xmListWidgetClass)
      return;
  XmListSelectPos (PRlist,PRpos,False);
}

/*------------------------------------------------------------------*/
void DoiDeselectListPos(
  /* selects a list item */
  Widget PRlist,
  int PRpos
  )
{
  if (DoiDebugFlag) printf("DoiDeselectListPos\n");

  if (PRlist == NULL) return;

  if (XtClass(PRlist) != xmListWidgetClass)
      return;
  XmListDeselectPos (PRlist,PRpos);
}

/*------------------------------------------------------------------*/
void DoiAddListItem (
  /* inserts an item after a given position */
  Widget PRlist,
  char *PRitem, 
  int PRpos
  )
{
  if (DoiDebugFlag) printf("DoiAddListItem\n");

  if (PRlist == NULL) return;

  if (XtClass(PRlist) != xmListWidgetClass)
      return;

  XmListAddItemUnselected(PRlist,XmStringCreateSimple(PRitem),PRpos);
}

/*------------------------------------------------------------------*/
void DoiDeleteListItem (
  /*  deletes an item from the specified list widget */
  Widget PRlist,
  int PRpos
  )
{
  if (DoiDebugFlag) printf("DoiDeleteListItem\n");

  if (PRlist == NULL) return;

  if (XtClass(PRlist) != xmListWidgetClass)
      return;

  XmListDeletePos(PRlist,PRpos);
}

/*------------------------------------------------------------------*/
int DoiGetListCount(
  /* reads the list count */
  Widget PRlist,
  int *PRcount
  )
{
  if (DoiDebugFlag) printf("DoiGetListCount\n");

  if (PRlist == NULL) return -1;

  if (XtClass(PRlist) != xmListWidgetClass)
      return -1;
  XtVaGetValues(PRlist,XmNitemCount,PRcount,NULL);
  return 0;
}

/*------------------------------------------------------------------*/
void DoiEmptyList(
  /* removes all rows of a list */
  Widget PRlist
  )
{  
  if (DoiDebugFlag) printf("DoiEmptyList\n");

  if (PRlist == NULL) return;

  if (XtClass(PRlist) != xmListWidgetClass)
      return;
  XmListDeleteAllItems(PRlist);
}

/*------------------------------------------------------------------*/
void DoiDeselectAllItems(
  /* deselect all items of a list */
  Widget PRlist
  )
{  
  if (DoiDebugFlag) printf("DoiDeselectAllItems\n");

  if (PRlist == NULL) return;

  if (XtClass(PRlist) != xmListWidgetClass)
      return;

  XmListDeselectAllItems(PRlist);
}
  
/*------------------------------------------------------------------*/
int DoiGetSelectedItem(
  /* returns the selected item and the number of all selected items */
  Widget PRlist,
  char  *PRitem,
  int    PRmaxLength
  )
{  
  int count;

  if (DoiDebugFlag) printf("DoiGetSelectedItem\n");

  if (PRlist == NULL) return -1;

  if (XtClass(PRlist) != xmListWidgetClass){
      return -1;
  }

  count = 0;
  XtVaGetValues(PRlist,XmNselectedItemCount,&count,NULL);
  if (DoiDebugFlag) printf("DoiGetSelectedItem count =%d\n",count);
  if (count){
    XmStringTable stab = NULL;
    XtVaGetValues(PRlist,XmNselectedItems,&stab,NULL);
    if (stab != NULL){
      char *string;
      XmStringGetLtoR (stab[0],XmSTRING_DEFAULT_CHARSET,&string);
      if (string && strlen(string) < (size_t)PRmaxLength){
        strcpy (PRitem,string);
        return 0;
      }else
        return -1;
    }
  } else if (PRmaxLength > 0) {
    *PRitem = '\0';
    return 0;
  }
  return -1;
}
  

/*------------------------------------------------------------------*/
/*------------------------------------------------------------------*/
/* special functions for tab groups */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
void DoiAddTabGroup(
  /*  adds a widget to the tab group */
  Widget PRwidget
 )
{
  if (DoiDebugFlag) printf("DoiAddTabGroup\n");

  if (PRwidget != NULL)
    XmAddTabGroup(PRwidget);
}

/*------------------------------------------------------------------*/
void DoiRemoveTabGroup(
  /* removes a widget from the tab group*/
  Widget PRwidget
 )
{
  if (DoiDebugFlag) printf("DoiRemoveTabGroup\n");

  if (PRwidget != NULL)
    XmRemoveTabGroup(PRwidget);
}


/*------------------------------------------------------------------*/
/*------------------------------------------------------------------*/
/* special functions for command widgets */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
void DoiCommandAppendValue(
  /* appends Value in CommandTextField*/
  Widget PRcommand,
  char *PRvalue)
{
  if (DoiDebugFlag) printf("DoiCommandAppendValue\n");

  if (PRcommand == NULL) return;

  if (XtClass(PRcommand) != xmCommandWidgetClass) return;

  XmCommandAppendValue (PRcommand, 
           XmStringCreateSimple(PRvalue));
  return;
}

/*------------------------------------------------------------------*/
void DoiCommandError(
  /* Insert error message into history list */
  Widget PRcommand,
  char *PRvalue)
{
  if (DoiDebugFlag) printf("DoiCommandError\n");

  if (PRcommand == NULL) return;

  if (XtClass(PRcommand) != xmCommandWidgetClass) return;

  XmCommandError (PRcommand, 
           XmStringCreateSimple(PRvalue));
  return;
}

/*------------------------------------------------------------------*/
void DoiCommandSetValue(
  /* replaces the text on the command line */
  Widget PRcommand,
  char *PRvalue)
{
  if (DoiDebugFlag) printf("DoiCommandSetValue\n");

  if (PRcommand == NULL) return;

  if (XtClass(PRcommand) != xmCommandWidgetClass) return;

  XmCommandSetValue (PRcommand, 
           XmStringCreateSimple(PRvalue));
  return;
}
#ifdef FORMAT
/*------------------------------------------------------------------*/
/*------------------------------------------------------------------*/
/* Functions for Table and Format widget */
/**/
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
int DoiGetRows (
  Widget PRtable,
  int*   PRrows)
{
  if (DoiDebugFlag) printf("DoiGetRows\n");

  if (PRtable == NULL) return -1;

  if (XtClass(PRtable) != xcTableWidgetClass) return -1;
  XtVaGetValues (PRtable, XcNtableRowCount, PRrows, NULL);
  if (DoiDebugFlag) printf("DoiGetRows=%d\n",*PRrows);
  return 0;
}

/*------------------------------------------------------------------*/
int DoiGetColumns (
  Widget PRtable,
  int*   PRcolumns)
{
  if (DoiDebugFlag) printf("DoiGetColumns\n");

  if (PRtable == NULL) return -1;

  if (XtClass(PRtable) != xcTableWidgetClass) return -1;
  XtVaGetValues (PRtable, XcNtableColumnCount, PRcolumns, NULL);
  if (DoiDebugFlag) printf("DoiGetColumns=%d\n",*PRcolumns);
  return 0;
}

/*------------------------------------------------------------------*/
int DoiGetVisibleRows (
  Widget PRtable,
  int*   PRvisRows )
{
  if (DoiDebugFlag) printf("DoiGetVisibleRows\n");

  if (PRtable == NULL) return -1;

  if (XtClass(PRtable) != xcTableWidgetClass) return -1;
  XtVaGetValues (PRtable, XcNvisibleRows, PRvisRows, NULL);
  if (DoiDebugFlag) printf("DoiGetVisibleRows=%d\n",PRvisRows);
  return 0;
}

/*------------------------------------------------------------------*/
void DoiSetTopRow (
  Widget PRtable,
  int    PRrow)
{
  if (DoiDebugFlag) printf("DoiSetTopRow(%d)\n",PRrow);

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;
  XtVaSetValues (PRtable, XcNviewRowIndex, PRrow, NULL);
  return;
}

/*------------------------------------------------------------------*/
int DoiGetSelectedRow (
  /* returns the first selected row in the table widget */
  Widget PRtable,
  int*   PRrow)
{
  XcTableArea * array;
  int count, rmin, minRow;

  if (DoiDebugFlag) printf("DoiGetSelectedRow\n");

  if (PRtable == NULL) return -1;

  if (XtClass(PRtable) != xcTableWidgetClass) return -1;

  if (XcTableGetSelectedArray(PRtable,&array,&count)) return -1;
  if (count < 1) return -1;

  /* and now we must find the top most row, the minimum! */
  minRow = array[count-1].top_row; /* any row doesn't matter */
  while ( count-- > 0) {
    rmin =  (array[count].top_row > array[count].bottom_row)?
             array[count].bottom_row:array[count].top_row;
    if (rmin < minRow) minRow = rmin; 
  }
  *PRrow = minRow;
  if (DoiDebugFlag) printf("DoiGetSelectedRow=%d\n",minRow);
  return 0;
}

/*------------------------------------------------------------------*/
void DoiEmptyTable (
  /* deletes all rows of a table, columns still exist */
  Widget PRtable)
{
  int i, rows, columns;

  if (DoiDebugFlag) printf("DoiEmptyTable\n");

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;

  XtVaGetValues (PRtable, XcNtableRowCount, &rows, NULL);
  if (DoiDebugFlag) printf("DoiEmptyTable deletes %d rows\n",rows);

  /* first deselect the table */
  XcTableDeselect (PRtable,0,0);
  XcTableDeleteRows (PRtable,1,rows);
}

/*------------------------------------------------------------------*/
  void DoiAddRows (
  Widget PRtable,
  int    PRrows, /* number of inserted rows */
  int    PRpos)  /* insert after position */
{
  int i, rows;

  if (DoiDebugFlag) printf("DoiAddRows(%d,%d)\n",PRrows,PRpos);

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;

  PRpos++;
  XtVaGetValues (PRtable, XcNtableRowCount, &rows, NULL);
  if (PRpos >  rows) PRpos = -1;
  for (i = 0; i < PRrows; i++)
    if (XcTableAddRowValueArray (PRtable,NULL,0,PRpos))
      if (DoiDebugFlag) printf ("XcTableAddRowValueArray cannot add row %d\n",i);
}

/*------------------------------------------------------------------*/
  void DoiDeleteRow (
  Widget PRtable,
  int    PRrow)
{
  if (DoiDebugFlag) printf("DoiDeleteRow(%d)\n",PRrow);

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;

  if (XcTableDeleteRows (PRtable,PRrow,1))
    if (DoiDebugFlag) printf ("XcTableDeleteRows reported error\n");
}

/*------------------------------------------------------------------*/
void DoiSelectRow (
  /* selects a row in a table */
  Widget PRtable,
  int PRrow)
{
  if (DoiDebugFlag) printf("DoiSelectRow(%d)\n",PRrow);

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;

  XcTableSetSelection (PRtable, PRrow, 0);
}

/*------------------------------------------------------------------*/
void DoiDeselectRow (
  Widget PRtable,
  int PRrow)
{
  if (DoiDebugFlag) printf("DoiDeselectRow(%d)\n",PRrow);

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;

  XcTableDeselect (PRtable,PRrow,0);
}

/*------------------------------------------------------------------*/
void DoiDeselectTable (
  Widget PRtable)
{
  if (DoiDebugFlag) printf("DoiDeselectTable\n");

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;

  XcTableDeselect (PRtable,0,0);
}

/*------------------------------------------------------------------*/
void DoiSetInputFocusTable (
  Widget PRtable,
  int    PRrow,
  int    PRcolumn)
{
  if (DoiDebugFlag) printf("DoiSetInputFocusTable\n");

  if (PRtable == NULL) return;

  if (XtClass(PRtable) != xcTableWidgetClass) return;

  XcTableSetInputFocus (PRtable, PRrow, PRcolumn);
}
#endif
