.so manmac.ms
.OH "''''"
.EH "''''"
.fp 1 H
.fp 2 HO
.fp 3 HB
.nr PS 12
.nr VS 14
.LP
\&
.sp 20
.ps 18
.vs 20p
\f(HBSINIX / WINDOWS NT\fP
.LP
.sp 2
.ps 30
.vs 34p
\f(HBCooL V2.1\fP
.LP
.sp
.ps 18
.vs 20p
\f(HBCoLibri Extensions\fP
.sp 11
\f(HBReference Manual\fP
.LP
.bp 
\&
.bp
\&
.sp 10
.ps 30
.vs 34p
\f(HBCooL (SINIX / WINDOWS NT)\fP
.LP
.sp 2
.ps 18
.vs 20p
\f(HBCoLibri Extensions\fP
.sp 3
\f(HBReference Manual\fP
.LP
.sp 23
.ps 12
.vs 14p
Edition March 1994 (CooL V2.1)
.LP
.bp
\&
.sp 34
.ps 9
.vs 11p
.TS
tab($);
l.
CooL
Copyright \(co Siemens Nixdorf Informationssysteme AG 1994
All rights reserved
.sp 0.5
The reproduction, transmission or use of this document or its contents
is not permitted without express written authority.
.sp 0.5
Offenders will be liable for damages. All rights, including rights created
by patent grant or registration of a utility model of design, are reserved.
.sp 0.5
Delivery subject to availability;
right of technical modifications reserved.
.sp 0.5
Published by
Siemens Nixdorf Informationssysteme AG
.TE
.LP
.bp
.OH "'CoLibrEx Reference Manual''Preface'"
.EH "'Preface''CoLibrEx Reference Manual'"
.OF "'''\\\\n(PN'"
.EF "'\\\\n(PN'''"
.NX 0 "Preface"
.sp
CoLibrEX is an extension of the CoLibri which is the library of the 
CooL Programming Environment.
This library provides additional and modified abstract data types.
.sp
Most parts of CoLibrEX were implemented with CooL whereby different 
standards were taken into account (e.g. X/Open Portability Guide, AT&T 
Class Library).
.sp 1.5
\f(HBAudience\fP
.sp
This manual contains all the information you require in order to work 
with CoLibrEX.
You should, however, be familiar with CooL and the concepts of 
object-oriented programming.
.sp 1.5
\f(HBContents\fP
.sp
The CoLibrEx Reference Manual is divided up into chapters for each 
object type with the following contents:
.IP Preface
In addition to a brief description of CoLibrEX and a summary of contents,
you will also find an explanation of the typographical conventions used 
in the manual.
.IP "1. How to Use CoLibrEX"
This chapter provides an explanation of the usage of CoLibrEX.
.IP "2.-18. Object Types"
These chapters describe the additional and modified functionality of the
object types provided by CoLibrEX.
.LP
.sp
\f(HBTypographical Conventions\fP
.sp
The following typographical conventions are used:
.sp 0.5
.IP \f(HBbold\fP 11
\f(HBBoldfaced\fP strings in syntax descriptions represent literals and 
must be typed in the manner in which they appear.
.IP \f(HOitalic\fP 11
\f(HOItalicized\fP strings represent substitutable arguments and the 
names of entries found elsewhere.
.IP \fCcourier\fP 11
\fCCourier\fP is used for program examples, user input, system output
and (error) messages.
.IP \f(HOname()\fP 11
The notation \f(HOname()\fP indicates C functions and CooL procedures 
and methods.
.IP \f(HB<file>\fP 11
The notation \f(HB<file>\fP indicates C header files (\f(HB<file.h>\fP) 
and CooL library files (\f(HB<file.cs>\fP).
.IP "{ }" 11
Braces { } around names represent constants.
.LP
.OH "''''"
.EH "''''"
.bp
.OH "'CoLibrEx Reference Manual''How to Use CoLibrEx'"
.EH "'How to Use CoLibrEx''CoLibrEx Reference Manual'"
.NX 1 "How to Use CoLibrEx"
.sp
The CoLibri procedures \f(HOPrelude\fP and \f(HOPostlude\fP are provided
for initializating and finalizating CoLibri, 
These procedures should be called also using CoLibrEX at the beginning 
and at the end of procedure \f(HOmain()\fP.
.sp 0.5
.KS
.IP EXAMPLES
.CS L
PROCEDURE main
DO
  Colibri::Prelude ();
\&...
  Colibri::Postlude ();
END DO;
.CE
.KE
.LP
The procedures \f(HOPrelude\fP and \f(HOPostlude\fP are
declared in the module \f(HOColibri\fP.
Therefore, the module implementation containing procedure \f(HOmain()\fP
must import these procedures from the module \f(HOColibri\fP.
.sp 0.5
.KS
.IP EXAMPLES
.CS L
IMPORT ..., Colibri, ...;
.CE
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibrEX Reference Manual''Calendar'"
.EH "'Calendar''CoLibrEX Reference Manual'"
.NX 1 "Calendar"
.sp
.NX 2 "Type Description"
.sp
This object implements a calendar. It has the following features:
.IP "- Nominator"
A string that represents the name of the calendar.
.IP "- Validity Period"
An interval that sets the calendar validity period.
.IP "- Working Hours"
This is a set of timetables. 
Each timetable is made of a validity period (the interval of time in 
which the timetable is defined), the working days in a week and the real
timetable (that gives the working hours for each working day of the 
week).
Timetables are stored in a set because there can be different timetables
for different time intervals in a year. 
The validity period of timetables must not overlap to each other (there
is only one timetable for every date) and they must cover all the 
validity period (all dates inside the calendar validity period must have
a timetable).
.IP "- Number of timetables"
This is the number of timetables in the set.
.IP "- Normal non-working days"
Another sorted set with normal non-working days in every year.
.IP "- Number of normal non-working days"
Number of elements in the normal non-working days set.
.IP "- Variable non-working days"
Non-working days that are not in a fixed day every year. 
They are sorted.
.IP "- Number of variable non-working days"
Number of variable non-working days in the set.
.IP "- Local non-working days"
Local non-working days (defined for a region, a city, an 
enterprise, ...). They are sorted.
.IP "- Number of local non-working days"
Number of local non-working days in the set.
.IP "- Working day start"
This is a state variable that determines the beginning of a working day.
It is used when adding or subtracting working durations to a 
\f(HODate\fP or \f(HOTimeStamp\fP. 
It works in this way:
.in +2
- When we do one of those operations on a \f(HODate\fP, if the 
\f(HODate\fP is a non-working day we get the working day that 
corresponds to that \f(HODate \fP (indicated by this state variable) 
which can be the previous or the next working day. 
Otherwise, we get the current \f(HODate\fP.
.sp 0.5
- When we do one of those operations on a \f(HOTimeStamp\fP, the 
\f(HODate\fP we get can be the current \f(HODate\fP (the \f(HODate\fP 
indicated by the \f(HOTimeStamp\fP), if it is a working day; the 
previous working day or the next working day.
.in -2
.IP "- Time after adding a working duration"
This is a state variable that determines the \f(HOTime\fP of a 
\f(HOTimestamp \fP after adding to it a working duration. 
This state variable indicates this time.
.IP "- Time after subtracting a working duration"
This is a state variable that determines the \f(HOTime\fP of a 
\f(HOTimeStamp\fP after subtracting from it a working duration. 
This state variable indicates this time.
.LP
.sp 0.5
.NX 2 "List of Methods"
.sp
The following methods are available in <Calendar.cs>:
.TS
tab (#);
l.
Method name
_
addLocalNWDay
addNormalNWDay
addVariableNWDay
addWHour
copy
Deserialize
getEndWHour
getLocalNWDays
getNbLocalNWDays
getNbNormalNWDays
getNbTimeTables
getNbVariableNWDays
getNominator
getNormalNWDays
getStartWHour
getTimeAddWDuration
getTimeSubWDuration
getType
getValidPeriod
getVariableNWDays
getWDayStart
getWHours
isEqual
isIntervalInWorkingDay
isIntervalInWorkingTime
isIntervalInWorkingWeek
isLocalNWDay
isNWWeekDay
isNormalNWDay
isTSInWorkingTime
isVariableNWDay
isWorkingDay
nextEndWT
nextEndWW
nextStartWT
nextStartWW
nextWDay
prevWDay
remLocalNWDay
remNormalNWDay
remVariableNWDay
remWHour
Serialize
setNominator
setTimeAddWDuration
setTimeSubWDuration
setValidPeriod
setWDayStart
timeAfterAdd
timeAfterSubtract
toWDate
.TE
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
The following exceptions can be raised using module \f(HOCalender\fP :
.TS
tab($);
l.
exception name
_
DateOutOfCalendar
InvalidEnumValue
MaxArraySizeExceeded
NonWorkingDayDup
NonWorkingDay
TimeTablesOverlap
ValidPeriodNotCovered
ValidPeriodNotInit
.TE
.sp
.NX 2 "How to use Calendar"
.sp
A variable of type \f(HOCalendar\fP is declared, as follows:
.CS L
VAR calendar : Calendar;
.CE
.sp 0.5
A variable of type \f(HOCalendar\fP can be initialized using the CooL 
constructor NEW.
.sp 0.5
A sub type of type \f(HOCalendar\fP is declared, as follows:
.CS L
TYPE MyCalendar = Calendar OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL implementation unit which uses the type \f(HOCalendar\fP must 
iimport \f(HOCalendar\fP:
.CS L
IMPORT ..., Calendar, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOCalendar\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''Calendar::INITIALLY'"
.EH "'Calendar::INITIALLY''CoLibrEX Reference Manual'"
.bp
.NX 3 "INITIALLY"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBINITIALLY (IN inNominator : STRING) : Calendar;\fP
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW. 
The parameter \f(HOinNominator\fP specifies the name of the current 
object. 
The current \f(HOCalendar\fP is initialized with NIL values for all the 
state variables (except the name) so it must be filled with other 
methods.
.IP "RETURN VALUE"
This method returns a new object of this class containing 
\f(HOinNominator\fP and a NIL \f(HOCalendar\fP.
.IP EXAMPLES
.CS L
VAR nominator : STRING;
VAR calendar  : Calendar::Calendar;
\&...
nominator := "calendarName";
calendar  := NEW Calendar::Calendar (nominator);
.CE
Then \f(HOcalendar\fP is initialized with the nominator "calendarName".
.IP "SEE ALSO"
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP,
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP 
.LP
.OH "'CoLibrEX Reference Manual''Calendar::addLocalNWDay'"
.EH "'Calendar::addLocalNWDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "addLocalNWDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD addLocalNWDay (IN inDate : Date);\fP
.IP DESCRIPTION
The method \f(HOaddLocalNWDay\fP adds \f(HOinDate\fP to the set of local
non-working days.
.sp 0.5
There is a maximum number of days in the set. 
It is defined by the constant {MAX_NB_LOCAL_NW_DAYS}.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOMaxArraySizeExceeded\fP"
is raised if the set is full and we try to add another element.
.IP "\(bu \f(HONonWorkingDayDup\fP"
is raised if this day is already declared as non-working day (normal or 
variable). 
.IP EXAMPLES
.CS L
VAR nominator : STRING;
VAR calendar  : Calendar::Calendar;
VAR date      : Date::Date;
\&...
nominator := "calendarName";
calendar  := NEW Calendar::Calendar (nominator);
date      := NEW Date::Date (1993, 9, 23);
calendar.addLocalNWDay (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP,
\f(HODate::INITIALLY\fP, 
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP 
.LP
.OH "'CoLibrEX Reference Manual''Calendar::addNormalNWDay'"
.EH "'Calendar::addNormalNWDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "addNormalNWDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD addNormalNWDay (IN inMonthDay : MonthDay);\fP
.IP DESCRIPTION
The method \f(HOaddNormalNWDay\fP adds \f(HOinMonthDay\fP to the set of
normal non-working days of all years.
.sp 0.5
There is a maximum number of days in the set. 
It is defined by the constant {MAX_NB_NORMAL_NW_DAYS}.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOMaxArraySizeExceeded\fP"
is raised if the set is full and we try to add another element.
.IP "\(bu \f(HONonWorkingDayDup\fP"
is raised if this day is already declared as non-working day (local or 
variable). 
.IP EXAMPLES
.CS L
VAR nominator : STRING;
VAR calendar  : Calendar::Calendar;
VAR month_day : MonthDay::MonthDay;
\&...
nominator := "calendarName";
calendar  := NEW Calendar::Calendar (nominator);
month_day := NEW MonthDay::MonthDay (12, 25);
calendar.addNormalNWDay (month_day);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP,
\f(HOMonthDay::INITIALLY\fP, 
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP 
.LP
.OH "'CoLibrEX Reference Manual''Calendar::addVariableNWDay'"
.EH "'Calendar::addVariableNWDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "addVariableNWDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD addVariableNWDay (IN inDate : Date);\fP
.IP DESCRIPTION
The method \f(HOaddVariableNWDay\fP adds \f(HOinDate\fP to the set of 
variable non-working days.
.sp 0.5
There is a maximum number of days in the set. 
It is defined by the constant {MAX_NB_VARIABLE_NW_DAYS}.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOMaxArraySizeExceeded\fP"
is raised if the set is full and we try to add another element.
.IP "\(bu \f(HONonWorkingDayDup\fP"
is raised if this day is already declared as non-working day (local or 
normal). 
.IP EXAMPLES
.CS L
VAR nominator : STRING;
VAR calendar  : Calendar::Calendar;
VAR date      : Date::Date;
\&...
nominator := "calendarName";
calendar  := NEW Calendar::Calendar (nominator);
date      := NEW Date::Date (1993, 10, 1);
calendar.addVariableNWDay (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddWHour\fP,
\f(HODate::INITIALLY\fP, 
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP 
.LP
.OH "'CoLibrEX Reference Manual''Calendar::addWHour'"
.EH "'Calendar::addWHour''CoLibrEX Reference Manual'"
.bp
.NX 3 "addWHour"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD addWHour (IN inTT : timeTable);\fP
.IP DESCRIPTION
The method \f(HOaddWHour\fP adds a timetable in the set of timetables. 
A timetable has the following structure:
.CS L
TYPE timeTable = 
   RECORD
      ValidPeriod : Interval;
      Table       : ARRAY [7] OF TimeInterval;
      NWWeekDays  : ARRAY [7] OF BOOL; 
      -- 1=Sunday, 2=Monday, ..., 7=Saturday.
   END RECORD;
.CE
.sp 0.5
where 
.br
- \f(HOValidPeriod\fP is the timetable validity period, 
.br
- \f(HOTable\fP stores the working hours of the working days (NIL for 
non-working days) 
.br
and 
.br
- \f(HONWWeekDays\fP indicates which days of the 
week are non-working days (TRUE when a day is a non-working day).
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOMaxArraySizeExceeded\fP"
is raised if the set is full and we try to add another element. 
.IP "\(bu \f(HOTimeTablesOverlap\fP"
is raised if the timetable we try to add to the set overlaps with an 
existing timetable in the set.
.KS
.IP EXAMPLES
.CS L
VAR nominator     : STRING;
VAR calendar      : Calendar::Calendar;
VAR start_date    : Date::Date;
VAR end_date      : Date::Date;
VAR valid_period  : Interval::Interval;
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR time_table    : Calendar::timeTable;
\&...
nominator     := "calendarName";
calendar      := NEW Calendar::Calendar::Calendar (nominator);
start_date    := NEW Date::Date (1993, 1, 1);
end_date      := NEW Date::Date (1993, 12, 31);
valid_period  := NEW Interval::Interval (start_date, end_date);
start_time    := NEW Time::Time (8, 30, 0);
end_time      := NEW Time::Time (15, 30, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
time_table.ValidPeriod  := valid_period;
time_table.NWWeekDay[1] := TRUE;
time_table.Table[1]     := NIL;
time_table.NWWeekDay[7] := TRUE;
time_table.Table[7]     := NIL;
FOR i IN 2..6 
LOOP
   time_table.NWWeekDay[i] := FALSE;
   time_table.Table[i]     := time_interval;
END LOOP;
calendar.addWHour (time_table);
.CE
.KE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP,
\f(HODate::INITIALLY\fP, 
\f(HOInterval::INITIALLY\fP, 
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP, 
\f(HOTime::INITIALLY\fP, 
\f(HOTimeInterval::INITIALLY \fP, 
.LP
.OH "'CoLibrEX Reference Manual''Calendar::copy'"
.EH "'Calendar::copy''CoLibrEX Reference Manual'"
.bp
.NX 3 "copy"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD copy () : Calendar;\fP
.IP DESCRIPTION
The method \f(HOcopy\fP creates a new object of this class containing 
the state of the current object.
.IP "RETURN VALUE"
This method returns a new object of this class containing the state of 
the current object.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar     : Calendar::Calendar;
VAR new_calendar : Calendar::Calendar;
\&...
new_calendar := calendar.copy ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP,
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP 
.LP
.OH "'CoLibrEX Reference Manual''Calendar::Deserialize'"
.EH "'Calendar::Deserialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Deserialize"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD Deserialize (IN inStream : Stream);\fP
.IP DESCRIPTION
The method \f(HODeserialize\fP makes \f(HOCalendar\fP to get its state 
from a \f(HOStream\fP received at \f(HOinStream\fP.
.IP EXAMPLES
.CS L
VAR calendar : Calendar::Calendar;
VAR stream   : Stream::Stream;
\&...
calendar := NEW Calendar::Calendar ("calendarName");
\&...
calendar.Serialize (stream);
DELETE calendar;
calendar := NEW Calendar::Calendar ("myDumcalendar");
\&...
calendar.Deserialize (stream);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOSerialize\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getEndWHour'"
.EH "'Calendar::getEndWHour''CoLibrEX Reference Manual'"
.bp
.NX 3 "getEndWHour"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD getEndWHour (IN inDate : Date) : Time;\fP
.IP DESCRIPTION
The method \f(HOgetEndWHour\fP creates a \f(HOTime\fP object with the 
working time end of the day \f(HOinDate\fP.
.IP "RETURN VALUE"
This method returns a \f(HOTime\fP object with the working time end of 
the day \f(HOinDate\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input date is not contained by the \f(HOCalendar\fP 
validity period. 
.IP "\(bu \f(HONonWorkingDay\fP"
is raised if the input \f(HODate\fP do not correspond to a working day, 
and so the working time end can not be calculated.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined. 
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR date     : Date::Date;
VAR time     : Time::Time;
\&...
date := NEW Date::Date (1993, 1, 10);
time := calendar.getEndWHour (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP, 
\f(HODate::INITIALLY\fP, 
\f(HOgetStartWHour\fP
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP, 
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getLocalNWDays'"
.EH "'Calendar::getLocalNWDays''CoLibrEX Reference Manual'"
.bp
.NX 3 "getLocalNWDays"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBMETHOD getLocalNWDays () : $ ARRAY [MAX_NB_LOCAL_NW_DAYS] 
$ OF Date;\fP
.TE
.IP DESCRIPTION
The method \f(HOgetLocalNWDays\fP creates a sorted array that is a copy
of the set of local non-working days.
.IP "RETURN VALUE"
This method returns a sorted array that is a copy of the set of local 
non-working days.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar     : Calendar::Calendar;
VAR local_NWDays : ARRAY [MAX_NB_LOCAL_NW_DAYS] OF Date::Date;
\&...
local_NWDays := calendar.getLocalNWDays ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOgetNbLocalNWDays\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getNbLocalNWDays'"
.EH "'Calendar::getNbLocalNWDays''CoLibrEX Reference Manual'"
.bp
.NX 3 "getNbLocalNWDays"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD getNbLocalNWDays () : INT;\fP
.IP DESCRIPTION
The method \f(HOgetNbLocalNWDays\fP returns the number of elements in 
the set of local non-working days.
.IP "RETURN VALUE"
This method returns the number of elements in the set of local 
non-working days.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR number   : INT;
\&...
number := calendar.getNbLocalNWDays ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOgetLocalNWDays\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getNbNormalNWDays'"
.EH "'Calendar::getNbNormalNWDays''CoLibrEX Reference Manual'"
.bp
.NX 3 "getNbNormalNWDays"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD getNbNormalNWDays () : INT;\fP
.IP DESCRIPTION
The method \f(HOgetNbNormalNWDays\fP returns the number of elements in 
the set of normal non-working days.
.IP "RETURN VALUE"
This method returns the number of elements in the set of normal 
non-working days.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR number   : INT;
\&...
number := calendar.getNbNormalNWDays ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOgetNormalNWDays\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getNbTimeTables'"
.EH "'Calendar::getNbTimeTables''CoLibrEX Reference Manual'"
.bp
.NX 3 "getNbTimeTables"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD getNbTimeTables () : INT;\fP
.IP DESCRIPTION
The method \f(HOgetNbTimeTables\fP returns the number of elements in the
set of timetables.
.IP "RETURN VALUE"
This method returns the number of elements in the set of timetables.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR number   : INT;
\&...
number := calendar.getNbTimeTables ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddWHour\fP, 
\f(HOgetWHours\fP,
\f(HOsetValidPeriod\fP 
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getNbVariableNWDays'"
.EH "'Calendar::getNbVariableNWDays''CoLibrEX Reference Manual'"
.bp
.NX 3 "getNbVariableNWDays"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD getNbVariableNWDays () : INT;\fP
.IP DESCRIPTION
The method \f(HOgetNbVariableNWDays\fP returns the number of elements in
the set of variable non-working days.
.IP "RETURN VALUE"
This method returns the number of elements in the set of variable 
non-working days.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR number   : INT;
\&...
number := calendar.getNbVariableNWDays ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOgetVariableNWDays\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getNominator'"
.EH "'Calendar::getNominator''CoLibrEX Reference Manual'"
.bp
.NX 3 "getNominator"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD getNominator () : STRING;\fP
.IP DESCRIPTION
The method \f(HOgetNominator\fP returns a STRING that is the 
\f(HOCalendar \fP name.
.IP "RETURN VALUE"
This method returns a STRING that is the \f(HOCalendar\fP name.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR string   : STRING;
\&...
string := calendar.getNominator ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOsetNominator\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getNormalNWDays'"
.EH "'Calendar::getNormalNWDays''CoLibrEX Reference Manual'"
.bp
.NX 3 "getNormalNWDays"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBMETHOD getNormalNWDays () : $ ARRAY [MAX_NB_NORMAL_NW_DAYS]
$ OF MonthDay;\fP
.TE
.IP DESCRIPTION
The method \f(HOgetNormalNWDays\fP creates a sorted array that is a copy
of the set of normal non-working days.
.IP "RETURN VALUE"
This method returns a sorted array that is a copy of the set of normal 
non-working days.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar      : Calendar::Calendar;
VAR normal_NWDays : ARRAY [MAX_NB_NORMAL_NW_DAYS] OF MonthDay;
\&...
normal_NWDays := calendar.getNormalNWDays ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOgetNbNormalNWDays\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getStartWHour'"
.EH "'Calendar::getStartWHour''CoLibrEX Reference Manual'"
.bp
.NX 3 "getStartWHour"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD getStartWHour (IN inDate : Date) : Time;\fP
.IP DESCRIPTION
The method \f(HOgetStartWHour\fP creates a \f(HOTime\fP object with the
working time start of the day \f(HOinDate\fP.
.IP "RETURN VALUE"
This method returns a \f(HOTime\fP object with the working time start of
the day \f(HOinDate\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input date is not contained by the \f(HOCalendar\fP 
validity period. 
.IP "\(bu \f(HONonWorkingDay\fP"
is raised if the input \f(HODate\fP do not correspond to a working day,
and so the working time start can not be calculated.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined. 
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR date     : Date::Date;
VAR time     : Time::Time;
\&...
date := NEW Date::Date (1993, 1, 10);
time := calendar.getStartWHour (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP, 
\f(HODate::INITIALLY\fP, 
\f(HOgetEndWHour\fP,
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getTimeAddWDuration'"
.EH "'Calendar::getTimeAddWDuration''CoLibrEX Reference Manual'"
.bp
.NX 3 "getTimeAddWDuration"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD getTimeAddWDuration () : TimeAdjustment;\fP
.IP DESCRIPTION
The method \f(HOgetTimeAddWDuration\fP returns a \f(HOTimeAdjustment\fP 
record used to determine time used to set \f(HOTime\fP of a 
\f(HOTimeStamp\fP after an addition of a working duration. 
This record has the following structure:
.CS L
TYPE TimeAdjustment = 
   RECORD
      AtTime    : INT;
      FixedTime : Time;
   END RECORD;
.CE
\f(HOAtTime\fP can get any of the following values:
.sp 0.5
1) {START_TIME_CURRENT_DAY} :
.in +2
The time is the start working time of the result date. 
It can be found in the corresponding timetable. 
\f(HOFixedTime\fP has no effect.
.in -2
2) {END_TIME_CURRENT_DAY} :
.in +2
The time is the end working time of the result date. 
It can be found in the corresponding timetable. 
\f(HOFixedTime\fP has no effect.
.in -2
3) {FIXED_TIME_CURRENT_DAY} :
.in +2
The time is indicated by \f(HOFixedTime\fP.
.in -2
.IP "RETURN VALUE"
This method returns a \f(HOTimeAdjustment\fP record used to determine 
the time used to set \f(HOTime\fP of a \f(HOTimeStamp\fP after an 
addition of a working duration.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar  : Calendar::Calendar;
VAR timeRound : Calendar::TimeAdjustment;
\&...
timeRound := calendar.getTimeAddWDuration ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOsetTimeAddWDuration\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getTimeSubWDuration'"
.EH "'Calendar::getTimeSubWDuration''CoLibrEX Reference Manual'"
.bp
.NX 3 "getTimeSubWDuration"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD getTimeSubWDuration () : TimeAdjustment;\fP
.IP DESCRIPTION
The method \f(HOgetTimeSubWDuration\fP returns a \f(HOTimeAdjustment\fP 
record used to determine time used to set \f(HOTime\fP of a 
\f(HOTimeStamp\fP after a subtraction of a working duration. 
This record has the following structure:
.CS L
TYPE TimeAdjustment = 
   RECORD
      AtTime    : INT;
      FixedTime : Time;
   END RECORD;
.CE
.sp 0.5
\f(HOAtTime\fP can get any of the following values:
.sp 0.5
1) {START_TIME_CURRENT_DAY} :
.in +2
The time is the start working time of the result date. 
It can be found in the corresponding timetable. 
\f(HOFixedTime\fP has no effect.
.in -2
2) {END_TIME_CURRENT_DAY} :
.in +2
The time is the end working time of the result date. 
It can be found in the corresponding timetable. 
\f(HOFixedTime\fP has no effect.
.in -2
3) {FIXED_TIME_CURRENT_DAY} :
.in +2
The time is indicated by \f(HOFixedTime\fP.
.in -2
.IP "RETURN VALUE"
This method returns a \f(HOTimeAdjustment\fP record used to determine 
the time used to set \f(HOTime\fP of a \f(HOTimeStamp\fP after a 
subtraction of a working duration.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar   : Calendar::Calendar;
VAR time_round : Calendar::TimeAdjustment;
\&...
time_round := calendar.getTimeSubWDuration ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOsetTimeSubWDuration\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getType'"
.EH "'Calendar::getType''CoLibrEX Reference Manual'"
.bp
.NX 3 "getType"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD getType () : STRING;\fP
.IP DESCRIPTION
The method \f(HOgetType\fP returns a STRING with the type name: 
\&"Calendar".
.IP "RETURN VALUE"
This method returns a STRING with the type name: "Calendar".
.IP EXAMPLES
.CS L
VAR nominator : STRING;
VAR calendar  : Calendar::Calendar;
VAR type      : STRING;
\&...
nominator := "calendarName";
calendar  := NEW Calendar::Calendar (nominator);
type      := calendar.getType ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getValidPeriod'"
.EH "'Calendar::getValidPeriod''CoLibrEX Reference Manual'"
.bp
.NX 3 "getValidPeriod"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD getValidPeriod () : Interval;\fP
.IP DESCRIPTION
The method \f(HOgetValidPeriod\fP returns an interval that is a copy of
the \f(HOCalendar\fP validity period.
.IP "RETURN VALUE"
This method returns an interval that is a copy of the \f(HOCalendar\fP 
validity period.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been 
initialized.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar     : Calendar::Calendar;
VAR valid_period : Interval::Interval;
\&...
valid_period := calendar.getValidPeriod ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddWHour\fP,
\f(HOsetValidPeriod\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getVariableNWDays'"
.EH "'Calendar::getVariableNWDays''CoLibrEX Reference Manual'"
.bp
.NX 3 "getVariableNWDays"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBMETHOD getVariableNWDays () : $ ARRAY [MAX_NB_VARIABLE_NW_DAYS]
$ OF Date;\fP
.TE
.IP DESCRIPTION
The method \f(HOgetVariableNWDays\fP creates a sorted array that is a 
copy of the set of variable non-working days.
.IP "RETURN VALUE"
This method returns a sorted array that is a copy of the set of variable
non-working days.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar     : Calendar::Calendar;
VAR local_NWDays : ARRAY [MAX_NB_VARIABLE_NW_DAYS] OF Date::Date;
\&...
local_NWDays := calendar.getVariableNWDays ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddVariableNWDay\fP, 
\f(HOgetNbVariableNWDays\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getWDayStart'"
.EH "'Calendar::getWDayStart''CoLibrEX Reference Manual'"
.bp
.NX 3 "getWDayStart"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD getWDayStart () : TimeAdjustment;\fP
.IP DESCRIPTION
The method \f(HOgetWDayStart\fP returns a \f(HOTimeAdjustment\fP record
used to determine the beginning of a working day. 
It is used when adding or subtracting working durations to a 
\f(HODate\fP or \f(HOTimeStamp\fP. 
.sp 0.5
It works in this way:
.sp 0.5
- When we do one of those operations on a \f(HODate\fP, if the 
\f(HODate\fP is a non-working day we get the working day that 
corresponds to that \f(HODate\fP (indicated by this state variable) 
which can be the previous or the next working day. 
Otherwise, we get the current \f(HODate\fP.
.sp 0.5
- When we do one of those operations on a \f(HOTimeStamp\fP, the 
\f(HODate\fP we get can be the current \f(HODate\fP (the \f(HODate\fP 
indicated by the \f(HOTimeStamp\fP), if it is a working day; the 
previous working day or the next working day.
.sp 0.5
This record has the following structure:
.CS L
TYPE TimeAdjustment = 
   RECORD
      AtTime    : INT;
      FixedTime : Time;
   END RECORD;
.CE
.sp 0.5
AtTime can get any of the following values:
.sp 0.5
1) {START_TIME_CURRENT_DAY} :
.in +2
A working day begins at the start working time of the current day. 
It can be found in the corresponding timetable. 
\f(HOFixedTime\fP has no effect.
.in -2
2) {END_TIME_PREVIOUS_DAY} :
.in +2
A working day begins at the end working time of the previous working 
day. 
It can be found in the corresponding timetable. 
\f(HOFixedTime\fP has no effect.
.in -2
3) {FIXED_TIME_CURRENT_DAY} :
.in +2
A working day begins at a fixed time of the current working day, 
indicated by \f(HOFixedTime\fP.
.in -2
4) {FIXED_TIME_PREVIOUS_DAY} :
.in +2
A working day begins at a fixed time of the previous working day, 
indicated by \f(HOFixedTime\fP.
.in -2
.IP "RETURN VALUE"
This method returns a \f(HOTimeAdjustment\fP record used to determine 
the date that is set to a \f(HODate\fP or \f(HOTimeStamp\fP before an 
addition or subtraction of a working duration.
.KS
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar   : Calendar::Calendar;
VAR time_round : Calendar::TimeAdjustment;
\&...
time_round := calendar.getWDayStart ();
.CE
.KE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::getWHours'"
.EH "'Calendar::getWHours''CoLibrEX Reference Manual'"
.bp
.NX 3 "getWHours"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBMETHOD getWHours () : $ ARRAY [MAX_NB_TIMETABLES] 
$ OF timeTable;\fP
.TE
.IP DESCRIPTION
The method \f(HOgetWHours\fP creates a sorted array that is a copy of 
the set of timetables.
.IP "RETURN VALUE"
This method returns a sorted array that is a copy of the set of 
timetables.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar    : Calendar::Calendar;
VAR time_tables : ARRAY [MAX_NB_TIMETABLES] OF Calendar::timeTable;
\&...
time_tables := calendar.getWHours ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddWHour\fP,
\f(HOsetValidPeriod\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::isEqual'"
.EH "'Calendar::isEqual''CoLibrEX Reference Manual'"
.bp
.NX 3 "isEqual"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD isEqual (IN inCalen : Calendar) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOisEqual\fP returns a boolean that indicates whether the
current \f(HOCalendar\fP is equal to the input Calendar \f(HOinCalen\fP.
.IP "RETURN VALUE"
This method returns a boolean that indicates whether the current 
\f(HOCalendar\fP is equal to the input Calendar \f(HOinCalen\fP.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar       : Calendar::Calendar;
VAR other_calendar : Calendar::Calendar;
VAR result         : BOOL;
\&...
other_calendar := calendar.Copy ();
result         := calendar.isEqual (other_calendar);
.CE
Then \f(HOresult\fP contains the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP, 
\f(HOCopy\fP,
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::isIntervalInWorkingDay'"
.EH "'Calendar::isIntervalInWorkingDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "isIntervalInWorkingDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD isIntervalInWorkingDay (IN inInterv : Interval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOisIntervalInWorkingDay\fP returns a boolean that 
indicates whether the input interval is inside a working day.
.IP "RETURN VALUE"
This method returns a boolean that indicates whether the input interval 
is inside a working day.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input interval is not contained by the \f(HOCalendar\fP
validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined. 
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar        : Calendar::Calendar;
VAR start_time      : Time::Time;
VAR end_time        : Time::Time;
VAR start_timeStamp : TimeStamp::TimeStamp;
VAR end_timeStamp   : TimeStamp::TimeStamp;
VAR interval        : Interval::Interval;
VAR result          : BOOL;
\&...
start_time      := NEW Time::Time (9, 40, 0);
end_time        := NEW Time::Time (16, 15, 0);
start_timeStamp := NEW TimeStamp::TimeStamp (1993, 8, 5, start_time);
end_timeStamp   := NEW TimeStamp::TimeStamp (1993, 8, 5, end_time);
interval        := NEW Interval::Interval (start_timeStamp, 
                                           end_timeStamp);
result          := calendar.isIntervalInWorkingDay (interval);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP, 
\f(HOInterval::INITIALLY\fP,
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP, 
\f(HOTime::INITIALLY\fP, 
\f(HOTimeStamp::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::isIntervalInWorkingTime'"
.EH "'Calendar::isIntervalInWorkingTime''CoLibrEX Reference Manual'"
.bp
.NX 3 "isIntervalInWorkingTime"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD isIntervalInWorkingTime (IN inInterv : Interval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOisIntervalInWorkingTime\fP returns a boolean that 
indicates whether the input interval is inside a working day and in 
working hours.
.IP "RETURN VALUE"
This method returns a boolean that indicates whether the input interval 
is inside a working day and in working hours.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input interval is not contained by the \f(HOCalendar\fP
validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar        : Calendar::Calendar;
VAR start_time      : Time::Time;
VAR end_time        : Time::Time;
VAR start_timeStamp : TimeStamp::TimeStamp;
VAR end_timeStamp   : TimeStamp::TimeStamp;
VAR interval        : Interval::Interval;
VAR result          : BOOL;
\&...
start_time      := NEW Time::Time (9, 40, 0);
end_time        := NEW Time::Time (16, 15, 0);
start_timeStamp := NEW TimeStamp::TimeStamp (1993, 8, 5, start_time);
end_timeStamp   := NEW TimeStamp::TimeStamp (1993, 8, 5, end_time);
interval        := NEW Interval::Interval (start_timeStamp, 
                                           end_timeStamp);
result          := calendar.isIntervalInWorkingTime (interval);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP, 
\f(HOInterval::INITIALLY\fP,
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP, 
\f(HOTime::INITIALLY\fP, 
\f(HOTimeStamp::INITIALLY\fP, 
.LP
.OH "'CoLibrEX Reference Manual''Calendar::isIntervalInWorkingWeek'"
.EH "'Calendar::isIntervalInWorkingWeek''CoLibrEX Reference Manual'"
.bp
.NX 3 "isIntervalInWorkingWeek"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD isIntervalInWorkingWeek (IN inInterv : Interval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOisIntervalInWorkingWeek\fP returns a boolean that 
indicates whether the input interval is inside the working days of a 
week.
.IP "RETURN VALUE"
This method returns a boolean that indicates whether the input interval 
is inside the working days of a week.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input interval is not contained by the \f(HOCalendar\fP
validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined. 
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar        : Calendar::Calendar;
VAR start_time      : Time::Time;
VAR end_time        : Time::Time;
VAR start_timeStamp : TimeStamp::TimeStamp;
VAR end_timeStamp   : TimeStamp::TimeStamp;
VAR interval        : Interval::Interval;
VAR result          : BOOL;
\&...
start_time      := NEW Time::Time (9, 40, 0);
end_time        := NEW Time::Time (16, 15, 0);
start_timeStamp := NEW TimeStamp::TimeStamp (1993, 8, 5, start_time);
end_timeStamp   := NEW TimeStamp::TimeStamp (1993, 8, 5, end_time);
interval        := NEW Interval::Interval (start_timeStamp, 
                                           end_timeStamp);
result           := calendar.isIntervalInWorkingWeek (interval);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP, 
\f(HOInterval::INITIALLY\fP
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP, 
\f(HOTime::INITIALLY\fP, 
\f(HOTimeStamp::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::isLocalNWDay'"
.EH "'Calendar::isLocalNWDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "isLocalNWDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD isLocalNWDay (IN inDate : Date) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOisLocalNWDay\fP returns a boolean that indicates whether
the input \f(HODate\fP is in the set of local non-working days.
.IP "RETURN VALUE"
This method returns a boolean that indicates whether the input 
\f(HODate\fP is in the set of local non-working days.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input date is not contained by the \f(HOCalendar\fP 
validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized and
all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR date     : Date::Date;
VAR result   : BOOL;
\&...
date   := NEW Date::Date (1993, 6, 15);
result := calendar.isLocalNWDay (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP, 
\f(HODate::INITIALLY\fP,
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::isNWWeekDay'"
.EH "'Calendar::isNWWeekDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "isNWWeekDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD isNWWeekDay (IN inDate : Date) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOisNWWeekDay\fP returns a boolean that indicates whether 
the input i\f(HODate\fP is a non-working day of a week.
.IP "RETURN VALUE"
This method returns a boolean that indicates whether the input 
\f(HODate\fP is a non-working day of a week.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input date is not contained by the \f(HOCalendar\fP 
validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR date     : Date::Date;
VAR result   : BOOL;
\&...
date   := NEW Date::Date (1993, 6, 15);
result := calendar.isNWWeekDay (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP, 
\f(HODate::INITIALLY\fP,
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::isNormalNWDay'"
.EH "'Calendar::isNormalNWDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "isNormalNWDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD isNormalNWDay (IN inDate : Date) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOisNormalNWDay\fP returns a boolean that indicates 
whether the input \f(HODate\fP is in the set of normal non-working days.
.IP "RETURN VALUE"
This method returns a boolean that indicates whether the input 
\f(HODate\fP is in the set of normal non-working days.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input date is not contained by the \f(HOCalendar\fP 
validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR date     : Date::Date;
VAR result   : BOOL;
\&...
date   := NEW Date::Date (1993, 6, 15);
result := calendar.isNormalNWDay (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP, 
\f(HODate::INITIALLY\fP,
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::isTSInWorkingTime'"
.EH "'Calendar::isTSInWorkingTime''CoLibrEX Reference Manual'"
.bp
.NX 3 "isTSInWorkingTime"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD isTSInWorkingTime (IN inTS : TimeStamp) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOisTSInWorkingTime\fP returns a boolean that indicates 
whether the input \f(HOTimeStamp\fP is inside a working day and in 
working hours.
.IP "RETURN VALUE"
This method returns a boolean that indicates whether the input 
\f(HOTimeStamp\fP is inside a working day and in working hours.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input \f(HOTimeStamp\fP is not contained by the 
\f(HOCalendar\fP validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar  : Calendar::Calendar;
VAR time      : Time::Time;
VAR timeStamp : TimeStamp::TimeStamp;
VAR result    : BOOL;
\&...
time      := NEW Time::Time (16, 15, 0);
timeStamp := NEW TimeStamp::TimeStamp (1993, 8, 5, time);
result    := calendar.isTSInWorkingTime (timeStamp);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOaddLocalNWDay\fP, 
\f(HOaddNormalNWDay\fP, 
\f(HOaddVariableNWDay\fP, 
\f(HOaddWHour\fP, 
\f(HOsetNominator\fP, 
\f(HOsetTimeAddWDuration\fP, 
\f(HOsetTimeSubWDuration\fP, 
\f(HOsetValidPeriod\fP, 
\f(HOsetWDayStart\fP, 
\f(HOTime::INITIALLY\fP, 
\f(HOTimeStamp::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::isVariableNWDay'"
.EH "'Calendar::isVariableNWDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "isVariableNWDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD isVariableNWDay (IN inDate : Date) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOisVariableNWDay\fP returns a boolean that indicates 
whether the input \f(HODate\fP is in the set of variable non-working 
days.
.IP "RETURN VALUE"
This method returns a boolean that indicates whether the input 
\f(HODate\fP is in the set of variable non-working days.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input date is not contained by the \f(HOCalendar\fP
 validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR date     : Date::Date;
VAR result   : BOOL;
\&...
date   := NEW Date::Date (1993, 6, 15);
result := calendar.isVariableNWDay (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HODate::INITIALLY\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::isWorkingDay'"
.EH "'Calendar::isWorkingDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "isWorkingDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD isWorkingDay (IN inDate : Date) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOisWorkingDay\fP returns a boolean that indicates whether
the input i\f(HODate\fP is not in any set of non-working days or is a 
non-working day of a week.
.IP "RETURN VALUE"
This method returns a boolean that indicates whether the input 
\f(HODate\fP is not in any set of non-working days or is a non-working 
day of a week.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input date is not contained by the \f(HOCalendar\fP 
validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR date     : Date::Date;
VAR result   : BOOL;
\&...
date   := NEW Date::Date (1993, 6, 15);
result := calendar.isWorkingDay (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HODate::INITIALLY\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::nextEndWT'"
.EH "'Calendar::nextEndWT''CoLibrEX Reference Manual'"
.bp
.NX 3 "nextEndWT"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD nextEndWT (IN inTS : TimeStamp) : TimeStamp;\fP
.IP DESCRIPTION
The method \f(HOnextEndWT\fP returns a \f(HOTimeStamp\fP that is the 
next end working time after the input \f(HOTimeStamp\fP.
.IP "RETURN VALUE"
This method returns a \f(HOTimeStamp\fP that is the next end working 
time after the input \f(HOTimeStamp\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input \f(HOTimeStamp\fP is not contained by the 
\f(HOCalendar\fP validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar         : Calendar::Calendar;
VAR time             : Time::Time;
VAR timeStamp        : TimeStamp::TimeStamp;
VAR end_working_time : TimeStamp::TimeStamp;
\&...
time             := NEW Time::Time (16, 15, 0);
timeStamp        := NEW TimeStamp::TimeStamp (1993, 8, 5, time);
end_working_time := calendar.nextEndWT (timeStamp);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP,
\f(HOTime::INITIALLY\fP,
\f(HOTimeStamp::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::nextEndWW'"
.EH "'Calendar::nextEndWW''CoLibrEX Reference Manual'"
.bp
.NX 3 "nextEndWW"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD nextEndWW (IN inTS : TimeStamp) : TimeStamp;\fP
.IP DESCRIPTION
The method \f(HOnextEndWW\fP returns a \f(HOTimeStamp\fP that is the 
end working time of the last working day in a week after the input 
\f(HOTimeStamp\fP.
.IP "RETURN VALUE"
This method returns a \f(HOTimeStamp\fP that is the end working time of 
the last working day in a week after the input \f(HOTimeStamp\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input \f(HOTimeStamp\fP is not contained by the 
\f(HOCalendar\fP validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar         : Calendar::Calendar;
VAR time             : Time::Time;
VAR timeStamp        : TimeStamp::TimeStamp;
VAR end_working_week : TimeStamp::TimeStamp;
\&...
time             := NEW Time::Time (16, 15, 0);
timeStamp        := NEW TimeStamp::TimeStamp (1993, 8, 5, time);
end_working_week := calendar.nextEndWW (timeStamp);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP,
\f(HOTime::INITIALLY\fP,
\f(HOTimeStamp::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::nextStartWT'"
.EH "'Calendar::nextStartWT''CoLibrEX Reference Manual'"
.bp
.NX 3 "nextStartWT"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD nextStartWT (IN inTS : TimeStamp) : TimeStamp;\fP
.IP DESCRIPTION
The method \f(HOnextStartWT\fP returns a \f(HOTimeStamp\fP that is the 
start working time of the next working day after the input 
\f(HOTimeStamp\fP.
.IP "RETURN VALUE"
This method returns a \f(HOTimeStamp\fP that is the start working time 
of the next working day after the input \f(HOTimeStamp\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input \f(HOTimeStamp\fP is not contained by the 
\f(HOCalendar\fP validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar           : Calendar::Calendar;
VAR time               : Time::Time;
VAR timeStamp          : TimeStamp::TimeStamp;
VAR start_working_time : TimeStamp::TimeStamp;
\&...
time               := NEW Time::Time (16, 15, 0);
timeStamp          := NEW TimeStamp::TimeStamp (1993, 8, 5, time);
start_working_time := calendar.nextStartWT (timeStamp);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP,
\f(HOTime::INITIALLY\fP,
\f(HOTimeStamp::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::nextStartWW'"
.EH "'Calendar::nextStartWW''CoLibrEX Reference Manual'"
.bp
.NX 3 "nextStartWW"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD nextStartWW (IN inTS : TimeStamp) : TimeStamp;\fP
.IP DESCRIPTION
The method \f(HOnextStartWW\fP returns a \f(HOTimeStamp\fP that is the 
next start working time of a working day following a non-working week 
day.
.IP "RETURN VALUE"
This method returns a \f(HOTimeStamp\fP that is the next start working
 time of a working day following a non-working week day.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input \f(HOTimeStamp\fP is not contained by the 
\f(HOCalendar\fP validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar           : Calendar::Calendar;
VAR time               : Time::Time;
VAR timeStamp          : TimeStamp::TimeStamp;
VAR start_working_week : TimeStamp::TimeStamp;
\&...
time               := NEW Time::Time (16, 15, 0);
timeStamp          := NEW TimeStamp::TimeStamp (1993, 8, 5, time);
start_working_week := calendar.nextStartWW (timeStamp);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP,
\f(HOTime::INITIALLY\fP,
\f(HOTimeStamp::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::nextWDay'"
.EH "'Calendar::nextWDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "nextWDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD nextWDay (IN inDate : Date) : Date;\fP
.IP DESCRIPTION
The method \f(HOnextWDay\fP returns a \f(HODate\fP that is the next 
working day after \f(HOinDate\fP.
.IP "RETURN VALUE"
This method returns a \f(HODate\fP that is the next working day after 
\f(HOinDate\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input date is not contained by the \f(HOCalendar\fP 
validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar  : Calendar::Calendar;
VAR date      : Date::Date;
VAR next_date : Date::Date;
\&...
date      := NEW Date::Date (1993, 6, 15);
next_date := calendar.nextWDay (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HODate::INITIALLY\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::prevWDay'"
.EH "'Calendar::prevWDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "prevWDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD prevWDay (IN inDate : Date) : Date;\fP
.IP DESCRIPTION
The method \f(HOprevWDay\fP returns a \f(HODate\fP that is the previous 
working day before \f(HOinDate\fP.
.IP "RETURN VALUE"
This method returns a \f(HODate\fP that is the previous working day 
before \f(HOinDate\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input date is not contained by the \f(HOCalendar\fP 
validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar      : Calendar::Calendar;
VAR date          : Date::Date;
VAR previous_date : Date::Date;
\&...
date          := NEW Date::Date (1993, 6, 15);
previous_date := calendar.prevWDay (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HODate::INITIALLY\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::remLocalNWDay'"
.EH "'Calendar::remLocalNWDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "remLocalNWDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD remLocalNWDay (IN inDate : Date);\fP
.IP DESCRIPTION
The method \f(HOremLocalNWDay\fP removes \f(HOinDate\fP from the set 
of local non-working days. 
If \f(HOinDate\fP is not in the set this method does nothing.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR date     : Date::Date;
\&...
date := NEW Date::Date (1993, 6, 15);
calendar.remLocalNWDay (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HODate::INITIALLY\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::remNormalNWDay'"
.EH "'Calendar::remNormalNWDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "remNormalNWDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD remNormalNWDay (IN inMonthDay : MonthDay);\fP
.IP DESCRIPTION
The method \f(HOremNormalNWDay\fP removes \f(HOinMonthDay\fP from the 
set of normal non-working days. 
If \f(HOinMonthDay\fP is not in the set this method does nothing.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar  : Calendar::Calendar;
VAR month_day : MonthDay::MonthDay;
\&...
month_day := NEW MonthDay::MonthDay (6, 15);
calendar.remNormalNWDay (month_day);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HOMonthDay::INITIALLY\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::remVariableNWDay'"
.EH "'Calendar::remVariableNWDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "remVariableNWDay"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD remVariableNWDay (IN inDate : Date);\fP
.IP DESCRIPTION
The method \f(HOremVariableNWDay\fP removes \f(HOinDate\fP from the set 
of variable non-working days. 
If \f(HOinDate\fP is not in the set this method does nothing.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR date     : Date::Date;
\&...
date := NEW Date::Date (1993, 6, 15);
calendar.remVariableNWDay (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HODate::INITIALLY\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::remWHour'"
.EH "'Calendar::remWHour''CoLibrEX Reference Manual'"
.bp
.NX 3 "remWHour"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD remWHour (IN inInterv : Interval);\fP
.IP DESCRIPTION
The method \f(HOremWHour\fP removes all timetables whose validity period
is contained by \f(HOinInterv\fP from the set of timetables. 
It also modifies the validity period of timetables that intersect with, 
but are not contained by, \f(HOinInterv\fP (removes the intersection).
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar   : Calendar::Calendar;
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
\&...
start_date := NEW Date::Date (1993, 6, 15);
end_date   := NEW Date::Date (1993, 9, 28);
interval   := NEW Interval::Interval (start_date, end_date);
calendar.remWHour (interval);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HODate::INITIALLY\fP,
\f(HOInterval::INITIALLY\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::Serialize'"
.EH "'Calendar::Serialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Serialize"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD Serialize (INOUT ioStream : Stream);\fP
.IP DESCRIPTION
The method \f(HOSerialize\fP updates the \f(HOStream\fP received at 
\f(HOioStream\fP to contain the state of the \f(HOCalendar\fP.
.IP EXAMPLES
.CS L
VAR calendar : Calendar::Calendar;
VAR stream   : Stream::Stream;
\&...
calendar := NEW Calendar::Calendar ("calendarName");
\&...
calendar.Serialize (stream);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODeserialize\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::setNominator'"
.EH "'Calendar::setNominator''CoLibrEX Reference Manual'"
.bp
.NX 3 "setNominator"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD setNominator (IN inNom : STRING);\fP
.IP DESCRIPTION
The method \f(HBsetNominator\fP changes the \f(HOCalendar\fP name. 
\f(HOinNom\fP is the new nominator.
.IP EXAMPLES
.CS L
VAR nominator    : STRING;
VAR calendar     : Calendar::Calendar;
VAR new_nominator : STRING;
\&...
nominator     := "calendarName";
calendar      := NEW Calendar::Calendar (nominator);
new_nominator := "new_calendarName";
calendar.setNominator (new_nominator);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::setTimeAddWDuration'"
.EH "'Calendar::setTimeAddWDuration''CoLibrEX Reference Manual'"
.bp
.NX 3 "setTimeAddWDuration"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD setTimeAddWDuration ($ IN inAtTime $ : INT, 
$ IN inFixedTime $ : Time);\fP
.TE
.IP DESCRIPTION
The method \f(HOsetTimeAddWDuration\fP sets the time adjustment used to
determine the time used to set the \f(HOTime\fP of a \f(HOTimeStamp\fP 
after an addition of a working duration. 
\f(HOinAtTime\fP may get the next values:
.sp 0.5
1) {START_TIME_CURRENT_DAY} :
.in +2
\f(HOinFixedTime\fP is ignored. 
Use the time returned by the method \f(HOgetStartWHour\fP.
.in -2
2) {END_TIME_CURRENT_DAY} :
.in +2
\f(HOinFixedTime\fP is ignored. 
Use the time returned by the method \f(HOgetEndWHour\fP.
.in -2
3) {FIXED_TIME_CURRENT_DAY} :
.in +2
Use the time given by \f(HOinFixedTime\fP.
.in -2
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidEnumValue\fP"
is raised if \f(HOinAtTime\fP gets an invalid value (different from the 
values explained before).
.IP EXAMPLES
.CS L
VAR nominator : STRING;
VAR calendar  : Calendar::Calendar;
VAR time      : Time::Time;
\&...
nominator := "calendarName";
calendar  := NEW Calendar::Calendar (nominator);
time      := NEW Time::Time (18, 0, 0);
calendar.setTimeAddWDuration (FIXED_TIME_CURRENT_DAY, time);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::setTimeSubWDuration'"
.EH "'Calendar::setTimeSubWDuration''CoLibrEX Reference Manual'"
.bp
.NX 3 "setTimeSubWDuration"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD setTimeSubWDuration ($ IN inAtTime $ : INT, 
$IN inFixedTime $ : Time);\fP
.TE
.IP DESCRIPTION
The method \f(HOsetTimeSubWDuration\fP sets the time adjustment used to
determine the time used to set the \f(HOTime\fP of a \f(HOTimeStamp\fP 
after a subtraction of a working duration. 
\f(HOinAtTime\fP may get the next values:
.sp 0.5
1) {START_TIME_CURRENT_DAY} :
.in +2
\f(HOinFixedTime\fP is ignored. 
Use the time returned by the method \f(HOgetStartWHour\fP.
.in -2
2) {END_TIME_CURRENT_DAY} :
.in +2
\f(HOinFixedTime\fP is ignored. 
Use the time returned by the method \f(HOgetEndWHour\fP.
.in -2
3) {FIXED_TIME_CURRENT_DAY} :
.in +2
Use the time given by \f(HOinFixedTime\fP.
.in -2
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidEnumValue\fP"
is raised if \f(HOinAtTime\fP gets an invalid value (different from the 
values explained before).
.IP EXAMPLES
.CS L
VAR nominator : STRING;
VAR calendar  : Calendar::Calendar;
VAR time      : Time::Time;
\&...
nominator := "calendarName";
calendar  := NEW Calendar::Calendar (nominator);
time      := NEW Time::Time (18, 0, 0);
calendar.setTimeSubWDuration (FIXED_TIME_CURRENT_DAY, time);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::setValidPeriod'"
.EH "'Calendar::setValidPeriod''CoLibrEX Reference Manual'"
.bp
.NX 3 "setValidPeriod"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD setValidPeriod (IN inInterv : Interval);\fP
.IP DESCRIPTION
The method \f(HOsetValidPeriod\fP sets the \f(HOCalendar\fP validity 
period. 
All \f(HOCalendar\fP based operations with dates check that these dates 
are in the \f(HOCalendar\fP validity period. 
If they are not in, an exception is raised.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOValidPeriodNotCovered\fP"
is raised if we set a new validity period that is not covered by the 
set of timetables. 
All dates in the validity period must correspond to one and only one 
timetable.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar     : Calendar::Calendar;
VAR start_date   : Date::Date;
VAR end_date     : Date::Date;
VAR valid_period : Interval::Interval;
\&...
start_date   := NEW Date::Date (1993, 6, 15);
end_date     := NEW Date::Date (1993, 9, 28);
valid_period := NEW Interval::Interval (start_date, end_date);
calendar.setValidPeriod (valid_period);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddLocalNWDay\fP,
\f(HOaddNormalNWDay\fP,
\f(HOaddVariableNWDay\fP,
\f(HOaddWHour\fP,
\f(HODate::INITIALLY\fP,
\f(HOInterval::INITIALLY\fP,
\f(HOsetNominator\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::setWDayStart'"
.EH "'Calendar::setWDayStart''CoLibrEX Reference Manual'"
.bp
.NX 3 "setWDayStart"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD setWDayStart ($ IN inAtTime $ : INT, 
$ IN inFixedTime $ : Time);\fP
.TE
.IP DESCRIPTION
The method \f(HOsetWDayStart\fP creates a \f(HOTimeAdjustment\fP record 
used to determine the beginning of a working day. 
It is used when adding or subtracting working durations to a 
\f(HODate\fP or \f(HOTimeStamp\fP. 
.sp 0.5
It works in this way:
.sp 0.5
- When we do one of those operations on a \f(HODate\fP, if the 
\f(HODate\fP is a non-working day we get the working day that 
corresponds to that \f(HODate\fP (indicated by this state variable) 
which can be the previous or the next working day. 
Otherwise, we get the current \f(HODate\fP.
.sp 0.5
- When we do one of those operations on a \f(HOTimeStamp\fP, the 
\f(HODate\fP we get can be the current \f(HODate\fP (the \f(HODate\fP 
indicated by the \f(HOTimeStamp\fP), if it is a working day; the 
previous working day or the next working day.
.sp 0.5
This record has the following structure:
.CS L
TYPE TimeAdjustment = 
   RECORD
      AtTime    : INT;
      FixedTime : Time;
   END RECORD;
.CE
.sp 0.5
\f(HOinAtTime\fP can get any of the following values:
.sp 0.5
1) {START_TIME_CURRENT_DAY} :
.in +2
A working day begins at the start working time of the current day. 
It can be found in the corresponding timetable. 
\f(HOinFixedTime\fP has no effect.
.in -2
2) {END_TIME_PREVIOUS_DAY} :
.in +2
A working day begins at the end working time of the previous working 
day. 
It can be found in the corresponding timetable. 
\f(HOinFixedTime\fP has no effect.
.in -2
3) {FIXED_TIME_CURRENT_DAY} :
.in +2
A working day begins at a fixed time of the current working day, 
indicated by \f(HOinFixedTime\fP.
.in -2
4) {FIXED_TIME_PREVIOUS_DAY} :
.in +2
A working day begins at a fixed time of the previous working day, 
indicated by \f(HOinFixedTime\fP.
.in -2
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidEnumValue\fP"
is raised if \f(HOinAtTime\fP gets an invalid value (different from 
the values explained before).
.KS
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR nominator : STRING;
VAR calendar  : Calendar::Calendar;
VAR time      : Time::Time;
\&...
nominator := "calendarName";
calendar  := NEW Calendar::Calendar (nominator);
time      := NEW Time::Time (18, 0, 0);
calendar.setWDayStart (FIXED_TIME_CURRENT_DAY, time);
.CE
.KE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::timeAfterAdd'"
.EH "'Calendar::timeAfterAdd''CoLibrEX Reference Manual'"
.bp
.NX 3 "timeAfterAdd"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD timeAfterAdd (IN inDate : Date) : Time;\fP
.IP DESCRIPTION
The method \f(HOtimeAfterAdd\fP returns the \f(HOTime\fP to be set in a 
\f(HOTimeStamp\fP after adding a working duration to it. 
The input \f(HODate\fP should be the resulting date after the addition.
.IP "RETURN VALUE"
This method returns a \f(HOTime\fP to be set in a \f(HOTimeStamp\fP 
after adding a working duration to it.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input date is not contained by the \f(HOCalendar\fP 
validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined. 
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR time     : Time::Time;
VAR date     : Date::Date;
\&...
date := NEW Date::Date (1993, 6, 15);
time := calendar.timeAfterAdd (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddWHour\fP,
\f(HOsetTimeAddWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::timeAfterSubtract'"
.EH "'Calendar::timeAfterSubtract''CoLibrEX Reference Manual'"
.bp
.NX 3 "timeAfterSubtract"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD timeAfterSubtract (IN inDate : Date) : Time;\fP
.IP DESCRIPTION
The method \f(HOtimeAfterSubtract\fP returns the \f(HOTime\fP to be set 
in a \f(HOTimeStamp\fP after subtracting a working duration to it. 
The input \f(HODate\fP should be the resulting date after the 
subtraction.
.IP "RETURN VALUE"
This method returns a \f(HOTime\fP to be set in a \f(HOTimeStamp\fP 
after subtracting a working duration to it.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input date is not contained by the \f(HOCalendar\fP 
validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined. 
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR time     : Time::Time;
VAR date     : Date::Date;
\&...
date := NEW Date::Date (1993, 6, 15);
time := calendar.timeAfterSubtract (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddWHour\fP,
\f(HOsetTimeSubWDuration\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar::toWDate'"
.EH "'Calendar::toWDate''CoLibrEX Reference Manual'"
.bp
.NX 3 "toWDate"
.sp
.IP MODULE
\f(HBCalendar\fP
.IP TYPE
\f(HBCalendar\fP
.IP SYNOPSIS
\f(HBMETHOD toWDate (IN inDate : Date) : Date;\fP
.IP DESCRIPTION
The method \f(HOtoWDate\fP is used to set a non working \f(HODate\fP to 
its corresponding closer working \f(HODate\fP according to the 
\f(HOCalendar\fP definition. 
It is used before adding or subtracting a working duration to a 
\f(HODate\fP.
.IP "RETURN VALUE"
This method returns a \f(HODate\fP that is the closer working day for 
\f(HOinDate\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the input date is not contained by the \f(HOCalendar\fP 
validity period.
.IP "\(bu \f(HOValidPeriodNotInit\fP"
is raised if the \f(HOCalendar\fP validity period has not been defined.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR calendar : Calendar::Calendar;
VAR date     : Date::Date;
VAR wDate    : Date::Date;
\&...
date  := NEW Date::Date (1993, 1, 1);
wDate := calendar.toWDate (date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOaddWHour\fP,
\f(HOsetValidPeriod\fP,
\f(HOsetWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Calendar'"
.EH "'Calendar''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOCalendar\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$IN$inNominator$STRING$
$result$$Calendar$
_
addLocalNWDay$IN$inDate$Date$MaxArraySizeExceeded
$$$$NonWorkingDayDup
_
addNormalNWDay$IN$inMonthDay$MonthDay$MaxArraySizeExceeded
$$$$NonWorkingDayDup
_
addVariableNWDay$IN$inDate$Date$MaxArraySizeExceeded
$$$$NonWorkingDayDup
_
addWHour$IN$inTT$timeTable$MaxArraySizeExceeded
$$$$TimeTablesOverlap
_
copy$result$$Calendar$
_
Deserialize$IN$inStream$Stream$
_
getEndWHour$IN$inDate$Date$DateOutOfCalendar
$result$$Time$NonWorkingDay
$$$$ValidPeriodNotInit
_
getLocalNWDays$result$$ARRAY [...] OF Date$
_
getNbLocalNWDays$result$$INT$
_
getNbNormalNWDays$result$$INT$
_
getNbTimeTables$result$$INT$
_
getNbVariableNWDays$result$$INT$
_
getNominator$result$$STRING$
_
getNormalNWDays$result$$ARRAY [...] OF MonthDay$
_
getStartWHour$IN$inDate$Date$DateOutOfCalendar
$result$$Time$NonWorkingDay
$$$$ValidPeriodNotInit
_
getTimeAddWDuration$result$$TimeAdjustment$
_
getTimeSubWDuration$result$$TimeAdjustment$
_
getType$result$$STRING$
_
getValidPeriod$result$$Interval$ValidPeriodNotInit
_
getVariableNWDays$result$$ARRAY [...] OF Date$
_
getWDayStart$result$$TimeAdjustment$
_
getWHours$result$$ARRAY [...] OF timeTable$
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
isEqual$IN$inCalen$Calendar$
$result$$BOOL$
_
isIntervalInWorkingDay$IN$inInterv$Interval$DateOutOfCalendar
$result$$BOOL$ValidPeriodNotInit
_
isIntervalInWorkingTime$IN$inInterv$Interval$DateOutOfCalendar
$result$$BOOL$ValidPeriodNotInit
_
isIntervalInWorkingWeek$IN$inInterv$Interval$DateOutOfCalendar
$result$$BOOL$ValidPeriodNotInit
_
isLocalNWDay$IN$inDate$Date$DateOutOfCalendar
$result$$BOOL$ValidPeriodNotInit
_
isNWWeekDay$IN$inDate$Date$DateOutOfCalendar
$result$$BOOL$ValidPeriodNotInit
_
isNormalNWDay$IN$inDate$Date$DateOutOfCalendar
$result$$BOOL$ValidPeriodNotInit
_
isTSInWorkingTime$IN$inTS$TimeStamp$DateOutOfCalendar
$result$$BOOL$ValidPeriodNotInit
_
isVariableNWDay$IN$inDate$Date$DateOutOfCalendar
$result$$BOOL$ValidPeriodNotInit
_
isWorkingDay$IN$inDate$Date$DateOutOfCalendar
$result$$BOOL$ValidPeriodNotInit
_
nextEndWT$IN$inTS$TimeStamp$DateOutOfCalendar
$result$$TimeStamp$ValidPeriodNotInit
_
nextEndWW$IN$inTS$TimeStamp$DateOutOfCalendar
$result$$TimeStamp$ValidPeriodNotInit
_
nextStartWT$IN$inTS$TimeStamp$DateOutOfCalendar
$result$$TimeStamp$ValidPeriodNotInit
_
nextStartWW$IN$inTS$TimeStamp$DateOutOfCalendar
$result$$TimeStamp$ValidPeriodNotInit
_
nextWDay$IN$inDate$Date$DateOutOfCalendar
$result$$Date$ValidPeriodNotInit
_
prevWDay$IN$inDate$Date$DateOutOfCalendar
$result$$Date$ValidPeriodNotInit
_
remLocalNWDay$IN$inDate$Date$
_
remNormalNWDay$IN$inMonthDay$MonthDay$
_
remVariableNWDay$IN$inDate$Date$
_
remWHour$IN$inInterv$Interval$
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
Serialize$INOUT$ioStream$Stream$
_
setNominator$IN$inNom$STRING$
_
setTimeAddWDuration$IN$inAtTime$INT$InvalidEnumValue
$IN$inFixedTime$Time$
_
setTimeSubWDuration$IN$inAtTime$INT$InvalidEnumValue
$IN$inFixedTime$Time$
_
setValidPeriod$IN inInterv$Interval$ValidPeriodNotCovered
_
setWDayStart$IN$inAtTime$INT$InvalidEnumValue
$IN$inFixedTime$Time$
_
timeAfterAdd$IN$inDate$Date$DateOutOfCalendar
$result$$Time$ValidPeriodNotInit
_
timeAfterSubtract$IN$inDate$Date$DateOutOfCalendar
$result$$Time$ValidPeriodNotInit
_
toWDate$IN$inDate$Date$DateOutOfCalendar
$result$$Date$ValidPeriodNotInit
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
.OH "'CoLibrEX Reference Manual''Date'"
.EH "'Date''CoLibrEX Reference Manual'"
.NX 1 "Date"
.sp
.NX 2 "Type Description"
.sp
\f(HODate\fP is an object type representing a \f(HOCalendar\fP entry 
consisting of year, month and day. 
This object type offers methods to construct, modify and actualize an 
object and to get information about an object. 
Further methods deal with arithmetic operations and predicates.
.sp
.NX 2 "List of Methods"
.sp
The following methods are available in <Date.cs>:
.TS
tab ($);
l l.
Method name$M(odified)/N(ew)
_
Add$M
Copy$
Deserialize$N
GetDay$
GetDayOfWeek$
GetDayOfYear$
GetMonth$
GetWeekOfYear$
GetYear$
IsActual$
IsEarlier$
IsEqual$
IsInFuture$
IsLater$
IsPassed$
NDistance$N
Serialize$N
SetDate$
SetToActualDate$
Subtract$M
WDistance$N
.TE
.sp 0.5
Modified and new methods are described in the following sections, 
the others are described in the CoLibri Reference Manual (see [1]).
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
.KS
The following exceptions can be raised using module \f(HODate\fP :
.TS
tab($);
l.
exception name
_
DateOutOfCalendar
NegativeDuration
.TE
.KE
.sp
.NX 2 "How to use Date"
.sp
A variable of type \f(HODate\fP is declared, as follows:
.CS L
VAR date : Date;
.CE
.sp 0.5
A variable of type \f(HODate\fP can be initialized using the CooL 
constructor NEW.
.sp 0.5
A sub type of type \f(HODate\fP is declared, as follows:
.CS L
TYPE MyDate = Date OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the object type \f(HODate\fP must
import \f(HODate\fP:
.CS L
IMPORT ..., Date, ...;
.CE
.sp
.NX 2 "Modified and New Methods Description"
.sp
The following sections contain the syntactical and semantical 
description of all modified and new methods provided by \f(HODate\fP. 
They are listed in alphabetical order.
.LP
.OH "'CoLibrEX Reference Manual''Date::Add'"
.EH "'Date::Add''CoLibrEX Reference Manual'"
.bp
.NX 3 "Add"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD Add (IN inExtent : Duration);\fP
.IP DESCRIPTION
The method \f(HOAdd\fP adds \f(HOinExtent\fP to the current date. 
\f(HOinExtent\fP may be a \f(HONDuration\fP or a \f(HOWDuration\fP (both
sub types of the non-instanciable type \f(HODuration\fP). 
In the first case we add a natural duration to a date. 
It is the common addition. 
In the second case we add a working duration to a date. 
It is a \f(HOCalendar\fP based addition.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if we add a working duration to the actual date and the result
is out of the \f(HOCalendar\fP validity period.
.IP EXAMPLES
.CS L
VAR date      : Date::Date;
VAR nDuration : NDuration::NDuration;
\&...
date      := NEW Date::Date (1993, 10, 1);
nDuration := NEW NDuration::NDuration (0, 5, 2, 0, 0, 0);
date.Add (nDuration);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODuration::INITIALLY\fP,
\f(HONDuration::INITIALLY\fP,
\f(HOWDuration::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Date::Deserialize'"
.EH "'Date::Deserialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Deserialize"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD Deserialize (IN inStream : Stream);\fP
.IP DESCRIPTION
The method \f(HODeserialize\fP loads the state of the date from a stream
received at \f(HOinStream\fP.
.IP EXAMPLES
.CS L
VAR date   : Date::Date;
VAR stream : Stream::Stream;
\&...
date := NEW Date::Date (1993, 10, 1);
date.Serialize (stream);
DELETE date;
date := NEW Date::Date (1990, 1, 1);
date.Deserialize (stream);
.CE
Then \f(HOdate\fP contains "1/10/1993".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOSerialize\fP
.LP
.OH "'CoLibrEX Reference Manual''Date::NDistance'"
.EH "'Date::NDistance''CoLibrEX Reference Manual'"
.bp
.NX 3 "NDistance"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD NDistance (IN inEndDate : Date) : NDuration;\fP
.IP DESCRIPTION
The method \f(HONDistance\fP creates a natural duration 
\&(\f(HONDuration\fP) object that is the distance between the current 
date and the input date measured in natural days.
.IP "RETURN VALUE"
This method returns a natural duration (\f(HONDuration\fP) object that 
is the distance between the current date and the input date measured in 
natural days.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised if the current date is later than the input date.
.IP EXAMPLES
.CS L
VAR date      : Date::Date;
VAR end_date  : Date::Date;
VAR nDistance : NDuration::NDuration;
\&...
date      := NEW Date::Date (1993, 6, 15);
end_date  := NEW Date::Date (1993, 9, 28);
nDistance := date.NDistance (end_date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOWDistance\fP
.LP
.OH "'CoLibrEX Reference Manual''Date::Serialize'"
.EH "'Date::Serialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Serialize"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD Serialize (INOUT ioStream : Stream);\fP
.IP DESCRIPTION
The method \f(HOSerialize\fP updates the \f(HOStream\fP received at 
\f(HOioStream\fP to contain the state of the current object.
.IP EXAMPLES
.CS L
VAR date   : Date::Date;
VAR stream : Stream::Stream;
\&...
date   := NEW Date::Date (1993, 10, 1);
date.Serialize (stream);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODeserialize\fP
.LP
.OH "'CoLibrEX Reference Manual''Date::Subtract'"
.EH "'Date::Subtract''CoLibrEX Reference Manual'"
.bp
.NX 3 "Subtract"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
\f(HBMETHOD Subtract (IN inExtent : Duration);\fP
.IP DESCRIPTION
The method \f(HOSubtract\fP subtracts \f(HOinExtent\fP to the current 
date. 
\f(HOinExtent\fP may be a \f(HONDuration\fP or a \f(HOWDuration\fP 
\&(both sub types of the non-instanciable type \f(HODuration\fP). 
In the first case we subtract a natural duration to a date. 
It is the common subtraction. 
In the second case we subtract a working duration to a date. 
It is a \f(HOCalendar\fP based subtraction.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if we subtract a working duration to the actual date and the 
result is out of the \f(HOCalendar\fP validity period.
.IP EXAMPLES
.CS L
VAR date      : Date::Date;
VAR nDuration : NDuration::NDuration;
\&...
date      := NEW Date::Date (1993, 10, 1);
nDuration := NEW NDuration::NDuration (0, 5, 2, 0, 0, 0);
date.Subtract (nDuration);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HODuration::INITIALLY\fP,
\f(HONDuration::INITIALLY\fP,
\f(HOWDuration::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Date::WDistance'"
.EH "'Date::WDistance''CoLibrEX Reference Manual'"
.bp
.NX 3 "WDistance"
.sp
.IP MODULE
\f(HBDate\fP
.IP TYPE
\f(HBDate\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBMETHOD WDistance $($ IN inEndDate $ : Date, 
$$ IN inCalen $ : Calendar) 
$:$ WDuration;$\fP
.TE
.IP DESCRIPTION
The method \f(HOWDistance\fP creates a working duration 
\&(\f(HOWDuration\fP) object that is the distance between the current 
date and the input date measured in working days.
.IP "RETURN VALUE"
This method returns a working duration (\f(HOWDuration\fP) object that 
is the distance between the current date and the input date measured 
in working days.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if the current date or the input date is out of the 
\f(HOCalendar\fP validity period.
.IP "\(bu \f(HONegativeDuration\fP"
is raised if the current date is later than the input date. 
.IP EXAMPLES
.CS L
VAR date      : Date::Date;
VAR end_date  : Date::Date;
VAR wDistance : WDuration::WDuration;
\&...
date      := NEW Date::Date (1993, 6, 15);
end_date  := NEW Date::Date (1993, 9, 28);
wDistance := date.WDistance (end_date);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HONDistance\fP
.LP
.OH "'CoLibrEX Reference Manual''Date'"
.EH "'Date''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HODate\fP.
.br
The column M/N shows whether the method is
.IP \(bu 3
modified (M),
.IP \(bu 3
a new method (N),
.IP \(bu 3
a method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
M/N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$year$INT$InvalidDate
$$IN$month$INT$
$$IN$day$INT$
$$result$$Date$
_
M$Add$IN$inExtent$Duration$DateOutOfCalendar
_
$Copy$result$$Date$
_
N$Deserialize$IN$inStream$Stream$
_
$GetDay$result$$INT$
_
$GetDayOfWeek$result$$INT$
_
$GetDayOfYear$result$$INT$
_
$GetMonth$result$$INT$
_
$GetWeekOfYear$result$$INT$
_
$GetYear$result$$INT$
_
$IsActual$result$$BOOL$
_
$IsEarlier$IN$operand$Date$
$$result$$BOOL$
_
$IsEqual$IN$operand$Date$
$$result$$BOOL$
_
$IsInFuture$result$$BOOL$
_
$IsLater$IN$operand$Date$
$$result$$BOOL$
_
$IsPassed$result$$BOOL$
_
N$NDistance$IN$inEndDate$Date$NegativeDuration
$$result$$NDuration$
_
N$Serialize$INOUT$ioStream$Stream$
_
$SetDate$IN$year$INT$InvalidDate
$$IN$month$INT$
$$IN$day$INT$
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
M/N$Name$Mode$Parameter$Type$Exceptions
=
$SetToActualDate$$$$
_
M$Subtract$IN$inExtent$Duration$DateOutOfCalendar
_
N$WDistance$IN$inEndDate$Date$DateOutOfCalendar
$$IN$inCalen$Calendar$NegativeDuration
$$result$$WDuration$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
.OH "'CoLibrEX Reference Manual''TimeStamp'"
.EH "'TimeStamp''CoLibrEX Reference Manual'"
.NX 1 "TimeStamp"
.sp
.NX 2 "Type Description"
.sp
\f(HOTimeStamp\fP is a sub type of object type \f(HODate\fP representing
a time point consisting of year, month and day together with a time 
value consisting of hours, minutes and seconds. 
In addition to the methods offered by \f(HODate\fP, this object type 
offers methods to construct an object together with a time value, to 
change the time and to get information about the time.
.sp
.NX 2 "List of Methods"
.sp
The following methods are available in <TimeStamp.cs>:
.TS
tab ($);
l l.
Method name$M(odified)/N(ew)
_
Add$M
Copy$
Deserialize$N
GetTime$
IsActual$
IsEarlier$
IsEqual$
IsInFuture$
IsLater$
IsPassed$
NDistance$M
Serialize$N
SetTime$
SetToActualDate$
Subtract$M
.TE
.sp 0.5
Modified and new methods are described in the following sections, 
the others are described in the CoLibri Reference Manual (see [1]).
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
.KS
The following exceptions can be raised using module \f(HOTimeStamp\fP :
.TS
tab($);
l.
exception name
_
DateOutOfCalendar
NegativeDuration
.TE
.KE
.sp
.NX 2 "How to use TimeStamp "
.sp
A variable of type \f(HOTimeStamp\fP is declared, as follows:
.CS L
VAR timeStamp : TimeStamp;
.CE
.sp 0.5
A variable of type \f(HOTimeStamp\fP can be initialized using the CooL 
constructor NEW.
.sp 0.5
A sub type of type \f(HOTimeStamp\fP is declared, as follows:
.CS L
TYPE MyTimeStamp = TimeStamp OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HOTimeStamp\fP must 
import \f(HOTimeStamp\fP:
.CS L
IMPORT ..., TimeStamp, ...;
.CE
.sp
.NX 2 "Modified and New Methods Description"
.sp
The following sections contain the syntactical and semantical 
description of all modified and new methods provided by 
\f(HOTimeStamp\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''TimeStamp::Add'"
.EH "'TimeStamp::Add''CoLibrEX Reference Manual'"
.bp
.NX 3 "Add"
.sp
.IP MODULE
\f(HBTimeStamp\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Add (IN inExtent : Duration);\fP
.IP DESCRIPTION
The method \f(HOAdd\fP adds \f(HOinExtent\fP to the current 
\f(HOTimeStamp\fP. 
\f(HOinExtent\fP may be a \f(HONDuration\fP or a \f(HOWDuration\fP 
\&(both sub types of the non-instanciable type \f(HODuration\fP). 
In the first case we add a natural duration to a \f(HOTimeStamp\fP. 
It is the common addition. 
In the second case we add a working duration to a \f(HOTimeStamp\fP. 
It is a \f(HOCalendar\fP based addition.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if we add a working duration to the actual \f(HOTimeStamp\fP 
and the result is out of the \f(HOCalendar\fP validity period.
.IP EXAMPLES
.CS L
VAR time      : Time::Time;
VAR timeStamp : TimeStamp::TimeStamp;
VAR nDuration : NDuration::NDuration;
\&...
time      := NEW Time::Time (17, 0 , 0);
timeStamp := NEW TimeStamp::TimeStamp (1993, 10, 1, time);
nDuration := NEW NDuration::NDuration (0, 5, 2, 0, 0, 0);
timeStamp.Add (nDuration);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODuration::INITIALLY\fP,
\f(HONDuration::INITIALLY\fP,
\f(HOWDuration::INITIALLY\fP,
\f(HOSubtract\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeStamp::Deserialize'"
.EH "'TimeStamp::Deserialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Deserialize"
.sp
.IP MODULE
\f(HBTimeStamp\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Deserialize (IN inStream : Stream);\fP
.IP DESCRIPTION
The method \f(HODeserialize\fP loads the state of the \f(HOTimeStamp\fP 
from a \f(HOStream\fP received at \f(HOinStream\fP.
.IP EXAMPLES
.CS L
VAR timeStamp : TimeStamp::TimeStamp;
VAR stream    : Stream::Stream;
\&...
timeStamp := NEW TimeStamp::TimeStamp 
                 (1993, 10, 1, NEW Time::Time (8, 30, 0));
timeStamp.Serialize (stream);
DELETE timeStamp;
timeStamp := NEW TimeStamp::TimeStamp 
                 (1990, 1, 1, NEW Time::Time (0, 0, 0));
timeStamp.Deserialize (stream);
.CE
Then \f(HOtimeStamp\fP has the value "01/10/1993, 08:30:00".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOSerialize\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeStamp::NDistance'"
.EH "'TimeStamp::NDistance''CoLibrEX Reference Manual'"
.bp
.NX 3 "NDistance"
.sp
.IP MODULE
\f(HBTimeStamp\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD NDistance (IN inEndDate : Date) : NDuration;\fP
.IP DESCRIPTION
The method \f(HONDistance\fP creates a natural duration 
\&(\f(HONDuration\fP) object that is the distance between the current 
\f(HOTimeStamp\fP and the input \f(HOTimeStamp\fP measured in natural 
days.
.IP "RETURN VALUE"
This method returns a natural duration (\f(HONDuration\fP) object that 
is the distance between the current \f(HOTimeStamp\fP and the input 
\f(HOTimeStamp\fP measured in natural days.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised if the current \f(HOTimeStamp\fP is later than the input 
\f(HOTimeStamp\fP.
.IP EXAMPLES
.CS L
VAR time          : Time::Time;
VAR end_time      : Time::Time;
VAR timeStamp     : TimeStamp::TimeStamp;
VAR end_timeStamp : TimeStamp::TimeStamp;
VAR nDuration     : NDuration::NDuration;
\&...
time          := NEW Time::Time (17, 0 , 0);
timeStamp     := NEW TimeStamp::TimeStamp (1993, 10, 1, time);
end_time      := NEW Time::Time (15, 30 , 0);
end_timeStamp := NEW TimeStamp::TimeStamp (1993, 11, 21, end_time);
nDistance     := timeStamp.NDistance (end_timeStamp);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeStamp::Serialize'"
.EH "'TimeStamp::Serialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Serialize"
.sp
.IP MODULE
\f(HBTimeStamp\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Serialize (INOUT ioStream : Stream);\fP
.IP DESCRIPTION
The method \f(HOSerialize\fP updates the \f(HOStream\fP received at 
\f(HOioStream\fP to contain the state of the current object.
.IP EXAMPLES
.CS L
VAR timeStamp : TimeStamp::TimeStamp;
VAR stream    : Stream::Stream;
\&...
timeStamp := NEW TimeStamp::TimeStamp 
                 (1993, 10, 1, NEW Time::Time (8, 30, 0));
timeStamp.Serialize (stream);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODeserialize\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeStamp::Subtract'"
.EH "'TimeStamp::Subtract''CoLibrEX Reference Manual'"
.bp
.NX 3 "Subtract"
.sp
.IP MODULE
\f(HBTimeStamp\fP
.IP TYPE
\f(HBTimeStamp = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Subtract (IN inExtent : Duration);\fP
.IP DESCRIPTION
The method \f(HOSubtract\fP subtracts \f(HOinExtent\fP to the current 
\f(HOTimeStamp\fP. 
\f(HOinExtent\fP may be a \f(HONDuration\fP or a \f(HOWDuration\fP 
\&(both sub types of the non-instanciable type \f(HODuration\fP). 
In the first case we subtract a natural duration to a \f(HOTimeStamp\fP.
It is the common subtraction. 
In the second case we subtract a working duration to a 
\f(HOTimeStamp\fP. 
It is a \f(HOCalendar\fP based subtraction. 
Before the subtraction, a time rounding is done: the \f(HOTimeStamp\fP 
is set to the working day start of the current day. 
After the subtraction, another time rounding is done: the resultant 
\f(HOTimeStamp\fP is set to the corresponding working day end.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODateOutOfCalendar\fP"
is raised if we subtract a working duration to the actual 
\f(HOTimeStamp\fP and the result is out of the \f(HOCalendar\fP validity
period.
.IP EXAMPLES
.CS L
VAR time      : Time::Time;
VAR timeStamp : TimeStamp::TimeStamp;
VAR nDuration : NDuration::NDuration;
\&...
time      := NEW Time::Time (17, 0 , 0);
timeStamp := NEW TimeStamp::TimeStamp (1993, 10, 1, time);
nDuration := NEW NDuration::NDuration (0, 5, 2, 0, 0, 0);
timeStamp.Subtract (nDuration);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HODuration::INITIALLY\fP,
\f(HONDuration::INITIALLY\fP,
\f(HOTime::INITIALLY\fP,
\f(HOWDuration::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeStamp'"
.EH "'TimeStamp''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOTimeStamp\fP.
.br
The column M/N shows whether the method is
.IP \(bu 3
modified (M),
.IP \(bu 3
a new method (N),
.IP \(bu 3
a method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
M/N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$year$INT$InvalidDate
$$IN$month$INT$InvalidTime
$$IN$day$INT$
$$IN$stamp$Time$
$$result$$TimeStamp$
_
M$Add$IN$inExtent$Duration$DateOutOfCalendar
_
$Copy$result$$Date$
_
N$Deserialize$IN$inStream$Stream$
_
$GetTime$result$$Time$
_
$IsActual$result$$BOOL$
_
$IsEarlier$IN$operand$Date$
$$result$$BOOL$
_
$IsEqual$IN$operand$Date$
$$result$$BOOL$
_
$IsInFuture$result$$BOOL$
_
$IsLater$IN$operand$Date$
$$result$$BOOL$
_
$IsPassed$result$$BOOL$
_
M$NDistance$IN$inEndDate$Date$NegativeDuration
$$result$$NDuration$
_
N$Serialize$INOUT$ioStream$Stream$
_
$SetTime$IN$stamp$Time$
_
$SetToActualDate$$$$
_
M$Subtract$IN$inExtent$Duration$DateOutOfCalendar
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
.OH "'CoLibrEX Reference Manual''Duration'"
.EH "'Duration''CoLibrEX Reference Manual'"
.NX 1 "Duration"
.sp
.NX 2 "Type Description"
.sp
\f(HODuration\fP is a non-instanciable object type representing a 
duration consisting of years, months and days. 
It offers common state variables and functionality to its sub types: 
\f(HONDuration\fP (natural duration) and \f(HOWDuration\fP (working 
duration, that is \f(HOCalendar\fP based).
.sp 0.5
Years state variable introduces a lack of precision because the 
difference between normal and leap years.  
Months state variable introduces a greater lack of precision, 
because the number of days in a month varies a lot (from 28 to 31 days).
.sp 0.5
When you compare two durations, years and months of both objects are 
converted into months and then are compared. 
Then days are compared. 
It is done in this way because you can not convert years and months to 
days because the lack of precision. 
This inconvenience creates a situation in which an exception is raised: 
when the result of the comparison between years and months is opposite 
to the result of the comparison between days. 
Then the exception \f(HONotComparableDurations\fP is raised.  
For example you can not compare 1 month and 30 days. 
But this decision has another inconvenience!!!
You can not compare 1000 years and 1 day!!!.
.sp
.NX 2 "List of Methods"
.sp
The following methods are available in <Duration.cs>:
.TS
tab($);
l.
Method name
_
Add
Copy
Divide
GetDayPart
GetMonthPart
GetYearPart
IsEqual
IsLonger
IsNull
IsShorter
Multiply
Subtract
ToMonths
ToSeconds
.TE
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
.KS
The following exceptions can be raised using module \f(HODuration\fP :
.TS
tab($);
l.
exception name
_
NotComparableDurations
NotInstanciableType
.TE
.KE
.sp
.NX 2 "How to use Duration"
.sp
A sub type of type \f(HODuration\fP is declared, as follows:
.CS L
TYPE MyDuration = Duration OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HODuration\fP must 
import \f(HODuration\fP:
.CS L
IMPORT ..., Duration, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of methods provided by \f(HODuration\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''Duration::INITIALLY'"
.EH "'Duration::INITIALLY''CoLibrEX Reference Manual'"
.bp
.NX 3 "INITIALLY"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN inYears $ : INT,
$$IN inMonths $ : INT,
$$IN inDays $ : INT)
$:$ Duration;$\fP
.TE
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONotInstanciableType\fP"
is raised if we try to create an object of this class.
.IP "SEE ALSO"
\f(HONDuration::INITIALLY\fP, 
\f(HOWDuration::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::Add'"
.EH "'Duration::Add''CoLibrEX Reference Manual'"
.bp
.NX 3 "Add"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD Add (IN inExtent : Duration);\fP
.IP DESCRIPTION
Method deferred. It is implemented in the sub types.
.IP "SEE ALSO"
\f(HONDuration::Add\fP,
\f(HOWDuration::Add\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::Copy'"
.EH "'Duration::Copy''CoLibrEX Reference Manual'"
.bp
.NX 3 "Copy"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD Copy () : Duration;\fP
.IP DESCRIPTION
Method deferred. It is implemented in the sub types.
.IP "SEE ALSO"
\f(HONDuration::Copy\fP,
\f(HOWDuration::Copy\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::Divide'"
.EH "'Duration::Divide''CoLibrEX Reference Manual'"
.bp
.NX 3 "Divide"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD Divide (IN inDivisor : INT);\fP
.IP DESCRIPTION
Method deferred. It is implemented in the sub types.
.IP "SEE ALSO"
\f(HONDuration::Divide\fP, 
\f(HOWDuration::Divide\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::GetDayPart'"
.EH "'Duration::GetDayPart''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetDayPart"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD GetDayPart () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetDayPart\fP returns the days state variable value.
.IP "RETURN VALUE"
This method returns the days state variable value.
.IP EXAMPLES
In the next example we create an object of type \f(HONDuration\fP 
because \f(HODuration\fP is a non-instanciable type.
.CS L
VAR nDuration : NDuration::NDuration;
VAR days      : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
days      := nDuration.GetDayPart ();
.CE
Then \f(HOdays\fP contains the value "3".
.IP "SEE ALSO"
\f(HONDuration::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::GetMonthPart'"
.EH "'Duration::GetMonthPart''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetMonthPart"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD GetMonthPart () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetMonthPart\fP returns the months state variable value.
.IP "RETURN VALUE"
This method returns the months state variable value.
.IP EXAMPLES
In the next example we create an object of type \f(HONDuration\fP 
because \f(HODuration\fP is a non-instanciable type.
.CS L
VAR nDuration : NDuration::NDuration;
VAR months    : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
months    := nDuration.GetMonthPart ();
.CE
Then \f(HOmonths\fP contains the value "2".
.IP "SEE ALSO"
\f(HONDuration::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::GetYearPart'"
.EH "'Duration::GetYearPart''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetYearPart"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD GetYearPart () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetYearPart\fP returns the years state variable value.
.IP "RETURN VALUE"
This method returns the years state variable value.
.IP EXAMPLES
In the next example we create an object of type \f(HONDuration\fP 
because \f(HODuration\fP is a non-instanciable type.
.CS L
VAR nDuration : NDuration::NDuration;
VAR years     : INT;
\&...
years := nDuration.GetYearPart ();
.CE
Then \f(HOyears\fP contains the value "1".
.IP "SEE ALSO"
\f(HONDuration::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::IsEqual'"
.EH "'Duration::IsEqual''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsEqual"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD IsEqual (IN inOperand : Duration) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEqual\fP compares two durations (two 
\f(HONDuration\fPs or two \f(HOWDuration\fPs). 
The comparison is made between years and months of the objects and 
between days of the objects.
.IP "RETURN VALUE"
This method returns a boolean that is the result of the comparison.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONotComparableDurations\fP"
is raised if years and months of one object are lower than years and 
months of the other object and days of the first object are greater than
days of the second object. 
The exception is also raised in the opposite case.
.IP EXAMPLES
In the next example we create an object of type \f(HONDuration\fP 
because \f(HODuration\fP is a non-instanciable type.
.CS L
VAR nDuration : NDuration::NDuration;
VAR operand   : NDuration::NDuration;
VAR result    : BOOL;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
operand   := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
result    := nDuration.IsEqual (operand);
.CE
Then \f(HOresult\fP contains the value TRUE.
.IP "SEE ALSO"
\f(HONDuration::IsEqual\fP, 
\f(HOWDuration: IsEqual\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::IsLonger'"
.EH "'Duration::IsLonger''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsLonger"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD IsLonger (IN inOperand : Duration) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLonger\fP compares two durations (two 
\f(HONDuration\fPs or two \f(HOWDuration\fPs). 
The comparison is made between years and months of the objects and 
between days of the objects.
.IP "RETURN VALUE"
This method returns a boolean that is the result of the comparison.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONotComparableDurations\fP"
is raised if years and months of one object are lower than years and 
months of the other object and days of the first object are greater than
days of the second object. 
The exception is also raised in the opposite case.
.IP EXAMPLES
In the next example we create an object of type \f(HONDuration\fP 
because \f(HODuration\fP is a non-instanciable type.
.CS L
VAR nDuration : NDuration::NDuration;
VAR operand   : NDuration::NDuration;
VAR result    : BOOL;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
operand   := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
result    := nDuration.IsLonger (operand);
.CE
Then \f(HOresult\fP contains the value FALSE.
.IP "SEE ALSO"
\f(HONDuration::IsLonger\fP, 
\f(HOWDuration::IsLonger\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::IsNull'"
.EH "'Duration::IsNull''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsNull"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD IsNull () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsNull\fP returns a boolean that indicates whether the 
\f(HODuration\fP is null (all its states variables have the value 0).
.IP "RETURN VALUE"
This method returns a boolean that indicates whether the 
\f(HODuration\fP is null (all its states variables have the value 0).
.IP EXAMPLES
In the next example we create an object of type \f(HONDuration\fP 
because \f(HODuration\fP is a non-instanciable type.
.CS L
VAR nDuration : NDuration::NDuration;
VAR result    : BOOL;
\&...
nDuration := NEW NDuration::NDuration (0, 0, 0, 0, 0, 0);
result    := nDuration.IsNull ();
.CE
Then \f(HOresult\fP contains the value TRUE.
.IP "SEE ALSO"
\f(HONDuration::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::IsShorter'"
.EH "'Duration::IsShorter''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsShorter"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD IsShorter (IN inOperand : Duration) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsShorter\fP compares two durations (two 
\f(HONDuration\fPs or two \f(HOWDuration\fPs). 
The comparison is made between years and months of the objects and 
between days of the objects.
.IP "RETURN VALUE"
This method returns a boolean that is the result of the comparison.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONotComparableDurations\fP"
is raised if years and months of one object are lower than years and 
months of the other object and days of the first object are greater than
days of the second object. 
The exception is also raised in the opposite case.
.IP EXAMPLES
In the next example we create an object of type \f(HONDuration\fP 
because \f(HODuration\fP is a non-instanciable type.
.CS L
VAR nDuration : NDuration::NDuration;
VAR operand   : NDuration::NDuration;
VAR result    : BOOL;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
operand   := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
result    := nDuration.IsShorter (operand);
.CE
Then \f(HOresult\fP contains the value FALSE.
.IP "SEE ALSO"
\f(HONDuration::IsShorter\fP, 
\f(HOWDuration::IsShorter\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::Multiply'"
.EH "'Duration::Multiply''CoLibrEX Reference Manual'"
.bp
.NX 3 "Multiply"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD Multiply (IN inFactor : INT);\fP
.IP DESCRIPTION
Method deferred. It is implemented in the sub types.
.IP "SEE ALSO"
\f(HONDuration::Multiply\fP,
\f(HOWDuration::Multiply\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::Subtract'"
.EH "'Duration::Subtract''CoLibrEX Reference Manual'"
.bp
.NX 3 "Subtract"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD Subtract (IN inExtent : Duration);\fP
.IP DESCRIPTION
Method deferred. It is implemented in the sub types.
.IP "SEE ALSO"
\f(HONDuration::Subtract\fP, 
\f(HOWDuration::Subtract\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::ToMonths'"
.EH "'Duration::ToMonths''CoLibrEX Reference Manual'"
.bp
.NX 3 "ToMonths"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD ToMonths () : INT;\fP
.IP DESCRIPTION
The method \f(HOToMonths\fP returns the number of months in the current 
\f(HODuration\fP calculated from state variables months and years. 
This method is internally used together with the method 
\f(HOToSeconds\fP to make comparisons between two \f(HODuration\fPs.
.IP "RETURN VALUE"
This method returns the number of months in the current \f(HODuration\fP
 calculated from state variables months and years.
.IP EXAMPLES
In the next example we create an object of type \f(HONDuration\fP 
because \f(HODuration\fP is a non-instanciable type.
.CS L
VAR nDuration : NDuration::NDuration;
VAR months    : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
months    := nDuration.ToMonths ();
.CE
Then \f(HOmonths\fP contains the value "14".
.IP "SEE ALSO"
\f(HONDuration::INITIALLY\fP,
\f(HOToSeconds\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration::ToSeconds'"
.EH "'Duration::ToSeconds''CoLibrEX Reference Manual'"
.bp
.NX 3 "ToSeconds"
.sp
.IP MODULE
\f(HBDuration\fP
.IP TYPE
\f(HBDuration\fP
.IP SYNOPSIS
\f(HBMETHOD ToSeconds () : INT;\fP
.IP DESCRIPTION
The method \f(HOToSeconds\fP returns the number of seconds in the 
current \f(HODuration\fP calculated from the state variable days. 
This method is internally used together with the method \f(HOToMonths\fP
to make comparisons between two \f(HODuration\fPs.
.IP "RETURN VALUE"
This method returns the number of seconds in the current 
\f(HODuration\fP calculated from the state variable days.
.IP EXAMPLES
In the next example we create an object of type \f(HOWDuration\fP 
because \f(HODuration\fP is a non-instanciable type.
.CS L
VAR wDuration : WDuration::WDuration;
VAR seconds   : INT;
\&...
wDuration := NEW WDuration::WDuration (1, 2, 3);
seconds   := wDuration.ToSeconds ();
.CE
Then \f(HOseconds\fP contains the value 3 * 24 * 60 * 60 = "259200".
.IP "SEE ALSO"
\f(HOToMonths\fP,
\f(HOWDuration::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Duration'"
.EH "'Duration''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HODuration\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$IN$inYears$INT$NotInstanciableType
$IN$inMonths$INT$
$IN$inDays$INT$
$result$$Duration$
_
Add$IN$inExtent$Duration$
_
Copy$result$$Duration$
_
Divide$IN$inDivisor$INT$
_
GetDayPart$result$$INT$
_
GetMonthPart$result$$INT$
_
GetYearPart$result$$INT$
_
IsEqual$IN$inOperand$Duration$NotComparableDurations
$result$$BOOL$
_
IsLonger$IN$inOperand$Duration$NotComparableDurations
$result$$BOOL$
_
IsNull$result$$BOOL$
_
IsShorter$IN$inOperand$Duration$NotComparableDurations
$result$$BOOL$
_
Multiply$IN$inFactor$INT$
_
Subtract$IN$inExtent$Duration$
_
ToMonths$result$$INT$
_
ToSeconds$result$$INT$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
.OH "'CoLibrEX Reference Manual''NDuration'"
.EH "'NDuration''CoLibrEX Reference Manual'"
.NX 1 "NDuration"
.sp
.NX 2 "Type Description"
.sp
\f(HONDuration\fP is a sub type of \f(HODuration\fP representing a 
duration consisting of years, months, days, hours, minutes and seconds. 
The values of years and months are automatically converted, if they are 
out of range (months with a greater value than 12 are converted into 
years and negative months are subtracted from years). 
The values of days, hours, minutes and seconds are also automatically 
converted, if they are out of range.
.sp
.NX 2 "List of Methods"
.sp
The following methods are available in <NDuration.cs>:
.TS
tab ($);
l l.
Method name$R(edefined)/N(ew)
_
Add$R
Copy$R
Divide$R
GetDayPart$
GetDays$N
GetHourPart$N
GetHours$N
GetMinutePart$N
GetMinutes$N
GetMonthPart$
GetMonths$N
GetQuarters$N
GetSecondPart$N
GetSeconds$N
GetSemesters$N
GetWeeks$N
GetYearPart$
GetYears$N
IsEqual$R
IsLonger$R
IsNull$
IsShorter$R
Multiply$R
SetNDuration$N
Subtract$R
ToMonths$
ToSeconds$R
.TE
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
The following exceptions can be raised using module \f(HONDuration\fP :
.TS
tab($);
l.
exception name
_
NegativeDuration
NotComparableDurations
NotNaturalDuration
.TE
.sp
.NX 2 "How to use NDuration"
.sp
A variable of type \f(HONDuration\fP is declared, as follows:
.CS L
VAR nDuration : NDuration;
.CE
.sp 0.5
A variable of type \f(HONDuration\fP can be initialized using the CooL 
constructor NEW.
.sp 0.5
A sub type of type \f(HONDuration\fP is declared, as follows:
.CS L
TYPE MyNDuration = NDuration OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HONDuration\fP must 
import \f(HONDuration\fP:
.CS L
IMPORT ..., NDuration, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HONDuration\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''NDuration::INITIALLY'"
.EH "'NDuration::INITIALLY''CoLibrEX Reference Manual'"
.bp
.NX 3 "INITIALLY"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN inYears $ : INT,
$$ IN inMonths $ : INT,
$$ IN inDays $ : INT,
$$ IN inHours $ : INT,
$$ IN inMinutes $ : INT,
$$ IN inSeconds $ : INT)
$:$ NDuration;$\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW. 
The parameters \f(HOinYears\fP, \f(HOinMonths\fP, \f(HOinDays\fP, 
\f(HOinHours\fP, \f(HOinMinutes\fP and \f(HOinSeconds\fP specify the 
natural duration of the current object.
.IP "RETURN VALUE"
This method returns a new object of this class containing 
\f(HOinYears\fP, \f(HOinMonths\fP, \f(HOinDays\fP, \f(HOinHours\fP, 
\f(HOinMinutes\fP and \f(HOinSeconds\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised if \f(HOinYears\fP, \f(HOinMonths\fP, \f(HOinDays\fP, 
\f(HOinHours\fP, \f(HOinMinutes\fP and \f(HOinSeconds\fP represent a 
negative duration.
.IP EXAMPLES
.CS L
VAR years     : INT;
VAR months    : INT;
VAR days      : INT;
VAR hours     : INT;
VAR minutes   : INT;
VAR seconds   : INT;
VAR nDuration : NDuration::NDuration;
\&...
years     := 1;
months    := 2;
days      := 3;
hours     := 4;
minutes   := 5;
seconds   := 6;
nDuration := NEW NDuration::NDuration (years, months, days, 
                                       hours, minutes, seconds);
.CE
.IP "SEE ALSO"
\f(HOSetNDuration\fP
.OH "'CoLibrEX Reference Manual''NDuration::Add'"
.EH "'NDuration::Add''CoLibrEX Reference Manual'"
.LP
.bp
.NX 3 "Add"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Add (IN inExtent : Duration);\fP
.IP DESCRIPTION
The method \f(HOAdd\fP adds the input \f(HODuration\fP (that must be a 
\f(HONDuration\fP) to the current \f(HONDuration\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONotNaturalDuration\fP"
is raised if the input \f(HODuration\fP is not a \f(HONDuration\fP.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR extent    : NDuration::NDuration;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
extent    := NEW NDuration::NDuration (2, 3, 4, 5, 6, 7);
nDuration.Add (extent);
.CE
Then \f(HOnDuration\fP has the value: 3 years, 5 months, 7 days, 9 
hours, 11 minutes and 13 seconds.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODivide\fP,
\f(HOMultiply\fP,
\f(HOSubtract\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::Copy'"
.EH "'NDuration::Copy''CoLibrEX Reference Manual'"
.bp
.NX 3 "Copy"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Copy () : Duration;\fP
.IP DESCRIPTION
The method \f(HOCopy\fP returns an \f(HONDuration\fP that is a copy of 
the current \f(HONDuration\fP.
.IP "RETURN VALUE"
This method returns an \f(HONDuration\fP that is a copy of the current 
\f(HONDuration\fP.
.IP EXAMPLES
.CS L
VAR nDuration  : NDuration::NDuration;
VAR local_copy : NDuration::NDuration;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
TYPESELECT wkDuration := nDuration.Copy () OF
   CASE NDuration :
      local_copy  := wkDuration;
END TYPESELECT;
.CE
Then \f(HOlocal_copy\fP has the same value than \f(HOnDuration\fP.
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::Divide'"
.EH "'NDuration::Divide''CoLibrEX Reference Manual'"
.bp
.NX 3 "Divide"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Divide (IN inDivisor : INT);\fP
.IP DESCRIPTION
The method \f(HODivide\fP divides the current \f(HONDuration\fP by the 
input integer.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR divisor   : INT;
\&...
nDuration := NEW NDuration::NDuration (2, 4, 6, 8, 10, 12);
divisor   := 2;
nDuration.Divide (divisor);
.CE
Then \f(HOnDuration\fP has the value: 1 year, 2 months, 3 days, 4 hours,
5 minutes and 6 seconds.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HOMultiply\fP,
\f(HOSubtract\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::GetDays'"
.EH "'NDuration::GetDays''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetDays"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetDays () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetDays\fP returns the total number of days of the 
current \f(HONDuration\fP object calculated from state variables years,
months and days.
.IP "RETURN VALUE"
This method returns the total number of days of the current 
\f(HONDuration\fP object calculated from state variables years, months 
and days.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR days      : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
days      := nDuration.GetDays ();
.CE
Then \f(HOdays\fP contains the value "428" days.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetHourPart\fP,
\f(HOGetHours\fP,
\f(HOGetMinutePart\fP,
\f(HOGetMinutes\fP,
\f(HOGetMonths\fP,
\f(HOGetQuarters\fP,
\f(HOGetSecondPart\fP,
\f(HOGetSeconds\fP,
\f(HOGetSemesters\fP,
\f(HOGetWeeks\fP,
\f(HOGetYears\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::GetHourPart'"
.EH "'NDuration::GetHourPart''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetHourPart"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetHourPart () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetHourPart\fP returns the hours state variable value.
.IP "RETURN VALUE"
This method returns the hours state variable value.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR hours     : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
hours     := nDuration.GetHourPart ();
.CE
Then \f(HOhours\fP contains the value "4".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetDays\fP,
\f(HOGetHours\fP,
\f(HOGetMinutePart\fP,
\f(HOGetMinutes\fP,
\f(HOGetMonths\fP,
\f(HOGetQuarters\fP,
\f(HOGetSecondPart\fP,
\f(HOGetSeconds\fP,
\f(HOGetSemesters\fP,
\f(HOGetWeeks\fP,
\f(HOGetYears\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::GetHours'"
.EH "'NDuration::GetHours''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetHours"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetHours () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetHours\fP returns the total number of hours of the 
current \f(HONDuration\fP object calculated from state variables years,
months, days and hours.
.IP "RETURN VALUE"
This method returns the total number of hours of the current 
\f(HONDuration\fP object calculated from state variables years, months,
days and hours.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR hours     : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
hours     := nDuration.GetHours ();
.CE
Then \f(HOhours\fP contains the value "10276" hours.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetDays\fP,
\f(HOGetHourPart\fP,
\f(HOGetMinutePart\fP,
\f(HOGetMinutes\fP,
\f(HOGetMonths\fP,
\f(HOGetQuarters\fP,
\f(HOGetSecondPart\fP,
\f(HOGetSeconds\fP,
\f(HOGetSemesters\fP,
\f(HOGetWeeks\fP,
\f(HOGetYears\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::GetMinutePart'"
.EH "'NDuration::GetMinutePart''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetMinutePart"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetMinutePart () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetMinutePart\fP returns the minutes state variable 
value.
.IP "RETURN VALUE"
This method returns the minutes state variable value.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR minutes   : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
minutes   := nDuration.GetMinutePart ();
.CE
Then \f(HOminutes\fP contains the value "5".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetDays\fP,
\f(HOGetHourPart\fP,
\f(HOGetHours\fP,
\f(HOGetMinutes\fP,
\f(HOGetMonths\fP,
\f(HOGetQuarters\fP,
\f(HOGetSecondPart\fP,
\f(HOGetSeconds\fP,
\f(HOGetSemesters\fP,
\f(HOGetWeeks\fP,
\f(HOGetYears\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::GetMinutes'"
.EH "'NDuration::GetMinutes''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetMinutes"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetMinutes () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetMinutes\fP returns the total number of minutes of 
the current \f(HONDuration\fP object calculated from state variables 
years, months, days, hours and minutes.
.IP "RETURN VALUE"
This method returns the total number of minutes of the current 
\f(HONDuration\fP object calculated from state variables years, months,
days, hours and minutes.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR minutes   : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
minutes   := nDuration.GetMinutes ();
.CE
Then \f(HOminutes\fP contains the value "616565" minutes.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetDays\fP,
\f(HOGetHourPart\fP,
\f(HOGetHours\fP,
\f(HOGetMinutePart\fP,
\f(HOGetMonths\fP,
\f(HOGetQuarters\fP,
\f(HOGetSecondPart\fP,
\f(HOGetSeconds\fP,
\f(HOGetSemesters\fP,
\f(HOGetWeeks\fP,
\f(HOGetYears\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::GetMonths'"
.EH "'NDuration::GetMonths''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetMonths"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetMonths () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetMonths\fP returns the total number of months of the 
current \f(HONDuration\fP object calculated from state variables years,
months and days.
.IP "RETURN VALUE"
This method returns the total number of months of the current 
\f(HONDuration\fP object calculated from state variables years, months 
and days.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR months    : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
months    := nDuration.GetMonths ();
.CE
Then \f(HOmonths\fP contains the value "14" months.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetDays\fP,
\f(HOGetHourPart\fP,
\f(HOGetHours\fP,
\f(HOGetMinutePart\fP,
\f(HOGetMinutes\fP,
\f(HOGetQuarters\fP,
\f(HOGetSecondPart\fP,
\f(HOGetSeconds\fP,
\f(HOGetSemesters\fP,
\f(HOGetWeeks\fP,
\f(HOGetYears\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::GetQuarters'"
.EH "'NDuration::GetQuarters''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetQuarters"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetQuarters () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetQuarters\fP returns the total number of quarters of 
the current \f(HONDuration\fP object calculated from state variables 
years, months and days.
.IP "RETURN VALUE"
This method returns the total number of quarters of the current 
\f(HONDuration\fP object calculated from state variables years, months 
and days.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR quarters  : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
quarters  := nDuration.GetQuarters ();
.CE
Then \f(HOquarters\fP contains the value "4" quarters.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetDays\fP,
\f(HOGetHourPart\fP,
\f(HOGetHours\fP,
\f(HOGetMinutePart\fP,
\f(HOGetMinutes\fP,
\f(HOGetMonths\fP,
\f(HOGetSecondPart\fP,
\f(HOGetSeconds\fP,
\f(HOGetSemesters\fP,
\f(HOGetWeeks\fP,
\f(HOGetYears\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::GetSecondPart'"
.EH "'NDuration::GetSecondPart''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetSecondPart"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetSecondPart () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetSecondPart\fP returns the seconds state variable 
value.
.IP "RETURN VALUE"
This method returns the seconds state variable value.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR seconds   : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
seconds   := nDuration.GetSecondPart ();
.CE
Then \f(HOseconds\fP contains the value "6".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetDays\fP,
\f(HOGetHourPart\fP,
\f(HOGetHours\fP,
\f(HOGetMinutePart\fP,
\f(HOGetMinutes\fP,
\f(HOGetMonths\fP,
\f(HOGetQuarters\fP,
\f(HOGetSeconds\fP,
\f(HOGetSemesters\fP,
\f(HOGetWeeks\fP,
\f(HOGetYears\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::GetSeconds'"
.EH "'NDuration::GetSeconds''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetSeconds"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetSeconds () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetSeconds\fP returns the total number of seconds of the
current \f(HONDuration\fP object calculated from state variables years,
months, days, hours, minutes and seconds.
.IP "RETURN VALUE"
This method returns the total number of seconds of the current 
\f(HONDuration\fP object calculated from state variables years, months,
days, hours, minutes and seconds.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR seconds   : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
seconds   := nDuration.GetSeconds ();
.CE
Then \f(HOseconds\fP contains the value "36993906" seconds.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetDays\fP,
\f(HOGetHourPart\fP,
\f(HOGetHours\fP,
\f(HOGetMinutePart\fP,
\f(HOGetMinutes\fP,
\f(HOGetMonths\fP,
\f(HOGetQuarters\fP,
\f(HOGetSecondPart\fP,
\f(HOGetSemesters\fP,
\f(HOGetWeeks\fP,
\f(HOGetYears\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::GetSemesters'"
.EH "'NDuration::GetSemesters''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetSemesters"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetSemesters () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetSemesters\fP returns the total number of semesters of
the current \f(HONDuration\fP object calculated from state variables 
years, months and days.
.IP "RETURN VALUE"
This method returns the total number of semesters of the current 
\f(HONDuration\fP object calculated from state variables years, months 
and days.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR semesters : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
semesters := nDuration.GetSemesters ();
.CE
Then \f(HOsemesters\fP contains the value "2" semesters.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetDays\fP,
\f(HOGetHourPart\fP,
\f(HOGetHours\fP,
\f(HOGetMinutePart\fP,
\f(HOGetMinutes\fP,
\f(HOGetMonths\fP,
\f(HOGetQuarters\fP,
\f(HOGetSecondPart\fP,
\f(HOGetSeconds\fP,
\f(HOGetWeeks\fP,
\f(HOGetYears\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::GetWeeks'"
.EH "'NDuration::GetWeeks''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetWeeks"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetWeeks () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetWeeks\fP returns the total number of weeks of the 
current \f(HONDuration\fP object calculated from state variables years,
months and days.
.IP "RETURN VALUE"
This method returns the total number of weeks of the current 
\f(HONDuration\fP object calculated from state variables years, months 
and days.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR weeks     : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
weeks     := nDuration.GetWeeks ();
.CE
Then \f(HOweeks\fP contains the value "61" weeks.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetDays\fP,
\f(HOGetHourPart\fP,
\f(HOGetHours\fP,
\f(HOGetMinutePart\fP,
\f(HOGetMinutes\fP,
\f(HOGetMonths\fP,
\f(HOGetQuarters\fP,
\f(HOGetSecondPart\fP,
\f(HOGetSeconds\fP,
\f(HOGetSemesters\fP,
\f(HOGetYears\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::GetYears'"
.EH "'NDuration::GetYears''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetYears"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetYears () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetYears\fP returns the total number of years of the 
current \f(HONDuration\fP object calculated from state variables years,
months and days.
.IP "RETURN VALUE"
This method returns the total number of years of the current 
\f(HONDuration\fP object calculated from state variables years, months 
and days.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR years     : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
years     := nDuration.GetYears ();
.CE
Then \f(HOyears\fP contains the value "1" year.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetDays\fP,
\f(HOGetHourPart\fP,
\f(HOGetHours\fP,
\f(HOGetMinutePart\fP,
\f(HOGetMinutes\fP,
\f(HOGetMonths\fP,
\f(HOGetQuarters\fP,
\f(HOGetSecondPart\fP,
\f(HOGetSeconds\fP,
\f(HOGetSemesters\fP,
\f(HOGetWeeks\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::IsEqual'"
.EH "'NDuration::IsEqual''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsEqual"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD IsEqual (IN inOperand : Duration) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEqual\fP compares the input \f(HODuration\fP (that 
must be a \f(HONDuration\fP) with the current \f(HONDuration\fP. 
The comparison is made between years and months of the objects and 
between days, hours, minutes and seconds of the objects.
.IP "RETURN VALUE"
This method returns a boolean that is the result of the comparison.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONotComparableDurations\fP"
is raised if years and months of one object are lower than years and 
months of the other object and days, hours, minutes and seconds of the 
first object are greater than days, hours, minutes and seconds of the 
second object. 
.IP "\(bu \f(HONotNaturalDuration\fP"
is raised if the input \f(HODuration\fP is not a \f(HONDuration\fP.  
The exception is also raised in the opposite case.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR operand   : NDuration::NDuration;
VAR result    : BOOL;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
operand   := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
result    := nDuration.IsEqual (operand);
.CE
Then \f(HOresult\fP contains the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsLonger\fP,
\f(HOIsNull\fP,
\f(HOIsShorter\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::IsLonger'"
.EH "'NDuration::IsLonger''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsLonger"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD IsLonger (IN inOperand : Duration) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLonger\fP compares the input \f(HODuration\fP (that 
must be a \f(HONDuration\fP) with the current \f(HONDuration\fP. 
The comparison is made between years and months of the objects and 
between days, hours, minutes and seconds of the objects.
.IP "RETURN VALUE"
This method returns a boolean that is the result of the comparison.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONotComparableDurations\fP"
is raised if years and months of one object are lower than years and 
months of the other object and days, hours, minutes and seconds of the 
first object are greater than days, hours, minutes and seconds of the 
second object. 
The exception is also raised in the opposite case.
.IP "\(bu \f(HONotNaturalDuration\fP"
is raised if the input \f(HODuration\fP is not a \f(HONDuration\fP.  
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR operand   : NDuration::NDuration;
VAR result    : BOOL;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
operand   := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
result    := nDuration.IsLonger (operand);
.CE
Then \f(HOresult\fP contains the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsEqual\fP,
\f(HOIsNull\fP,
\f(HOIsShorter\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::IsShorter'"
.EH "'NDuration::IsShorter''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsShorter"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD IsShorter (IN inOperand : Duration) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsShorter\fP compares the input \f(HODuration\fP (that 
must be a \f(HONDuration\fP) with the current \f(HONDuration\fP. 
The comparison is made between years and months of the objects and 
between days, hours, minutes and seconds of the objects.
.IP "RETURN VALUE"
This method returns a boolean that is the result of the comparison.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONotComparableDurations\fP"
is raised if years and months of one object are lower than years and 
months of the other object and days, hours, minutes and seconds of the 
first object are greater than days, hours, minutes and seconds of the 
second object. 
The exception is also raised in the opposite case.
.IP "\(bu \f(HONotNaturalDuration\fP"
is raised if the input \f(HODuration\fP is not a \f(HONDuration\fP.  
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR operand   : NDuration::NDuration;
VAR result    : BOOL;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
operand   := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
result    := nDuration.IsShorter (operand);
.CE
Then \f(HOresult\fP contains the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsEqual\fP,
\f(HOIsLonger\fP,
\f(HOIsNull\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::Multiply'"
.EH "'NDuration::Multiply''CoLibrEX Reference Manual'"
.bp
.NX 3 "Multiply"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Multiply (IN inFactor : INT);\fP
.IP DESCRIPTION
The method \f(HOMultiply\fP multiplies the current \f(HONDuration\fP by 
the input factor.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR factor    : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
factor    := 2;
nDuration.Multiply (factor);
.CE
Then \f(HOnDuration\fP has the value: 2 years, 4 months, 6 days, 8 
hours, 10 minutes and 12 seconds.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HODivide\fP,
\f(HOSubtract\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::SetNDuration'"
.EH "'NDuration::SetNDuration''CoLibrEX Reference Manual'"
.bp
.NX 3 "SetNDuration"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD SetNDuration ($ IN inYears $ : INT,
$ IN inMonths $ : INT,
$ IN inDays $ : INT,
$ IN inHours $ : INT,
$ IN inMinutes $ : INT,
$ IN inSeconds $ : INT);\fP
.TE
.IP DESCRIPTION
The method \f(HOSetNDuration\fP assigns the values of the parameters 
\f(HOinYears\fP, \f(HOinMonths\fP, \f(HOinDays\fP, \f(HOinHours\fP, 
\f(HOinMinutes\fP and \f(HOinSeconds\fP to the current object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised if \f(HOinYears\fP, \f(HOinMonths\fP, \f(HOinDays\fP, 
\f(HOinHours\fP, \f(HOinMinutes\fP and \f(HOinSeconds\fP represent a 
negative duration. 
If the exception is raised, the previous state values of the 
\f(HONDuration\fP are kept.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
nDuration.SetNDuration (2, 3, 4, 5, 6, 7);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::Subtract'"
.EH "'NDuration::Subtract''CoLibrEX Reference Manual'"
.bp
.NX 3 "Subtract"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Subtract (IN inExtent : Duration);\fP
.IP DESCRIPTION
The method \f(HOSubtract\fP subtracts the input \f(HODuration\fP (that 
must be a \f(HONDuration\fP) to the current \f(HONDuration\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised if the input duration is longer than the current duration.
.IP "\(bu \f(HONotNaturalDuration\fP"
is raised if the input \f(HODuration\fP is not a \f(HONDuration\fP. 
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR extent    : NDuration::NDuration;
\&...
nDuration := NEW NDuration::NDuration (2, 3, 4, 5, 6, 7);
extent    := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
nDuration.Subtract (extent);
.CE
Then \f(HOnDuration\fP has the value: 1 year, 1 month, 1 day, 1 hour, 1
minute and 1 second.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HODivide\fP,
\f(HOMultiply\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration::ToSeconds'"
.EH "'NDuration::ToSeconds''CoLibrEX Reference Manual'"
.bp
.NX 3 "ToSeconds"
.sp
.IP MODULE
\f(HBNDuration\fP
.IP TYPE
\f(HBNDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD ToSeconds () : INT;\fP
.IP DESCRIPTION
The method \f(HOToSeconds\fP returns the number of seconds in the 
current \f(HONDuration\fP calculated from state variables days, hours, 
minutes and seconds. 
This method is internally used together with the method \f(HOToMonths\fP
to make comparisons between two \f(HONDuration\fPs.
.IP "RETURN VALUE"
This method returns the number of seconds in the current 
\f(HONDuration\fP calculated from state variables days, hours, minutes 
and seconds.
.IP EXAMPLES
.CS L
VAR nDuration : NDuration::NDuration;
VAR seconds   : INT;
\&...
nDuration := NEW NDuration::NDuration (1, 2, 3, 4, 5, 6);
seconds   := wDuration.ToSeconds ();
.CE
Then \f(HOseconds\fP contains the value "273906".
.IP "SEE ALSO"
\f(HOWDuration::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''NDuration'"
.EH "'NDuration''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HONDuration\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$inYears$INT$NegativeDuration
$$IN$inMonths$INT$
$$IN$inDays$INT$
$$IN$inHours$INT$
$$IN$inMinutes$INT$
$$IN$inSeconds$INT$
$$result$$NDuration$
_
R$Add$IN$inExtent$Duration$NotNaturalDuration
_
R$Copy$result$$Duration$
_
R$Divide$IN$inDivisor$INT$
_
$GetDayPart$result$$INT$
_
N$GetDays$result$$INT$
_
N$GetHourPart$result$$INT$
_
N$GetHours$result$$INT$
_
N$GetMinutePart$result$$INT$
_
N$GetMinutes$result$$INT$
_
$GetMonthPart$result$$INT$
_
N$GetMonths$result$$INT$
_
N$GetQuarters$result$$INT$
_
N$GetSecondPart$result$$INT$
_
N$GetSeconds$result$$INT$
_
N$GetSemesters$result$$INT$
_
N$GetWeeks$result$$INT$
_
$GetYearPart$result$$INT$
_
N$GetYears$result$$INT$
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
R$IsEqual$IN$inOperand$Duration$NotComparableDurations
$result$$BOOL$NotNaturalDuration
_
R$IsLonger$IN$inOperand$Duration$NotComparableDurations
$result$$BOOL$NotNaturalDuration
_
$IsNull$result$$BOOL$
_
R$IsShorter$IN$inOperand$Duration$NotComparableDurations
$result$$BOOL$NotNaturalDuration
_
R$Multiply$IN$inFactor$INT$
_
N$SetNDuration$IN$inYears$INT$NegativeDuration
$$IN$inMonths$INT$
$$IN$inDays$INT$
$$IN$inHours$INT$
$$IN$inMinutes$INT$
$$IN$inSeconds$INT$
_
R$Subtract$IN$inExtent$Duration$NegativeDuration
$$$$$NotNaturalDuration
_
$ToMonths$result$$INT$
_
R$ToSeconds$result$$INT$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibrEX Reference Manual''WDuration'"
.EH "'WDuration''CoLibrEX Reference Manual'"
.NX 1 "WDuration"
.sp
.NX 2 "Type Description"
.sp
\f(HOWDuration\fP is a sub type of \f(HODuration\fP representing a 
duration consisting of years, months and days based on a 
\f(HOCalendar\fP. 
The values of years and months are automatically converted, if they are 
out of range (months with a greater value than 12 are converted into 
years and negative months are subtracted from years).
.sp
.NX 2 "List of Methods"
.sp
The following methods are available in <WDuration.cs>:
.TS
tab ($);
l l.
Method name$R(edefined)/N(ew)
_
Add$R
Copy$R
Divide$R
GetCalendar$N
GetDayPart$
GetMonthPart$
GetYearPart$
IsEqual$R
IsLonger$R
IsNull$
IsShorter$R
Multiply$R
SetWDuration$N
Subtract$R
ToMonths$
ToSeconds$
.TE
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
.KS
The following exceptions can be raised using module \f(HOWDuration\fP :
.TS
tab($);
l.
exception name
_
NegativeDuration
NotComparableDurations
NotEqualCalendars
NotWorkingDuration
.TE
.KE
.sp
.NX 2 "How to use WDuration"
.sp
A variable of type \f(HOWDuration\fP is declared, as follows:
.CS L
VAR wDuration : WDuration;
.CE
.sp 0.5
A variable of type \f(HOWDuration\fP can be initialized using the CooL 
constructor NEW.
.sp 0.5
A sub type of type \f(HOWDuration\fP is declared, as follows:
.CS L
TYPE MyWDuration = WDuration OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HOWDuration\fP must 
import \f(HOWDuration\fP:
.CS L
IMPORT ..., WDuration, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOWDuration\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''WDuration::INITIALLY'"
.EH "'WDuration::INITIALLY''CoLibrEX Reference Manual'"
.bp
.NX 3 "INITIALLY"
.sp
.IP MODULE
\f(HBWDuration\fP
.IP TYPE
\f(HBWDuration = Duration\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN inYears $ : INT,
$$ IN inMonths $ : INT,
$$ IN inDays $ : INT,
$$ IN inCalendar $ : Calendar)
$:$ WDuration;$\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW. 
The parameters \f(HOinYears\fP, \f(HOinMonths\fP, \f(HOinDays\fP and 
\f(HOinCalendar\fP specify the working duration of the current object.
.IP "RETURN VALUE"
This method returns a new object of this class containing 
\f(HOinYears\fP, \f(HOinMonths\fP, \f(HOinDays\fP and 
\f(HOinCalendar\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised if \f(HOinYears\fP, \f(HOinMonths\fP and \f(HOinDays\fP 
represent a negative duration.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR years     : INT;
VAR months    : INT;
VAR days      : INT;
VAR calendar  : Calendar::Calendar;
VAR wDuration : WDuration::WDuration;
\&...
years     := 1;
months    := 2;
days      := 3;
wDuration := NEW WDuration::WDuration (years, months, days, calendar);
.CE
.IP "SEE ALSO"
\f(HOSetWDuration\fP
.LP
.OH "'CoLibrEX Reference Manual''WDuration::Add'"
.EH "'WDuration::Add''CoLibrEX Reference Manual'"
.bp
.NX 3 "Add"
.sp
.IP MODULE
\f(HBWDuration\fP
.IP TYPE
\f(HBWDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Add (IN inExtent : Duration);\fP
.IP DESCRIPTION
The method \f(HOAdd\fP adds the input \f(HODuration\fP (that must be a 
\f(HOWDuration\fP) to the current \f(HOWDuration\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONotEqualCalendars\fP"
is raised if both \f(HOWDurations\fP are based on different 
\f(HOCalendars\fP.
.IP "\(bu \f(HONotWorkingDuration\fP"
is raised if the input \f(HODuration\fP is not a \f(HOWDuration\fP. 
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR wDuration : WDuration::WDuration;
VAR extent    : WDuration::WDuration;
VAR calendar  : Calendar::Calendar;
\&...
wDuration := NEW WDuration::WDuration (1, 2, 3, calendar);
extent    := NEW WDuration::WDuration (2, 3, 4, calendar);
wDuration.Add (extent);
.CE
Then \f(HOwDuration\fP has the value: 3 years, 5 months and 7 days.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODivide\fP,
\f(HOMultiply\fP,
\f(HOSubtract\fP
.LP
.OH "'CoLibrEX Reference Manual''WDuration::Copy'"
.EH "'WDuration::Copy''CoLibrEX Reference Manual'"
.bp
.NX 3 "Copy"
.sp
.IP MODULE
\f(HBWDuration\fP
.IP TYPE
\f(HBWDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Copy () : Duration;\fP
.IP DESCRIPTION
The method \f(HOCopy\fP returns a \f(HOWDuration\fP that is a copy of 
the current \f(HOWDuration\fP.
.IP "RETURN VALUE"
This method returns a \f(HOWDuration\fP that is a copy of the current 
\f(HOWDuration\fP.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR wDuration  : WDuration::WDuration;
VAR local_copy : WDuration::WDuration;
VAR calendar   : Calendar::Calendar;
\&...
wDuration := NEW WDuration::WDuration (1, 2, 3, calendar);
TYPESELECT wkDuration := wDuration.Copy () OF
   CASE WDuration :
      local_copy  := wkDuration;
END TYPESELECT;
.CE
Then \f(HOlocal_copy\fP has the same value than \f(HOwDuration\fP.
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''WDuration::Divide'"
.EH "'WDuration::Divide''CoLibrEX Reference Manual'"
.bp
.NX 3 "Divide"
.sp
.IP MODULE
\f(HBWDuration\fP
.IP TYPE
\f(HBWDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Divide (IN inDivisor : INT);\fP
.IP DESCRIPTION
The method \f(HODivide\fP divides the current \f(HOWDuration\fP by the 
input integer.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR wDuration : WDuration::WDuration;
VAR divisor   : INT;
VAR calendar  : Calendar::Calendar;
\&...
wDuration := NEW WDuration::WDuration (2, 4, 6, calendar);
divisor   := 2;
wDuration.Divide (divisor);
.CE
Then \f(HOwDuration\fP has the value: 1 years, 2 months and 3 days.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HOMultiply\fP,
\f(HOSubtract\fP
.LP
.OH "'CoLibrEX Reference Manual''WDuration::GetCalendar'"
.EH "'WDuration::GetCalendar''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetCalendar"
.sp
.IP MODULE
\f(HBWDuration\fP
.IP TYPE
\f(HBWDuration = Duration\fP
.IP SYNOPSIS
\f(HBMETHOD GetCalendar () : Calendar;\fP
.IP DESCRIPTION
The method \f(HOGetCalendar\fP returns the \f(HOCalendar\fP that the 
\f(HOWDuration\fP is based on.
.IP "RETURN VALUE"
This method returns a \f(HOCalendar\fP that is a copy of the 
\f(HOWDuration\fP \f(HOCalendar\fP.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR wDuration     : WDuration::WDuration;
VAR calendar      : Calendar::Calendar;
VAR calendar_copy : Calendar::Calendar;
\&...
wDuration     := NEW WDuration::WDuration (1, 2, 3, calendar);
calendar_copy := wDuration.GetCalendar ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOCalendar::addLocalNWDay\fP,
\f(HOCalendar::addNormalNWDay\fP,
\f(HOCalendar::addVariableNWDay\fP,
\f(HOCalendar::addWHour\fP,
\f(HOCalendar::setNominator\fP,
\f(HOCalendar::setTimeAddWDuration\fP,
\f(HOCalendar::setTimeSubWDuration\fP,
\f(HOCalendar::setValidPeriod\fP,
\f(HOCalendar::setWDayStart\fP
.LP
.OH "'CoLibrEX Reference Manual''WDuration::IsEqual'"
.EH "'WDuration::IsEqual''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsEqual"
.sp
.IP MODULE
\f(HBWDuration\fP
.IP TYPE
\f(HBWDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD IsEqual (IN inOperand : Duration) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEqual\fP compares the input \f(HODuration\fP (that 
must be a \f(HOWDuration\fP) with the current \f(HOWDuration\fP. 
The comparison is made between years and months of the objects and 
between days of the objects.
.IP "RETURN VALUE"
This method returns a boolean that is the result of the comparison.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONotComparableDurations\fP"
is raised if years and months of one object are lower than years and 
months of the other object and days of the first object are greater 
than days of the second object. 
The exception is also raised in the opposite case. 
.IP "\(bu \f(HONotEqualCalendars\fP"
is raised if we try to compare two \f(HOWDuration\fPs that are based on 
different \f(HOCalendar\fPs.
.IP "\(bu \f(HONotWorkingDuration\fP"
is raised if the input \f(HODuration\fP is not a \f(HOWDuration\fP.  
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR wDuration : WDuration::WDuration;
VAR operand   : WDuration::WDuration;
VAR result    : BOOL;
VAR calendar  : Calendar::Calendar;
\&...
wDuration := NEW WDuration::WDuration (1, 2, 3, calendar);
operand   := NEW WDuration::WDuration (1, 2, 3, calendar);
result    := wDuration.IsEqual (operand);
.CE
Then result contains the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsLonger\fP,
\f(HOIsShorter\fP
.LP
.OH "'CoLibrEX Reference Manual''WDuration::IsLonger'"
.EH "'WDuration::IsLonger''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsLonger"
.sp
.IP MODULE
\f(HBWDuration\fP
.IP TYPE
\f(HBWDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD IsLonger (IN inOperand : Duration) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLonger\fP compares the input \f(HODuration\fP (that 
must be a \f(HOWDuration\fP) with the current \f(HOWDuration\fP. 
The comparison is made between years and months of the objects and 
between days of the objects.
.IP "RETURN VALUE"
This method returns a boolean that is the result of the comparison.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONotComparableDurations\fP"
is raised if years and months of one object are lower than years and 
months of the other object and days of the first object are greater 
than days of the second object. 
The exception is also raised in the opposite case. 
.IP "\(bu \f(HONotEqualCalendars\fP"
is raised if we try to compare two \f(HOWDuration\fPs that are based on 
different \f(HOCalendar\fPs.
.IP "\(bu \f(HONotWorkingDuration\fP"
is raised if the input \f(HODuration\fP is not a \f(HOWDuration\fP.  
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR wDuration : WDuration::WDuration;
VAR operand   : WDuration::WDuration;
VAR result    : BOOL;
VAR calendar  : Calendar::Calendar;
\&...
wDuration := NEW WDuration::WDuration (1, 2, 3, calendar);
operand   := NEW WDuration::WDuration (1, 2, 3, calendar);
result    := nDuration.IsLonger (operand);
.CE
Then \f(HOresult\fP contains the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsEqual\fP,
\f(HOIsShorter\fP
.LP
.OH "'CoLibrEX Reference Manual''WDuration::IsShorter'"
.EH "'WDuration::IsShorter''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsShorter"
.sp
.IP MODULE
\f(HBWDuration\fP
.IP TYPE
\f(HBWDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD IsShorter (IN inOperand : Duration) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsShorter\fP compares the input \f(HODuration\fP (that 
must be a \f(HOWDuration\fP) with the current \f(HOWDuration\fP. 
The comparison is made between years and months of the objects and 
between days of the objects.
.IP "RETURN VALUE"
This method returns a boolean that is the result of the comparison.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONotComparableDurations\fP"
is raised if years and months of one object are lower than years and 
months of the other object and days of the first object are greater 
than days of the second object. 
The exception is also raised in the opposite case. 
.IP "\(bu \f(HONotEqualCalendars\fP"
is raised if we try to compare two \f(HOWDuration\fPs that are based on 
different \f(HOCalendar\fPs.
.IP "\(bu \f(HONotWorkingDuration\fP"
is raised if the input \f(HODuration\fP is not a \f(HOWDuration\fP.  
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR wDuration : WDuration::WDuration;
VAR operand   : WDuration::WDuration;
VAR result    : BOOL;
VAR calendar  : Calendar::Calendar;
\&...
wDuration := NEW WDuration::WDuration (1, 2, 3, calendar);
operand   := NEW WDuration::WDuration (1, 2, 3, calendar);
result    := wDuration.IsShorter (operand);
.CE
Then \f(HOresult\fP contains the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsEqual\fP,
\f(HOIsLonger\fP
.LP
.OH "'CoLibrEX Reference Manual''WDuration::Multiply'"
.EH "'WDuration::Multiply''CoLibrEX Reference Manual'"
.bp
.NX 3 "Multiply"
.sp
.IP MODULE
\f(HBWDuration\fP
.IP TYPE
\f(HBWDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Multiply (IN inFactor : INT);\fP
.IP DESCRIPTION
The method \f(HOMultiply\fP multiplies the current \f(HOWDuration\fP by 
the input factor.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR wDuration : WDuration::WDuration;
VAR factor    : INT;
VAR calendar  : Calendar::Calendar;
\&...
wDuration := NEW WDuration::WDuration (1, 2, 3, calendar);
factor    := 2;
wDuration.Multiply (factor);
.CE
Then \f(HOwDuration\fP has the value: 2 years, 4 months and 6 days.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HODivide\fP,
\f(HOSubtract\fP
.LP
.OH "'CoLibrEX Reference Manual''WDuration::SetWDuration'"
.EH "'WDuration::SetWDuration''CoLibrEX Reference Manual'"
.bp
.NX 3 "SetWDuration"
.sp
.IP MODULE
\f(HBWDuration\fP
.IP TYPE
\f(HBWDuration = Duration\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD SetWDuration ($ IN inYears $ : INT,
$ IN inMonths $ : INT,
$ IN inDays $ : INT,
$ IN inCalendar $ : Calendar);\fP
.TE
.IP DESCRIPTION
The method \f(HOSetWDuration\fP assigns the values of the parameters 
\f(HOinYears\fP, \f(HOinMonths\fP, \f(HOinDays\fP and \f(HOinCalendar\fP
to the current object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised if \f(HOinYears\fP, \f(HOinMonths\fP and \f(HOinDays\fP 
represent a negative duration. 
If the exception is raised, the previous state values of the 
\f(HOWDuration\fP are kept.
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fPs are initialized 
and all their state variables set.
.CS L
VAR wDuration    : WDuration::WDuration;
VAR calendar     : Calendar::Calendar;
VAR new_calendar : Calendar::Calendar;
\&...
wDuration := NEW WDuration::WDuration (1, 2, 3, calendar);
\&...
wDuration.SetWDuration (2, 3, 4, new_calendar);
.CE
.IP "SEE ALSO"
\f(HOSubtract\fP
.LP
.OH "'CoLibrEX Reference Manual''WDuration::Subtract'"
.EH "'WDuration::Subtract''CoLibrEX Reference Manual'"
.bp
.NX 3 "Subtract"
.sp
.IP MODULE
\f(HBWDuration\fP
.IP TYPE
\f(HBWDuration = Duration\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Subtract (IN inExtent : Duration);\fP
.IP DESCRIPTION
The method \f(HOSubtract\fP subtracts the input \f(HODuration\fP (that 
must be a \f(HOWDuration\fP) to the current \f(HOWDuration\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeDuration\fP"
is raised if the input duration is longer than the current duration. 
.IP "\(bu \f(HONotComparableDurations\fP"
is raised if years and months of one object are lower than years and 
months of the other object and days of the first object are greater 
than days of the second object. 
The exception is also raised in the opposite case. 
.IP "\(bu \f(HONotEqualCalendars\fP"
is raised if both \f(HOWDuration\fPs are based on different 
\f(HOCalendar\fPs.
.IP "\(bu \f(HONotWorkingDuration\fP"
is raised if the input \f(HODuration\fP is not a \f(HOWDuration\fP. 
.IP EXAMPLES
In the next example suppose that the \f(HOCalendar\fP is initialized 
and all its state variables set.
.CS L
VAR wDuration : WDuration::WDuration;
VAR extent    : WDuration::WDuration;
VAR calendar  : Calendar::Calendar;
\&...
wDuration := NEW WDuration::WDuration (2, 3, 4, calendar);
extent    := NEW WDuration::WDuration (1, 2, 3, calendar);
wDuration.Subtract (extent);
.CE
Then \f(HOwDuration\fP has the value: 1 year, 1 month and 1 day.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HODivide\fP,
\f(HOMultiply\fP
.LP
.OH "'CoLibrEX Reference Manual''WDuration'"
.EH "'WDuration''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOWDuration\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$inYears$INT$NegativeDuration
$$IN$inMonths$INT$
$$IN$inDays$INT$
$$IN$inCalendar$Calendar$
$$result$$WDuration$
_
R$Add$IN$inExtent$Duration$NotEqualCalendars
$$$$$NotWorkingDuration
_
R$Copy$result$$Duration$
_
R$Divide$IN$inDivisor$INT$
_
N$GetCalendar$result$$Calendar$
_
$GetDayPart$result$$INT$
_
$GetMonthPart$result$$INT$
_
$GetYearPart$result$$INT$
_
R$IsEqual$IN$inOperand$Duration$NotComparableDurations
$$result$$BOOL$NotEqualCalendars
$$$$$NotWorkingDuration
_
R$IsLonger$IN$inOperand$Duration$NotComparableDurations
$$result$$BOOL$NotEqualCalendars
$$$$$NotWorkingDuration
_
$IsNull$result$$BOOL$
_
R$IsShorter$IN$inOperand$Duration$NotComparableDurations
$$result$$BOOL$NotEqualCalendars
$$$$$NotWorkingDuration
_
R$Multiply$IN$inFactor$INT$
_
N$SetWDuration$IN$inYears$INT$NegativeDuration
$$IN$inMonths$INT$
$$IN$inDays$INT$
$$IN$inCalendar$Calendar$
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
R$Subtract$IN$inExtent$Duration$NegativeDuration
$$$$$NotComparableDurations
$$$$$NotEqualCalendars
$$$$$NotWorkingDuration
_
$ToMonths$result$$INT$
_
$ToSeconds$result$$INT$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibrEX Reference Manual''Interval'"
.EH "'Interval''CoLibrEX Reference Manual'"
.NX 1 "Interval"
.sp
.NX 2 "Type Description"
.sp
\f(HOInterval\fP is an object type representing an interval consisting 
of a start and end time point. 
This object type offers methods to construct, modify and actualize an 
object and to get information about an object. 
Further methods deal with arithmetic operations and predicates.
.sp
.NX 2 "List of Methods"
.sp
The following methods are available in <Interval.cs>:
.TS
tab($);
l l.
Methodname$M(odified)/N(ew)
_
Add$
AddToEnd$
AddToStart$M
Contains$
ContainsDate$
Copy$
Deserialize$N
GetEnd$
GetNLength$N
GetStart$
GetWLength$N
Intersect$
IsActual$
IsEarlier$
IsEndInSameDay$
IsEndInSameMonth$
IsEndInSameWeek$
IsEndInSameYear$
IsEqual$
IsEqualND$N
IsEqualWD$N
IsInFuture$
IsLater$
IsLongerND$N
IsLongerWD$N
IsOverlapping$
IsPassed$
IsShorterND$N
IsShorterWD$N
IsStartInSameDay$
IsStartInSameMonth$
IsStartInSameWeek$
IsStartInSameYear$
Serialize$N
SetEnd$
SetInterval$N
SetStart$
Subtract$
SubtractFromEnd$M
SubtractFromStart$
Unite$
.TE
.sp 0.5
Modified and new methods are described in the following sections, 
the others are described in the CoLibri Reference Manual (see [1]).
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
The following exceptions can be raised using module \f(HOInterval\fP :
.TS
tab($);
l.
exception name
_
NegativeInterval
.TE
.sp
.NX 2 "How to use Interval"
.sp
A variable of type \f(HOInterval\fP is declared, as follows:
.CS L
VAR interval : Interval;
.CE
.sp 0.5
A variable of type \f(HOInterval\fP can be initialized using the CooL 
constructor NEW.
.sp 0.5
A sub type of type \f(HOInterval\fP is declared, as follows:
.CS L
TYPE MyInterval = Interval OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HOInterval\fP must 
import \f(HOInterval\fP:
.CS L
IMPORT ..., Interval, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOInterval\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''Interval::AddToStart'"
.EH "'Interval::AddToStart''CoLibrEX Reference Manual'"
.bp
.NX 3 "AddToStart"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD AddToStart (IN inExtent : NDuration);\fP
.IP DESCRIPTION
The method \f(HOAddToStart\fP adds \f(HOinExtent\fP to the start date of
the current interval.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeInterval\fP"
is raised if the calculated start date is later than the end date.
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR extent     : NDuration::NDuration;
\&...
start_date := NEW Date::Date (1993, 01, 1);
end_date   := NEW Date::Date (1993, 03, 1);
interval   := NEW Interval::Interval (start_date, end_date);
extent     := NEW NDuration::NDuration (0, 1, 0, 0, 0, 0);
interval.AddToStart (extent);
.CE
Then \f(HOinterval\fP contains "01/02/1993" as start date 
and "01/03/1993" as end date.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HOAddToEnd\fP,
\f(HODate::INITIALLY\fP,
\f(HONDuration::INITIALLY\fP,
\f(HOSubtract\fP,
\f(HOSubtractFromEnd\fP,
\f(HOSubtractFromStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval::Deserialize'"
.EH "'Interval::Deserialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Deserialize"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Deserialize (IN inStream : Stream);\fP
.IP DESCRIPTION
The method \f(HODeserialize\fP loads the state of the \f(HOInterval\fP 
from a \f(HOStream\fP received at \f(HOinStream\fP.
.IP EXAMPLES
.CS L
VAR interval : Interval::Interval;
VAR stream   : Stream::Stream;
\&...
interval     := NEW Interval::Interval (NEW Date::Date (1993,1,1), 
                                        NEW Date::Date (1993,1,2));
interval.Serialize (stream);
DELETE interval;
\&...
interval     := NEW Interval::Interval (NEW Date::Date (1993,1,3), 
                                        NEW Date::Date (1993,1,4));
interval.Deserialize (stream);
.CE
Then \f(HOinterval\fP has the value "01/01/1993" - "02/01/1993".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOSerialize\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval::GetNLength'"
.EH "'Interval::GetNLength''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetNLength"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD GetNLength () : NDuration;\fP
.IP DESCRIPTION
The method \f(HOGetNLength\fP returns the difference in natural days 
between the start and end date of the current interval.
.IP "RETURN VALUE"
This method returns the difference in natural days between the start 
and end date of the current interval.
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR nDuration  : NDuration::NDuration;
\&...
start_date := NEW Date::Date (1993, 01, 1);
end_date   := NEW Date::Date (1993, 01, 2);
interval   := NEW Interval::Interval (start_date, end_date);
nDuration  := interval.GetNLength ();
.CE
Then \f(HOnDuration\fP contains the value: 0 years, 0 months, 1 days, 0 
hours, 0 minutes and 0 seconds.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODate::INITIALLY\fP,
\f(HOGetWLength\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval::GetWLength'"
.EH "'Interval::GetWLength''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetWLength"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD GetWLength (IN inCalendar : Calendar) : WDuration;\fP
.IP DESCRIPTION
The method \f(HOGetWLength\fP returns the difference in working days 
between the start and end date of the current interval according to 
\f(HOinCalendar\fP.
.IP "RETURN VALUE"
This method returns the difference in working days between the start and
end date of the current interval according to \f(HOinCalendar\fP.
.IP EXAMPLES
.CS L
VAR start_date    : Date::Date;
VAR end_date      : Date::Date;
VAR interval      : Interval::Interval;
VAR wDuration     : WDuration::WDuration;
VAR calendar      : Calendar::Calendar;
VAR name          : STRING;
VAR mode          : CHAR;
VAR calendar_arch : CalendarArch::CalendarArch;
\&...
name          := "CalendarFile";
mode          := STREAM_READ;
calendar_arch := NEW CalendarArch::CalendarArch (mode, name);
calendar      := calendar_arch.LoadCalendar();
calendar_arch.Close;
start_date    := NEW Date::Date (1993, 01, 01);
end_date      := NEW Date::Date (1993, 01, 02);
interval      := NEW Interval::Interval (start_date, end_date);
wDuration     := interval.GetWLength ();
.CE
Then the contents of \f(HOwDuration\fP depends on the definition of 
calendar.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOCalendar::INITIALLY\fP,
\f(HOCalendar::Deserialize\fP,
\f(HOCalendarArch::INITIALLY\fP,
\f(HOCalendarArch::LoadCalendar\fP,
\f(HOCalendarArch::Close\fP,
\f(HODate::INITIALLY\fP,
\f(HOGetNLength\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval::IsEqualND'"
.EH "'Interval::IsEqualND''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsEqualND"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsEqualND (IN inOperand : Interval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEqualND\fP tests whether the length of current 
interval is equal to the length of \f(HOinOperand\fP.
Both lengths are measured as natural duration. 
.IP "RETURN VALUE"
This method returns TRUE if the length of current interval is equal to 
the length of \f(HOinOperand\fP.  
Both lengths are measured as natural duration. 
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR interval         : Interval::Interval;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR other_interval   : Interval::Interval;
VAR result           : BOOL;
\&...
start_date       := NEW Date::Date (1993, 01, 1);
end_date         := NEW Date::Date (1993, 02, 1);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1993, 03, 1);
other_end_date   := NEW Date::Date (1993, 04, 1);
other_interval   := NEW Interval::Interval (other_start_date, 
                                            other_end_date);
result           := interval.IsEqualND (other_interval);
.CE
Then \f(HOresult\fP has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODate::INITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsEqualWD\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval::IsEqualWD'"
.EH "'Interval::IsEqualWD''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsEqualWD"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBMETHOD IsEqualWD $($ IN inOperand $ : Interval, 
$$ IN inCalendar $ : Calendar) 
$:$ BOOL;$\fP
.TE
.IP DESCRIPTION
The method \f(HOIsEqualWD\fP tests whether the length of current 
interval is equal to the length of \f(HOinOperand\fP.
Both lengths are measured as working duration according to 
\f(HOinCalendar\fP. 
.IP "RETURN VALUE"
This method returns TRUE if the length of current interval is equal to 
the length of \f(HOinOperand\fP.  
Both lengths are measured as working duration according to 
\f(HOinCalendar\fP. 
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR interval         : Interval::Interval;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR other_interval   : Interval::Interval;
VAR result           : BOOL;
VAR calendar         : Calendar::Calendar;
VAR name             : STRING;
VAR mode             : CHAR;
VAR calendar_arch    : CalendarArch::CalendarArch;
\&...
name             := "CalendarFile";
mode             := STREAM_READ;
calendar_arch    := NEW CalendarArch::CalendarArch (mode, name);
calendar         := calendar_arch.LoadCalendar();
calendar_arch.Close();
start_date       := NEW Date::Date (1993, 01, 01);
end_date         := NEW Date::Date (1993, 02, 01);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1993, 03, 01);
other_end_date   := NEW Date::Date (1993, 04, 01);
other_interval   := NEW Interval::Interval (other_start_date, 
                                            other_end_date);
result           := interval.IsEqualWD (other_interval, calendar);
.CE
Then the \f(HOvalue\fP of result depends on \f(HOCalendar\fP definition.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOCalendar::INITIALLY\fP,
\f(HOCalendar::Deserialize\fP,
\f(HOCalendarArch::INITIALLY\fP,
\f(HOCalendarArch::Close\fP,
\f(HOCalendarArch::LoadCalendar\fP,
\f(HODate::INITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsEqualND\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval::IsLongerND'"
.EH "'Interval::IsLongerND''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsLongerND"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsLongerND (IN inOperand : Interval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLongerND\fP tests whether the length of current 
interval is longer to the length of \f(HOinOperand\fP.
Both lengths are measured as natural duration. 
.IP "RETURN VALUE"
This method returns TRUE if the length of current interval is longer to 
the length of \f(HOinOperand\fP.  
Both lengths are measured as natural duration. 
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR interval         : Interval::Interval;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR other_interval   : Interval::Interval;
VAR result           : BOOL;
\&...
start_date       := NEW Date::Date (1993, 01, 01);
end_date         := NEW Date::Date (1993, 03, 01);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1993, 03, 01);
other_end_date   := NEW Date::Date (1993, 04, 01);
other_interval   := NEW Interval::Interval (other_start_date, 
                                            other_end_date);
result           := interval.IsLongerND (other_interval);
.CE
Then \f(HOresult\fP has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODate::INITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsLongerWD\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval::IsLongerWD'"
.EH "'Interval::IsLongerWD''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsLongerWD"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBMETHOD IsLongerWD $($ IN inOperand $ : Interval, 
$$ IN inCalendar $ : Calendar) 
$:$ BOOL;$\fP
.TE
.IP DESCRIPTION
The method \f(HOIsLongerWD\fP tests whether the length of current 
interval is longer to the length of \f(HOinOperand\fP.
Both lengths are measured as working duration according to 
\f(HOinCalendar\fP. 
.IP "RETURN VALUE"
This method returns TRUE if the length of current interval is longer to 
the length of \f(HOinOperand\fP.  
Both lengths are measured as working duration according to 
\f(HOinCalendar\fP. 
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR interval         : Interval::Interval;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR other_interval   : Interval::Interval;
VAR result           : BOOL;
VAR calendar         : Calendar::Calendar;
VAR name             : STRING;
VAR mode             : CHAR;
VAR calendar_arch    : CalendarArch::CalendarArch;
\&...
name             := "CalendarFile";
mode             := STREAM_READ;
calendar_arch    := NEW CalendarArch::CalendarArch (mode, name);
calendar         := calendar_arch.LoadCalendar();
calendar_arch.Close();
start_date       := NEW Date::Date (1993, 01, 01);
end_date         := NEW Date::Date (1993, 02, 01);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1993, 02, 01);
other_end_date   := NEW Date::Date (1993, 03, 01);
other_interval   := NEW Interval::Interval (other_start_date, 
                                            other_end_date);
result           := interval.IsLongerWD (other_interval, calendar);
.CE
Then the \f(HOvalue\fP of result depends on \f(HOCalendar\fP definition.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODate::INITIALLY\fP,
\f(HOCalendar::INITIALLY\fP,
\f(HOCalendar::Deserialize\fP,
\f(HOCalendarArch::INITIALLY\fP,
\f(HOCalendarArch::Close\fP,
\f(HOCalendarArch::LoadCalendar\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsLongerND\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval::IsShorterND'"
.EH "'Interval::IsShorterND''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsShorterND"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsShorterND (IN inOperand : Interval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsShorterND\fP tests whether the length of current 
interval is shorter to the length of \f(HOinOperand\fP.
Both lengths are measured as natural duration. 
.IP "RETURN VALUE"
This method returns TRUE if the length of current interval is shorter to
the length of \f(HOinOperand\fP.  
Both lengths are measured as natural duration. 
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR interval         : Interval::Interval;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR other_interval   : Interval::Interval;
VAR result           : BOOL;
\&...
start_date       := NEW Date::Date (1993, 01, 01);
end_date         := NEW Date::Date (1993, 02, 01);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1993, 03, 01);
other_end_date   := NEW Date::Date (1993, 05, 01);
other_interval   := NEW Interval::Interval (other_start_date, 
                                            other_end_date);
result           := interval.IsShorterND (other_interval);
.CE
Then \f(HOresult\fP has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODate::INITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsShorterWD\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval::IsShorterWD'"
.EH "'Interval::IsShorterWD''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsShorterWD"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBMETHOD IsShorterWD $($ IN inOperand $ : Interval, 
$$ IN inCalendar $ : Calendar) 
$:$ BOOL;$\fP
.TE
.IP DESCRIPTION
The method \f(HOIsShorterWD\fP tests whether the length of current 
interval is shorter to the length of \f(HOinOperand\fP.
Both lengths are measured as working duration according to 
\f(HOinCalendar\fP. 
.IP "RETURN VALUE"
This method returns TRUE if the length of current interval is shorter 
to the length of \f(HOinOperand\fP.  
Both lengths are measured as working duration according to 
\f(HOinCalendar\fP. 
.IP EXAMPLES
.CS L
VAR start_date       : Date::Date;
VAR end_date         : Date::Date;
VAR interval         : Interval::Interval;
VAR other_start_date : Date::Date;
VAR other_end_date   : Date::Date;
VAR other_interval   : Interval::Interval;
VAR result           : BOOL;
VAR calendar         : Calendar::Calendar;
VAR name             : STRING;
VAR mode             : CHAR;
VAR calendar_arch    : CalendarArch::CalendarArch;
\&...
name             := "CalendarFile";
mode             := STREAM_READ;
calendar_arch    := NEW CalendarArch::CalendarArch (mode, name);
calendar         := calendar_arch.LoadCalendar();
calendar_arch.Close();
start_date       := NEW Date::Date (1993, 02, 01);
end_date         := NEW Date::Date (1993, 03, 01);
interval         := NEW Interval::Interval (start_date, end_date);
other_start_date := NEW Date::Date (1993, 03, 01);
other_end_date   := NEW Date::Date (1993, 04, 01);
other_interval   := NEW Interval::Interval (other_start_date, 
                                            other_end_date);
result           := interval.IsShorterWD (other_interval, calendar);
.CE
Then the value of \f(HOresult\fP depends on \f(HOCalendar\fP definition.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODate::INITIALLY\fP,
\f(HOCalendar::INITIALLY\fP,
\f(HOCalendar::Deserialize\fP,
\f(HOCalendarArch::INITIALLY\fP,
\f(HOCalendarArch::Close\fP,
\f(HOCalendarArch::LoadCalendar\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsShorterND\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval::Serialize'"
.EH "'Interval::Serialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Serialize"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Serialize (INOUT ioStream : Stream);\fP
.IP DESCRIPTION
The method \f(HOSerialize\fP updates the \f(HOStream\fP received at 
\f(HOioStream\fP to contain the state of the current object.
.IP EXAMPLES
.CS L
VAR interval : Interval::Interval;
VAR stream   : Stream::Stream;
\&...
interval     := NEW Interval::Interval (NEW Date::Date (1993, 01, 01), 
                                        NEW Date::Date (1993, 02, 01));
interval.Serialize (stream);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODeserialize\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval::SetInterval'"
.EH "'Interval::SetInterval''CoLibrEX Reference Manual'"
.bp
.NX 3 "SetInterval"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD SetInterval ($ IN inStart $ : Date, 
$ IN inEnd $ : Date);\fP
.TE
.IP DESCRIPTION
The method \f(HOSetInterval\fP assigns the value of the parameter 
\f(HOinStart\fP to the start date of the current object and the value 
of the parameter \f(HOinEnd\fP to the end date of the current object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeInterval\fP"
is raised if \f(HOinStart\fP is later than \f(HOinEnd\fP.
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR the_start  : Date::Date;
VAR the_end    : Date::Date;
\&...
start_date := NEW Date::Date (1993, 01, 01);
end_date   := NEW Date::Date (1993, 02, 01);
interval   := NEW Interval::Interval (start_date, end_date);
the_start  := NEW Date::Date (1993, 03, 01);
the_end    := NEW Date::Date (1993, 04, 01);
interval.SetInterval (the_start, the_end);
.CE
Then \f(HOinterval\fP contains "01/03/1993" as start date 
and "01/04/1993" as end date.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODate::INITIALLY\fP,
\f(HOSetEnd\fP,
\f(HOSetStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval::SubtractFromEnd'"
.EH "'Interval::SubtractFromEnd''CoLibrEX Reference Manual'"
.bp
.NX 3 "SubtractFromEnd"
.sp
.IP MODULE
\f(HBInterval\fP
.IP TYPE
\f(HBInterval\fP
.IP SYNOPSIS
\f(HBMETHOD SubtractFromEnd (IN inExtent : Duration);\fP
.IP DESCRIPTION
The method \f(HOSubtractFromEnd\fP subtracts \f(HOinExtent\fP from the 
end date of the current interval.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeInterval\fP"
is raised if the calculated end date is earlier than the start date.
.IP EXAMPLES
.CS L
VAR start_date : Date::Date;
VAR end_date   : Date::Date;
VAR interval   : Interval::Interval;
VAR extent     : NDuration::NDuration;
\&...
start_date := NEW Date::Date (1993, 01, 01);
end_date   := NEW Date::Date (1993, 02, 02);
interval   := NEW Interval::Interval (start_date, end_date);
extent     := NEW NDuration::NDuration (0, 0, 1, 0, 0, 0);
interval.SubtractFromEnd (extent);
.CE
Then \f(HOinterval\fP contains "01/01/1993" as start date 
and "01/02/1993" as end date.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HOAddToEnd\fP,
\f(HOAddToStart\fP,
\f(HODate::INITIALLY\fP,
\f(HODuration::INITIALLY\fP,
\f(HOSubtract\fP,
\f(HOSubtractFromStart\fP
.LP
.OH "'CoLibrEX Reference Manual''Interval'"
.EH "'Interval''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOInterval\fP.
.br
The column M/N shows whether the method is
.IP \(bu 3
modified (M),
.IP \(bu 3
a new method (N),
.IP \(bu 3
a method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
M/N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$start$Date$NegativeInterval
$$IN$end$Date$
$$result$$Interval$
_
$Add$IN$extent$Duration$
_
$AddToEnd$IN$extent$Duration$
_
M$AddToStart$IN$inExtent$NDuration$NegativeInterval
_
$Contains$IN$operand$Interval$
$$result$$BOOL$
_
$ContainsDate$IN$operand$Date$
$$result$$BOOL$
_
$Copy$result$$Interval$
_
N$Deserialize$IN$inStream$Stream$
_
$GetEnd$result$$Date$
_
N$GetNLength$result$$NDuration$
_
$GetStart$result$$Date$
_
N$GetWLength$IN$inCalendar$Calendar$
$$result$$WDuration$
_
$Intersect$IN$operand$Interval$NoOverlap
_
$IsActual$result$$BOOL$
_
$IsEarlier$IN$operand$Date$
$$result$$BOOL$
_
$IsEndInSameDay$IN$operand$Interval$
$$result$$BOOL$
_
$IsEndInSameMonth$IN$operand$Interval$
$$result$$BOOL$
_
$IsEndInSameWeek$IN$operand$Interval$
$$result$$BOOL$
_
$IsEndInSameYear$IN$operand$Interval$
$$result$$BOOL$
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
M/N$Name$Mode$Parameter$Type$Exceptions
=
$IsEqual$IN$operand$Interval$
$$result$$BOOL$
_
N$IsEqualND$IN$inOperand$Interval$
$$result$$BOOL$
_
N$IsEqualWD$IN$inOperand$Interval$
$$IN$inCalendar$Calendar$
$$result$$BOOL$
_
$IsInFuture$result$$BOOL$
_
$IsLater$IN$operand$Date$
$$result$$BOOL$
_
N$IsLongerND$IN$inOperand$Interval$
$$result$$BOOL$
_
N$IsLongerWD$IN$inOperand$Interval$
$$IN$inCalendar$Calendar$
$$result$$BOOL$
_
$IsOverlapping$IN$operand$Interval$
$$result$$BOOL$
_
$IsPassed$result$$BOOL$
_
N$IsShorterND$IN$inOperand$Interval$
$$result$$BOOL$
_
N$IsShorterWD$IN$inOperand$Interval$
$$IN$inCalendar$Calendar$
$$result$$BOOL$
_
$IsStartInSameDay$IN$operand$Interval$
$$result$$BOOL$
_
$IsStartInSameMonth$IN$operand$Interval$
$$result$$BOOL$
_
$IsStartInSameWeek$IN$operand$Interval$
$$result$$BOOL$
_
$IsStartInSameYear$IN$operand$Interval$
$$result$$BOOL$
_
N$Serialize$INOUT$ioStream$Stream$
_
$SetEnd$IN$end$Date$NegativeInterval
_
N$SetInterval$IN$inStart$Date$NegativeInterval
$$IN$inEnd$Date$
_
$SetStart$IN$start$Date$NegativeInterval
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
M/N$Name$Mode$Parameter$Type$Exceptions
=
$Subtract$IN$extent$Duration$
_
M$SubtractFromEnd$IN$inExtent$Duration$NegativeInterval
_
$SubtractFromStart$IN$extent$Duration$
_
$Unite$IN$operand$Interval$NoOverlap
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibrEX Reference Manual''TimeInterval'"
.EH "'TimeInterval''CoLibrEX Reference Manual'"
.NX 1 "TimeInterval"
.sp
.NX 2 "Type Description"
.sp
\f(HOTimeInterval\fP is an object type representing a time interval 
consisting of a start and end time (within a day). 
This object type offers methods to construct, modify and actualize an 
object and to get information about an object. 
Further methods deal with arithmetic operations and predicates.
.sp
.NX 2 "List of Methods"
.sp
The following methods are available in <TimeInterval.cs>:
.TS
tab (#);
l.
Method name
_
Add
AddToEnd
AddToStart
Contains
ContainsTime
Copy
Deserialize
GetEnd
GetLength
GetStart
Intersect
IsActual
IsEarlier
IsEndInSameHour
IsEndInSameMinute
IsEndInSameSecond
IsEqual
IsInFuture
IsLater
IsLonger
IsOverlapping
IsPassed
IsShorter
IsStartInSameHour
IsStartInSameMinute
IsStartInSameSecond
Serialize
SetEnd
SetStart
SetTimeInterval
Subtract
SubtractFromEnd
SubtractFromStart
Unite
.TE
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
The following exceptions can be raised using module 
\f(HOTimeInterval\fP :
.TS
tab($);
l.
exception name
_
InvalidTime
NegativeTimeInterval
NoOverlap
.TE
.sp
.NX 2 "How to use TimeInterval"
.sp
A variable of type \f(HOTimeInterval\fP is declared, as follows:
.CS L
VAR time_interval : TimeInterval;
.CE
.sp 0.5
A variable of type \f(HOTimeInterval\fP can be initialized using the 
CooL constructor NEW.
.sp 0.5
A sub type of type \f(HOTimeInterval\fP is declared, as follows:
.CS L
TYPE MyTimeInterval = TimeInterval OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HOTimeInterval\fP must
import \f(HOTimeInterval\fP:
.CS L
IMPORT ..., TimeInterval, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOTimeInterval\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''TimeInterval::INITIALLY'"
.EH "'TimeInterval::INITIALLY''CoLibrEX Reference Manual'"
.bp
.NX 3 "INITIALLY"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN inStart $ : Time,
$$ IN inEnd $ : Time)
$:$ TimeInterval;$\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW. 
The parameters \f(HOinStart\fP and \f(HOinEnd\fP specify the interval 
of the current object.
.IP "RETURN VALUE"
This method returns a new object of this class containing 
\f(HOinStart\fP and \f(HOinEnd\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeTimeInterval\fP"
is raised if \f(HOinStart\fP is later than \f(HOinEnd\fP.
.IP EXAMPLES
.CS L
VAR start_hour    : INT;
VAR start_minute  : INT;
VAR start_second  : INT;
VAR start_time    : Time::Time;
VAR end_hour      : INT;
VAR end_minute    : INT;
VAR end_second    : INT;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
\&...
start_hour   := 10;
start_minute := 15;
start_second := 0;
start_time   := NEW Time::Time (start_hour, start_minute, start_second);
end_hour     := 13;
end_minute   := 20;
end_second   := 0;
end_time     := NEW Time::Time (end_hour, end_minute, end_second);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
.CE
.IP "SEE ALSO"
\f(HOSetTimeInterval\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::Add'"
.EH "'TimeInterval::Add''CoLibrEX Reference Manual'"
.bp
.NX 3 "Add"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Add (IN inExtent : NDuration);\fP
.IP DESCRIPTION
The method \f(HOAdd\fP adds \f(HOinExtent\fP to the start and end time 
of the current interval.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidTime\fP"
is raised if the end time of the interval is greater than 23 hours, 59 
minutes and 59 seconds.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR extent        : NDuration::NDuration;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
extent        := NEW NDuration::NDuration (0, 0, 0, 2, 10, 0);
time_interval.Add (extent);
.CE
Then \f(HOtime_interval\fP contains "12:25:00" as start time and 
\&"15:30:00" as end time.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAddToEnd\fP,
\f(HOAddToStart\fP,
\f(HONDuration::INITIALLY\fP,
\f(HOSubtract\fP,
\f(HOSubtractFromEnd\fP,
\f(HOSubtractFromStart\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::AddToEnd'"
.EH "'TimeInterval::AddToEnd''CoLibrEX Reference Manual'"
.bp
.NX 3 "AddToEnd"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD AddToEnd (IN inExtent : NDuration);\fP
.IP DESCRIPTION
The method \f(HOAddToEnd\fP adds \f(HOinExtent\fP to the end time of the
current interval.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidTime\fP"
is raised if the resulting time is greater than 23 hours, 59 minutes and
59 seconds.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR extent        : NDuration::NDuration;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
extent        := NEW NDuration::NDuration (0, 0, 0, 2, 10, 0);
time_interval.AddToEnd (extent);
.CE
Then \f(HOtime_interval\fP contains "10:15:00" as start time and 
\&"15:30:00" as end time.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HOAddToStart\fP,
\f(HONDuration::INITIALLY\fP,
\f(HOSubtract\fP,
\f(HOSubtractFromEnd\fP,
\f(HOSubtractFromStart\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::AddToStart'"
.EH "'TimeInterval::AddToStart''CoLibrEX Reference Manual'"
.bp
.NX 3 "AddToStart"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD AddToStart (IN inExtent : NDuration);\fP
.IP DESCRIPTION
The method \f(HOAddToStart\fP adds \f(HOinExtent\fP to the start time of
the current interval.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeTimeInterval\fP"
is raised if the calculated start time is later than the end time.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR extent        : NDuration::NDuration;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
extent        := NEW NDuration::NDuration (0, 0, 0, 2, 10, 0);
time_interval.AddToStart (extent);
.CE
Then \f(HOtime_interval\fP contains "12:25:00" as start time and 
\&"13:20:00" as end time.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HOAddToEnd\fP,
\f(HONDuration::INITIALLY\fP,
\f(HOSubtract\fP,
\f(HOSubtractFromEnd\fP,
\f(HOSubtractFromStart\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::Contains'"
.EH "'TimeInterval::Contains''CoLibrEX Reference Manual'"
.bp
.NX 3 "Contains"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Contains (IN inOperand : TimeInterval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOContains\fP tests whether the current interval contains 
\f(HOinOperand\fP. 
The current interval contains \f(HOinOperand\fP if the start and end 
time of \f(HOinOperand\fP is between the start and end time of the 
current interval. 
If two intervals are equal, they contain each other.
.IP "RETURN VALUE"
This method returns TRUE if the current interval contains 
\f(HOinOperand\fP. 
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
VAR result              : BOOL;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 10, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
result              := time_interval.Contains (other_time_interval);
.CE
Then \f(HOresult\fP has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOContainsTime\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::ContainsTime'"
.EH "'TimeInterval::ContainsTime''CoLibrEX Reference Manual'"
.bp
.NX 3 "ContainsTime"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD ContainsTime (IN inOperand : Time) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOContainsTime\fP tests whether the current interval 
contains \f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the current interval contains 
\f(HOinOperand\fP. 
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR operand       : Time::Time;
VAR result        : BOOL;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
operand       := NEW Time::Time (12, 35, 0);
result        := time_interval.ContainsTime (operand);
.CE
Then \f(HOresult\fP has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOContains\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::Copy'"
.EH "'TimeInterval::Copy''CoLibrEX Reference Manual'"
.bp
.NX 3 "Copy"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Copy () : TimeInterval;\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this class containing 
the state of the current object.
.IP "RETURN VALUE"
This method returns a new object of this class containing the state of 
the current object.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR local_copy    : TimeInterval::TimeInterval;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
local_copy    := time_interval.Copy ();
.CE
Then \f(HOlocal_copy\fP has the same value as \f(HOtime_interval\fP.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::Deserialize'"
.EH "'TimeInterval::Deserialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Deserialize"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Deserialize (IN inStream : Stream);\fP
.IP DESCRIPTION
The method \f(HODeserialize\fP loads the state of the 
\f(HOTimeInterval\fP from a \f(HOStream\fP received at \f(HOinStream\fP.
.IP EXAMPLES
.CS L
VAR time_interval : TimeInterval::TimeInterval;
VAR stream        : Stream::Stream;
\&...
time_interval := NEW TimeInterval::TimeInterval 
                    (NEW Time::Time (8, 30, 0), 
                     NEW Time::Time (12, 30, 0));
time_interval.Serialize (stream);
DELETE time_interval;
time_interval := NEW TimeInterval::TimeInterval 
                    (NEW Time::Time (18, 40, 0), 
                     NEW Time::Time (19, 50, 0));
time_interval.Deserialize (stream);
.CE
Then \f(HOtime_interval\fP has the value "08:30:00" - "12:30:00".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOSerialize\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::GetEnd'"
.EH "'TimeInterval::GetEnd''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetEnd"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD GetEnd () : Time;\fP
.IP DESCRIPTION
The method \f(HOGetEnd\fP returns the end time of the current interval.
.IP "RETURN VALUE"
This method returns the end time of the current interval.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR time          : Time::Time;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
time          := time_interval.GetEnd ();
.CE
Then \f(HOtime\fP has the value "13:20:00".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetLength\fP,
\f(HOGetStart\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::GetLength'"
.EH "'TimeInterval::GetLength''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetLength"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD GetLength () : NDuration;\fP
.IP DESCRIPTION
The method \f(HOGetLength\fP returns the difference between the start 
and end time of the current interval.
.IP "RETURN VALUE"
This method returns the difference between the start and end time of the
current interval.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR nDuration     : NDuration::NDuration;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
nDuration     := time_interval.GetLength ();
.CE
Then \f(HOnDuration\fP contains the value: 0 years, 0 months, 0 days, 3 
hours, 5 minutes and 0 seconds.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::GetStart'"
.EH "'TimeInterval::GetStart''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetStart"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD GetStart () : Time;\fP
.IP DESCRIPTION
The method \f(HOGetStart\fP returns the start time of the current 
interval.
.IP "RETURN VALUE"
This method returns the start time of the current interval.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR time          : Time::Time;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
time          := time_interval.GetStart ();
.CE
Then \f(HOtime\fP has the value "10:15:00".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOGetEnd\fP,
\f(HOGetLength\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::Intersect'"
.EH "'TimeInterval::Intersect''CoLibrEX Reference Manual'"
.bp
.NX 3 "Intersect"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Intersect (IN inOperand : TimeInterval);\fP
.IP DESCRIPTION
The method \f(HOIntersect\fP intersects the current interval with 
\f(HOinOperand\fP. 
The new start time of the current interval is the latest start time of 
both intervals and the new end time of the current interval is the 
earliest end time of both intervals.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONoOverlap\fP"
is raised if the current interval and \f(HOinOperand\fP do not overlap 
each other.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 40, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
time_interval.Intersect (other_time_interval);
.CE
Then \f(HOtime_interval\fP contains the interval from "10:30:00" to 
\&"13:20:00".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOTime::INITIALLY\fP,
\f(HOUnite\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsActual'"
.EH "'TimeInterval::IsActual''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsActual"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsActual () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsActual\fP tests whether the actual time is between the
start and end time of the current interval.
.IP "RETURN VALUE"
This method returns TRUE if the actual time is between the start and the
end time of the current interval and FALSE in other case.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR result        : BOOL;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
result        := time_interval.IsActual ();
.CE
Then \f(HOresult\fP has the value TRUE, for example, if the actual time 
is "12:00:00".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsEarlier'"
.EH "'TimeInterval::IsEarlier''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsEarlier"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsEarlier (IN inOperand : Time) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEarlier\fP tests whether the end time of the current 
interval is earlier than \f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the end time of the current interval is 
earlier than \f(HOinOperand\fP and FALSE in other case.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR operand       : Time::Time;
VAR result        : BOOL;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
operand       := NEW Time::Time (12, 35, 0);
result        := time_interval.IsEarlier (operand);
.CE
Then \f(HOresult\fP has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsEndInSameHour'"
.EH "'TimeInterval::IsEndInSameHour''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsEndInSameHour"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsEndInSameHour (IN inOperand : TimeInterval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEndInSameHour\fP tests whether the hour of the end 
time of the current interval is equal to the hour of the end time of 
\f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the hour of the end time of the current 
interval is equal to the hour of the end time of \f(HOinOperand\fP. 
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
VAR result              : BOOL;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 10, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
result := time_interval.IsEndInSameHour (other_time_interval);
.CE
Then \f(HOresult\fP has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsEndInSameMinute\fP,
\f(HOIsEndInSameSecond\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsEndInSameMinute'"
.EH "'TimeInterval::IsEndInSameMinute''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsEndInSameMinute"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsEndInSameMinute (IN inOperand : TimeInterval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEndInSameMinute\fP tests whether the minute of the end
time of the current interval is equal to the minute of the end time of 
\f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the minute of the end time of the current 
interval is equal to the minute of the end time of \f(HOinOperand\fP. 
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
VAR result              : BOOL;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 10, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
result := time_interval.IsEndInSameMinute (other_time_interval);
.CE
Then \f(HOresult\fP has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsEndInSameHour\fP,
\f(HOIsEndInSameSecond\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsEndInSameSecond'"
.EH "'TimeInterval::IsEndInSameSecond''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsEndInSameSecond"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsEndInSameSecond (IN inOperand : TimeInterval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEndInSameSecond\fP tests whether the second of the end
time of the current interval is equal to the second of the end time of 
\f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the second of the end time of the current 
interval is equal to the second of the end time of \f(HOinOperand\fP. 
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
VAR result              : BOOL;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 10, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
result := time_interval.IsEndInSameSecond (other_time_interval);
.CE
Then \f(HOresult\fP has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsEndInSameHour\fP,
\f(HOIsEndInSameMinute\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsEqual'"
.EH "'TimeInterval::IsEqual''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsEqual"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsEqual (IN inOperand : TimeInterval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEqual\fP tests whether the current interval is equal 
to \f(HOinOperand\fP. 
Two intervals are equal if their single components are equal.
.IP "RETURN VALUE"
This method returns TRUE if the current interval is equal to 
\f(HOinOperand\fP. 
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
VAR result              : BOOL;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 10, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
result := time_interval.IsEqual (other_time_interval);
.CE
Then \f(HOresult\fP has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsInFuture'"
.EH "'TimeInterval::IsInFuture''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsInFuture"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsInFuture () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsInFuture\fP tests whether the current interval is 
later than the actual time.
.IP "RETURN VALUE"
This method returns TRUE if the current interval is later than the 
actual time. 
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR result        : BOOL;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
result        := time_interval.IsInFuture ();
.CE
Then \f(HOresult\fP has the value TRUE, for example, if the actual time
is "08:00:00".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsLater'"
.EH "'TimeInterval::IsLater''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsLater"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsLater (IN inOperand : Time) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLater\fP tests whether the start time of the current 
interval is later than \f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the start time of the current interval is 
later than \f(HOinOperand\fP and FALSE in other case.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR operand       : Time::Time;
VAR result        : BOOL;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
operand       := NEW Time::Time (12, 35, 0);
result        := time_interval.IsLater (operand);
.CE
Then \f(HOresult\fP has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsPassed\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsLonger'"
.EH "'TimeInterval::IsLonger''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsLonger"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsLonger (IN inOperand : TimeInterval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLonger\fP tests whether the current interval is longer
than \f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the current interval is longer than 
\f(HOinOperand\fP. 
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
VAR result              : BOOL;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 10, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
result              := time_interval.IsLonger (other_time_interval);
.CE
Then \f(HOresult\fP has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsOverlapping\fP,
\f(HOIsShorter\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsOverlapping'"
.EH "'TimeInterval::IsOverlapping''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsOverlapping"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsOverlapping (IN inOperand : TimeInterval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsOverlapping\fP tests whether the start time or the end
time of \f(HOinOperand\fP is contained by the current interval.
.IP "RETURN VALUE"
This method returns TRUE if the start time or the end time of 
\f(HOinOperand\fP is contained by the current interval. 
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
VAR result              : BOOL;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 10, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
result := time_interval.IsOverlapping (other_time_interval);
.CE
Then \f(HOresult\fP has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsLonger\fP,
\f(HOIsShorter\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsPassed'"
.EH "'TimeInterval::IsPassed''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsPassed"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsPassed () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsPassed\fP tests whether the current interval is 
earlier than the actual time.
.IP "RETURN VALUE"
This method returns TRUE if the current interval is earlier than the 
actual time. 
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR result        : BOOL;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
result        := time_interval.IsPassed ();
.CE
Then \f(HOresult\fP has the value FALSE, for example, if the actual 
time is "08:00:00".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsShorter'"
.EH "'TimeInterval::IsShorter''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsShorter"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsShorter (IN inOperand : TimeInterval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsShorter\fP tests whether the current interval is 
shorter than \f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the current interval is shorter than 
\f(HOinOperand\fP. 
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
VAR result              : BOOL;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 10, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
result := time_interval.IsShorter (other_time_interval);
.CE
Then \f(HOresult\fP has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsLonger\fP,
\f(HOIsOverlapping\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsStartInSameHour'"
.EH "'TimeInterval::IsStartInSameHour''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsStartInSameHour"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsStartInSameHour (IN inOperand : TimeInterval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsStartInSameHour\fP tests whether the hour of the start
time of the current interval is equal to the hour of the start time of 
\f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the hour of the start time of the current 
interval is equal to the hour of the start time of \f(HOinOperand\fP. 
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
VAR result              : BOOL;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 10, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
result := time_interval.IsStartInSameHour (other_time_interval);
.CE
Then \f(HOresult\fP has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsStartInSameMinute\fP,
\f(HOIsStartInSameSecond\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsStartInSameMinute'"
.EH "'TimeInterval::IsStartInSameMinute''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsStartInSameMinute"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsStartInSameMinute (IN inOperand : TimeInterval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsStartInSameMinute\fP tests whether the minute of the 
start time of the current interval is equal to the minute of the start 
time of \f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the minute of the start time of the current 
interval is equal to the minute of the start time of \f(HOinOperand\fP.
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
VAR result              : BOOL;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 10, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
result := time_interval.IsStartInSameMinute (other_time_interval);
.CE
Then \f(HOresult\fP has the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsStartInSameHour\fP,
\f(HOIsStartInSameSecond\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::IsStartInSameSecond'"
.EH "'TimeInterval::IsStartInSameSecond''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsStartInSameSecond"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD IsStartInSameSecond (IN inOperand : TimeInterval) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsStartInSameSecond\fP tests whether the second of the 
start time of the current interval is equal to the second of the start 
time of \f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the second of the start time of the current 
interval is equal to the second of the start time of \f(HOinOperand\fP.
Otherwise it returns FALSE.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
VAR result              : BOOL;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 10, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
result := time_interval.IsStartInSameSecond (other_time_interval);
.CE
Then \f(HOresult\fP has the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsStartInSameHour\fP,
\f(HOIsStartInSameMinute\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::Serialize'"
.EH "'TimeInterval::Serialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Serialize"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Serialize (INOUT ioStream : Stream);\fP
.IP DESCRIPTION
The method \f(HOSerialize\fP updates the \f(HOStream\fP received at 
\f(HOioStream\fP to contain the state of the current object.
.IP EXAMPLES
.CS L
VAR time_interval : TimeInterval::TimeInterval;
VAR stream        : Stream::Stream;
\&...
time_interval := NEW TimeInterval::TimeInterval 
                    (NEW Time::Time (8, 30, 0), 
                     NEW Time::Time (12, 30, 0));
time_interval.Serialize (stream);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HODeserialize\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::SetEnd'"
.EH "'TimeInterval::SetEnd''CoLibrEX Reference Manual'"
.bp
.NX 3 "SetEnd"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD SetEnd (IN inEnd : Time);\fP
.IP DESCRIPTION
The method \f(HOSetEnd\fP assigns the value of the parameter 
\f(HOinEnd\fP to the end time of the current object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeTimeInterval\fP"
is raised if \f(HOinEnd\fP is earlier than the start time of the current
object.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR the_end       : Time::Time;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
the_end       := NEW Time::Time (15, 25, 0);
time_interval.SetEnd (the_end);
.CE
Then \f(HOtime_interval\fP contains "10:15:00" as start time and 
\&"15:25:00" as end time.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOSetStart\fP,
\f(HOSetTimeInterval\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::SetStart'"
.EH "'TimeInterval::SetStart''CoLibrEX Reference Manual'"
.bp
.NX 3 "SetStart"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD SetStart (IN inStart : Time);\fP
.IP DESCRIPTION
The method \f(HOSetStart\fP assigns the value of the parameter 
\f(HOinStart\fP to the start time of the current object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeTimeInterval\fP"
is raised if \f(HOinStart\fP is later than the end time of the current 
object.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR the_start     : Time::Time;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
the_start     := NEW Time::Time (9, 25, 0);
time_interval.SetStart (the_start);
.CE
Then \f(HOtime_interval\fP contains "09:25:00" as start time 
and "13:20:00" as end time.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOSetEnd\fP,
\f(HOSetTimeInterval\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::SetTimeInterval'"
.EH "'TimeInterval::SetTimeInterval''CoLibrEX Reference Manual'"
.bp
.NX 3 "SetTimeInterval"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD SetTimeInterval ($ IN inStart $ : Time, 
$ IN inEnd $ : Time);\fP
.TE
.IP DESCRIPTION
The method \f(HOSetTimeInterval\fP assigns the value of the parameter 
\f(HOinStart\fP to the start time of the current object and the value 
of the parameter \f(HOinEnd\fP to the end time of the current object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeTimeInterval\fP"
is raised if \f(HOinStart\fP is later than \f(HOinEnd\fP.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR the_start     : Time::Time;
VAR the_end       : Time::Time;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
the_start     := NEW Time::Time (9, 25, 0);
the_end       := NEW Time::Time (19, 40, 0);
time_interval.SetTimeInterval (the_start, the_end);
.CE
Then \f(HOtime_interval\fP contains "09:25:00" as start time 
and "19:40:00" as end time.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOSetEnd\fP,
\f(HOSetStart\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::Subtract'"
.EH "'TimeInterval::Subtract''CoLibrEX Reference Manual'"
.bp
.NX 3 "Subtract"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Subtract (IN inExtent : NDuration);\fP
.IP DESCRIPTION
The method \f(HOSubtract\fP subtracts \f(HOinExtent\fP from the start 
and end time of the current interval.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidTime\fP"
is raised if the start time of the interval is lower than 0 hours, 0 
minutes and 0 seconds.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR extent        : NDuration::NDuration;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
extent        := NEW NDuration::NDuration (0, 0, 0, 2, 10, 0);
time_interval.Subtract (extent);
.CE
Then \f(HOtime_interval\fP contains "08:05:00" as start time 
and "11:10:00" as end time.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HOAddToEnd\fP,
\f(HOAddToStart\fP,
\f(HONDuration::INITIALLY\fP,
\f(HOSubtractFromEnd\fP,
\f(HOSubtractFromStart\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::SubtractFromEnd'"
.EH "'TimeInterval::SubtractFromEnd''CoLibrEX Reference Manual'"
.bp
.NX 3 "SubtractFromEnd"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD SubtractFromEnd (IN inExtent : NDuration);\fP
.IP DESCRIPTION
The method \f(HOSubtractFromEnd\fP subtracts \f(HOinExtent\fP from the 
end time of the current interval.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONegativeTimeInterval\fP"
is raised if the calculated end time is earlier than the start time.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR extent        : NDuration::NDuration;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
extent        := NEW NDuration::NDuration (0, 0, 0, 2, 10, 0);
time_interval.SubtractFromEnd (extent);
.CE
Then \f(HOtime_interval\fP contains "10:15:00" as start time 
and "11:10:00" as end time.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HOAddToEnd\fP,
\f(HOAddToStart\fP,
\f(HONDuration::INITIALLY\fP,
\f(HOSubtract\fP,
\f(HOSubtractFromStart\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::SubtractFromStart'"
.EH "'TimeInterval::SubtractFromStart''CoLibrEX Reference Manual'"
.bp
.NX 3 "SubtractFromStart"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD SubtractFromStart (IN inExtent : NDuration);\fP
.IP DESCRIPTION
The method \f(HOSubtractFromStart\fP subtracts \f(HOinExtent\fP from the
start time of the current interval.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidTime\fP"
is raised if the resulting time is lower than 0 hours, 0 minutes and 0 
seconds.
.IP EXAMPLES
.CS L
VAR start_time    : Time::Time;
VAR end_time      : Time::Time;
VAR time_interval : TimeInterval::TimeInterval;
VAR extent        : NDuration::NDuration;
\&...
start_time    := NEW Time::Time (10, 15, 0);
end_time      := NEW Time::Time (13, 20, 0);
time_interval := NEW TimeInterval::TimeInterval (start_time, end_time);
extent        := NEW NDuration::NDuration (0, 0, 0, 2, 10, 0);
time_interval.SubtractFromStart (extent);
.CE
Then \f(HOtime_interval\fP contains "08:05:00" as start time 
and "13:20:00" as end time.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOAdd\fP,
\f(HOAddToEnd\fP,
\f(HOAddToStart\fP,
\f(HONDuration::INITIALLY\fP,
\f(HOSubtract\fP,
\f(HOSubtractFromEnd\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval::Unite'"
.EH "'TimeInterval::Unite''CoLibrEX Reference Manual'"
.bp
.NX 3 "Unite"
.sp
.IP MODULE
\f(HBTimeInterval\fP
.IP TYPE
\f(HBTimeInterval\fP
.IP SYNOPSIS
\f(HBMETHOD Unite (IN inOperand : TimeInterval);\fP
.IP DESCRIPTION
The method \f(HOUnite\fP unites the current interval with 
\f(HOinOperand\fP. 
The new start time of the current interval is the earliest start time of
both intervals and the new end time of the current interval is the 
latest end time of both intervals.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HONoOverlap\fP"
is raised if the current interval and \f(HOinOperand\fP do not overlap 
each other.
.IP EXAMPLES
.CS L
VAR start_time          : Time::Time;
VAR end_time            : Time::Time;
VAR time_interval       : TimeInterval::TimeInterval;
VAR other_start_time    : Time::Time;
VAR other_end_time      : Time::Time;
VAR other_time_interval : TimeInterval::TimeInterval;
\&...
start_time          := NEW Time::Time (10, 15, 0);
end_time            := NEW Time::Time (13, 20, 0);
time_interval       := NEW TimeInterval::TimeInterval (start_time, 
                                                       end_time);
other_start_time    := NEW Time::Time (10, 30, 0);
other_end_time      := NEW Time::Time (13, 40, 0);
other_time_interval := NEW TimeInterval::TimeInterval (other_start_time,
                                                       other_end_time);
time_interval.Unite (other_time_interval);
.CE
Then \f(HOtime_interval\fP contains the interval from "10:15:00" to 
\&"13:40:00".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIntersect\fP,
\f(HOTime::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeInterval'"
.EH "'TimeInterval''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOTimeInterval\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$IN$inStart$Time$NegativeTimeInterval
$IN$inEnd$Time$
$result$$TimeInterval$
_
Add$IN$inExtent$NDuration$InvalidTime
_
AddToEnd$IN$inExtent$NDuration$InvalidTime
_
AddToStart$IN$inExtent$NDuration$NegativeTimeInterval
_
Contains$IN$inOperand$TimeInterval$
$result$$BOOL$
_
ContainsTime$IN$inOperand$Time$
$result$$BOOL$
_
Copy$result$$TimeInterval$
_
Deserialize$IN$inStream$Stream$
_
GetEnd$result$$Time$
_
GetLength$result$$NDuration$
_
GetStart$result$$Time$
_
Intersect$IN$inOperand$TimeInterval$NoOverlap
_
IsActual$result$$BOOL$
_
IsEarlier$IN$inOperand$Time$
$result$$BOOL$
_
IsEndInSameHour$IN$inOperand$TimeInterval$
$result$$BOOL$
_
IsEndInSameMinute$IN$inOperand$TimeInterval$
$result$$BOOL$
_
IsEndInSameSecond$IN$inOperand$TimeInterval$
$result$$BOOL$
_
IsEqual$IN$inOperand$TimeInterval$
$result$$BOOL$
_
IsInFuture$result$$BOOL$
_
IsLater$IN$inOperand$Time$
$result$$BOOL$
_
IsLonger$IN$inOperand$TimeInterval$
$result$$BOOL$
.TE
.NL
.nr PS 12
.KE
.bp
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
IsOverlapping$IN$inOperand$TimeInterval$
$result$$BOOL$
_
IsPassed$result$$BOOL$
_
IsShorter$IN$inOperand$TimeInterval$
$result$$BOOL$
_
IsStartInSameHour$IN$inOperand$TimeInterval$
$result$$BOOL$
_
IsStartInSameMinute$IN$inOperand$TimeInterval$
$result$$BOOL$
_
IsStartInSameSecond$IN$inOperand$TimeInterval$
$result$$BOOL$
_
Serialize$INOUT$ioStream$Stream$
_
SetEnd$IN$inEnd$Time$NegativeTimeInterval
_
SetStart$IN$inStart$Time$NegativeTimeInterval
_
SetTimeInterval$IN$inStart$Time$NegativeTimeInterval
$IN$inEnd$Time$
_
Subtract$IN$inExtent$NDuration$InvalidTime
_
SubtractFromEnd$IN$inExtent$NDuration$NegativeTimeInterval
_
SubtractFromStart$IN$inExtent$NDuration$InvalidTime
_
Unite$IN$inOperand$TimeInterval$NoOverlap
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibrEX Reference Manual''MonthDay'"
.EH "'MonthDay''CoLibrEX Reference Manual'"
.NX 1 "MonthDay"
.sp
.NX 2 "Type Description"
.sp
\f(HOMonthDay\fP is an object type representing a date no matter the 
year consisting on month and day. 
This object type offers methods to construct, modify and actualize an 
object and to get information about an object. 
Further methods deal with arithmetic operations and predicates.
.sp
.NX 2 "List of Methods"
.sp
The following methods are available in <MonthDay.cs>:
.TS
tab (#);
l.
Method name
_
Copy
Deserialize
GetDay
GetMonth
IsActual
IsDateEqual
IsEarlier
IsEqual
IsInFuture
IsLater
IsPassed
Serialize
SetMonthDay
SetToActualDate
.TE
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
The following exceptions can be raised using module \f(HOMonthDay\fP :
.TS
tab($);
l.
exception name
_
InvalidMonthDay
.TE
.sp
.NX 2 "How to use MonthDay"
.sp
A variable of type \f(HOMonthDay\fP is declared, as follows:
.CS L
VAR month_day : MonthDay;
.CE
.sp 0.5
A variable of type \f(HOMonthDay\fP can be initialized using the CooL 
constructor NEW.
.sp 0.5
A sub type of type \f(HOMonthDay\fP is declared, as follows:
.CS L
TYPE MyMonthDay = MonthDay OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HOMonthDay\fP must 
import \f(HOMonthDay\fP:
.CS L
IMPORT ..., MonthDay, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOMonthDay\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''MonthDay::INITIALLY'"
.EH "'MonthDay::INITIALLY''CoLibrEX Reference Manual'"
.bp
.NX 3 "INITIALLY"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN inMonth $ : INT,
$$ IN inDay $ : INT)
$:$ MonthDay;$\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW. 
The parameters \f(HOinMonth\fP and \f(HOinDay\fP specify the date of the
current object.
.IP "RETURN VALUE"
This method returns a new object of this class containing 
\f(HOinMonth\fP and \f(HOinDay\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidMonthDay\fP"
is raised if \f(HOinMonth\fP and \f(HOinDay\fP do not represent a valid
MonthDay.
.IP EXAMPLES
.CS L
VAR month     : INT;
VAR day       : INT;
VAR month_day : MonthDay::MonthDay;
\&...
month     := 10;
day       := 1;
month_day := NEW MonthDay::MonthDay (month, day);
.CE
.IP "SEE ALSO"
\f(HOSetMonthDay\fP, 
\f(HOSetToActualDate\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::Copy'"
.EH "'MonthDay::Copy''CoLibrEX Reference Manual'"
.bp
.NX 3 "Copy"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD Copy () : MonthDay;\fP
.IP DESCRIPTION
The method \f(HOCopy\fP creates a new object of this class containing 
the state of the current object.
.IP "RETURN VALUE"
This method creates a new object of this class containing the state of 
the current object.
.IP EXAMPLES
.CS L
VAR month_day  : MonthDay::MonthDay;
VAR local_copy : MonthDay::MonthDay;
\&...
month_day  := NEW MonthDay::MonthDay (10, 1);
local_copy := month_day.Copy ();
.CE
Then \f(HOlocal_copy\fP contains the same value as \f(HOmonth_day\fP.
.IP "SEE ALSO"
\f(HOINITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::Deserialize'"
.EH "'MonthDay::Deserialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Deserialize"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD Deserialize (IN inStream : Stream);\fP
.IP DESCRIPTION
The method \f(HODeserialize\fP loads the state of \f(HOMonthDay\fP from 
a \f(HOStream \fP received at \f(HOinStream\fP.
.IP EXAMPLES
.CS L
VAR month_day : MonthDay::MonthDay;
VAR stream    : Stream::Stream;
\&...
month_day := NEW MonthDay::MonthDay (10, 1);
month_day.Serialize (stream);
DELETE month_day;
month_day := NEW MonthDay::MonthDay (9, 11);
month_day.Deserialize (stream);
.CE
Then \f(HOmonth_day\fP has the value "01/10".
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOSerialize\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::GetDay'"
.EH "'MonthDay::GetDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetDay"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD GetDay () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetDay\fP returns the day of the current \f(HOMonthDay\fP.
.IP "RETURN VALUE"
This method returns the day of the current \f(HOMonthDay\fP.
.IP EXAMPLES
.CS L
VAR month_day : MonthDay::MonthDay;
VAR day       : INT;
\&...
month_day := NEW MonthDay::MonthDay (10, 1);
day       := month_day.GetDay ();
.CE
Then \f(HOday\fP contains the value "1".
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOGetMonth\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::GetMonth'"
.EH "'MonthDay::GetMonth''CoLibrEX Reference Manual'"
.bp
.NX 3 "GetMonth"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD GetMonth () : INT;\fP
.IP DESCRIPTION
The method \f(HOGetMonth\fP returns the month of the current 
\f(HOMonthDay\fP.
.IP "RETURN VALUE"
This method returns the month of the current \f(HOMonthDay\fP.
.IP EXAMPLES
.CS L
VAR month_day : MonthDay::MonthDay;
VAR month     : INT;
\&...
month_day := NEW MonthDay::MonthDay (10, 1);
month     := month_day.GetMonth ();
.CE
Then \f(HOmonth\fP contains the value 1.
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOGetDay\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::IsActual'"
.EH "'MonthDay::IsActual''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsActual"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD IsActual () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsActual\fP tests whether the current \f(HOMonthDay\fP 
is the actual date (without year).
.IP "RETURN VALUE"
This method returns TRUE if the current \f(HOMonthDay\fP is the actual 
date (without year) and FALSE in other case.
.IP EXAMPLES
.CS L
VAR month_day : MonthDay::MonthDay;
VAR result    : BOOL;
\&...
month_day := NEW MonthDay::MonthDay (10, 1);
result    := month_day.IsActual ();
.CE
Then \f(HOresult\fP contains the value FALSE if, for example, today is 
\&"18/06/1993".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsDateEqual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::IsDateEqual'"
.EH "'MonthDay::IsDateEqual''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsDateEqual"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD IsDateEqual (IN inDate : Date) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsDateEqual\fP tests whether \f(HOinDate\fP is in the 
same month and day as the current \f(HOMonthDay\fP.
.IP "RETURN VALUE"
This method returns TRUE if \f(HOinDate\fP is in the same month and day 
as the current \f(HOMonthDay\fP and FALSE in other case.
.IP EXAMPLES
.CS L
VAR month_day : MonthDay::MonthDay;
VAR date      : Date::Date;
VAR result    : BOOL;
\&...
month_day := NEW MonthDay::MonthDay (10, 1);
date      := NEW Date::Date (1993, 10, 1);
result    := month_day.IsDateEqual (date);
.CE
Then \f(HOresult\fP contains the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::IsEarlier'"
.EH "'MonthDay::IsEarlier''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsEarlier"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD IsEarlier (IN inOperand : MonthDay) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEarlier\fP tests whether the current \f(HOMonthDay\fP 
is earlier than \f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the current \f(HOMonthDay\fP is earlier 
than \f(HOinOperand\fP and FALSE in other case.
.IP EXAMPLES
.CS L
VAR month_day       : MonthDay::MonthDay;
VAR other_month_day : MonthDay::MonthDay;
VAR result          : BOOL;
\&...
month_day       := NEW MonthDay::MonthDay (10, 1);
other_month_day := NEW MonthDay::MonthDay (7, 1);
result          := month_day.IsEarlier (other_month_day);
.CE
Then \f(HOresult\fP contains the value FALSE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsDateEqual\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::IsEqual'"
.EH "'MonthDay::IsEqual''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsEqual"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD IsEqual (IN inOperand : MonthDay) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsEqual\fP tests whether the current \f(HOMonthDay\fP 
is equal to \f(HOinOperand\fP. 
Two \f(HOMonthDay\fPs are equal if their single components are equal.
.IP "RETURN VALUE"
This method returns TRUE if the current \f(HOMonthDay\fP is equal to 
\f(HOinDate\fP and FALSE in other case.
.IP EXAMPLES
.CS L
VAR month_day       : MonthDay::MonthDay;
VAR other_month_day : MonthDay::MonthDay;
VAR result          : BOOL;
\&...
month_day       := NEW MonthDay::MonthDay (10, 1);
other_month_day := NEW MonthDay::MonthDay (10, 1);
result          := month_day.IsEqual (other_month_day);
.CE
Then \f(HOresult\fP contains the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsDateEqual\fP,
\f(HOIsEarlier\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::IsInFuture'"
.EH "'MonthDay::IsInFuture''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsInFuture"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD IsInFuture () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsInFuture\fP tests whether the current \f(HOMonthDay\fP
is later than the actual date.
.IP "RETURN VALUE"
This method returns TRUE if the current \f(HOMonthDay\fP is later than 
the actual date and FALSE in other case.
.IP EXAMPLES
.CS L
VAR month_day : MonthDay::MonthDay;
VAR result    : BOOL;
\&...
month_day := NEW MonthDay::MonthDay (10, 1);
result    := month_day.IsInFuture ();
.CE
.fi
Then \f(HOresult\fP contains the value TRUE if, for example, today is 
\&"18/06/1993".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsDateEqual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsLater\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::IsLater'"
.EH "'MonthDay::IsLater''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsLater"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD IsLater (IN inOperand : MonthDay) : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsLater\fP tests whether the current \f(HOMonthDay\fP 
is later than \f(HOinOperand\fP.
.IP "RETURN VALUE"
This method returns TRUE if the current \f(HOMonthDay\fP is later than 
\f(HOinOperand\fP and FALSE in other case.
.IP EXAMPLES
.CS L
VAR month_day       : MonthDay::MonthDay;
VAR other_month_day : MonthDay::MonthDay;
VAR result          : BOOL;
\&...
month_day       := NEW MonthDay::MonthDay (10, 1);
other_month_day := NEW MonthDay::MonthDay (7, 1);
result          := month_day.IsLater (other_month_day);
.CE
Then \f(HOresult\fP contains the value TRUE.
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsDateEqual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsPassed\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::IsPassed'"
.EH "'MonthDay::IsPassed''CoLibrEX Reference Manual'"
.bp
.NX 3 "IsPassed"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD IsPassed () : BOOL;\fP
.IP DESCRIPTION
The method \f(HOIsPassed\fP tests whether the current \f(HOMonthDay\fP 
is earlier than the actual date.
.IP "RETURN VALUE"
This method returns TRUE if the current \f(HOMonthDay\fP is earlier than
the actual day and FALSE in other case.
.IP EXAMPLES
.CS L
VAR month_day : MonthDay::MonthDay;
VAR result    : BOOL;
\&...
month_day := NEW MonthDay::MonthDay (10, 1);
result    := month_day.IsPassed ();
.CE
Then \f(HOresult\fP contains the value FALSE if, for example, today is 
\&"18/06/1993".
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOIsActual\fP,
\f(HOIsDateEqual\fP,
\f(HOIsEarlier\fP,
\f(HOIsEqual\fP,
\f(HOIsInFuture\fP,
\f(HOIsLater\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::Serialize'"
.EH "'MonthDay::Serialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Serialize"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD Serialize (INOUT ioStream : Stream);\fP
.IP DESCRIPTION
The method \f(HOSerialize\fP updates the \f(HOStream\fP received at 
\f(HOioStream\fP to contain the state of the current object.
.IP EXAMPLES
.CS L
VAR month_day : MonthDay::MonthDay;
VAR stream    : Stream::Stream;
\&...
month_day := NEW MonthDay::MonthDay (10, 1);
month_day.Serialize (stream);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HODeserialize\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::SetMonthDay'"
.EH "'MonthDay::SetMonthDay''CoLibrEX Reference Manual'"
.bp
.NX 3 "SetMonthDay"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBMETHOD SetMonthDay ($ IN inMonth $ : INT, 
$ IN inDay $ : INT);\fP
.TE
.IP DESCRIPTION
The method \f(HOSetMonthDay\fP assigns the values of the parameters 
\f(HOinMonth\fP and \f(HOinDay\fP to the current \f(HOMonthDay\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidMonthDay\fP"
is raised if \f(HOinMonth\fP and \f(HOinDay\fP do not represent a valid 
\f(HOMonthDay\fP.
.IP EXAMPLES
.CS L
VAR month_day : MonthDay::MonthDay;
\&...
month_day := NEW MonthDay::MonthDay (10, 1);
month_day.SetMonthDay (7, 1);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOSetToActualDate\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay::SetToActualDate'"
.EH "'MonthDay::SetToActualDate''CoLibrEX Reference Manual'"
.bp
.NX 3 "SetToActualDate"
.sp
.IP MODULE
\f(HBMonthDay\fP
.IP TYPE
\f(HBMonthDay\fP
.IP SYNOPSIS
\f(HBMETHOD SetToActualDate;\fP
.IP DESCRIPTION
The method \f(HOSetToActualDate\fP assigns the actual date (machine 
date) to the current object.
.IP EXAMPLES
.CS L
VAR month_day : MonthDay::MonthDay;
\&...
month_day := NEW MonthDay::MonthDay (10, 1);
month_day.SetToActualDate ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOSetMonthDay\fP
.LP
.OH "'CoLibrEX Reference Manual''MonthDay'"
.EH "'MonthDay''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOMonthDay\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$IN$inMonth$INT$InvalidMonthDay
$IN$inDay$INT$
$result$$MonthDay$
_
Copy$result$$MonthDay$
_
Deserialize$IN$inStream$Stream$
_
GetDay$result$$INT$
_
GetMonth$result$$INT$
_
IsActual$result$$BOOL$
_
IsDateEqual$IN$inDate$Date$
$result$$BOOL$
_
IsEarlier$IN$inOperand$MonthDay$
$result$$BOOL$
_
IsEqual$IN$inOperand$MonthDay$
$result$$BOOL$
_
IsInFuture$result$$BOOL$
_
IsLater$IN$inOperand$MonthDay$
$result$$BOOL$
_
IsPassed$result$$BOOL$
_
Serialize$INOUT$ioStream$Stream$
_
SetMonthDay$IN$inMonth$INT$InvalidMonthDay
$IN$inDay$INT$
_
SetToActualDate$$$$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
.OH "'CoLibrEX Reference Manual''Archive'"
.EH "'Archive''CoLibrEX Reference Manual'"
.NX 1 "Archive"
.sp
.NX 2 "Type Description"
.sp
\f(HOArchive\fP is a non-instanciable object type that gives general 
functionality to implement persistence in any object.
.sp
.NX 2 "List of Methods"
.sp
The following methods are available in <Archive.cs>:
.TS
tab ($);
l.
Method name
_
Close
.TE
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
.NX 2 "How to use Archive"
.sp
A sub type of type \f(HOArchive\fP is declared, as follows:
.CS L
TYPE MyArchive = Archive OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HOArchive\fP must 
import \f(HOArchive\fP:
.CS L
IMPORT ..., Archive, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOArchive\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''Archive::INITIALLY'"
.EH "'Archive::INITIALLY''CoLibrEX Reference Manual'"
.bp
.NX 3 "INITIALLY"
.sp
.IP MODULE
\f(HBArchive\fP
.IP TYPE
\f(HBArchive\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN inMode $ : CHAR, 
$$ IN inName $ : STRING)
$:$ Archive;\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW. 
The parameters \f(HOinName\fP and \f(HOinMode\fP specify the file to be 
open and the mode.
.sp 0.5
\f(HOinMode\fP may take the next values:
.br
1) {STREAM_READ} : \f(HOFile\fP is open to be read.
.br
2) {STREAM_WRITE} : \f(HOFile\fP is open to be written.
.IP "RETURN VALUE"
This method returns a new object of this class with the file 
\f(HOinName\fP open in mode \f(HOinMode\fP.
.IP ERRORS
See exceptions raised by \f(HOStream\fP type, as they can be raised 
while creating an archive. 
No particular exceptions are raised by \f(HOArchive\fP type.
.IP EXAMPLES
In the next example we create an object of type \f(HOCalendarArch\fP 
because \f(HOArchive\fP is a non-instanciable type.
.CS L
VAR name          : STRING
VAR mode          : CHAR;
VAR calendar_arch : CalendarArch::CalendarArch;
\&...
name          := "myArchiveName";
mode          := STREAM_READ;
calendar_arch := NEW CalendarArch::CalendarArch (mode, name);
.CE
.IP "SEE ALSO"
\f(HOStream::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Archive::Close'"
.EH "'Archive::Close''CoLibrEX Reference Manual'"
.bp
.NX 3 "Close"
.sp
.IP MODULE
\f(HBArchive\fP
.IP TYPE
\f(HBArchive\fP
.IP SYNOPSIS
\f(HBMETHOD Close;\fP
.IP DESCRIPTION
The method \f(HOClose\fP closes and deletes current archive.
.IP ERRORS
See exceptions raised by \f(HOStream\fP type, as they can be raised 
while closing an archive. 
No particular exceptions are raised by \f(HOArchive\fP type.
.IP EXAMPLES
In the next example we create an object of type \f(HOCalendarArch\fP 
because \f(HOArchive\fP is a non-instanciable type.
.CS L
VAR name          : STRING
VAR mode          : CHAR;
VAR calendar_arch : CalendarArch::CalendarArch;
\&...
name          := "myArchiveName";
mode          := STREAM_READ;
calendar_arch := NEW CalendarArch::CalendarArch (mode, name);
\&...
calendar_arch.Close ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOStream::Close\fP
.LP
.OH "'CoLibrEX Reference Manual''Archive'"
.EH "'Archive''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOArchive\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$IN$inMode$CHAR$InvalidOpenMode
$IN$inName$STRING$
$result$$Archive$
_
Close$$$$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
.OH "'CoLibrEX Reference Manual''CalendarArch'"
.EH "'CalendarArch''CoLibrEX Reference Manual'"
.NX 1 "CalendarArch"
.sp
.NX 2 "Type Description"
.sp
\f(HOCalendarArch\fP is an object type that implements the persistence 
of \f(HOCalendar\fP object. 
It is a sub type of \f(HOArchive\fP type.
.sp
.NX 2 "List of Methods"
.sp
The following methods are available in <CalendarArch.cs>:
.TS
tab ($);
l l.
Method name$N(ew)
_
Close$
LoadCalendar$N
StoreCalendar$N
.TE
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
.NX 2 "How to use CalendarArch"
.sp
A variable of type \f(HOCalendarArch\fP is declared, as follows:
.CS L
VAR calendar_arch : CalendarArch;
.CE
.sp 0.5
A variable of type \f(HOCalendarArch\fP can be initialized using the 
CooL constructor NEW.
.sp 0.5
A sub type of type \f(HOCalendaArch\fP is declared, as follows:
.CS L
TYPE MyCalendarArch = CalendarArch OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HOCalendarArch\fP must
import \f(HOCalendarArch\fP:
.CS L
IMPORT ..., CalendarArch, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOCalendarArch\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''CalendarArch::INITIALLY'"
.EH "'CalendarArch::INITIALLY''CoLibrEX Reference Manual'"
.bp
.NX 3 "INITIALLY"
.sp
.IP MODULE
\f(HBCalendarArch\fP
.IP TYPE
\f(HBCalendarArch = Archive\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN inMode $ : CHAR, 
$$ IN inName $ : STRING)
$:$ CalendarArch;\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW. 
The parameters \f(HOinName\fP and \f(HOinMode\fP specify the file to be 
open and the mode.
.sp 0.5
\f(HOinMode\fP may take the next values:
.br
1) {STREAM_READ} : \f(HOFile\fP is open to be read.
.br
2) {STREAM_WRITE} : \f(HOFile\fP is open to be written.
.IP "RETURN VALUE"
This method returns a new object of this class with the file 
\f(HOinName\fP open in mode \f(HOinMode\fP.
.IP ERRORS
See exceptions raised by \f(HOStream\fP type, as they can be raised 
while creating an archive. 
No particular exceptions are raised by \f(HOCalendarArch\fP type.
.IP EXAMPLES
In the next example we create an object of type \f(HOCalendarArch\fP .
.CS L
VAR name          : STRING
VAR mode          : CHAR;
VAR calendar_arch : CalendarArch::CalendarArch;
\&...
name          := "myArchiveName";
mode          := STREAM_READ;
calendar_arch := NEW CalendarArch::CalendarArch (mode, name);
.CE
.IP "SEE ALSO"
\f(HOStream::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''CalendarArch::LoadCalendar'"
.EH "'CalendarArch::LoadCalendar''CoLibrEX Reference Manual'"
.bp
.NX 3 "LoadCalendar"
.sp
.IP MODULE
\f(HBCalendarArch\fP
.IP TYPE
\f(HBCalendarArch = Archive\fP
.IP SYNOPSIS
\f(HBMETHOD LoadCalendar () : Calendar;\fP
.IP DESCRIPTION
The method \f(HOLoadCalendar\fP reads the \f(HOCalendar\fP stored in the
\f(HOFile\fP associated to the \f(HOArchive\fP and returns it.
.IP "RETURN VALUE"
This method reads the \f(HOCalendar\fP stored in \f(HOFile\fP and 
returns it.
.IP ERRORS
See exceptions raised by \f(HOStream\fP type, as they can be raised 
while loading \f(HOCalendar\fP. 
No particular exceptions are raised by \f(HOCalendarArch\fP type.
.IP EXAMPLES
.CS L
VAR name          : STRING
VAR mode          : CHAR;
VAR calendar_arch : CalendarArch::CalendarArch;
VAR calendar      : Calendar::Calendar;
\&...
name          := "myArchiveName";
mode          := STREAM_READ;
calendar_arch := NEW CalendarArch::CalendarArch (mode, name);
calendar      := calendar_arch.LoadCalendar ();
calendar_arch.Close ();
.CE
.IP "SEE ALSO"
\f(HOArchive::INITIALLY\fP, 
\f(HOArchive::Close\fP,
\f(HOStoreCalendar\fP, 
\f(HOStream::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''CalendarArch::StoreCalendar'"
.EH "'CalendarArch::StoreCalendar''CoLibrEX Reference Manual'"
.bp
.NX 3 "StoreCalendar"
.sp
.IP MODULE
\f(HBCalendarArch\fP
.IP TYPE
\f(HBCalendarArch = Archive\fP
.IP SYNOPSIS
\f(HBMETHOD StoreCalendar (IN inCalendar : Calendar);\fP
.IP DESCRIPTION
The method \f(HOStoreCalendar\fP writes to the \f(HOFile\fP associated 
to the \f(HOArchive\fP the input \f(HOCalendar\fP.
.IP ERRORS
See exceptions raised by \f(HOStream\fP type, as they can be raised 
while storing \f(HOCalendar\fP. 
No particular exceptions are raised by \f(HOCalendarArch\fP type.
.IP EXAMPLES
.CS L
VAR name          : STRING
VAR mode          : CHAR;
VAR calendar_arch : CalendarArch::CalendarArch;
VAR calendar      : Calendar::Calendar;
\&...
calendar      := NEW Calendar::Calendar ("calendarName");
\&...
name          := "myArchiveName";
mode          := STREAM_WRITE;
calendar_arch := NEW CalendarArch::CalendarArch (mode, name);
calendar_arch.StoreCalendar (calendar);
calendar_arch.Close ();
.CE
.IP "SEE ALSO"
\f(HOArchive::INITIALLY\fP,
\f(HOArchive::Close\fP,
\f(HOCalendar::INITIALLY\fP,
\f(HOLoadCalendar\fP,
\f(HOStream::INITIALLY\fP,
\f(HOStream::Close\fP
.LP
.OH "'CoLibrEX Reference Manual''CalendarArch'"
.EH "'CalendarArch''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOCalendarArch\fP.
.br
The column N shows whether the method is
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$inMode$CHAR$InvalidOpenMode
$$IN$inName$STRING$
$$result$$CalendarArch$
_
$Close$$$$
_
N$LoadCalendar$result$$Calendar$
_
N$StoreCalendar$IN$inCalendar$Calendar$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibrEX Reference Manual''Stream'"
.EH "'Stream''CoLibrEX Reference Manual'"
.NX 1 "Stream"
.sp
.NX 2 "Type Description"
.sp
\f(HOStream\fP is a generic non-instanciable object type representing a
data stream.  
Particular sub types should be created for each implementation (i.e. on
a file) of the data stream.
.sp
.NX 2 "List of Methods"
.sp
The following methods are available in <Stream.cs>:
.TS
tab ($);
l.
Method name
_
Close
Read
ReadLine
Seek
SeekLine
Write
WriteLine
.TE
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
The following exceptions can be raised using module \f(HOStream\fP :
.TS
tab($);
l.
exception name
_
InvalidOpenMode
InvalidOperation
.TE
.sp
.NX 2 "How to use Stream"
.sp
A variable of type \f(HOStream\fP is declared, as follows:
.CS L
VAR stream : Stream;
.CE
.sp 0.5
A variable of type \f(HOStream\fP can be initialized using the CooL 
constructor NEW for any of its instanciable sub types.
.sp 0.5
A sub type of type \f(HOStream\fP is declared, as follows:
.CS L
TYPE MyStream = Stream OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HOStream\fP must 
import \f(HOStream\fP:
.CS L
IMPORT ..., Stream, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOStream\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''Stream::INITIALLY'"
.EH "'Stream::INITIALLY''CoLibrEX Reference Manual'"
.bp
.NX 3 "INITIALLY"
.sp
.IP MODULE
\f(HBStream\fP
.IP TYPE
\f(HBStream\fP
.IP SYNOPSIS
\f(HBINITIALLY (IN inMode : CHAR) : Stream;\fP
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW. 
Please, remember no instances should be created of this type. 
This is a generic non-instanciable type.
The parameter \f(HOinMode\fP specifies the open mode for the 
\f(HOStream\fP.
.sp 0.5
\f(HOinMode\fP may take the next values:
.br
1) {STREAM_READ} : \f(HOStream\fP is open to be read.
.br
2) {STREAM_WRITE} : \f(HOStream\fP is open to be written.
.br
.IP "RETURN VALUE"
This method returns a new object of this class open in mode 
\f(HOinMode\fP.
Please, remember no instances should be created of this type. 
This is a generic non instanciable type.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidOpenMode\fP"
is raised if the mode parameter does not have a valid value. 
See also exceptions raised by its sub types.
.IP EXAMPLES
In the next example we create an object of type \f(HOFileStream\fP 
because \f(HOStream\fP is a non-instanciable type.
.CS L
VAR name         : STRING;
VAR mode         : CHAR;
VAR stream       : Stream::Stream;
\&...
name   := "myArchiveName";
mode   := STREAM_READ;
stream := NEW FileStream::FileStream (mode, name);
.CE
.IP "SEE ALSO"
\f(HOArchive::INITIALLY\fP,
\f(HOArchive::Close\fP,
\f(HOStream::Close\fP
.LP
.OH "'CoLibrEX Reference Manual''Stream::Close'"
.EH "'Stream::Close''CoLibrEX Reference Manual'"
.bp
.NX 3 "Close"
.sp
.IP MODULE
\f(HBStream\fP
.IP TYPE
\f(HBStream\fP
.IP SYNOPSIS
\f(HBMETHOD Close;\fP
.IP DESCRIPTION
The method \f(HOClose\fP closes the stream and deletes from memory the 
stream object.
.IP EXAMPLES
In the next example we create an object of type \f(HOFileStream\fP 
because \f(HOStream\fP is a non-instanciable type.
.CS L
VAR name         : STRING;
VAR mode         : CHAR;
VAR stream       : Stream::Stream;
\&...
name   := "myArchiveName";
mode   := STREAM_READ;
stream := NEW FileStream::FileStream (mode, name);
\&...
stream.Close ();
.CE
.IP "SEE ALSO"
\f(HOArchive::INITIALLY\fP,
\f(HOArchive::Close\fP,
\f(HOStream::INITIALLY\fP
.LP
.OH "'CoLibrEX Reference Manual''Stream::Read'"
.EH "'Stream::Read''CoLibrEX Reference Manual'"
.bp
.NX 3 "Read"
.sp
.IP MODULE
\f(HBStream\fP
.IP TYPE
\f(HBStream\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l0 l.
\f(HBMETHOD Read $($ INOUT $ ioBuf $ : REF ARRAY OF CHAR, 
$$ IN $ inBufLen $ : INT) 
$:$ INT;$$\fP
.TE
.IP DESCRIPTION
This method reads from \f(HOStream\fP into \f(HOioBuf\fP characters 
until end of \f(HOStream\fP encountered, or \f(HOinBufLen\fP characters 
read. 
\f(HOioBuf\fP is then null-terminated.
\f(HOinBufLen\fP +1 must be allocated to \f(HOioBuf\fP at least!.
.IP "RETURN VALUE"
This method returns the length of returned \f(HOioBuf\fP string.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidOperation\fP"
is raised if the \f(HOStream\fP was open in {STREAM_WRITE} mode.
.IP EXAMPLES
In the next example we create an object of type \f(HOFileStream\fP 
because \f(HOStream\fP is a non-instanciable type.
.CS L
VAR string      : REF ARRAY OF CHAR;
VAR size        : size_t;
VAR length      : INT;
VAR real_length : INT;
VAR name        : STRING;
VAR mode        : CHAR;
VAR stream      : Stream::Stream;
\&...
name        := "myArchiveName";
mode        := STREAM_READ;
stream      := NEW FileStream::FileStream (mode, name);
\&...
size        := MaxStringLength+1;
length      := size - 1;
string      := malloc(size);
real_length := stream.Read(string, length);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOReadLine\fP,
\f(HOWrite\fP,
\f(HOWriteLine\fP,
\f(HOSeek\fP,
\f(HOSeekLine\fP
.LP
.OH "'CoLibrEX Reference Manual''Stream::ReadLine'"
.EH "'Stream::ReadLine''CoLibrEX Reference Manual'"
.bp
.NX 3 "ReadLine"
.sp
.IP MODULE
\f(HBStream\fP
.IP TYPE
\f(HBStream\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l0 l.
\f(HBMETHOD ReadLine $($ INOUT $ ioBuf $ : REF ARRAY OF CHAR, 
$$ IN $ inBufLen $ : INT) 
$:$ INT;$$\fP
.TE
.IP DESCRIPTION
This method reads from \f(HOStream\fP into \f(HOioBuf\fP characters 
until newline encountered or end of \f(HOStream\fP encountered or 
\f(HOinBufLen\fP characters read. 
\f(HOioBuf\fP is then null-terminated.
\f(HOinBufLen\fP+1 must be allocated to \f(HOioBuf\fP at least!.
.IP "RETURN VALUE"
This method returns the length of returned \f(HOioBuf\fP string.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidOperation\fP"
is raised if the \f(HOStream\fP was open in {STREAM_WRITE} mode.
.IP EXAMPLES
In the next example we create an object of type \f(HOFileStream\fP 
because \f(HOStream\fP is a non-instanciable type.
.CS L
VAR string      : REF ARRAY OF CHAR;
VAR size        : size_t;
VAR length      : INT;
VAR real_length : INT;
VAR name        : STRING;
VAR mode        : CHAR;
VAR stream      : Stream::Stream;
\&...
name        := "myArchiveName";
mode        := STREAM_READ;
stream      := NEW FileStream::FileStream (mode, name);
\&...
size        := MaxStringLength+1;
length      := size - 1;
string      := stdlib::malloc(size);
real_length := stream.ReadLine(string, length);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HORead\fP,
\f(HOSeek\fP,
\f(HOSeekLine\fP,
\f(HOWrite\fP,
\f(HOWriteLine\fP
.LP
.OH "'CoLibrEX Reference Manual''Stream::Seek'"
.EH "'Stream::Seek''CoLibrEX Reference Manual'"
.bp
.NX 3 "Seek"
.sp
.IP MODULE
\f(HBStream\fP
.IP TYPE
\f(HBStream\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBMETHOD Seek $($ IN inOffset $ : INT, 
$$ IN inFrom $ : INT) 
$:$ INT;$\fP
.TE
.IP DESCRIPTION
This method moves the stream pointer inOffset number of bytes.
The pointer is moved from 
.br
(a) start of stream (\f(HOinFrom\fP = {SEEK_SET}), 
.br
(b) its current position (\f(HOinFrom\fP = {SEEK_CUR}) 
.br
or 
.br
(c) end of stream (\f(HOinFrom\fP = {SEEK_END}).
.IP "RETURN VALUE"
The method returns the resulting pointer offset from start of stream.
.IP EXAMPLES
In the next example we create an object of type \f(HOFileStream\fP 
because \f(HOStream\fP is a non-instanciable type.
.CS L
VAR offset   : INT;
VAR from     : INT;
VAR position : INT;
VAR name     : STRING;
VAR mode     : CHAR;
VAR stream   : Stream::Stream;
\&...
name     := "myArchiveName";
mode     := STREAM_READ;
stream   := NEW FileStream::FileStream (mode, name);
\&...
offset   := 100;
from     := SEEK_CUR;
position := stream.Seek(offset, from);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HORead\fP,
\f(HOReadLine\fP,
\f(HOWrite\fP,
\f(HOWriteLine\fP,
\f(HOSeekLine\fP
.LP
.OH "'CoLibrEX Reference Manual''Stream::SeekLine'"
.EH "'Stream::SeekLine''CoLibrEX Reference Manual'"
.bp
.NX 3 "SeekLine"
.sp
.IP MODULE
\f(HBStream\fP
.IP TYPE
\f(HBStream\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBMETHOD SeekLine $($ IN inOffset $ : INT, 
$$ IN inFrom $ : INT) 
$:$ INT;$\fP
.TE
.IP DESCRIPTION
This method moves the stream pointer \f(HOinOffset\fP number of lines.
The pointer is moved from 
.br
(a) start of stream (\f(HOinFrom\fP = {SEEK_SET}), 
.br
(b) its current position (\f(HOinFrom\fP = {SEEK_CUR}) 
.br
or 
.br
(c) end of stream (\f(HOinFrom\fP = {SEEK_END}).
.IP "RETURN VALUE"
The method returns the resulting pointer offset from start of stream.
.IP EXAMPLES
In the next example we create an object of type \f(HOFileStream\fP 
because \f(HOStream\fP is a non-instanciable type.
.CS L
VAR offset   : INT;
VAR from     : INT;
VAR position : INT;
VAR name     : STRING;
VAR mode     : CHAR;
VAR stream   : Stream::Stream;
\&...
name     := "myArchiveName";
mode     := STREAM_READ;
stream   := NEW FileStream::FileStream (mode, name);
\&...
offset   := 100;
from     := SEEK_CUR;
position := stream.SeekLine(offset, from);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HORead\fP,
\f(HOReadLine\fP,
\f(HOWrite\fP,
\f(HOWriteLine\fP,
\f(HOSeek\fP
.LP
.OH "'CoLibrEX Reference Manual''Stream::Write'"
.EH "'Stream::Write''CoLibrEX Reference Manual'"
.bp
.NX 3 "Write"
.sp
.IP MODULE
\f(HBStream\fP
.IP TYPE
\f(HBStream\fP
.IP SYNOPSIS
\f(HBMETHOD Write (IN inBuf : REF ARRAY OF CHAR);\fP
.IP DESCRIPTION
This method writes a null terminated input string into current 
\f(HOStream\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidOperation\fP"
is raised if the \f(HOStream\fP was open in {STREAM_READ} mode.
.IP EXAMPLES
In the next example we create an object of type \f(HOFileStream\fP 
because \f(HOStream\fP is a non-instanciable type.
.CS L
VAR string   : REF ARRAY OF CHAR;
VAR size     : size_t;
VAR name     : STRING;
VAR mode     : CHAR;
VAR stream   : Stream::Stream;
\&...
name    := "myArchiveName";
mode    := STREAM_WRITE;
stream  := NEW FileStream::FileStream (mode, name);
\&...
size    := MaxStringLength+1;
string  := stdlib::malloc(size);
string  := "This is a text to be written into the Stream";
stream.Write(string);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HORead\fP,
\f(HOReadLine\fP,
\f(HOWriteLine\fP,
\f(HOSeek\fP,
\f(HOSeekLine\fP
.LP
.OH "'CoLibrEX Reference Manual''Stream::WriteLine'"
.EH "'Stream::WriteLine''CoLibrEX Reference Manual'"
.bp
.NX 3 "WriteLine"
.sp
.IP MODULE
\f(HBStream\fP
.IP TYPE
\f(HBStream\fP
.IP SYNOPSIS
\f(HBMETHOD WriteLine (IN inBuf : REF ARRAY OF CHAR);\fP
.IP DESCRIPTION
This method writes a null terminated input string into current 
\f(HOStream\fP. 
Then adds a newLine character to the \f(HOStream\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidOperation\fP"
is raised if the \f(HOStream\fP was open in {STREAM_READ} mode.
.IP EXAMPLES
In the next example we create an object of type \f(HOFileStream\fP 
because \f(HOStream\fP is a non-instanciable type.
.CS L
VAR string   : REF ARRAY OF CHAR;
VAR size     : size_t;
VAR name     : STRING;
VAR mode     : CHAR;
VAR stream   : Stream::Stream;
\&...
name    := "myArchiveName";
mode    := STREAM_WRITE;
stream  := NEW FileStream::FileStream (mode, name);
\&...
size    := MaxStringLength+1;
string  := stdlib::malloc(size);
string  := "This is a line to be written into the Stream";
stream.WriteLine (string);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HORead\fP,
\f(HOReadLine\fP,
\f(HOWrite\fP,
\f(HOSeek\fP,
\f(HOSeekLine\fP
.LP
.OH "'CoLibrEX Reference Manual''Stream'"
.EH "'Stream''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOStream\fP.
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
INITIALLY$IN$inMode$CHAR$InvalidOpenMode
$result$$Stream$
_
Close$$$$
_
Read$INOUT$ioBuf$REF ARRAY OF CHAR$InvalidOperation
$IN$inBufLen$INT$
$result$$INT$
_
ReadLine$INOUT$ioBuf$REF ARRAY OF CHAR$InvalidOperation
$IN$inBufLen$INT$
$result$$INT$
_
Seek$IN$inOffset$INT$
$IN$inFrom$INT$
$result$$INT$
_
SeekLine$IN$inOffset$INT$
$IN$inFrom$INT$
$result$$INT$
_
Write$IN$inBuf$REF ARRAY OF CHAR$InvalidOperation
_
WriteLine$IN$inBuf$REF ARRAY OF CHAR$InvalidOperation
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibrEX Reference Manual''FileStream'"
.EH "'FileStream''CoLibrEX Reference Manual'"
.NX 1 "FileStream"
.sp
.NX 2 "Type Description"
.sp
Type Description
.sp
\f(HOFileStream\fP is an object type representing a file implementation 
of a data stream.
\f(HOFileStream\fP is a sub type of the object type \f(HOStream\fP.
.sp
.NX 2 "List of Methods"
.sp
All methods are inherited from the \f(HOStream\fP type.
\f(HOFileStream\fP provides an implementation for these methods.
The following methods are available in <FileStream.cs>:
.TS
tab ($);
l l.
Method name$R(edefined)
_
Close$R
Read$R
ReadLine$R
Seek$R
SeekLine$R
Write$R
WriteLine$R
.TE
.sp
.NX 2 "Error Handling"
.sp 
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be 
raised in case of an error are listed. 
This type adds some exceptions particular to the file implementation of 
a i\f(HOStream\fP.
.sp
The following exceptions can be raised using module \f(HOFileStream\fP :
.TS
tab($);
l.
exception name
_
CloseFileError
DirectoryError
FileNameNeeded
InvalidOpenMode
InvalidOperation
InvalidOperation
OpenFileError
.TE
.sp
.NX 2 "How to use FileStream"
.sp
A variable of type \f(HOFileStream\fP is declared, as follows:
.CS L
VAR stream : FileStream;
.CE
.sp 0.5
A variable of type \f(HOFileStream\fP can be initialized using the CooL 
constructor NEW for any of its instanciable sub types.
.sp 0.5
A sub type of type \f(HOFileStream\fP is declared, as follows:
.CS L
TYPE MyStream = FileStream OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HOFileStream\fP must 
import \f(HOFileStream\fP:
.CS L
IMPORT ..., FileStream, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOFileStream\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''FileStream::INITIALLY'"
.EH "'FileStream::INITIALLY''CoLibrEX Reference Manual'"
.bp
.NX 3 "INITIALLY"
.sp
.IP MODULE
\f(HBFileStream\fP
.IP TYPE
\f(HBFileStream = Stream\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBINITIALLY $($ IN inMode $ : CHAR, 
$$ IN inName $ : STRING)
$:$ FileStream;\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW. 
The parameter \f(HOinMode\fP specifies the open mode for the 
\f(HOFileStream\fP.
The parameter \f(HOinName\fP specifies filename for the file which is 
to be used for data persistency. 
It can be composed of a path name and the proper file name. 
Path name is optional but file name can not be null.
.sp 0.5
\f(HOinMode\fP may take the next values:
.br
1) {STREAM_READ} : \f(HOFileStream\fP is open to be read.
.br
2) {STREAM_WRITE} : \f(HOFileStream\fP is open to be written.
.IP "RETURN VALUE"
This method returns a new object of this class open in mode 
\f(HOinMode\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HODirectoryError\fP"
is raised if \f(HOinName\fP contains a non existent path. 
.IP "\(bu \f(HOFileNameNeeded\fP"
is raised if the filename part of \f(HOinName\fP is null. 
.IP "\(bu \f(HOInvalidOpenMode\fP"
is raised if the mode parameter does not have a valid value. 
.IP "\(bu \f(HOOpenFileError\fP"
is raised if an error occurs while opening the file.
.IP EXAMPLES
.CS L
VAR name   : STRING;
VAR mode   : CHAR;
VAR stream : FileStream::FileStream;
\&...
name   := "myArchiveName";
mode   := STREAM_READ;
stream := NEW FileStream::FileStream (mode, name);
.CE
.IP "SEE ALSO"
\f(HOArchive::INITIALLY\fP,
\f(HOArchive::Close\fP,
\f(HOClose\fP
.LP
.OH "'CoLibrEX Reference Manual''FileStream::Close'"
.EH "'FileStream::Close''CoLibrEX Reference Manual'"
.bp
.NX 3 "Close"
.sp
.IP MODULE
\f(HBFileStream\fP
.IP TYPE
\f(HBFileStream = Stream\fP
.IP SYNOPSIS
\f(HBMETHOD Close;\fP
.IP DESCRIPTION
The method \f(HOClose\fP closes the \f(HOFile\fP and deletes from memory
the \f(HOFileStream\fP object.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOCloseFileError\fP"
is raised if an error occurs while closing the file.
.IP EXAMPLES
.CS L
VAR name         : STRING;
VAR mode         : CHAR;
VAR stream       : FileStream::FileStream;
\&...
name   := "myArchiveName";
mode   := STREAM_READ;
stream := NEW FileStream::FileStream (mode, name);
\&...
stream.Close ();
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOArchive::INITIALLY\fP, 
\f(HOArchive::Close\fP
.LP
.OH "'CoLibrEX Reference Manual''FileStream::Read'"
.EH "'FileStream::Read''CoLibrEX Reference Manual'"
.bp
.NX 3 "Read"
.sp
.IP MODULE
\f(HBFileStream\fP
.IP TYPE
\f(HBFileStream = Stream\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l0 l.
\f(HBMETHOD Read $($ INOUT $ ioBuf $ : REF ARRAY OF CHAR, 
$$ IN $ inBufLen $ : INT) 
$:$ INT;$\fP
.TE
.IP DESCRIPTION
This method reads from \f(HOFileStream\fP into \f(HOioBuf\fP characters 
until end of \f(HOFileStream\fP encountered, or \f(HOinBufLen\fP 
characters read. 
\f(HOioBuf\fP is then null-terminated.
\f(HOinBufLen\fP+1 must be allocated to \f(HOioBuf\fP at least!.
.IP "RETURN VALUE"
This method returns the length of returned \f(HOioBuf\fP string.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidOperation\fP"
is raised if the \f(HOFileStream\fP was open in {STREAM_WRITE} mode.
.IP EXAMPLES
.CS L
VAR string      : REF ARRAY OF CHAR;
VAR size        : size_t;
VAR length      : INT;
VAR real_length : INT;
VAR name        : STRING;
VAR mode        : CHAR;
VAR stream      : FileStream::FileStream;
\&...
name        := "myArchiveName";
mode        := STREAM_READ;
stream      := NEW FileStream::FileStream (mode, name);
\&...
size        := MaxStringLength+1;
length      := size - 1;
string      := stdlib::malloc(size);
real_length := stream.Read(string, length);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HOReadLine\fP,
\f(HOSeek\fP,
\f(HOSeekLine\fP,
\f(HOWrite\fP,
\f(HOWriteLine\fP
.LP
.OH "'CoLibrEX Reference Manual''FileStream::ReadLine'"
.EH "'FileStream::ReadLine''CoLibrEX Reference Manual'"
.bp
.NX 3 "ReadLine"
.sp
.IP MODULE
\f(HBFileStream\fP
.IP TYPE
\f(HBFileStream = Stream\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l0 l.
\f(HBMETHOD ReadLine $($INOUT $ ioBuf $ : REF ARRAY OF CHAR, 
$$ IN $ inBufLen $ : INT) 
$:$ INT;$\fP
.TE
.IP DESCRIPTION
This method reads from \f(HOFileStream\fP into \f(HOioBuf\fP characters 
until newline encountered or end of \f(HOFileStream\fP encountered or 
\f(HOinBufLen\fP characters read. 
\f(HOioBuf\fP is then null-terminated.
\f(HOinBufLen\fP+1 must be allocated to \f(HOioBuf\fP at least!.
.IP "RETURN VALUE"
This method returns the length of returned \f(HOioBuf\fP string.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidOperation\fP"
is raised if the \f(HOFileStream\fP was open in {STREAM_WRITE} mode.
.IP EXAMPLES
.CS L
VAR string      : REF ARRAY OF CHAR;
VAR size        : size_t;
VAR length      : INT;
VAR real_length : INT;
VAR name        : STRING;
VAR mode        : CHAR;
VAR stream      : FileStream::FileStream;
\&...
name        := "myArchiveName";
mode     :   = STREAM_READ;
stream   :   = NEW FileStream::FileStream (mode, name);
\&...
size        := MaxStringLength+1;
length      := size - 1;
string      := stdlib::malloc(size);
real_length := stream.ReadLine(string, length);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HORead\fP,
\f(HOWrite\fP,
\f(HOWriteLine\fP,
\f(HOSeek\fP,
\f(HOSeekLine\fP
.LP
.OH "'CoLibrEX Reference Manual''FileStream::Seek'"
.EH "'FileStream::Seek''CoLibrEX Reference Manual'"
.bp
.NX 3 "Seek"
.sp
.IP MODULE
\f(HBFileStream\fP
.IP TYPE
\f(HBFileStream = Stream\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBMETHOD Seek $($ IN inOffset $ : INT, 
$$ IN inFrom $ : INT) 
$:$ INT;$\fP
.TE
.IP DESCRIPTION
This method moves the stream pointer \f(HOinOffset\fP number of bytes.
The pointer is moved from 
.br
(a) start of stream (\f(HOinFrom\fP = {SEEK_SET}), 
.br
(b) its current position (\f(HOinFrom\fP = {SEEK_CUR}) 
.br
or 
.br
(c) end of stream (\f(HOinFrom\fP = {SEEK_END}).
.IP "RETURN VALUE"
The method returns the resulting pointer offset from start of stream.
.IP EXAMPLES
.CS L
VAR offset   : INT;
VAR from     : INT;
VAR position : INT;
VAR name     : STRING;
VAR mode     : CHAR;
VAR stream   : FileStream::FileStream;
\&...
name     := "myArchiveName";
mode     := STREAM_READ;
stream   := NEW FileStream::FileStream (mode, name);
\&...
offset   := 100;
from     := SEEK_CUR;
position := stream.Seek(offset, from);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HORead\fP,
\f(HOReadLine\fP,
\f(HOWrite\fP,
\f(HOWriteLine\fP,
\f(HOSeekLine\fP
.LP
.OH "'CoLibrEX Reference Manual''FileStream::SeekLine'"
.EH "'FileStream::SeekLine''CoLibrEX Reference Manual'"
.bp
.NX 3 "SeekLine"
.sp
.IP MODULE
\f(HBFileStream\fP
.IP TYPE
\f(HBFileStream = Stream\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBMETHOD SeekLine $($ IN inOffset $ : INT, 
$$ IN inFrom $ : INT) 
$:$ INT;$\fP
.TE
.IP DESCRIPTION
This method moves the stream pointer \f(HOinOffset\fP number of lines.
The pointer is moved from 
.br
(a) start of stream (\f(HOinFrom\fP = {SEEK_SET}), 
.br
(b) its current position (\f(HOinFrom\fP = {SEEK_CUR}) 
.br
or 
.br
(c) end of stream (\f(HOinFrom\fP = {SEEK_END}).
.IP "RETURN VALUE"
The method returns the resulting pointer offset from start of stream.
.IP EXAMPLES
.CS L
VAR offset   : INT;
VAR from     : INT;
VAR position : INT;
VAR name     : STRING;
VAR mode     : CHAR;
VAR stream   : FileStream::FileStream;
\&...
name     := "myArchiveName";
mode     := STREAM_READ;
stream   := NEW FileStream::FileStream (mode, name);
\&...
offset   := 100;
from     := SEEK_CUR;
position := stream.SeekLine(offset, from);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HORead\fP,
\f(HOReadLine\fP,
\f(HOWrite\fP,
\f(HOWriteLine\fP,
\f(HOSeek\fP
.LP
.OH "'CoLibrEX Reference Manual''FileStream::Write'"
.EH "'FileStream::Write''CoLibrEX Reference Manual'"
.bp
.NX 3 "Write"
.sp
.IP MODULE
\f(HBFileStream\fP
.IP TYPE
\f(HBFileStream = Stream\fP
.IP SYNOPSIS
\f(HBMETHOD Write (IN inBuf : REF ARRAY OF CHAR);\fP
.IP DESCRIPTION
This method writes a null terminated input string into current 
\f(HOFileStream\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidOperation\fP"
is raised if the \f(HOFileStream\fP was open in {STREAM_READ} mode.
.IP EXAMPLES
.CS L
VAR string : REF ARRAY OF CHAR;
VAR size   : size_t;
VAR name   : STRING;
VAR mode   : CHAR;
VAR stream : FileStream::FileStream;
\&...
name   := "myArchiveName";
mode   := STREAM_WRITE;
stream := NEW FileStream::FileStream (mode, name);
\&...
size   := MaxStringLength+1;
string := stdlib::malloc(size);
string := "This is a text to be written into the FileStream";
stream.Write(string);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HORead\fP,
\f(HOReadLine\fP,
\f(HOWriteLine\fP,
\f(HOSeek\fP,
\f(HOSeekLine\fP
.LP
.OH "'CoLibrEX Reference Manual''FileStream::WriteLine'"
.EH "'FileStream::WriteLine''CoLibrEX Reference Manual'"
.bp
.NX 3 "WriteLine"
.sp
.IP MODULE
\f(HBFileStream\fP
.IP TYPE
\f(HBFileStream = Stream\fP
.IP SYNOPSIS
\f(HBMETHOD WriteLine (IN inBuf : REF ARRAY OF CHAR);\fP
.IP DESCRIPTION
This method writes a null terminated input string into current 
\f(HOFileStream\fP. 
Then adds a newLine character to the \f(HOFileStream\fP.
.IP ERRORS
The following exception may be raised:
.IP "\(bu \f(HOInvalidOperation\fP"
is raised if the \f(HOFileStream\fP was open in {STREAM_READ} mode.
.IP EXAMPLES
.CS L
VAR string : REF ARRAY OF CHAR;
VAR size   : size_t;
VAR name   : STRING;
VAR mode   : CHAR;
VAR stream : FileStream::FileStream;
\&...
name   := "myArchiveName";
mode   := STREAM_WRITE;
stream := NEW FileStream::FileStream (mode, name);
\&...
size   := MaxStringLength+1;
string := stdlib::malloc(size);
string := "This is a line to be written into the FileStream";
stream.WriteLine(string);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HORead\fP,
\f(HOReadLine\fP,
\f(HOWrite\fP,
\f(HOSeek\fP,
\f(HOSeekLine\fP
.LP
.OH "'CoLibrEX Reference Manual''FileStream'"
.EH "'FileStream''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HOFileStream\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$inMode$CHAR$DirectoryError
$$IN$inName$STRING$FileNameNeeded
$$result$$FileStream$InvalidOpenMode
$$$$$OpenFileError
_
R$Close$$$$CloseFileError
_
R$Read$INOUT$ioBuf$REF ARRAY OF CHAR$InvalidOperation
$$IN$inBufLen$INT$
$$result$$INT$
_
R$ReadLine$INOUT$ioBuf$REF ARRAY OF CHAR$InvalidOperation
$$IN$inBufLen$INT$
$$result$$INT$
_
R$Seek$IN$inOffset$INT$
$$IN$inFrom$INT$
$$result$$INT$
_
R$SeekLine$IN$inOffset$INT$
$$IN$inFrom$INT$
$$result$$INT$
_
R$Write$IN$inBuf$REF ARRAY OF CHAR$InvalidOperation
_
R$WriteLine$IN$inBuf$REF ARRAY OF CHAR$InvalidOperation
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibrEX Reference Manual''DateRepr'"
.EH "'DateRepr''CoLibrEX Reference Manual'"
.NX 1 "DateRepr"
.sp
.NX 2 "Type Description"
.sp
\f(HODateRepr\fP is a sub type of \f(HODate\fP which adds presentation 
methods to \f(HODate\fP.
.sp
.NX 2 "List of Methods"
.sp
These are the additional methods which are redefined to \f(HODateRepr\fP
type, available in <DateRepr.cs>:
.TS
tab ($);
l l.
Method name$R(edefined)
_
Deserialize$R
Serialize$R
.TE
.sp 0.5
The new redefined methods are described in the following sections, 
the others are described in the CoLibri Reference Manual (see [1]).
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
.NX 2 "How to use DateRepr"
.sp
A variable of type \f(HODateRepr\fP is declared, as follows:
.CS L
VAR dateRepr : DateRepr;
.CE
.sp 0.5
A variable of type \f(HODateRepr\fP can be initialized using the CooL 
constructor NEW for any of its instanciable sub types.
.sp 0.5
A sub type of type \f(HODateRepr\fP is declared, as follows:
.CS L
TYPE MyDateRepr = DateRepr OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HODateRepr\fP must 
import \f(HODateRepr\fP:
.CS L
IMPORT ..., DateRepr, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all new additional methods provided by \f(HODateRepr\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''DateRepr::Deserialize'"
.EH "'DateRepr::Deserialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Deserialize"
.sp
.IP MODULE
\f(HBDateRepr\fP
.IP TYPE
\f(HBDateRepr = Date\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Deserialize (IN inStream : Stream);\fP
.IP DESCRIPTION
The method \f(HODeserialize\fP loads the state of \f(HODateRepr\fP 
from a \f(HOStream \fP received at \f(HOinStream\fP.
.IP EXAMPLES
.CS L
VAR dateRepr : DateRepr::DateRepr;
VAR stream   : Stream::Stream;
\&...
dateRepr := NEW DateRepr::DateRepr (1993, 10, 01, "%d/%m/%y");
dateRepr.Serialize (stream);
DELETE dateRepr;
dateRepr := NEW DateRepr::DateRepr (1990, 01, 01, "%d/%m/%y");
dateRepr.Deserialize (stream);
.CE
Then \f(HOdateRepr\fP has the value "01/10/1993" and the date format 
\&"%d/%m/%y".
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOSerialize\fP
.LP
.OH "'CoLibrEX Reference Manual''DateRepr::Serialize'"
.EH "'DateRepr::Serialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Serialize"
.sp
.IP MODULE
\f(HBDateRepr\fP
.IP TYPE
\f(HBDateRepr = Date\fP
.IP SYNOPSIS
\f(HBMETHOD Serialize (INOUT ioStream : Stream);\fP
.IP DESCRIPTION
The method \f(HOSerialize\fP updates the \f(HOStream\fP received at 
\f(HOioStream\fP to contain the state of the current object.
.IP EXAMPLES
.CS L
VAR dateRepr : DateRepr::DateRepr;
VAR stream   : Stream::Stream;
\&...
dateRepr := NEW DateRepr::DateRepr (1993, 10, 01, "%d/%m/%y");
dateRepr.Serialize (stream);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODeserialize\fP
.LP
.OH "'CoLibrEX Reference Manual''DateRepr'"
.EH "'DateRepr''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the new methods provided by the object type
\f(HODateRepr\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
R$Deserialize$IN$inStream$Stream$
_
R$Serialize$INOUT$ioStream$Stream$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibrEX Reference Manual''Time'"
.EH "'Time''CoLibrEX Reference Manual'"
.NX 1 "Time"
.sp
.NX 2 "Type Description"
.sp
\f(HOTime\fP is an object type representing a time value consisting of 
hours, minutes and seconds, as described in the CoLibri Reference Manual
\&(see [1]).
.sp
.NX 2 "List of Methods"
.sp
These are the methods which have been added to \f(HOTime\fP, available 
in <Time.cs>:
.TS
tab ($);
l l.
Method name$N(ew)
_
Deseriablize$N
Serialize$N
.TE
.sp 0.5
The new additional methods are described in the following sections, 
the others are described in the CoLibri Reference Manual (see [1]).
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
.NX 2 "How to use Time"
.sp
A variable of type \f(HOTime\fP is declared, as follows:
.CS L
VAR time : Time;
.CE
.sp 0.5
A variable of type \f(HOTime\fP can be initialized using the CooL 
constructor NEW for any of its instanciable sub types.
.sp 0.5
A sub type of type \f(HOTime\fP is declared, as follows:
.CS L
TYPE MyTime = Time OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HOTime\fP must 
import \f(HOTime\fP:
.CS L
IMPORT ..., Time, ...;
.CE
.sp
.NX 2 "Method Description"
.sp 
The following sections contain the syntactical and semantical 
description of all new additional methods provided by \f(HOTime\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''Time::Deserialize'"
.EH "'Time::Deserialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Deserialize"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD Deserialize (IN inStream : Stream);\fP
.IP DESCRIPTION
The method \f(HODeserialize\fP loads the state of \f(HOTime\fP from a 
\f(HOStream\fP received at \f(HOinStream\fP.
.IP EXAMPLES
.CS L
VAR time   : Time::Time;
VAR stream : Stream::Stream;
\&...
time   := NEW Time::Time (8, 30, 0);
time.Serialize (stream);
DELETE time;
time   := NEW Time::Time (12, 30, 0);
time.Deserialize (stream);
.CE
Then \f(HOtime\fP has the value "08:30:00".
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOSerialize\fP
.LP
.OH "'CoLibrEX Reference Manual''Time::Serialize'"
.EH "'Time::Serialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Serialize"
.sp
.IP MODULE
\f(HBTime\fP
.IP TYPE
\f(HBTime\fP
.IP SYNOPSIS
\f(HBMETHOD Serialize (INOUT ioStream : Stream);\fP
.IP DESCRIPTION
The method \f(HOSerialize\fP updates the \f(HOStream\fP received at 
\f(HOioStream\fP to contain the state of the current object.
.IP EXAMPLES
.CS L
VAR time   : Time::Time;
VAR stream : Stream::Stream;
\&...
time   := NEW Time::Time (8, 30, 0);
time.Serialize (stream);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODeserialize\fP
.LP
.OH "'CoLibrEX Reference Manual''Time'"
.EH "'Time''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the new methods provided by the object type
\f(HOTime\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
N$Deserialize$IN$inStream$Stream$
_
N$Serialize$INOUT$ioStream$Stream$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
.OH "'CoLibrEX Reference Manual''TimeRepr'"
.EH "'TimeRepr''CoLibrEX Reference Manual'"
.NX 1 "TimeRepr"
.sp
.NX 2 "Type Description"
.sp
\f(HOTimeRepr\fP is a sub type of \f(HOTime\fP,
see CoLibri Reference Manual (see [1]).
.sp
.NX 2 "List of Methods"
.sp
These are the methods which have been added to \f(HOTimeRepr\fP, 
available in <TimeRepr.cs>:
.TS
tab ($);
l l.
Method name$R(edefined)
_
Deserialize$R
Serialize$R
.TE
.sp 0.5
The new additional methods are described in the following sections, 
the others are described in the CoLibri Reference Manual (see [1]).
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
.NX 2 "How to use TimeRepr"
.sp
A variable of type \f(HOTimeRepr\fP is declared, as follows:
.CS L
VAR timeRepr : TimeRepr;
.CE
.sp 0.5
A variable of type \f(HOTimeRepr\fP can be initialized using the CooL 
constructor NEW for any of its instanciable sub types.
.sp 0.5
A sub type of type \f(HOTimeRepr\fP is declared, as follows:
.CS L
TYPE MyTimeRepr = TimeRepr OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HOTimeRepr\fP must 
import \f(HOTimeRepr\fP:
.CS L
IMPORT ..., TimeRepr, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all new additional methods provided by \f(HOTimeRepr\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''TimeRepr::Deserialize'"
.EH "'TimeRepr::Deserialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Deserialize"
.sp
.IP MODULE
\f(HBTimeRepr\fP
.IP TYPE
\f(HBTimeRepr = Time\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Deserialize (IN inStream : Stream);\fP
.IP DESCRIPTION
The method \f(HODeserialize\fP loads the state of \f(HOTimeRepr\fP from 
a \f(HOStream\fP recieved at \f(HOinStream\fP.
.IP EXAMPLES
.CS L
VAR timeRepr   : TimeRepr::TimeRepr;
VAR stream     : Stream::Stream;
\&...
timeRepr   := NEW TimeRepr::TimeRepr (8, 30, 0, "%H:%M:%S");
timeRepr.Serialize (stream);
DELETE time;
timeRepr   := NEW TimeRepr::TimeRepr (12, 30, 0, "%H:%M:%S");
time.Deserialize (stream);
.CE
Then \f(HOtime\fP has the value "08:30:00" and the time format 
\&"%H:%M:%S".
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOSerialize\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeRepr::Serialize'"
.EH "'TimeRepr::Serialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Serialize"
.sp
.IP MODULE
\f(HBTimeRepr\fP
.IP TYPE
\f(HBTimeRepr = Time\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Serialize (INOUT ioStream : Stream);\fP
.IP DESCRIPTION
The method \f(HOSerialize\fP updates the \f(HOStream\fP received at 
\f(HOioStream\fP to contain the state of the current object.
.IP EXAMPLES
.CS L
VAR timeRepr : TimeRepr::TimeRepr;
VAR stream   : Stream::Stream;
\&...
timeRepr := NEW TimeRepr::TimeRepr (8, 30, 0, "%H:%M:%S");
timeRepr.Serialize (stream);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HODeserialize\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeRepr'"
.EH "'TimeRepr''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the new methods provided by the object type
\f(HOTimeRepr\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
R$Deserialize$IN$inStream$Stream$
_
R$Serialize$INOUT$ioStream$Stream$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'CoLibrEX Reference Manual''TimeStampRepr'"
.EH "'TimeStampRepr''CoLibrEX Reference Manual'"
.NX 1 "TimeStampRepr"
.sp
.NX 2 "Type Description"
.sp
\f(HOTimeStampRepr\fP is a sub type of \f(HOTimeStamp\fP, 
see CoLibri Reference Manual (see [1]).
.sp
.NX 2 "List of Methods"
.LP
These are the methods added to \f(HOTimeStampRepr\fP, available in 
\&<TimeStampRepr.cs>:
.TS
tab ($);
l l.
Method name$R(edefined)
_
Deserialize$R
Serialize$R
.TE
.sp 0.5
The new additional methods are described in the following sections, 
the others are described in the CoLibri Reference Manual (see [1]).
.sp
.NX 2 "Error Handling"
.sp
Error handling uses the exception handling of CooL. 
For each method described below the exceptions which will be raised in 
case of an error are listed.
.sp
.NX 2 "How to use TimeStampRepr"
.sp
A variable of type \f(HOTimeStampRepr\fP is declared, as follows:
.CS L
VAR timeStampRepr : TimeStampRepr;
.CE
.sp 0.5
A variable of type \f(HOTimeStampRepr\fP can be initialized using the 
CooL constructor NEW for any of its instanciable sub types.
.sp 0.5
A sub type of type \f(HOTimeStampRepr\fP is declared, as follows:
.CS L
TYPE MyTimeStampRepr = TimeStampRepr OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL compilation unit which uses the type \f(HOTimeStampRepr\fP 
must import \f(HOTimeStampRepr\fP:
.CS L
IMPORT ..., TimeStampRepr, ...;
.CE
.sp
.NX 2 "Method Description"
.sp
The following sections contain the syntactical and semantical 
description of all methods provided by \f(HOTimeStampRepr\fP. 
They are listed in alphabetical order.
.sp
.OH "'CoLibrEX Reference Manual''TimeStampRepr::Deserialize'"
.EH "'TimeStampRepr::Deserialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Deserialize"
.sp
.IP MODULE
\f(HBTimeStampRepr\fP
.IP TYPE
\f(HBTimeStampRepr = TimeStamp\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Deserialize (IN inStream : Stream);\fP
.IP DESCRIPTION
The method \f(HODeserialize\fP loads the state of \f(HOTimeStampRepr\fP 
from a \f(HOStream\fP received at \f(HOinStream\fP.
.IP EXAMPLES
.CS L
VAR timeStampRepr : TimeStampRepr;
VAR stream        : Stream::Stream;
\&...
timeStampRepr := NEW TimeStampRepr::TimeStampRepr 
                     (1993, 10, 01, NEW Time::Time (8, 30, 0), 
                      "%d/%m/%y");
timeStampRepr.Serialize (stream);
DELETE timeStampRepr;
timeStampRepr := NEW TimeStampRepr::TimeStampRepr 
                     (1990, 01, 01, NEW Time::Time (0, 0, 0),
                      "%d/%m/%y");
timeStamp.Deserialize (stream);
.CE
Then \f(HOtimeStamp\fP has the value "01/10/1993", "08:30:00" and the 
date format "%d/%m/%y".
.IP "SEE ALSO"
\f(HOINITIALLY\fP, 
\f(HOSerialize\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeStampRepr::Serialize'"
.EH "'TimeStampRepr::Serialize''CoLibrEX Reference Manual'"
.bp
.NX 3 "Serialize"
.sp
.IP MODULE
\f(HBTimeStampRepr\fP
.IP TYPE
\f(HBTimeStampRepr = TimeStamp\fP
.IP SYNOPSIS
\f(HBREDEFINED METHOD Serialize (INOUT ioStream : Stream);\fP
.IP DESCRIPTION
The method \f(HOSerialize\fP updates the \f(HOStream\fP received at 
\f(HOioStream\fP to contain the state of the current object.
.IP EXAMPLES
.CS L
VAR timeStampRepr : TimeStampRepr;
VAR stream        : Stream::Stream;
\&...
timeStampRepr := NEW TimeStampRepr::TimeStampRepr 
                     (1993, 10, 01, NEW Time::Time (8, 30, 0),
                      "%d/%m/%y");
timeStampRepr.Serialize (stream);
.CE
.IP "SEE ALSO"
\f(HOINITIALLY\fP,
\f(HODeserialize\fP
.LP
.OH "'CoLibrEX Reference Manual''TimeStampRepr'"
.EH "'TimeStampRepr''CoLibrEX Reference Manual'"
.bp
.NX 2 "Quick Reference"
.sp
The table below summarizes the new methods provided by the object type
\f(HOTimeStampRepr\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
R$Deserialize$IN$inStream$Stream$
_
R$Serialize$INOUT$ioStream$Stream$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "''''"
.EH "''''"
.bp
.OH "'CoLibrEX Reference Manual''Dictionary'"
.EH "'Dictionary''CoLibrEX Reference Manual'"
.bp
.NX 2 "Dictionary"
.sp
.NX 3 "Type Description"
.sp
\f(HODictionary\fP is a generic object type representing a container consisting of an
arbitrary number of elements.
Each element consists of a unique key value and a related entry value.
The key values are unique within a dictionary.
A strong order must be defined for the key values.
This object type offers methods to insert, delete, retrieve or replace
elements and to split or merge dictionaries.
Moreover this type provides a cursor which allows to navigate through the
elements of a dictionary and to retrieve the contents of the elements.
.sp
The types of the key and entry values must be specified by the application
programmer to get a special \f(HODictionary\fP type if a variable of type
\f(HODictionary\fP must be declared.
.sp 0.5
.IP NOTE
If the key type is an object type, the key values which
are used to keep the order may not be changed.
.LP
.sp 0.5
The general features of any \f(HODictionary\fP type are described using the
following syntax:
.TS
tab($);
l l l.
String$Description$Example
_
Dictionary$name of the special \f(HODictionary\fP type$ClientDictionary
KeyType$type of the key values$PersonalNumber
EntryType$type of the entry values$PersonalName
.TE
.sp
.NX 3 "List of Methods"
.sp
The following methods are available in \f(HO<Dictionary.cs>\fP:
.TS
tab($);
l.
Method name
_
Apply
Contains
GetEntry
GetEntryAtCursor
GetKeyAtCursor
GetNumberOfElements
GetNumberOfMatches
InsertElement
IsEmpty
IsEqual
IsFirst
IsLast
Merge
RemoveElement
ReplaceEntry
SetCursorToElement
SetCursorToFirst
SetCursorToLast
SetCursorToNext
SetCursorToPrevious
SetEntryAtCursor
Split
.TE
.sp 0.5
The new additional methods are described in the following sections, 
the others are described in the CoLibri Reference Manual (see [1]).
.sp
.NX 3 "Error Handling"
.sp
Error handling uses the exception handling of CooL.
For each method described below the exceptions which will be raised in case
of an error are listed.
.sp
The following exceptions can be raised using module \f(HODictionary\fP :
.TS
tab($);
l.
exception name
_
Map::ContainerEmpty
Map::CursorUndefined
BTree::KeyAlreadyExists
BTree::KeyNotFound
BTree::NoNextElement
BTree::NoPreviousElement
.TE
.sp
.NX 3 "How to use Dictionary"
.sp
A variable of type \f(HODictionary\fP is declared as follows:
.CS L
VAR person_dictionary : Dictionary [PersonDictionaryKeyType, PersonDictionaryEntryType];
.CE
.sp 0.5
A variable of type \f(HODictionary\fP can be initialized using the CooL constructor
NEW.
.sp
A sub type of type \f(HODictionary\fP is declared as follows:
.CS L
TYPE PersonDictionary [KeyType, EntryType, ...] = Dictionary OBJECT ... END OBJECT;
.CE
.sp 0.5
Each CooL module which uses the type \f(HODictionary\fP must import the module
\f(HODictionary\fP:
.CS L
IMPORT ..., Dictionary, ...;
.CE
.sp 0.5
.NX 3 "Method Description"
.sp
The following sections contain the syntactical and semantical description of
all methods provided by \f(HODictionary\fP.
They are listed in alphabetical order.
.sp
.KS
The examples are based on a generic object type of type \f(HODictionary\fP:
.CS L
TYPE IntObject = OBJECT( IN number : INT )
PUBLIC
  METHOD Get : INT;
  METHOD Put( IN number : INT );
PROTECTED
STATE
  integer : INT;
BODY
  INITIALLY( IN number : INT )
  DO
    integer := number;
  END DO;

  METHOD Get : INT
  DO 
    RETURN integer;
  END DO;

  METHOD Put( IN number : INT )
  DO
    integer := number;
  END DO;
END OBJECT;

TYPE StringObject = OBJECT( IN str : STRING )
PUBLIC
  METHOD Get : STRING;
  METHOD Put( IN str : STRING );
PROTECTED
STATE
  string : STRING;
BODY
  INITIALLY( IN str : STRING )
  DO
    string := str;
  END DO;

  METHOD Get : STRING
  DO 
    RETURN string;
  END DO;

  METHOD Put( IN str : STRING )
  DO
    string := str;
  END DO;
END OBJECT;

\&...

VAR person_dictionary : Dictionary::Dictionary [IntObject, StringObject];
.CE
.KE
.sp 0.5
It is assumed that this special \f(HODictionary\fP type contains the following
elements as objects:
.TS
tab($);
l l.
Key value$Entry value
_
13$John Wayne
17$Marilyn Monroe
99$peter stuyvesant
.TE
.LP
.OH "'CoLibrEX Reference Manual''Dictionary::INITIALLY'"
.EH "'Dictionary::INITIALLY''CoLibrEX Reference Manual'"
.bp
.NX 4 "INITIALLY"
.sp
.IP MODULE
\f(HBDictionary\fP
.IP TYPE
\f(HBDictionary\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l0 l.
\f(HBINITIALLY $($ IN less $ : $ PROCEDURE
$$$$( IN KeyType,
$$$$  IN KeyType ) : BOOL,
$$ IN equal $ : $ PROCEDURE
$$$$( IN KeyType,
$$$$  IN KeyType ) : BOOL) 
$:$ Dictionary $$[KeyType, EntryType];\fP
.TE
.IP DESCRIPTION
INITIALLY is implicitly called when using the CooL constructor NEW.
The parameters \f(HOless\fP and \f(HOequal\fP specify the order and equality
of the key values of the current object.
The procedure \f(HOless\fP is used for the correct placement of an element in
a dictionary, the procedure \f(HOequal\fP is used for the correct access to an
element in a dictionary.
The cursor is not defined after a new dictionary is created.
.IP "RETURN VALUE"
This method returns a new object of this type.
.KS
.IP EXAMPLES
.CS L
PROCEDURE lessPersonDictionary ( IN key1 : IntObject, IN key2 : IntObject ) : BOOL
DO
   -- This procedure returns TRUE, if key1 is less than key2.
   -- Otherwise it returns FALSE.
   RETURN (key1.Get < key2.Get);
END DO;
\&...
PROCEDURE equalPersonDictionary ( IN key1 : IntObject, IN key2 : IntObject ) : BOOL
DO
   -- This procedure returns TRUE, if key1 is equal to key2.
   -- Otherwise it returns FALSE.
   RETURN (key1.Get = key2.Get);
END DO;
\&...
VAR person_dictionary : Dictionary::Dictionary [IntObject, StringObject];
\&...
person_dictionary := NEW Dictionary::Dictionary [IntObject, StringObject] (lessPersonDictionary, equalPersonDictionary);
.CE
.KE
.IP "SEE ALSO"
\f(HOMerge\fP
.LP
.OH "'CoLibrEX Reference Manual''Dictionary'"
.EH "'Dictionary''CoLibrEX Reference Manual'"
.bp
.NX 3 "Quick Reference"
.sp
The table below summarizes the methods provided by the object type
\f(HODictionary\fP.
.br
The column R/N shows whether the method is
.IP \(bu 3
redefined (R),
.IP \(bu 3
a new method (N),
.IP \(bu 3
an inherited method without modifications ( ).
.LP
.KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l | l.
R/N$Name$Mode$Parameter$Type$Exceptions
=
$INITIALLY$IN$less$PROCEDURE$
$$IN$equal$PROCEDURE$
$$result$$Dictionary [KeyType, EntryType]$
_
$Apply$IN$routine$PROCEDURE$ContainerEmpty
_
$Contains$IN$key$KeyType$
$$result$$BOOL$
_
$GetEntry$IN$key$KeyType$ContainerEmpty
$$result$$EntryType$KeyNotFound
_
$GetEntryAtCursor$result$$EntryType$CursorUndefined
_
$GetKeyAtCursor$result$$KeyType$CursorUndefined
_
$GetNumberOfElements$result$$INT$
_
$GetNumberOfMatches$IN$predicate$PROCEDURE$
$$result$$INT$
_
$InsertElement$IN$key$KeyType$KeyAlreadyExists
$$IN$entry$EntryType$
_
$IsEmpty$result$$BOOL$
_
$IsEqual$IN$second_dictionary$Dictionary [KeyType, EntryType]$
$$IN$equal_entry$PROCEDURE$
$$result$$BOOL$
_
$IsFirst$result$$BOOL$CursorUndefined
_
$IsLast$result$$BOOL$CursorUndefined
_
$Merge$IN$second_dictionary$Dictionary [KeyType, EntryType]$KeyAlreadyExists
_
$RemoveElement$IN$key$KeyType$ContainerEmpty
$$$$$KeyNotFound
_
$ReplaceEntry$IN$key$KeyType$ContainerEmpty
$$IN$entry$EntryType$KeyNotFound
_
$SetCursorToElement$IN$key$KeyType$ContainerEmpty
$$$$$KeyNotFound
_
$SetCursorToFirst$$$$ContainerEmpty
_
$SetCursorToLast$$$$ContainerEmpty
_
$SetCursorToNext$$$$CursorUndefined
$$$$$NoNextElement
_
$SetCursorToPrevious$$$$CursorUndefined
$$$$$NoPreviousElement
_
$SetEntryAtCursor$IN$entry$EntryType$CursorUndefined
_
$Split$IN$key$KeyType$ContainerEmpty
$$result$$Dictionary [KeyType, EntryType]$
.TE
.NL
.nr PS 12
.KE
.LP
.OH "'CoLibrEX Reference Manual''References'"
.EH "'References''CoLibrEX Reference Manual'"
.NX 0 "References
.sp
.IP [1] 5
CooL V2.1
.br
CoLibri -  Reference Manual
.LP
.OH "''''"
.EH "''''"
.bo
\&
.bp
.OH "'CoLibrEX Reference Manual''Contents'"
.EH "'Contents''CoLibrEX Reference Manual'"
.PX
