.OH "'CooL Language Reference Manual''Declarations'"
.EH "'Declarations''CooL Language Reference Manual'"
.bp
.NX 1 "Declarations"
.LP
A declaration introduces an entity, such as a type, constant,
variable, exception or procedure, and declares a name that can be used
to refer to that entity.
.LP
A program is a set of modules and a module is a set of declarations.
Declarations may be mutually recursive and may be given in any order.
Inside a module all identifiers introduced by these declarations must
be unique.
.\"===========================================================================
.NX 2 "Type Declaration"
.LP
A type declaration has the form
.Ss
TYPE I = T;
.Se
where
.Si I
is an identifier and
.Si T
is a type (other than an identifier denoting an object type).
.LP
It defines
.Si I
as a type name which is equivalent to
.Si T.
.\"===========================================================================
.NX 2 "Constant Declaration"
.LP
A constant declaration has the form
.Ss
CONST I1, ... , In : T = C;
.Se
where
.Si Ii
are identifiers,
.Si T
is a type which is equivalent to
.Si BOOL,
an integer type, a floating point type,
.Si CHAR,
.Si STRING
or an 
.Si ENUM
type and
.Si C
is a constant expression.
.LP
It declares each identifier
.Si Ii
as a named constant of type
.Si T
with the value 
.Si C.
The type of the value must be compatible with the type 
.Si T 
or both types must be numeric (i.e. of integer type or floating point
type).
.\"===========================================================================
.NX 2 "Variable Declaration"
.LP
A variable declaration has the form
.Ss
VAR I1, ... , In : T := C;
.Se
where
.Si Ii
are identifiers and
.Si T
is a type and 
.Si C
is a constant expression.
.LP
It declares each identifier
.Si Ii
as variable with values of the type
.Si T
whose initial value is the value of 
.Si C.
The type of
.Si C
must be compatible with the type 
.Si T 
or both types must be numeric (i.e. of integer type or floating point
type).
.LP
The initialization
.Si ":= C" 
may be omitted. In this case the initial value is an arbitrary
value of type
.Si T.
.\"===========================================================================
.NX 2 "Exception Declaration"
.LP
An exception declaration has the form
.Ss
EXCEPTION E1, ... , En Sig;
.Se
where
.Si Ei
are identifiers. It declares each identifier
.Si Ei
as an exception.
.LP
.Si Sig
is either empty or a signature of the form
.Ss
(P1, ... , Pn)
.Se
.Si Pi
is a formal parameter of the form
.Ss
IN I : T
.Se
where
.Si I 
is an identifier and
.Si T
is a type. The mode specification 
.Si IN
may be omitted.
.LP
The notation
.Ss
IN I1, ... , In : T
.Se
is a shorthand for
.Ss
IN I1 : T, ... , IN In : T
.Se
.LP
If the signature is omitted, the exception takes no argument.
.LP
An exception may be used to indicate an error situation using a raise
statement and to deal with such situations in a try statement.
.\"===========================================================================
.NX 2 "Procedure Declaration"
.LP
A procedure declaration has the form
.Ss
PROCEDURE P Sig
   Locals
DO
   Stmts
END DO;
.Se
where 
.Si P
is an identifier.
.LP
.Si Sig
is either empty or a signature of the form
.Ss
(P1 , ... , Pn)
.Se
or
.Ss
(P1 , ... , Pn) : T
.Se
The first form is used for 
.Ii "proper procedures"
that may be used in call statements.
.br
The second form is used for
.Ii "functions"
returning a value of the type
.Si T
and may be used in call expressions.
.LP
.Si Pi
is a formal parameter declaration of the form
.Ss
M I : T
.Se
where
.Si I 
is an identifier
and
.Si T
is a type.
.Si M
is the 
.Ii "mode"
which is either
.Si IN,
.Si OUT
, or
.Si INOUT.
The mode may be omitted, in which case
.Si IN
is assumed.
.LP
The notation
.Ss
M I1, ... , In : T
.Se
is a shorthand for
.Ss
M I1 : T, ... , M In : T
.Se
.LP
.Si Locals
is a list of variable declarations. An identifier 
.Si I 
introduced in
.Si Locals 
is declared as a local variable, visible in 
.Si Stmts.
.LP
.Si Stmts
is a list of statements.
.LP
The declaration defines
.Si P
as a procedure with the given signature.
.KS
.SH
Procedure Calls
.LP
A procedure call is used to activate the computation described by the
.Si Stmts
of the procedure declaration. A call has the form
.Ss
P (A1 , ... , An);
.Se
.KE
The
.Si Ai
are called the 
.Ii "actual parameters."
There must be as many actual parameters as there are formal
parameters.
.Si Ai
is an expression if the mode of the corresponding formal parameter is
.Si IN
;
it must be a designator, if the mode is
.Si OUT
or
.Si INOUT.
.LP
The execution of a procedure call first evaluates the actual
parameters and then executes the statements given in the procedure
declaration.
.LP
During elaboration of the procedure the actual parameters are referred
to by the corresponding formal parameters.
.LP
For each invocation of a procedure a fresh set of local variables is
created which may be accessed by the statements given in the procedure
declaration.
.SH
Parameter Modes
.LP
Depending on its mode, a formal parameter may be used to access or
update the value of the actual parameter.
.LP
If the mode of the parameter is 
.Si IN,
the formal parameter may be used to access the value of the actual
parameter but not to update that value.  Formal parameters of mode
.Si IN
cannot be used as actual parameters of mode
.Si OUT
or
.Si INOUT.
They cannot be used as the target of an assignment.
.LP
If the mode of the parameter is
.Si OUT,
the formal parameter may be used to update the value of the actual
parameter but not to access its value as provided by the caller (hence
the formal parameter must be considered as initially undefined).
.LP
If the mode of the parameter is
.Si INOUT,
the formal parameter may be used to access the value of the actual
parameter as well as to update that value.
.LP
The formal parameter is an alias of the actual parameter if the mode
is
.Si OUT
or
.Si INOUT,
or if the mode is
.Si IN
and the type is an array type. Otherwise the formal parameter refers
to a copy of the actual parameter's value as provided by the caller.
.SH
Parameter Types
.LP
The type of the formal parameter determines the possible types of
actual parameters.
.LP
If the mode of the formal parameter is 
.Si IN
the type of the actual parameter must be compatible to the type of the
formal parameter.
.LP
If the mode of the formal parameter is 
.Si OUT
the type of the formal parameter must be compatible to the type of the
actual parameter.
.LP
If the mode of the formal parameter is 
.Si INOUT
the type of the actual parameter must be compatible to the type of the
formal parameter and vice versa.
.LP
If the mode of the formal parameter is 
.Si IN
and its type is 
.Si "ARRAY [Lwb .. Upb] OF CHAR,"
.Si "ARRAY OF CHAR,"
.Si "REF ARRAY [Lwb .. Upb] OF CHAR,"
or
.Si "REF ARRAY OF CHAR,"
a string literal may be supplied as actual parameter. The formal
parameter then designates the string interpreted as an array of
characters or (in the latter two cases) as the address of an array
containing the characters of the string.
.\"===========================================================================
.KS
.NX 2 "Foreign Declarations"
.LP
Variables and procedures from modules not written in CooL are made
accessible by foreign declaration.
.SH
Foreign Variables
.LP
The specification of a foreign variable has the form
.Ss
FOREIGN VAR I1, ... , In : T;
.Se
where
.Si Ii
are identifiers and
.Si T
is a type.  It declares
.Si Ii
as a variable with values of the type
.Si T.
There must be an actual declaration of
.Si Ii
in a separate module written in a language other than CooL.
.KE
.SH 
Foreign Procedures
.LP
The specification of a foreign procedure has the form
.Ss
FOREIGN PROCEDURE P Sig;
.Se
where 
.Si P
is an identifier and
.Si Sig
is a signature. It declares
.Si P
as a procedure with the signature
.Si Sig.
.LP
There must be an actual declaration of 
.Si P
in a separate module written in a language other than CooL. CooL
follows the C parameter passing conventions.
.LP
The formal parameter list of
.Si P
may be terminated with an ellipsis (".."):
.Ss
(P1 , ... , Pn, ..)
.Se
In this case, a call may provide more than n parameters. The
additional parameters may be of any type; their mode is assumed to be
.Si IN.
The use of the ellipsis is restricted to foreign procedures.
.SH
Foreign Types
.LP
The following list gives the corresponding CooL data type to a C data
type:
.in +.5i
.ps \n(PS-1
.vs \n(VS-1
.TS
tab(#) ;
lfC lfC .
C#CooL
_
int#INT
short#SHORT INT
long#LONG INT
unsigned int#UNSIGNED INT
unsigned short#UNSIGNED SHORT INT
unsigned long#UNSIGNED LONG INT
float#FLOAT
double#DOUBLE
char#CHAR
enum { ... }#ENUM ... END ENUM
struct { ... }#RECORD ... END RECORD 
union { ... }#UNION ... END UNION
T [N]#ARRAY [1 .. N] OF T
char \(**#REF ARRAY OF CHAR
T \(**#REF T
void \(**#ADDRESS
(\(**)( ... )#PROCEDURE ( ... )
.TE
.ps \n(PS
.vs \n(VS
.in -.5i
