--                             -*- Mode: Cool2 -*- 
-- mystring.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: mystring.cs[1.0] Tue Feb 22 10:01:17 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 10:01:43 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Wed Mar 16 12:03:40 1994
-- Update Count    : 4
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION mystring

IMPORT FixedString 
  FROM globals;
IMPORT MySet 
  FROM Bayer;

TYPE String = OBJECT (IN string : ARRAY OF CHAR)
  
PUBLIC

  METHOD GetString : REF ARRAY OF CHAR;
  METHOD GetFixed  : FixedString;
  METHOD PutString (IN s : REF ARRAY OF CHAR);
  -- METHOD IsEqual (IN s : String);
  
PROTECTED
  
STATE
  str  : REF ARRAY OF CHAR;

END OBJECT;

PROCEDURE is_equal (IN str1 : ARRAY OF CHAR, 
		    IN str2 : ARRAY OF CHAR) : BOOL;
PROCEDURE contains (IN str1 : ARRAY OF CHAR, 
		    IN str2 : ARRAY OF CHAR) : BOOL;
PROCEDURE starts_with (IN str1 : ARRAY OF CHAR, 
		       IN str2 : ARRAY OF CHAR) : BOOL;
PROCEDURE ends_with (IN str1 : ARRAY OF CHAR, 
		     IN str2 : ARRAY OF CHAR) : BOOL;
PROCEDURE IsGenericVar (IN name : FixedString) : BOOL;
PROCEDURE IsFormalTypeVar (IN name : FixedString) : BOOL;
PROCEDURE IsHiddenName (IN name : FixedString) : BOOL;
PROCEDURE changec3iToCName (INOUT name : ARRAY OF CHAR);
PROCEDURE get_longest_var_name (IN var_set : MySet) : INT;
PROCEDURE change_name (IN  name1  : ARRAY OF CHAR, 
		       OUT name2  : ARRAY OF CHAR, 
		       IN  delim1 : ARRAY OF CHAR, 
		       IN  delim2 : ARRAY OF CHAR);
PROCEDURE split_string (IN  base : ARRAY OF CHAR, 
			OUT left : ARRAY OF CHAR, 
			OUT right : ARRAY OF CHAR);
PROCEDURE split_string_at_delimiter (IN  base      : ARRAY OF CHAR, 
				     OUT left      : ARRAY OF CHAR, 
				     OUT right     : ARRAY OF CHAR,
				     IN  delimiter : CHAR);
PROCEDURE isPositivInteger (IN s : ARRAY OF CHAR) : BOOL;
PROCEDURE isInteger (IN s : ARRAY OF CHAR) : BOOL;
  
END SPECIFICATION;
