--                             -*- Mode: Cool2 -*- 
-- opsys.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: opsys.cs[1.0] Tue Feb 22 10:01:33 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 10:03:03 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Fri Jun 10 13:08:38 1994
-- Update Count    : 26
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION opsys

IMPORT Function
  FROM function;
IMPORT StringList
  FROM stringlist;

CONST PT_INIT   : INT = 0;
CONST PT_IREAD  : INT = 1;
CONST PT_DREAD  : INT = 2;
CONST PT_UREAD  : INT = 3;
CONST PT_IWRITE : INT = 4;
CONST PT_DWRITE : INT = 5;
CONST PT_UWRITE : INT = 6;
CONST PT_RESUME : INT = 7;
CONST PT_EXIT   : INT = 8;
CONST PT_STEP   : INT = 9;

VAR arguments       : StringList;	 -- argument list passed to
					 -- the debugged process.

PROCEDURE my_ptrace (OUT return_code : INT,
				    IN  request     : INT,
				    IN  pid  : INT,
				    IN  address     : INT,
				    IN  data        : INT);

PROCEDURE get_process_id () : INT;

PROCEDURE open_executable ();
  -- -----------------------------------------------------------
  -- Open the running process and change some signal and fault
  -- behaviour. 
  -- -----------------------------------------------------------

PROCEDURE computeCooLRange (IN    function  : Function,
			    INOUT firstLine : INT,
			    INOUT lastLine  : INT);
  -- -----------------------------------------------------------------
  -- This procedure computes the range of CooL source lines a block is
  -- defined in. Complicated. Warning.
  -- -----------------------------------------------------------------

PROCEDURE read_register (IN offset : INT) : UNSIGNED INT;
  -- -----------------------------------------------------------------
  -- This procedure reads the register at offset offset.
  -- -----------------------------------------------------------------

PROCEDURE get_pc;
  -- -----------------------------------------------------------------
  -- This procedure reads the actual pc value of the debugged process.
  -- -----------------------------------------------------------------

PROCEDURE get_fp;
  -- -----------------------------------------------------------------
  -- This procedure reads the actual fp value of the debugged process.
  -- -----------------------------------------------------------------

PROCEDURE get_ra : INT;
  -- -----------------------------------------------------------------
  -- This procedure reads the actual frame size of the debugged process.
  -- -----------------------------------------------------------------
  
PROCEDURE write_pc ();
  -- -----------------------------------------------------------------
  -- This procedure writes the actual pc value of the debugged process.
  -- -----------------------------------------------------------------

PROCEDURE get_reg_addr : BOOL;
  -- -----------------------------------------------------------------
  -- Don't get the register base offset, simply open the running
  -- process for reading the information later.  
  -- -----------------------------------------------------------------

PROCEDURE is_process_returning_active : BOOL;
  -- -----------------------------------------------------------------
  -- This procedure interpretes the returned values (parameter and
  -- return value) of the wait system call. 
  -- As an interesting side effect, the actual pc and fp values of the
  -- debugged process are read and therefore be accessible after this
  -- procedure.
  -- -----------------------------------------------------------------

TYPE WAITRETURN = UNION
  ret : INT;
  ret_c : ARRAY [4] OF CHAR;
END UNION;

PROCEDURE my_wait (OUT process_return : WAITRETURN);
PROCEDURE correct_pc (IN pc : INT) : INT;

END SPECIFICATION;

