# ;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Fundamental -*- ;;;;;;;;;;;;;;;;;;;;;;;;;
# Makefile -- Makefile for making MaX
# 
#   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
#   All rights reserved
# 
# AtFSID          : $Header: Makefile[1.1] Wed Jan  5 12:04:14 1994 lutz@hawaii saved $
# Author          : Lutz Hilken
# 
# Created On      : Wed Jan  5 11:31:21 1994
# Last Modified By: unknown full name
# Last Modified On: Mon Jul 04 12:08:34 1994
# Update Count    : 104
# 
# HISTORY
# PURPOSE
# 	|>Description of module's purpose<|


# --------------------------------------------------------------------
#		system specification 
# --------------------------------------------------------------------

# Path to this node system relative to the root of the
# repository area defined above (e.g. src/vc/save).

NODEPATH = max/src

# A short name for this node system

NODENAME = MaX

# --------------------------------------------------------------------
#		the system's components
# --------------------------------------------------------------------

#
# The system (program, library, etc.) to be built. If you want to
# manage multiple programs, you should introduce multiple targets
# (like BIN1TARGET BIN2TARGET or any better names). In this case you 
# have to adjust the system building actions accordingly.

BINTARGET = max.exe
LIBTARGET =
SHAREDLIBTARGET =

# Aliases for (filesystem links to) $(BINTARGET).

ALIASES =

# The release number generator. The version number of this file will
# be used as release identifier for the whole system.

VERSIONFILE   = Release.c	# source
VERSIONOBJECT =	Release.obj	# derived (if source contains program code)

# The names of the subdirectories containing subsystems which are also
# to be built.

SUBSYSTEMS =

# The regular source and header files.
#
# PUBLIC headers (of a library) would be delivered (INCLUDEPATH) to the user.
# GLOBAL and LOCAL headers wouldn't be installed.

# CPP CooL Sources

PUBLIC_P_COOL_SPECS =
GLOBAL_P_COOL_SPECS =
LOCAL_P_COOL_SPECS  =
P_COOL_IMPLS =
P_COOL_MODS  =

# CooL Sources

PUBLIC_COOL_SPECS =
GLOBAL_COOL_SPECS =
LOCAL_COOL_SPECS  = \
	     Bayer.cs break.cs director.cs error.cs execut.cs expression.cs \
	     maxfile.cs function.cs globals.cs help.cs main.cs \
	     method.cs maxui.cs mysetgen.cs mystring.cs objecttype.cs \
	     opsys.cs runstack.cs runtime.cs stringlist.cs type.cs \
	     unixsymtab.cs unknownfunc.cs variable.cs \
	     Toi.cs ToiString.cs
COOL_IMPLS = Bayer.ci break.ci director.ci error.ci execut.ci expression.ci \
	     maxfile.ci function.ci globals.ci help.ci main.ci \
	     method.ci maxui.ci mysetgen.ci mystring.ci objecttype.ci \
	     runstack.ci runtime.ci stringlist.ci type.ci \
	     unknownfunc.ci variable.ci \
	     Toi.ci ToiString.ci
COOL_MODS  =

SYSDEP_SRC = coffbib.ci cofflowlev.c elfbib.ci elflowlev.c \
	     S-ODT.ci S-5.40.ci s_svr_4.ci s_win_nt.ci \
	     m_i386.cs m_i386.ci m_mips.cs m_mips.ci

SYSDEP_TMP = unixsymtab.ci unixsymtab.c2m unixsymtab.c \
	     opsys.ci opsys.c2m opsys.c \
	     machine.cs machine.h machine.ci machine.c2m machine.c \
	     lowlevel.c             

# Sources of variant source components stored under equal names in
# different locations. During system builds, only one of each (equally
# named) group is chosen. Source distributions need all of them.

VARIANTHEADERS =

VARIANTSOURCES =

VARIANTOBJECTS = lowlevel.obj machine.obj opsys.obj unixsymtab.obj

# C Sources

PUBLIC_C_HDR =
GLOBAL_C_HDR =
LOCAL_C_HDR  =
C_SRC =

# Templates

PUBLIC_TMPL = maxrc
GLOBAL_TMPL =
LOCAL_TMPL  =

# All sources

HEADERS = $(PUBLIC_P_COOL_SPECS) $(GLOBAL_P_COOL_SPECS) $(LOCAL_P_COOL_SPECS) \
          $(PUBLIC_COOL_SPECS) $(GLOBAL_COOL_SPECS) $(LOCAL_COOL_SPECS) \
          $(PUBLIC_C_HDR) $(GLOBAL_C_HDR) $(LOCAL_C_HDR) \
          $(PUBLIC_TMPL) $(GLOBAL_TMPL) $(LOCAL_TMPL)
SOURCES = $(P_COOL_IMPLS) $(P_COOL_MODS) $(COOL_IMPLS) $(COOL_MODS) $(C_SRC) 

# The manuals

MANUALS = $(MAN1) $(MAN3) $(MAN4) $(MAN5) $(MAN7)
MAN1 = max.1
MAN3 =
MAN4 =
MAN5 =
MAN7 =

# All source components of the system (should not be changed)

COMPONENTS = $(MANUALS) $(HEADERS) $(SOURCES) $(SYSDEP_SRC) \
             Shapefile Makefile Dependencies

# The derived files. All files, that are automatically produced during
# a build process should be listed here.

OBJECTS = $(VERSIONOBJECT) \
          $(P_COOL_MODS:.cmp=.obj) \
          $(P_COOL_IMPLS:.cip=.obj) \
          $(COOL_MODS:.cm=.obj) \
          $(COOL_IMPLS:.ci=.obj) \
          $(C_SRC:.c=.obj) \
	  $(VARIANTOBJECTS)

PUBLIC_HEADERS = \
          $(PUBLIC_P_COOL_SPECS:.csp=.cs) $(PUBLIC_P_COOL_SPECS:.csp=.h) \
          $(PUBLIC_COOL_SPECS) $(PUBLIC_COOL_SPECS:.cs=.h) \
          $(PUBLIC_C_HDR) \
          $(PUBLIC_TMPL)
GLOBAL_HEADERS = \
          $(GLOBAL_P_COOL_SPECS:.csp=.cs) $(GLOBAL_P_COOL_SPECS:.csp=.h) \
          $(GLOBAL_COOL_SPECS) $(GLOBAL_COOL_SPEC:.cs=.h) \
          $(GLOBAL_C_HDR) \
          $(GLOBAL_TMPL)

TMPS    = $(PUBLIC_P_COOL_SPECS:.csp=.cs) $(PUBLIC_P_COOL_SPECS:.csp=.h) \
          $(GLOBAL_P_COOL_SPECS:.csp=.cs) $(GLOBAL_P_COOL_SPECS:.csp=.h) \
          $(LOCAL_P_COOL_SPECS:.csp=.cs) $(LOCAL_P_COOL_SPECS:.csp=.h) \
          $(P_COOL_MODS:.cmp=.cm) $(P_COOL_MODS:.cmp=.h) \
            $(P_COOL_MODS:.cmp=.c) $(P_COOL_MODS:.cmp=.c2m) \
          $(P_COOL_IMPLS:.cip=.ci) $(P_COOL_IMPLS:.cip=.c) \
            $(P_COOL_IMPLS:.cip=.c2m) \
          $(PUBLIC_COOL_SPECS:.cs=.h) \
          $(GLOBAL_COOL_SPECS:.cs=.h) \
          $(LOCAL_COOL_SPECS:.cs=.h) \
          $(COOL_MODS:.cm=.h) $(COOL_MODS:.cm=.c) $(COOL_MODS:.cm=.c2m) \
          $(COOL_IMPLS:.ci=.c) $(COOL_IMPLS:.ci=.c2m) \
	  $(SYSDEP_TMP)

# --------------------------------------------------------------------
#		Private add ons
# --------------------------------------------------------------------

EMACS_PROJECT = /home/lutz/.files

# --------------------------------------------------------------------
#		environment specifications and locations
# --------------------------------------------------------------------

# The operating system, $(_TARGET) shall be built for.

SYSTEM = s_win_nt

# The processor type.

MACHINE = m_i386

# The object file format

OFILEFMT = coff

# The C Compiler

CCOMP = gcc

# The base directory of the project's repository area.

BASE = /project/cpe/development

# Locations and modes for the installation of executables, header
# files, libraries and manuals.

INSTALLBASE    = /project/hoods/V2.0A/wx-541-att
INSTALLBINPATH = $(INSTALLBASE)/bin
INSTALLBINMODE = 555
INSTALLINCPATH = $(INSTALLBASE)/include
INSTALLINCMODE = 444
INSTALLLIBPATH = $(INSTALLBASE)/lib
INSTALLLIBMODE = 444
INSTALLMANPATH = $(INSTALLBASE)/man
INSTALLMANMODE = 444

# Directories, where local libraries and header files are to be
# installed for project wide use.

LOCAL        = h:/gcc
LOCALBINPATH = $(LOCAL)/bin
LOCALBINMODE = 775
LOCALINCPATH = $(LOCAL)/include
LOCALINCMODE = 664
LOCALLIBPATH = $(LOCAL)/lib
LOCALLIBMODE = 664

# --------------------------------------------------------------------
#		tools, flags, libraries etc.
# --------------------------------------------------------------------

# The following macros will be overwritten by the system root makefile

MAKE  = make
SHELL = cmd.exe

COOL  = $(LOCALBINPATH)/cool

CC = gcc
CPP = gcc -E
LD  = link32

MAKECPPFLAGS  = -P
MAKECOOLFLAGS =
MAKECFLAGS    =
MAKELDFLAGS   = -nologo -stack:0x100000,0x100000 -subsystem:console

SHLIBGENFLAGS = -G -KPIC

# Preprocessor switches. (eg. -DDEBUG)

SWITCHES = -DNDEBUG -D_M_IX86 -D_X86_ -D_CONSOLE -D__stdcall="" -D__cdecl="" \
           -fno-builtin

SYSLIBS  = libgcc2.lib libc.lib oldnames.lib kernel_.lib netapi_.lib \
	   user32.lib user_.lib

RANLIB   = /usr/bin/touch

# The following macros will NOT be overwritten by the system root makefile

COOLINC   = -d $(LOCALINCPATH)

INCLUDES  = -I$(LOCALINCPATH) -Id:/msvcnt/include

LOCALLIBS = $(LOCALLIBPATH)/libColibri.lib \
            $(LOCALLIBPATH)/libcool.lib

PCOOLFLAGS = $(MAKECPPFLAGS) -D$(MACHINE) -D$(SYSTEM)
COOLFLAGS  = $(COOLINC) $(MAKECOOLFLAGS) 
CFLAGS     = $(INCLUDES) $(MAKECFLAGS) $(SWITCHES) -D$(MACHINE) -D$(SYSTEM)
LDFLAGS    = $(MAKELDFLAGS)

# --------------------------------------------------------------------
#			default targets
# --------------------------------------------------------------------

# The default action (do not change)

all: build

# --------------------------------------------------------------------
#		Dependencies
# --------------------------------------------------------------------

include Dependencies.win-nt

# --------------------------------------------------------------------
#		implicit rules 
# --------------------------------------------------------------------

include $(LOCALINCPATH)/default_build_rules

# --------------------------------------------------------------------
#		special rules 
# --------------------------------------------------------------------

printsys :
	@echo "BS: >$(HOSTTYPE)<, >$(SYSTEM)<" ;\
	 echo "Machine : >$(MACHINE)<" ;\
	 echo "C-sys: >$(CC)<, >$(CFLAGS)<, >$(OFILEFMT)<, >$(SYSLIBS)<" ;\
	 echo "CooL: >$(COOLROOT)<, >$(COOLBIN)<, >$(COOLLIB)<, >$(COOLINC)<"
	
preparesys : $(OFILEFMT)bib.ci $(OFILEFMT)lowlev.c $(SYSTEM).ci $(MACHINE).cs $(MACHINE).ci
	@echo "Compiling for $(OFILEFMT), $(SYSTEM) on $(MACHINE) ..."
	\rm -f unixsymtab.ci opsys.ci machine.cs machine.ci lowlevel.c
	ln $(OFILEFMT)bib.ci unixsymtab.ci
	ln $(OFILEFMT)lowlev.c lowlevel.c
	ln $(SYSTEM).ci opsys.ci
	ln $(MACHINE).cs machine.cs
	ln $(MACHINE).ci machine.ci

$(EMACS_PROJECT) : Makefile
	cp /dev/null $(EMACS_PROJECT)
	for i in $(COOL_MODS) coffbib.ci elfbib.ci \
		   S-ODT.ci S-5.40.ci S-5.41.ci system486.ci mips.ci ; do \
	  echo "`pwd`/$$i" ;\
	done | sort > $(EMACS_PROJECT) 

max.tar : $(COMPONENTS)
	@echo "Packing max..." ;\
	tar -cf max.tar $(COMPONENTS) ;\
	echo "Packing max...done."

max.cpio : $(COMPONENTS)
	@echo "Packing max..." ;\
	find $(COMPONENTS) -print | cpio -ov > max.cpio ;\
	echo "Packing max...done."

# --------------------------------------------------------------------
#		other targets
# --------------------------------------------------------------------

# The final system building action.

targets: $(BINTARGET) $(LIBTARGET) $(SHAREDLIBTARGET)

# Construction of a binary would look like:
$(BINTARGET): $(OBJECTS)
	$(LD) $(LDFLAGS) -out:$(BINTARGET) $(OBJECTS) $(LOCALLIBS) $(SYSLIBS)
#	@_aliases="$(ALIASES)"; \
#	for i in $$_aliases; \
#	do \
#	  rm -f $$i; \
#	  echo linking $(BINTARGET) to $$i; \
#	  ln $(BINTARGET) $$i; \
#	done

# The install actions. 

# Contruction of derived sources (portable binaries)

preinstall:

localinstalltargets: localinstallbin \
		localinstalllib \
		localinstallsharedlib \
		localinstallheaders

installtargets: installbin \
		installlib installsharedlib \
		installheaders installmanuals


# The cleanup action. Removes all automatically rederivable files.

doclean:
	rm -f $(BINTARGET) $(ALIASES) $(LIBTARGET) $(SHAREDLIBTARGET) \
	      $(OBJECTS) $(TMPS)

include $(LOCALINCPATH)/general_targets
