#ifdef s_win_nt
# include <windows.h>
#endif

# include <setjmp.h>
# include <stdio.h>
# include <stdlib.h>
# include <memory.h>

jmp_buf C3IC3ICurrExceptBuf;
void *C3IC3ICurrExcept;
int C3IC3IExceptLevel = 0;

/*------------------------------------------------------------------------*/
/*    RTS default exception handler                                       */

void C3IC3IDEFAULTEXCEPTHANDLER( void * ExceptionDescription )
{
#ifdef s_win_nt
  MessageBox(NULL,
  	     *((char **)ExceptionDescription),
  	     "Default CooL Exception Handler",
  	     MB_OK | MB_TASKMODAL);
  ExitProcess(0);
#else
  printf( "exception %s handled by default exception handler\n",
           *((char **)ExceptionDescription) );
  exit (0);
#endif
}

void C3IC3IRAISE( void )
{
  if ( C3IC3IExceptLevel )
     longjmp( C3IC3ICurrExceptBuf, 1 ); /* value may be any integer */
  else
     C3IC3IDEFAULTEXCEPTHANDLER( C3IC3ICurrExcept );
}

void C3IC3IRestorePrevExceptionHandler (jmp_buf C3IC3IPrevExceptBuf)
{
  memcpy( C3IC3ICurrExceptBuf, C3IC3IPrevExceptBuf, sizeof(jmp_buf) );
  C3IC3IExceptLevel--;
}

void C3IC3ISetCurrentExceptionHandler (jmp_buf C3IC3IPrevExceptBuf)
{
  memcpy( C3IC3IPrevExceptBuf, C3IC3ICurrExceptBuf, sizeof(jmp_buf) );
  C3IC3IExceptLevel++;
}
