/***************************************************************************/
/*                      SQL_ENTR.C - SQLGEN-start                          */
/*-------------------------------------------------------------------------*/
/*      Copyright (C) Siemens Nixdorf Informationssysteme AG 1992          */
/*      All rights reserved                                                */
/*	Last modified by Michael Watzek					   */
/***************************************************************************/

# include "sql_defs.h"

static char sccsid[] = "@(#) sql_entr.c 1.0 1992-11-29";

static int optionindex;
static char *optionargument;

# ifdef DATABASE_PRESENT
static char *optionstring = "Vvl:c:o:";
# else
static char *optionstring = "Vvl:o:";
# endif

static int get_options();
int verbose_Flag = FALSE;
char *Outfile_Name = (char *)0;
int check_Flag = FALSE;
char *Database = (char *)0;
char *Language = (char *)0;
LANGUAGE current_Language = L_COOL;

static void get_Infile_Name();
static void open_Output_Files();

/*---- MAIN ---------------------------------------------------------------*/

main( argc, argv )
int argc;
char **argv;
{
    int Code;
    int option;

    /* scan options */

    optionindex = 1;
    while ((option = get_options(argc, argv, optionstring)) != EOF)
        {
        switch (option)
            {
	    case 'V':
	      {
		static char version[] = "@(#) sqlgen 1.1 1992-11-29";
		printf( "%s\n", version + 5 ); 
		break;
	      }
	    case 'v':
	      /* verbose flag */
	      verbose_Flag = TRUE;
	      break;

# ifdef DATABASE_PRESENT

	      /* This part should be only included if a database system is
		 avialable at the current system */

	    case 'c':
	      /* check switch */
	      check_Flag = TRUE;
	      Database = optionargument;

              /* 
                 In the routine connect_Database() sqlgen tries to build
                 a connection with the given database. If it is not
                 possible to connect sqlgen with the given database this
                 is reported and the compilation terminates.
              */

              connect_Database();
	      break;
# endif
	    case 'o':
	      /* output directive */
	      Outfile_Name = optionargument;
	      break;
	      /* language switch */
	    case 'l':
	      Language = optionargument;
	      if ( strcmp( Language, COOL ) == 0 )
		{
		  current_Language = L_COOL;
		  break;
		}
              /* This argument is not supported in this release */
	      if ( strcmp( Language, CPP ) == 0 )
		{
		  current_Language = L_COOL;
		  sql_error( "C++ not yet implemented" );
		  break;
		}

	      sql_fatal( "illegal language specification" );
            }
        }
    if ( argv[optionindex] == NULL )
        sql_fatal( "missing input file" );

    if ( argv[optionindex + 1] != NULL )
        sql_fatal( "too many arguments" );

    /* open and read input file */

    get_Infile_Name( argv[optionindex] );

    strcpy( Modulename, Infile_Name );
    Modulename[strlen(Modulename)-4] = '\0';

    read_Input_File();

    /* open all necessary output files */

    open_Output_Files();

    if ( verbose_Flag )
      {
	fprintf( Protocolfile, "SOI for %s:\n\n", Infile_Name );
	fprintf( Protocolfile, "generated language interface: %s\n\n",
		                  current_Language == L_COOL ? "CooL" : "C++" );
      }

    /* analyse input and generate output
       sqlgen is a one pass system       */

    Code = yyparse();

    /* success */

    sql_exit( 0 );
}

/*---- GET_INFILE_NAME ----------------------------------------------------*/

static void get_Infile_Name( File_Name )
char *File_Name;
{
  int length;
  char *Pointer_to_File_Name;

  length = strlen( File_Name );
  Pointer_to_File_Name = File_Name + length;
  if ( strcmp( (Pointer_to_File_Name - 4), ".sql" ) != 0 )
    {
      Infile_Name = Get_String_Space( length + 5 );
      strcpy( Infile_Name, File_Name );
      strcpy( (Infile_Name + length), ".sql" );
      length += 5;
    }
  else
    {
      Infile_Name = Get_String_Space( length + 1 );
      strcpy( Infile_Name, File_Name );
      length++;
    }
  SpecificationfileName = Get_String_Space( length );
  ImplementationfileName = Get_String_Space( length );
  LanguagefileName = Get_String_Space( length );
  HeaderfileName = Get_String_Space( length );
  ESQLfileName = Get_String_Space( length );
  
}

/*---- OPEN_OUTPUT_FILES --------------------------------------------------*/

void open_Output_Files()
{
  if ( Outfile_Name == (char *)0 )
    {
      
      /* In this routine the Infile_Name is changed. This does not lead
	 to an error because the Infile_Name is never more used in
	 sqlgen */
      
      int file_name_length;
      
      file_name_length = strlen( Infile_Name );
      
      if ( verbose_Flag )
	{
	  strcpy( &Infile_Name[file_name_length - 3], "prt" );
	  Protocolfile = fopen( Infile_Name, "w" );
	}
      strcpy( &Infile_Name[file_name_length - 4], "E.ec" );
      strcpy( ESQLfileName, Infile_Name );
      ESQLfile = fopen( Infile_Name, "w" );
      switch ( current_Language )
	{
	case L_COOL:
	  strcpy( &Infile_Name[file_name_length - 4], ".cs" );
	  strcpy( SpecificationfileName, Infile_Name );
	  Specificationfile = fopen( Infile_Name, "w" );
	  strcpy( &Infile_Name[file_name_length - 4], ".ci" );
	  strcpy( ImplementationfileName, Infile_Name );
	  Implementationfile = fopen( Infile_Name, "w" );
	  break;
	case L_CPP:
	  strcpy( &Infile_Name[file_name_length - 4], ".cpp" );
	  strcpy( LanguagefileName, Infile_Name );
	  Languagefile = fopen( Infile_Name, "w" );
	  strcpy( &Infile_Name[file_name_length - 3], "h" );
	  strcpy( HeaderfileName, Infile_Name );
	  Headerfile = fopen( Infile_Name, "w" );
	  break;
	}
      strcpy( &Infile_Name[file_name_length - 4], ".sql" );
    }
  else
    {
      int length;
      char *filename;
      
      length = strlen( Outfile_Name );
      filename = Get_String_Space( length + 5 );
      strcpy( filename, Outfile_Name );
      if ( verbose_Flag )
	{
	  strcpy( filename + length, ".prt" );
	  Protocolfile = fopen( filename, "w" );
	}
      strcpy( filename + length, "E.ec" );
      strcpy( ESQLfileName, filename );
      ESQLfile = fopen( filename, "w" );
      switch ( current_Language )
	{
	case L_COOL:
	  strcpy( filename + length, ".cs" );
	  strcpy( SpecificationfileName, filename );
	  Specificationfile = fopen( SpecificationfileName, "w" );
	  strcpy( filename + length, ".ci" );
	  strcpy( ImplementationfileName, filename );
	  Implementationfile = fopen( ImplementationfileName, "w" );
	  break;
	case L_CPP:
	  strcpy( filename + length, ".cpp" );
	  strcpy( LanguagefileName, filename );
	  Languagefile = fopen( filename, "w" );
	  strcpy( filename + length, ".h" );
	  strcpy( HeaderfileName, filename );
	  Headerfile = fopen( filename, "w" );
	  break;
	}
    }
  
  if ( verbose_Flag )
    if ( Protocolfile == NULL )
      sql_fatal( "cannot open protocol file" );

  switch ( current_Language )
    {
    case L_COOL:
      if ( Implementationfile == NULL || Specificationfile == NULL || ESQLfile == NULL )
	sql_fatal( "cannot open output files" );
      break;
    case L_CPP:
      if ( Languagefile == NULL || Headerfile == NULL || ESQLfile == NULL )
	sql_fatal( "cannot open output files" );
      break;
    }
}

/*---- SQL_EXIT -----------------------------------------------------------*/

void sql_exit( Code )
int Code;
{
    close_Files();
    if ( Errors != 0 )
      remove_Files();
    exit( Code );
}

/*---- GET_OPTIONS ---------------------------------------------------------*/

static int get_options (argc, argv, Optionstring)
int argc;
char **argv;
char *Optionstring;
{
    char *Option;
    char *Pointer_to_Optionstring;
    static int in_get_options = 0;

    Pointer_to_Optionstring = Optionstring;
    if (optionindex >= argc || *argv[optionindex] != '-'
        && in_get_options == 0)

    /* no flag in argv[optionindex] */

    return (EOF);
    Option = argv[optionindex] + 1 + in_get_options;

    /* Option points to the actual flag */

    if ( *Option == '-' )
        {

        /* ending flag ( -- ) in argv */

        optionindex++;
        return (EOF);
        }
    if ( *Option == '\0' )

    /* empty flag ( - ) in argv */

    Option = " ";
    while ( *Pointer_to_Optionstring++ != *Option )
        if ( *Pointer_to_Optionstring == '\0' )
            {

            /* actual flag is not in Optionstring */

            char temp[50];

            sprintf( temp, "illegal option flag: %c", *Option );
            sql_fatal( temp ); 
            }
    if ( *Pointer_to_Optionstring == ':' )
        {

        /* an argument is expected */

        in_get_options = 0;
        optionindex++;
        if ( Option[1] != '\0' )
            optionargument = &Option[1];
        else
            if ((optionargument = argv[optionindex++]) == NULL)
                {
                /* missing argument */
                char temp[100];

                sprintf( temp, "missing argument after option flag: %c",
                                                                *Option);
                sql_fatal( temp );
                }
        }
    else
        if ( Option[1] != '\0' )
            /* more flags exist in argv */
            in_get_options++;
        else
            {
            /* it is possible that more flags follow which are
               start with - */
            in_get_options = 0;
            optionindex++;
            }
    return (*Option);
}
