/***************************************************************************/
/*                      SQL_SCAN.C - SQLGEN-scanner                        */
/*-------------------------------------------------------------------------*/
/*      Copyright (C) Siemens Nixdorf Informationssysteme AG 1992          */
/*      All rights reserved                                                */
/*	Last modified by Michael Watzek					   */
/***************************************************************************/

# include <sys/types.h>
# include <sys/stat.h>
# include <fcntl.h>
# include "sql_defs.h"

static char sccsid[] = "@(#) sql_scan.c 1.0 1992-11-29";

/*---- globale Definitionen -----------------------------------------------*/

int Errors = 0;

/* values of the current position in the input file */

int Column = 1;
int Line = 1;

/* all possible used files */

FILE *Specificationfile;
FILE *Implementationfile;
FILE *Languagefile;
FILE *Headerfile;
FILE *ESQLfile;
FILE *Protocolfile;

/* input file name */

char *Infile_Name;
char  Modulename[255];
char *SpecificationfileName = 0;
char *ImplementationfileName = 0;
char *LanguagefileName = 0;
char *HeaderfileName = 0;
char *ESQLfileName = 0;

/* flag for scanning SQL */

int SQL_TEXT_Flag = FALSE;
int SELECT_Flag = FALSE;
int more_SQL_possible = FALSE;
int Message_enabled = TRUE;

/* auxiliaries */

static int End_Of_File_first = TRUE;
char *Input_File_Buffer;
char *Pointer_to_Input_File_Buffer;

# define MAX_LENGTH_RESERVED_WORD 10
# define BUFFER_SIZE 200
char Character_Buffer[BUFFER_SIZE];

struct keydesc
{
    int kwlength;
    unsigned char *kw;
    int kwcode;
};

/*---- reserved words of sqlgen ------------------------------------------*/

static char kw001[] = "VIEW";
static char kw002[] = "AS";
static char kw003[] = "CURSOR";
static char kw004[] = "OPEN";
static char kw005[] = "WITH";
static char kw006[] = "FOR";
static char kw007[] = "SELECT";
static char kw008[] = "INSERT";
static char kw009[] = "UPDATE";
static char kw010[] = "INTO";
static char kw011[] = "SYSTEM";
static char kw012[] = "CONST";
static char kw013[] = "STATEMENT";
static char kw014[] = "IS";
static char kw015[] = "IN";
static char kw016[] = "OUT";
static char kw017[] = "INOUT";
static char kw018[] = "CHAR";
static char kw019[] = "VARCHAR";
static char kw020[] = "INTEGER";
static char kw021[] = "SERIAL";
static char kw022[] = "SMALLINT";
static char kw023[] = "SMALLFLOAT";
static char kw024[] = "FLOAT";
static char kw025[] = "DECIMAL";
static char kw026[] = "MONEY";
static char kw027[] = "DATE";
static char kw028[] = "DATETIME";
static char kw029[] = "INTERVAL";
static char kw030[] = "YEAR";
static char kw031[] = "MONTH";
static char kw032[] = "DAY";
static char kw033[] = "HOUR";
static char kw034[] = "MINUTE";
static char kw035[] = "SECOND";
static char kw036[] = "FRACTION";
static char kw037[] = "TO";

static struct keydesc yykeydv[] =
{
    {0,0,0},
    {4,kw001,VIEW},
    {2,kw002,AS},
    {6,kw003,CURSOR},
    {4,kw004,OPEN},
    {4,kw005,WITH},
    {3,kw006,FOR},
    {6,kw007,SELECT},
    {6,kw008,INSERT},
    {6,kw009,UPDATE},
    {4,kw010,INTO},
    {6,kw011,SYSTEM},
    {5,kw012,CONST},
    {9,kw013,STATEMENT},
    {2,kw014,IS},
    {2,kw015,IN},
    {3,kw016,OUT},
    {5,kw017,INOUT},
    {4,kw018,CHAR},
    {7,kw019,VARCHAR},
    {7,kw020,INTEGER},
    {6,kw021,SERIAL},
    {8,kw022,SMALLINT},
    {10,kw023,SMALLFLOAT},
    {5,kw024,FLOAT},
    {7,kw025,DECIMAL},
    {5,kw026,MONEY},
    {4,kw027,DATE},
    {8,kw028,DATETIME},
    {8,kw029,INTERVAL},
    {4,kw030,YEAR},
    {5,kw031,MONTH},
    {3,kw032,DAY},
    {4,kw033,HOUR},
    {6,kw034,MINUTE},
    {6,kw035,SECOND},
    {8,kw036,FRACTION},
    {2,kw037,TO}
};

/* 
   The following code provides an analysis for reserved words. The used
   method works with an access vector which is produced out of the reserved
   words. The reserved words are devided into classes. The classes are built
   from the identificator length. In the corresponding class methods it is
   computed an index into the reserved word table. The refered entry is 
   compared with the current identificator. If the entry and the current 
   identificator are identical then the current identificator is a reserved 
   word and its internal representation is returned to the caller.
*/

static short yyacc[] =
{
    0,2,0,0,32,25,6,18,27,-1,20,0,33,10,0,16,0,0,0,4,
    37,24,0,19,0,26,1,5,3,30,28,15,36,35,8,29,14,0,34,12,
    31,17,7,0,-14,22,9,0,21,11,0,0,0,0,0,0,0,0,0,0,
    0,0
};

static yyfkt0 ()
{
    return (0);
}

static yyfkt02()
{
    register int yybase;
    if((yybase = yyacc[(*Character_Buffer&0x5f)-64]) < 0)
        yybase = yyacc[(Character_Buffer[1]&0x5f)-48-yybase];
    return(yybase);
}

static yyfkt03()
{
    return(yyacc[(*Character_Buffer&0x5f)-64]);
}

static yyfkt04()
{
    return(yyacc[(*Character_Buffer&0x5f)-60]);
}

static yyfkt05()
{
    return(yyacc[(Character_Buffer[3]&0x5f)-44]);
}

static yyfkt06()
{
    register int yybase;
    if((yybase = yyacc[(*Character_Buffer&0x5f)-39]) < 0)
        yybase = yyacc[(Character_Buffer[2]&0x5f)-48-yybase];
    return(yybase);
}

static yyfkt07()
{
    return(yyacc[(*Character_Buffer&0x5f)-63]);
}

static yyfkt08()
{
    return(yyacc[(*Character_Buffer&0x5f)-38]);
}

static yyfkt09()
{
    return(13);
}

static yyfkt10()
{
    return(23);
}

static int (*yyfkt[])() = 
{
    0,
    yyfkt0,
    yyfkt02,
    yyfkt03,
    yyfkt04,
    yyfkt05,
    yyfkt06,
    yyfkt07,
    yyfkt08,
    yyfkt09,
    yyfkt10
};


yykey( buffer , length)
char *buffer;
int length;
{
    register unsigned char *yys, *yyt;
    int yyindex;
    struct keydesc *yykeyd;
    if (length > MAX_LENGTH_RESERVED_WORD)
        return (IDENTIFIER);
    if ((yyindex = (*yyfkt[length])()) <= 0 ||
       length != (yykeyd = yykeydv+yyindex)->kwlength)
        return (IDENTIFIER);
    yys = yykeyd->kw;
    yyt = buffer;
    while (*yys)
        if (*yys++ != (*yyt++ & 0x5f))
            return (IDENTIFIER);
    if (*yyt)
        return (IDENTIFIER);
    return (yykeyd->kwcode);
}

/*---- SQL_GETC -----------------------------------------------------------*/

int sql_getc()
{
    int Character;

    Character = *Pointer_to_Input_File_Buffer++;
    if ( Character == '\t' )
        Column = Column + (9 - Column % 8);
    else
        Column++;
# ifdef SCANECHO
    putchar( Character );
# endif
    return ( Character );
}

/*---- SQL_UNGETC ---------------------------------------------------------*/

void sql_ungetc( Character )
int Character;
{
    if ( Pointer_to_Input_File_Buffer > Input_File_Buffer )
      Pointer_to_Input_File_Buffer--;
    Column--;
    if ( Column == 0 )
        {
        Column = 1;
        Line--;
        if ( Line == 0 )
            Line = 1;
        }
}

/*---- READ_INPUT_FILE ----------------------------------------------------*/

void read_Input_File()
{
    struct stat Input_File_Stat;
    int Infile;
    int byte_count;

    /* 
       In this routine the whole input file is read. Therefore, sqlgen
       can always operate over the buffer which is created in this
       routine. All get and unget operations work over this buffer.
     */

    if ( (Infile = open( Infile_Name, O_RDONLY )) == -1 )
        sql_fatal( "input file not found" );
    fstat( Infile, &Input_File_Stat );
    Input_File_Buffer = Get_Input_Buffer( Input_File_Stat.st_size + 1);
    Pointer_to_Input_File_Buffer = Input_File_Buffer;

    /* 
       The result value of read( number of read bytes ) must be saved.
       In UNIX the file size and the read bytes are always equal, but in
       MS/DOS with BorlandC these two values are not equal. In the input
       buffer must be stored a null character at position 
                       Input_File_Buffer[byte_count] 
       to indicate the end of the input buffer.
    */

    byte_count = read( Infile, Input_File_Buffer, Input_File_Stat.st_size );
    if ( byte_count == -1 )
        sql_fatal( "cannot read input file" );
    *(Input_File_Buffer + byte_count) = '\0';
}

/*---- CLOSE_FILES --------------------------------------------------------*/

void close_Files()
{
    fprintf( Specificationfile, "\nEND SPECIFICATION;\n" );
    fprintf( Implementationfile, "\nEND IMPLEMENTATION;\n" );
    fclose( Specificationfile );
    fclose( Implementationfile );
/*
    fclose( Languagefile );
*/
    fclose( Headerfile );
    fclose( ESQLfile );
    fclose( Protocolfile );
}

/*---- REMOVE_FILES --------------------------------------------------------*/

void remove_Files()
{
    remove( LanguagefileName );
    if ( HeaderfileName != 0 )
      remove( HeaderfileName );
    remove( ESQLfileName );

}

/*---- SQL_FATAL ----------------------------------------------------------*/

     /* 
        The following three routines are used to report occured errors.
    The error message system distinguishes three levels of error
    messages: warnings, errors, fatal errors. A warning reports a
    minor error and the compilation process continues. An error
    reports an illegal use of a syntax or semantic construct. A fatal
    error reports an illegal use or an unrecoverable error of sqlgen.
     */

void sql_fatal( message )
char *message;
{
    fprintf( stderr, "sqlgen-fatal: line: %d, column: %d: %s\n", 
            Line, Column, message);
    if ( verbose_Flag )
      fprintf( Protocolfile, "sqlgen-fatal: line: %d, column: %d: %s\n", 
                                              Line, Column, message);
    Errors++;
    sql_exit(1);
}

/*---- SQL_ERROR ----------------------------------------------------------*/

void sql_error( message )
char *message;
{
    fprintf( stderr, "sqlgen-error: line: %d, column: %d: %s\n",
            Line, Column, message );
    if ( verbose_Flag )
      fprintf( Protocolfile, "sqlgen-error: line: %d, column: %d: %s\n",
            Line, Column, message );
  
    Errors++;
}

/*---- SQL_WARNING --------------------------------------------------------*/

void sql_warning( message )
char *message;
{
    if ( Message_enabled )
      {
        fprintf( stderr, "sqlgen-warning: line: %d, column: %d: %s\n", 
            Line, Column, message );	
	if ( verbose_Flag )
	  fprintf( Protocolfile, "sqlgen-warning: line: %d, column: %d: %s\n", 
                    Line, Column, message );
      }
}

/*---- SQL_INFORMATION -----------------------------------------------------*/

void sql_information( message )
char *message;
{
    fprintf( stderr, "sqlgen-info: %s\n", message );
    if ( verbose_Flag )
      fprintf( Protocolfile, "sqlgen-info: %s\n", message );
}

/*---- SCAN_COMMENT -------------------------------------------------------*/

      /* 
     This routine provides a multiline scan of comments. The comment 
     syntax corresponds to the CooL comment syntax. 
      */

void scan_comment()
{
    int actual_Character;

comment:
    actual_Character = sql_getc();
comment1:
    switch ( actual_Character )
    {
    case '\n':
        Line++;
        Column = 1;
        goto comment;
    case '\0':
        sql_error( "unexpected end of file in comment" );
    case '*':
        actual_Character = sql_getc();
        if ( actual_Character == ')' )
        break;
        else
        goto comment1;
        default:
            goto comment;        
        }
}

void scan_SQL_comment()
{
    int actual_Character;

comment:
    actual_Character = sql_getc();
comment1:
    switch ( actual_Character )
    {
    case '\n':
        Line++;
        Column = 1;
        goto comment;
    case '\0':
        sql_error( "unexpected end of file in comment" );
    case '*':
	*(Pointer_to_Input_File_Buffer-1) = ' ';
        actual_Character = sql_getc();
	*(Pointer_to_Input_File_Buffer-1) = ' ';
        if ( actual_Character == ')' )
        break;
        else
        goto comment1;
      default:
	*(Pointer_to_Input_File_Buffer-1) = ' ';
	goto comment;        
        }
}

/*---- SCAN_REVERS --------------------------------------------------------*/

       /*
      This function is used to scan the input buffer from right to left.
      While scanning in this direction it is checked whether a given
      string (Text) is found or not. The function returns a boolean value
      which indicates if the given string was found in the input buffer.
       */

int scan_revers( Pointer, Text )
char *Pointer;
char *Text;
{
    int test_length;

    test_length = strlen( Text );
    Text += test_length;
    while( test_length-- )
        {
	if ( ((*Pointer--)&0x5f) == *--Text )
            continue;
        return FALSE;
        }
    return TRUE;
}

/*---- SCAN_SQL_TEXT ------------------------------------------------------*/

       /*
      This routine is used to scan SQL statements. The start and the
      length are stored in the actual attribute value (yylval).
       */

void scan_SQL_Text()
{
    char *Pointer_to_SQL_Text;
    int actual_Character;

    Pointer_to_SQL_Text = Pointer_to_Input_File_Buffer;
    yylval.sql.Begin = Pointer_to_SQL_Text;

sql_text:
    actual_Character = sql_getc();
    switch ( actual_Character )
        {
        case '\n':
            Line++;
            Column = 1;
            goto sql_text;
        case '\0':
            sql_error( "unexpected end of file in SQL-statement" );
            sql_ungetc( actual_Character );
            break;
	case '-':
	    actual_Character = sql_getc();
	    if ( actual_Character == '-' )
	      {
		*(Pointer_to_Input_File_Buffer-2) = ' ';
		while ( actual_Character != '\n' )
		  {
		    *(Pointer_to_Input_File_Buffer-1) = ' ';
		    actual_Character = sql_getc();
		  }
		sql_ungetc( actual_Character );
	      }
	    else
	      {
		sql_ungetc( actual_Character );
	      }
	    goto sql_text;;

	  case '(':
	    actual_Character = sql_getc();
	    if ( actual_Character == '*' )
	      {
		*(Pointer_to_Input_File_Buffer-2) = ' ';
		*(Pointer_to_Input_File_Buffer-1) = ' ';
		scan_SQL_comment();
	      }
	    else
	      {
		sql_ungetc( actual_Character );
	      }
	    goto sql_text;

    /* 
       The following two case entries must be distiguished because the
       string terminator is not equal.
    */

        case '\"':
        sql_text_string:
            actual_Character = sql_getc();
            switch ( actual_Character )
                {
                case '\"':
                    break;
                case '\0':
                    sql_error( "unexpected end of file in SQL-statement" );
                case '\n':
                    Line++;
                    Column = 1;
                    sql_error( "newline not allowed in string constant" );
                default:
                    goto sql_text_string;
                }
            goto sql_text;
        case '\'':
        sql_text_char:
            actual_Character = sql_getc();
            switch ( actual_Character )
                {
                case '\'':
                    break;
                case '\0':
                    sql_error( "unexpected end of file in SQL-statement" );
                case '\n':
                    Line++;
                    Column = 1;
                    sql_error( "newline not allowed in string constant" );
                default:
                    goto sql_text_char;
                }
            goto sql_text;

        /* This case entry indicates the end of the SQL statement */

        case ';':
            /* The character ';' will be used later to end a SQL statement
               in sqlgen */
            sql_ungetc( actual_Character );
            yylval.sql.Length = 
                          Pointer_to_Input_File_Buffer - Pointer_to_SQL_Text;
            break;
        default:
            goto sql_text;
        }

    /* This part is used to separat a possible specification of 
       'FOR UPATE' from the scanned select statement inside a cursor */

    if ( SELECT_Flag )
        {
        char *Pointer_to_last;
        int local_Line;
        int local_Column;

        Pointer_to_last = yylval.sql.Begin + yylval.sql.Length - 1;
        while (    SQL_WHITESPACE(*Pointer_to_last) )
            Pointer_to_last--;
        if ( scan_revers( Pointer_to_last, "UPDATE" ) )
            {
            Pointer_to_last -= 6;
            while ( SQL_WHITESPACE(*Pointer_to_last) )
                Pointer_to_last--;
            if ( scan_revers( Pointer_to_last, "FOR" ) )
                {
                int local_length;

                Pointer_to_last -= 2;
                local_length = Pointer_to_Input_File_Buffer - Pointer_to_last;
                yylval.sql.Length -= local_length;
                while( local_length-- )
                    sql_ungetc( *Pointer_to_Input_File_Buffer );
                }
            }
        }
}

/*---- YYLEX --------------------------------------------------------------*/

       /*
          The function yylex is the scanner. This scanner routine is
          programmed by hand. This should increase the scanner speed.
          The case entries represent the columns of the virtual state 
          table of the scanner.
       */

int yylex()
{
    int actual_Character;
    char *Pointer_to_Character_Buffer;
    int Error_Flag;
    int Buffer_Length;
    int Id_Code;

    if ( more_SQL_possible )
        {
        char *Temp_Input_Pointer;
        int Temp_Line;
        int Temp_Column;
        int Next_Code;
	int Temp_End_Of_File_first;

	more_SQL_possible = FALSE;
	Temp_Input_Pointer = Pointer_to_Input_File_Buffer;
	Temp_Line = Line;
	Temp_Column = Column;
	Temp_End_Of_File_first = End_Of_File_first;
	Message_enabled = FALSE;
	Next_Code = yylex();
	Pointer_to_Input_File_Buffer = Temp_Input_Pointer;
	Line = Temp_Line;
	Column = Temp_Column;
	End_Of_File_first = Temp_End_Of_File_first;
	Message_enabled = TRUE;
	switch ( Next_Code )
	    {
            case VIEW:
            case CONST:
            case STATEMENT:
            case 0:
            case SQL_END:
                break;
            default:
		SQL_TEXT_Flag = TRUE;
            }
        }

    if ( SQL_TEXT_Flag )
        {

        /* If the SQL_TEXT_FLAG is TRUE then the scanner has to analyse
           the next input as SQL statement. If the SELECT_Flag is set it
           is reset to FALSE. */

        scan_SQL_Text();
        SQL_TEXT_Flag = FALSE;
        if ( SELECT_Flag )
            {
            SELECT_Flag = FALSE;
            return sql_select;
            }
        else
            return sql_statement;
	}

    /*
       The scanner is programmed as endless loop. Only if a legal token
       could be accepted the scanner routine is left. In the case of an
       occured error the scanner continues its work in state zero. In the 
       scanner occured errors have always warning level. Therefore, errors
       at scan time does never lead to a termination of the compilation
       process of sglgen.
    */

    for (;;)
        {
        switch ( (actual_Character = sql_getc()) )
            {
            case '\0':
                /* This case entry indicates the end of file tag */
                if ( End_Of_File_first )
                    {
                     sql_ungetc( actual_Character );
		     End_Of_File_first = FALSE;
                     return SQL_END;
                    }
                return 0;
            case ' ':
            case '\t':
                continue;
            case '\n':
                Line++;
                Column = 1;
                continue;
            case ',':
                return CM;
            case '=':
                return ASSIGN;
            case '+':
                return PLUS;
            case '-':
                actual_Character = sql_getc();
                if ( actual_Character == '-' )
                    {
                    while ( actual_Character != '\n' )
                        actual_Character = sql_getc();
                    sql_ungetc( actual_Character );
                    continue;
                    }
                else
                    {
                    sql_ungetc( actual_Character );
                    return MINUS;
                    }
            case '*':
                return MUL;
            case '/':
                return DIV;
            case '(':
                actual_Character = sql_getc();
                if ( actual_Character == '*' )
                    {
                    scan_comment();
                    }
                else
                    {
                    sql_ungetc( actual_Character );
                    return LP;
                    }
                continue;
            case ')':
                return RP;
            case ';':
                return SM;
            default:
                if ( FIRST_CHARACTER_OF_IDENTIFIER( actual_Character ) )
                    {

                    /* 
                       Here an identifier is received from the input.
                       The generator sqlgen does not support unlimited 
                       identifier length, therefore every scanned 
                       identifier is truncated at its BUFFER_SIZE - 1
                       character. If an identifier has had to be truncated
                       a corresponding warning message is reported by
                       sqlgen.
                    */
            
                    Pointer_to_Character_Buffer = Character_Buffer;
                    Error_Flag = FALSE;
                    Buffer_Length = 0;
                    while ( CHARACTER_OF_IDENTIFIER( actual_Character ) )
                        {
                        if ( Buffer_Length <  BUFFER_SIZE - 1 )
                            {
                            *Pointer_to_Character_Buffer++ = actual_Character;
                            Buffer_Length++;
                            }
                        else
                            Error_Flag = TRUE;
                        actual_Character = sql_getc();
                        }
                    sql_ungetc( actual_Character );
                    *Pointer_to_Character_Buffer = '\0';
                    if ( Error_Flag )
                        sql_warning( "identifier truncated" );
                    Id_Code = yykey( Character_Buffer, Buffer_Length);
                    if ( Id_Code == IDENTIFIER )
                        {
                        yylval.ident.Hash = 
                                        hash( Character_Buffer, Buffer_Length);
                        yylval.ident.Line = Line;
                        return IDENTIFIER;
                        }
                    else
                        {
                        if ( Id_Code == SELECT && yyerrflag == 0 )
                            {
                            /* SELECT has to be included into the sql-
                               statement of the cursor because this is
                               necessary to check it later */
                            while ( CHARACTER_OF_IDENTIFIER( 
                                        *(Pointer_to_Input_File_Buffer-1) ) )
                                sql_ungetc( *Pointer_to_Input_File_Buffer );
                            }
                        return Id_Code;
                        }
                    }
                else
                    {

                    /*
                       Here an integer literal is received from input.
                       The maximal length of an integer literal is
                       BUFFER_SIZE - 1.  Furthermore, it is checked 
                       whether the resulting digits for the numeric
                       value of the integer literal produced by sscanf
                       are equal to the scanned digits or not. If the
                       resulting digits are not equal then a warning
                       message is reported.
                    */

                    if ( isdigit( actual_Character ) )
                        {
                        char Number_Buffer[BUFFER_SIZE];
    
                        Pointer_to_Character_Buffer = Character_Buffer;
                        Error_Flag = FALSE;
                        Buffer_Length = 0;
                        while ( isdigit( actual_Character ) )
                            {
                            if ( Buffer_Length <  BUFFER_SIZE - 1 )
                                {
                                *Pointer_to_Character_Buffer++ = 
                                                            actual_Character;
                                Buffer_Length++;
                                }
                            else
                                Error_Flag = TRUE;
                            actual_Character = sql_getc();
                            }
                        sql_ungetc( actual_Character );
                        *Pointer_to_Character_Buffer = '\0';
                        if ( Error_Flag )
                            sql_warning( "integer literal truncated" );
                        yylval.number = atoi( Character_Buffer );
                        sprintf( Number_Buffer, "%d", yylval.number );
			Pointer_to_Character_Buffer = Character_Buffer;
			while ( *Pointer_to_Character_Buffer == '0' )
			    Pointer_to_Character_Buffer++;
                        if ( strcmp(Pointer_to_Character_Buffer,
						       Number_Buffer) != 0 )
                            sql_warning( "integer literal out of range" );
                        return NUMBER;
                        }
                    else
                        sql_warning( "illegal character ignored" );
                    }
            }
        }
}

