-------------------------------------------------------------------------
--
--      CoLibri V2.0 - SQL-Interface (Informix 4.0)
--
-------------------------------------------------------------------------
--
--      Copyright (C) Siemens Nixdorf Informationssysteme AG 1992
--      All rights reserved
--
-------------------------------------------------------------------------
--
-- Author        : A. Graffigna
-- Creation      : 01.10.1992
--
-------------------------------------------------------------------------
--
-- Last Modified By: Torsten Dumm
-- Last Modified On: Wed Feb 16 15:22:38 1994
-- Update Count    : 9
--
-------------------------------------------------------------------------
--
-- Module        : SqlChar.cs
-- Purpose       : Module for supporting the SQL data type SQLCHAR.
-- Updates       : 
--                 Torsten Dumm 08.02.94
--                 module modified for the CooL Version 2.0
--
-- Exports       : CONST     MAX_SQL_CHAR_LENGTH ;
--                 CONST     MAX_SQL_VAR_CHAR_LENGTH ;
--
--                 TYPE      SQLCHAR ;
--
--                 FUNCTION  getSqlCharLength   (..) ;
--                 FUNCTION  isSqlCharEqualNull (..) ;
--                 PROCEDURE setSqlCharToNull   (..) ;
--                 FUNCTION  SqlChar            (..) ;
--                 FUNCTION  SqlCharToString    (..) ;
--                 FUNCTION  SqlVarChar         (..) ;
--                 PROCEDURE StringToSqlChar    (..) ;
--
-------------------------------------------------------------------------

SPECIFICATION SqlChar

CONST MAX_SQL_CHAR_LENGTH     : INT = 32511 ;
CONST MAX_SQL_VAR_CHAR_LENGTH : INT = 255 ;

-------------------------------------------------------------------------
-- The data type SQLCHAR.
-------------------------------------------------------------------------

TYPE SQLCHAR = RECORD
                  value     : REF ARRAY OF CHAR ;
                  indicator : INT ;
                  length    : INT ;
	       END RECORD;

PROCEDURE getSqlCharLength (IN sql_char : SQLCHAR 
			    ) : INT;
  ----------------------------------------------------------------------
  -- This function delivers the length of the input variable sql_char
  -- as it was defined using the function SqlChar.
  -- Exceptions : ValueIsNull.
  ----------------------------------------------------------------------

PROCEDURE isSqlCharEqualNull (IN sql_char : SQLCHAR 
			      ) : BOOL;
  ----------------------------------------------------------------------
  -- This function checks if the input variable sql_char contains
  -- the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE setSqlCharToNull (INOUT sql_char : SQLCHAR);
  ----------------------------------------------------------------------
  -- This procedure sets the variable sql_char to the null value.
  -- Additionally the memory space of this variable will be released.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE SqlChar (IN string : STRING,
		   IN length : INT
		   ) : SQLCHAR;
  ----------------------------------------------------------------------
  -- This function initializes a variable of type SQLCHAR by providing
  -- enough memory space for a string of length characters.
  -- Additionally this variable will be filled with a literal or a
  -- C-String if the first input parameter string has an actual
  -- length greater than zero.
  -- Exceptions : LengthOfStringIsZero
  --              MaxSqlCharLengthExceeded
  --              StringIsTooLarge .
  ----------------------------------------------------------------------

PROCEDURE SqlCharToString (IN sql_char : SQLCHAR
			   ) : STRING;
  ----------------------------------------------------------------------
  -- This procedure converts SQLCHAR to a C-String. Final blanks will not
  -- be transferred.
  -- The variable string has to contain a pointer to enough memory space.
  -- Exceptions : ValueIsNull.
  ----------------------------------------------------------------------

PROCEDURE SqlVarChar (IN string     : STRING,
		      IN max_length : INT,
		      IN min_length : INT 
		      ) : SQLCHAR;
   ----------------------------------------------------------------------
   -- This function is used for the handling of the INFORMIX type VARCHAR.
   -- It initializes a variable of type SQLCHAR by providing enough
   -- memory space for a string of length characters.
   -- Additionally this variable will be filled with a literal or a
   -- C-String if the first input parameter string has an actual
   -- length greater than zero.
   -- The input parameter min_length is tested but not used actually.
   -- Exceptions : LengthOfStringIsZero
   --              MaxSqlVarCharLengthExceeded
   --              MaxLengthIsSmallerThanMinLength
   --              MinLengthIsLessThanZero
   --              StringIsTooLarge .
   ----------------------------------------------------------------------

PROCEDURE StringToSqlChar (IN    string   : STRING,
			   INOUT sql_char : SQLCHAR ) ;
  ----------------------------------------------------------------------
  -- This procedure converts a literal or a C-String to a SQLCHAR.
  -- Exceptions : LengthOfStringIsZero
  --              StringIsTooLarge .
  ----------------------------------------------------------------------

END SPECIFICATION;
