-------------------------------------------------------------------------
--
--      CoLibri V2.0 - SQL-Doubleerface (Informix 4.0)
--
-------------------------------------------------------------------------
--
--      Copyright (C) Siemens Nixdorf Informationssysteme AG 1992
--      All rights reserved
--
-------------------------------------------------------------------------
--
-- Author        : A. Graffigna
-- Creation      : 01.10.1992
--
-------------------------------------------------------------------------
--
-- Last Modified By: Torsten Dumm
-- Last Modified On: Thu Feb 17 11:38:32 1994
-- Update Count    : 4
--
-------------------------------------------------------------------------
--
-- Module        : SqlFloat.cs
-- Purpose       : Module for supporting the SQL data types
--                 SQLSMALLFLOAT and SQLFLOAT.
-- Updates       : 
--                 Torsten Dumm 08.02.94
--                 module modified for the CooL Version 2.0
--
-- Exports       : TYPE     SQLSMALLFLOAT ;
--
--                 FUNCTION DoubleToSqlSmallfloat    (..) ;
--                 FUNCTION isSqlSmallfloatEqualNull (..) ;
--                 FUNCTION setSqlSmallfloatToNull   (..) ;
--                 FUNCTION SqlSmallfloatToDouble    (..) ;
--
--                 TYPE     SQLFLOAT  ;
--
--                 FUNCTION DoubleToSqlFloat         (..) ;
--                 FUNCTION isSqlFloatEqualNull      (..) ;
--                 FUNCTION setSqlFloatToNull        (..) ;
--                 FUNCTION SqlFloatToDouble         (..) ;
-------------------------------------------------------------------------

SPECIFICATION SqlFloat 

-------------------------------------------------------------------------
-- The data type SQLSMALLFLOAT.
-------------------------------------------------------------------------

TYPE SQLSMALLFLOAT = RECORD
                        value     : FLOAT ;
		        indicator : INT ;
	             END RECORD;

PROCEDURE DoubleToSqlSmallfloat (IN double : DOUBLE 
				 ) : SQLSMALLFLOAT;
  ----------------------------------------------------------------------
  -- This function converts a DOUBLE to a SQLSMALLFLOAT.
  -- Exceptions : ValueIsOutOfRange.
  ----------------------------------------------------------------------
  
PROCEDURE isSqlSmallfloatEqualNull (IN sql_smallfloat : SQLSMALLFLOAT 
				    ) : BOOL;
  ----------------------------------------------------------------------
  -- This function checks if the input variable sql_smallfloat contains
  -- the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------
  
PROCEDURE setSqlSmallfloatToNull : SQLSMALLFLOAT;
  ----------------------------------------------------------------------
  -- This function sets a variable of type SQLSMALLFLOAT to the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE SqlSmallfloatToDouble (IN sql_smallfloat : SQLSMALLFLOAT 
				 ) : DOUBLE;
  ----------------------------------------------------------------------
  -- This function converts SQLSMALLFLOAT to a DOUBLE.
  -- Exceptions : ValueIsNull.
  ----------------------------------------------------------------------

-------------------------------------------------------------------------
-- The data type SQLFLOAT.
-------------------------------------------------------------------------

TYPE SQLFLOAT  = RECORD
                    value     : DOUBLE ;
		    indicator : INT ;
	         END RECORD  ;

PROCEDURE DoubleToSqlFloat (IN double : DOUBLE 
			    ) : SQLFLOAT;
  ----------------------------------------------------------------------
  -- This function converts a DOUBLE to a SQLFLOAT.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE isSqlFloatEqualNull (IN sql_float : SQLFLOAT 
			       ) : BOOL;
  ----------------------------------------------------------------------
  -- This function checks if the input variable sql_float contains
  -- the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------
  
PROCEDURE setSqlFloatToNull : SQLFLOAT;
  ----------------------------------------------------------------------
  -- This function sets a variable of type SQLFLOAT to the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE SqlFloatToDouble (IN sql_float : SQLFLOAT 
			    ) : DOUBLE;
  ----------------------------------------------------------------------
  -- This function converts SQLFLOAT to a DOUBLE.
  -- Exceptions : ValueIsNull.
  ----------------------------------------------------------------------

END SPECIFICATION;
