-------------------------------------------------------------------------
--
--      CoLibri V2.0 - SQL-Interface (Informix 4.0)
--
-------------------------------------------------------------------------
--
--      Copyright (C) Siemens Nixdorf Informationssysteme AG 1992
--      All rights reserved
--
-------------------------------------------------------------------------
--
-- Author        : A. Graffigna
-- Creation      : 01.10.1992
--
-------------------------------------------------------------------------
--
-- Last Modified By: A. Graffigna
-- Last Modified On: Tue Sep 06 15:30:22 1994
-- Update Count    : 6
--
-------------------------------------------------------------------------
--
-- Module        : SqlInterval.cs
-- Purpose       : Module for supporting the SQL data type SQLINTERVAL.
-- Updates       : 
--                 Torsten Dumm 08.02.94
--                 module modified for the CooL Version 2.0
--                 A. Graffigna 06.09.94
--                 Module adapted to NDuration (Natural Duration).
--
-- Exports       : TYPE      SQLINTERVAL ;
--
--                 PROCEDURE DurationToSqlInterval  (..) ;
--                 FUNCTION  isSqlIntervalEqualNull (..) ;
--                 PROCEDURE setSqlIntervalToNull   (..) ;
--                 FUNCTION  SqlInterval            (..) ;
--                 PROCEDURE SqlIntervalToDuration  (..) ;
--                 PROCEDURE SqlIntervalToString    (..) ;
--                 PROCEDURE StringToSqlInterval    (..) ;
--                 
-------------------------------------------------------------------------

SPECIFICATION SqlInterval

IMPORT dec_t     FROM SqlDecimal;
IMPORT NDuration FROM NDuration;
  
-------------------------------------------------------------------------
-- The data type SQLINTERVAL.
-------------------------------------------------------------------------

TYPE intrvl_t = RECORD
	           in_qual : SHORT INT ;
	           in_dec  : dec_t ;
                END RECORD;

TYPE SQLINTERVAL = RECORD
                      value     : intrvl_t ;
	              indicator : INT ;
		      length    : INT ;
		      from      : INT ;
		      to        : INT ;
	           END RECORD;

PROCEDURE DurationToSqlInterval (IN    duration     : NDuration,
				 INOUT sql_interval : SQLINTERVAL);
  ----------------------------------------------------------------------
  -- This procedure converts the Duration to a SQLINTERVAL.
  -- Exceptions : IllegalCombination .
  ----------------------------------------------------------------------

PROCEDURE isSqlIntervalEqualNull (IN sql_interval : SQLINTERVAL 
				  ) : BOOL;
  ----------------------------------------------------------------------
  -- This function checks if the input variable sql_interval contains
  -- the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE setSqlIntervalToNull (INOUT sql_interval : SQLINTERVAL);
  ----------------------------------------------------------------------
  -- This procedure sets a variable of type SQLINTERVAL to the null value.
  -- Exceptions : None.
  ----------------------------------------------------------------------

PROCEDURE SqlInterval (IN length : INT,
		       IN from   : INT,
		       IN to     : INT,
		       IN string : STRING 
		       ) : SQLINTERVAL;
  ----------------------------------------------------------------------
  -- This function initializes a variable of type SQLINTERVAL with a
  -- C-String which has to contain a valid representation of an interval
  -- value.
  -- If the C-String has an actual length of zero the function result
  -- will be a SQLINTERVAL initialized with zero.
  -- The parameters "from" and "to" determine the components which have
  -- to be part of the variable.
  -- Two combinations are possible, either years and months or days, hours,
  -- minutes, seconds and fractions.
  -- "from" has to be larger than "to".
  -- "length" defines how many places (one upto nine) the first component
  -- will have.
  -- A "length" of zero means the use of standard values.
  -- Exceptions : LengthIsLessThanZero
  --              LengthIsLargerThanNine
  --              LengthForFractionsNotAllowed
  --              IllegalComponentCombination
  --              IllegalComponent
  --              WrongOrderOfComponents
  --              NoConversionPossible
  --              TooMuchValuesAtBeginning
  --              TooMuchValuesAtEnd
  --              StringContainsCharacters
  --              RangeOverflow
  --              ValueOverflow
  --              ResultOverflow
  --              IncompatibleConversion
  --              InvalidComponent .
  ----------------------------------------------------------------------

PROCEDURE SqlIntervalToDuration (IN    sql_interval : SQLINTERVAL,
				 INOUT duration     : NDuration);
  ----------------------------------------------------------------------
  -- This procedure converts the SQLINTERVAL to a Duration.
  -- Exceptions : ValueIsNull
  --              IllegalCombination .
  ----------------------------------------------------------------------

PROCEDURE SqlIntervalToString (IN sql_interval : SQLINTERVAL
			       ) : STRING;
  ----------------------------------------------------------------------
  -- This procedure converts the SQLINTERVAL to a C-String.
  -- The variable string has to contain enough memory space for at least
  -- 26 characters.
  -- The produced C-String will be terminated by a null-character.
  -- Exceptions : ValueIsNull .
  ----------------------------------------------------------------------

PROCEDURE StringToSqlInterval (IN    string       : STRING,
			       INOUT sql_interval : SQLINTERVAL);
  ----------------------------------------------------------------------
  -- This procedure converts the C-String to a SQLINTERVAL.
  -- The C-String has to contain a valid representation of a date and
  -- time value.
  -- The C-String has to be finished with the null-character.
  -- Exceptions : LengthOfStringIsZero
  --              NoConversionPossible
  --              TooMuchValuesAtBeginning
  --              TooMuchValuesAtEnd
  --              StringContainsCharacters
  --              RangeOverflow
  --              ValueOverflow
  --              ResultOverflow
  --              IncompatibleConversion
  --              InvalidComponent .
  ----------------------------------------------------------------------

END SPECIFICATION;
