#include "topic.h"

#define sign(x) ((x>=0)?((x==0)?0:1):-1)

static void default_error(s)
	char *s;
	{
	fprintf(stderr,"Topic error: %s\n",s);
	exit(-1);
	}

static void (*error)()=default_error;

void topic_error(fn)
	void  (*fn)();
	{
	error=fn;
	}

void topic_default()
	{
	error=default_error;
	}

int topic_cmp(left,right)
        topic left,right;
        {
        int result;

        result=strcmp(left->name,right->name);
	return(sign(result));
        }

topic new_topic(name,pag)
        char *name;
	char *pag;
	{
	topic p;

	p=(topic)malloc(sizeof(struct TOPIC));
	if(p==NULL) error("Allocation error");
	p->name=(char*)malloc(strlen(name)+1);
	if(p->name==NULL) error("Allocation error");
	p->pag=(char*)malloc(strlen(pag)+1);
	if(p->pag==NULL) error("Allocation error");
	collapse(strupr(strcpy(p->name,name)));
	collapse(strupr(strcpy(p->pag,pag)));
	return(p);
        }

void topic_free(p)
        topic p;
        {
	free(p->name);
	free(p->pag);
        free(p);
        }

char* topic_page(p)
        topic p;
        {
	if(p!=NULL) return(p->pag);
	else return(NULL);
	}

char *topic_name(p)
	topic p;
	{
	if(p!=NULL) return(p->name);
	else return(NULL);
	}

void topic_put(p,f)
	topic p;
	FILE *f;
	{
	fprintf(f,NUMFORMAT,(long)strlen(p->name));
	fprintf(f,"%s",p->name);
	fprintf(f,NUMFORMAT,(long)strlen(p->pag));
	fprintf(f,"%s\n",p->pag);
	}

topic topic_get(f)
	FILE *f;
	{
	char *name,*page;
	topic t;
	long nlen,plen;

	fscanf(f,NUMFORMAT,&nlen);
	name=(char*)malloc(nlen+1);
	if(name==NULL) error("Allocation error");
	fgets(name,nlen+1,f);
	fscanf(f,NUMFORMAT,&plen);
	page=(char*)malloc(plen+1);
	if(page==NULL) error("Allocation error");
	fgets(page,plen+1,f);
	t=new_topic(name,page);
	free(page);
	free(name);
	return(t);
	}
