#include "visual.h"

fontdef title_font,sub_font,hdef_font,hgo_font;
fontdef hlink_font,text_font,source_font;

static short app_bits[]={
#include "help.icon"
	};

static short index_bits[]={
#include "index.icon"
	};

static short next_bits[]={
#include "next.icon"
	};

static short previous_bits[]={
#include "previous.icon"
	};

static short back_bits[]={
#include "back.icon"
	};

static short search_bits[]={
#include "search.icon"
	};
 
Panel_item tslist;
int tslist_items;

Scrollbar x_scroll,y_scroll;

void interface()
	{
	Panel_item file_btn,help_btn,about_btn;
	Panel_item index_btn,next_btn,previous_btn,back_btn,search_btn,quit_btn;
	Menu help_menu;
	Server_image index_img,next_img,previous_img;
	Server_image back_img,search_img,app_img,hot_img,hot_mask_img;
	Icon app_icon;
	Panel tspanel;
	Panel loadpanel;
		
	frame=(Frame)xv_create(NULL,FRAME,
		FRAME_LABEL,"XVHelp 1.0",
		XV_WIDTH,FRAMEWIDTH,
		XV_HEIGHT,FRAMEHEIGHT,
		FRAME_NO_CONFIRM,TRUE,
		NULL);

	/* Definition of the topics search frame. */

	tsframe=(Frame)xv_create(frame,FRAME_CMD,
					XV_WIDTH,400,
					XV_HEIGHT,210,
					FRAME_LABEL,"Topic Search",
					NULL);
	tspanel=(Panel)xv_get(tsframe,FRAME_CMD_PANEL);
	tslist_items=0;
	tslist=(Panel_item)xv_create(tspanel,PANEL_LIST,
					PANEL_LIST_DISPLAY_ROWS,10,
					PANEL_LIST_WIDTH,370,
					PANEL_NOTIFY_PROC,tsnotify,
					PANEL_CHOOSE_ONE,TRUE,
					NULL);

	/* Definition of the load file frame*/

	loadframe=(Frame)xv_create(frame,FRAME_CMD,
					XV_WIDTH,400,
					XV_HEIGHT,50,
					FRAME_LABEL,"Open helpfile",
					PANEL_VALUE_DISPLAY_LENGTH,128,
					NULL);
	loadpanel=(Panel)xv_get(loadframe,FRAME_CMD_PANEL);
	xv_create(loadpanel,PANEL_TEXT,
		PANEL_LABEL_STRING,"Helpfile name: ",
		PANEL_NOTIFY_PROC,loadnotify,
		PANEL_NOTIFY_LEVEL,PANEL_SPECIFIED,
		PANEL_NOTIFY_STRING,"\n\r",
		NULL);

	/* We set the icon for the application: this frame property */
	/* it is the only that cannot be specified during the creation. */

	app_img=get_image(ICON_DIM,app_bits);
	app_icon=(Icon)xv_create(NULL,ICON,
		ICON_IMAGE,app_img,
		NULL);
	xv_set(frame,FRAME_ICON,app_icon,
		NULL);

	/* Panel creation. */

	panel=(Panel)xv_create(frame,PANEL,
		XV_HEIGHT,100,
		NULL);

	/* Images creation. */

	index_img=get_image(IMGBTN_DIM,index_bits);
	next_img=get_image(IMGBTN_DIM,next_bits);
	previous_img=get_image(IMGBTN_DIM,previous_bits);
	back_img=get_image(IMGBTN_DIM,back_bits);
	search_img=get_image(IMGBTN_DIM,search_bits);
 
	/* Display definition. */

	dpy=(Display*)xv_get(frame,XV_DISPLAY);

 	/* Cursors creation. */
 
	defcursor=XCreateFontCursor(dpy,XC_question_arrow);
	gotocursor=XCreateFontCursor(dpy,XC_hand2);
	linkcursor=XCreateFontCursor(dpy,XC_exchange);
	normcursor=XCreateFontCursor(dpy,XC_left_ptr);	

	/* Menu creation. */

	help_menu=(Menu)xv_create(NULL,MENU,
		MENU_NOTIFY_PROC,proc_help,
		MENU_STRINGS,"Help on help","Index","Previous","Next",
		"Back","Search",NULL,NULL);

	/* Buttons creation. */

	new_panel_row(0);
	file_btn=get_btn(panel,"Load file",do_file_open);
	help_btn=get_menu_btn(panel,"Help",help_menu);
 	about_btn=get_btn(panel,"About",about);
	quit_btn=get_btn(panel,"Quit",do_quit);

	new_panel_row(1);
	index_btn=get_icon_btn(panel,index_img,do_index);
	back_btn=get_icon_btn(panel,back_img,do_back);
	previous_btn=get_icon_btn(panel,previous_img,do_previous);
	next_btn=get_icon_btn(panel,next_img,do_next);
	search_btn=get_icon_btn(panel,search_img,do_search);

	/* Canvas creation. */

       	canvas=(Canvas)xv_create(frame,CANVAS,
		CANVAS_REPAINT_PROC,canvas_repaint,
 		CANVAS_X_PAINT_WINDOW,TRUE,
		CANVAS_AUTO_EXPAND,TRUE,
		CANVAS_AUTO_SHRINK,FALSE,
		CANVAS_HEIGHT,CANVASHEIGHT,
		CANVAS_WIDTH,CANVASWIDTH,
		NULL);

	/* Canvas events selection. */

	xv_set(canvas_paint_window(canvas),
		WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,LOC_MOVE,NULL,
		WIN_EVENT_PROC,event_handler,
		NULL);

	/* Scrollbars creation. */

	x_scroll=(Scrollbar)xv_create(canvas,SCROLLBAR,
		SCROLLBAR_DIRECTION,SCROLLBAR_HORIZONTAL,
		SCROLLBAR_PIXELS_PER_UNIT,8,
		SCROLLBAR_PAGE_LENGTH,30,
		NULL);
	y_scroll=(Scrollbar)xv_create(canvas,SCROLLBAR,
		SCROLLBAR_DIRECTION,SCROLLBAR_VERTICAL,
		SCROLLBAR_PIXELS_PER_UNIT,8,
		SCROLLBAR_PAGE_LENGTH,30,
		NULL);

	/* We load the title, subtitle, text, source and */
	/* hotword fonts.				 */

	title_font=get_font(canvas,"lucidasans-bold-18");
	sub_font=get_font(canvas,"lucidasans-18");
	text_font=get_font(canvas,"lucidasans-12");
	source_font=get_font(canvas,"lucidasans-12");
	hdef_font=get_font(canvas,"lucidasans-bold-12");
	hgo_font=get_font(canvas,"lucidasans-bold-12");
	hlink_font=get_font(canvas,"lucidasans-bold-12");
	}

void set_topic_list(v)
	vector v;
	{
	int i;
	
	for(i=0;i<tslist_items;i++) 
		xv_set(tslist,PANEL_LIST_DELETE,0,NULL); 
	for(i=0;i<vector_num(v);i++)
		xv_set(tslist,PANEL_LIST_INSERT,i,
			PANEL_LIST_STRING,i,topic_name(vector_read(v,i)),NULL);  
	tslist_items=vector_num(v);
	}
