.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfAlert
.SH DESCRIPTION
The XfwfAlert widget is a pop-up dialog box with three parts: an
icon in the top left corner, a text area, and a row of buttons along
the bottom. Usually the alert widget is used for error messages,
warnings and other kinds of informational messages. The icon indicates
the type of message: (fatal) error, warning, other message, request
for confirmation, etc. There are some built-in icons for these types.
Most alerts will have one or two buttons, e.g., OK and CANCEL.

An alert widget can be created in the usual way for shells, with
\fIXtVaCreatePopup\fP and similar routines, but a much more convenient way
is a call to \fIXfwfDialog\fP. \fIXfwfDialog\fP creates a temporary alert
widget and waits for the user to acknowledge it by clicking one of the
buttons. The function returns the number of the button that was
clicked.

An alert is made up of XfwfBoard(3X11), XfwfIcon(3X11),
Xfwflabel(3X11) and XfwfButton(3X11) widgets. The label widget will be
set to the minimum size that will show the full message. The alert
widget will be as small as possible to show all its children.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfAlert
Name	Class	Type	Default
XtNicon	XtCIcon	Icon *	"NONE"
XtNmessage	XtCMessage	String 	NULL 
XtNbuttons	XtCButtons	String 	NULL 
XtNlastChoice	XtCLastChoice	int 	0 
XtNcallback	XtCCallback	Callback	NULL 

.TE
.ps +2

.TP
.I "XtNicon"
The icon is of type \fIIcon\fP (see XfwfIcon(3X11)). The converter can load
images from file and it knows about 6 built-in icons: \fI"FATAL"\fP, \fI"ERROR"\fP,
\fI"WARNING"\fP, \fI"QUESTION"\fP, \fI"INFO"\fP and \fI"NONE"\fP. The \fINONE\fP icon is an
invisible (i.e., transparent) image of the same size as the others.

.hi
Icon * icon = <String>"NONE"
.eh

.TP
.I "XtNmessage"
The message is a simple string, that may include newlines.

.hi
String  message = NULL 
.eh

.TP
.I "XtNbuttons"
The buttons are created with labels which will be taken from the
\fIbuttons\fP resource. \fIbuttons\fP is a string with the labels separated by
vertical bars. If the string is empty, a single button with label
``Ok'' will be created.

.hi
String  buttons = NULL 
.eh

.TP
.I "XtNlastChoice"
The last button that was selected is also the default for the next
time (as soon as keyboard traversal has been implemented\dots) Buttons
are numbered starting with 0. Set this resource to -1 if you don't
want a default button.

.hi
int  lastChoice = 0 
.eh

.TP
.I "XtNcallback"
When a button is clicked, the number of the button is stored in
\fIlastChoice\fP, before the \fIcallback\fP functions are called. The
callbacks is passed the number in the \fIcall_data\fP argument. The
buttons are numbered starting at 0.

.hi
<Callback> XtCallbackList  callback = NULL 
.eh

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
TransientShell
Name	Class	Type	Default
transientFor	XtCTransientFor	Widget 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
WMShell
Name	Class	Type	Default
baseHeight	XtCBaseHeight	Int 	XtUnspecifiedShellInt 
baseWidth	XtCBaseWidth	Int 	XtUnspecifiedShellInt 
XtNtitle	XtCTitle	String 	NULL 
titleEncoding	XtCTitleEncoding	Atom 	XA_STRING 
XtNtransient	XtCTransient	Boolean 	False 
waitForWm	XtCWaitForWm	Boolean 	True 
winGravity	XtCWinGravity	Int 	NULL 
wmTimeout	XtCWmTimeout	Int 	5000 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Shell
Name	Class	Type	Default
allowShellResize	XtCAllowShellResize	Boolean 	False 
createPopupChildProc	XtCCreatePopupChildProc	XTCreatePopupChildProc 	NULL 
XtNgeometry	XtCGeometry	String 	NULL 
overrideRedirect	XtCOverrideRedirect	Boolean 	False 
popdownCallback	XtCPopdownCallback	Callback	NULL 
popupCallback	XtCPopupCallback	Callback	NULL 
saveUnder	XtCSaveUnder	Boolean 	False 
XtNvisual	XtCVisual	Visual *	CopyFromParent 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Exports"

As stated above, the alert widget can be created in the normal way
as a Shell widget with a particular set of resources, but a more
convenient way in many cases will be the \fIXfwfDialog\fP function. The
function creates an alert box with an icon, message and buttons, pops
it up, and returns only when the user has clicked one of the buttons.
The function's result will be the number of the button that was
clicked.

The first argument, \fItoplevel\fP, will be the widget that is used as the
alert's parent. Usually that will be the top level window of the
application, but it need not be. The alert box will appear
approximately in the middle of the \fItoplevel\fP widget (if the window
manager allows it).

The second argument is the name of the icon that will be shown in the
upper left corner of the alert. It can be one of the built-in names
\fI"FATAL"\fP, \fI"ERROR"\fP, \fI"WARNING"\fP, \fI"QUESTION"\fP, \fI"INFO"\fP and
\fI"NONE"\fP; or it can be the name of a file that contains an icon in XPM
format. The icon widget is of class XfwfIcon(3X11). It is named
\fI"_icon"\fP.

The third argument is the message to display in the center of the
alert. It may contain newlines. The message will be put into an
XfwfLabel(3X11) widget, named, appropriately, \fI"_message"\fP.

The last argument, \fIbuttons\fP, is a single string containing the labels
for all buttons, separated with a vertical bar. If this argument is
\fINULL\fP, that doesn't mean that there will be no buttons. Instead, a
single button with the label \fI"OK"\fP will be created. After all, if
there are no buttons, how will the alert box ever disappear? The
buttons are of type XfwfButton(3X11) and are named \fI"1"\fP, \fI"2"\fP, etc.

The alert itself will simply be called \fI"alert"\fP and its child, an
XfwfBoard(3X11) widget, will be called \fI"_board"\fP.

The implementation is as follows: After the alert has been created,
\fIXfwfDialog\fP adds a callback to the alert widget, which will set the
\fIchoice\fP variable when a button is pressed. The function then enters a
special purpose event loop, which dispatches events normally, but only
until the \fIchoice\fP variable is changed. The function returns with the
value of \fIchoice\fP

\fBdef\fP max(a, b) =
((a )>(b )?(a ):(b ))

\fBdef\fP min(a, b) =
((a )<(b )?(a ):(b ))

.nf
int  XfwfDialog(String  name, Widget  parent, String  icon, String  msg, String  buttons)
.fi

.hi
{
    Widget alert;
    int choice = -1;
    XEvent event;
    Position x, y;
    Dimension wd, ht, wd1, ht1;

    x = $parent$x;
    y = $parent$y;
    wd = $parent$width;
    ht = $parent$height;
    alert = XtVaCreatePopupShell
	(name, xfwfAlertWidgetClass, parent,
	 XtVaTypedArg, XtNicon, XtRString, icon, strlen(icon) + 1,
	 XtNmessage, msg,
	 XtNbuttons, buttons,
	 NULL);
    XtAddCallback(alert, XtNcallback, button_pressed, choice);
    XtRealizeWidget(alert);
    wd1 = $alert$width;
    ht1 = $alert$height;
    x = max(0, x + wd/2 - wd1/2);
    y = max(0, y + ht/2 - ht1/2);
    XtMoveWidget(alert, x, y);
    XtPopup(alert, XtGrabExclusive);
    while (choice == -1)
	XtAppProcessEvent(XtWidgetToApplicationContext(parent),
			  XtIMXEvent | XtIMTimer);
    XtDestroyWidget(alert);
    return choice;
}
.eh

.hi
.SH "Importss"

.nf

.B incl
 <stdlib.h>
.fi

.nf

.B incl
 <stdio.h>
.fi

.nf

.B incl
 <Xfwf/Icon.h>
.fi

.nf

.B incl
 <Xfwf/Label.h>
.fi

.nf

.B incl
 <Xfwf/RowCol.h>
.fi

.nf

.B incl
 <Xfwf/Button.h>
.fi

.nf

.B incl
 <Xfwf/Converters.h>
.fi

.hi

.hi
.SS "Private variables"

The various widgets that make up the alert box are stored in private
variables. \fIbutton\fP is an array of widgets, \fInum_buttons\fP is the length
of the array.

.nf
Widget  outer
.fi

.nf
Widget  iconw
.fi

.nf
Widget  labelw
.fi

.nf
Widget * buttonw
.fi

.nf
int  num_buttons
.fi

.hi

.hi
.SS "Methods"

The converter from String to Icon needs one extra argument, viz., the
widget for which the icon is loaded. An offset of 0 should give a
pointer to the widget itself.

.nf
class_initialize()
{
    static XtConvertArgRec args[] = {
    { XtWidgetBaseOffset, 0, sizeof(Widget) } };

    XtSetTypeConverter(XtRString, "Icon", cvtStringToIcon,
		       args, XtNumber(args), XtCacheNone, NULL);
}
.fi

The \fIinitialize\fP methods sets the local variables to \fINULL\fP and then
calls a utility function to create the children. The same function is
used by the \fIset_values\fP method.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
    $outer = NULL;
    $buttonw = NULL;
    $labelw = NULL;
    $iconw = NULL;
    $num_buttons = NULL;
    $buttons = XtNewString($buttons);
    $message = XtNewString($message);
    $outer = XtVaCreateManagedWidget("outer", xfwfBoardWidgetClass, $, NULL);
    create_children($);
}
.fi

\fIset_values\fP checks to see if any of the resources changed. If so,
the old children are destroyed and new ones are made.

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
    Boolean recreate = False;

    if ($old$message != $message) {
	XtFree($old$message);
	$message = XtNewString($message);
	recreate = True;
    }
    if ($old$buttons != $buttons) {
	XtFree($old$buttons);
	$buttons = XtNewString($buttons);
	recreate = True;
    }
    if ($old$icon != $icon || recreate) {
	create_children($);
    }
    return False;
}
.fi

.nf
destroy($)
{
    XtFree($buttons);
    XtFree($message);
    XtFree((String) $buttonw);
}
.fi

.hi

.hi
.SH "Utilities"

\fBdef\fP ALLOC = 1024 

\fBdef\fP myrealloc(p, size) =
(void *)XtRealloc ((void *)p ,(size +ALLOC -1 )/ALLOC *ALLOC )

\fBdef\fP mymalloc(size) =
(void *)XtMalloc (size )

\fBdef\fP myfree(p) =
XtFree ((void *)p )

The \fIbutton_pressed\fP callback is used by the \fIXfwfDialog\fP function.
It receives the number of the button that was pressed in the alert box
as \fIcall_data\fP and it has a reference to a variable as \fIclient_data\fP.
It simply copies the number to the variable and pops down the alert.

.nf
button_pressed(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
    XtPopdown(w);
    *((int*) client_data) = (int) call_data;
}
.fi

The \fIclick\fP callback is attached to each of the buttons. It sets the
\fIlastChoice\fP resource and calls the \fIcallback\fP routines of the alert widget.

.nf
click(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
    Widget $ = XtParent(XtParent(w));

    $lastChoice = (int) client_data;
    XtCallCallbackList($, $callback, (XtPointer) $lastChoice);
}
.fi

The \fIcreate_children\fP function is called by \fIinitialize\fP and
\fIset_values\fP. It destroys the old children, except for the board, and
creates new ones. The board is only resized, to fit the new children.

.nf
create_children($)
{
    Dimension ht, maxht, iconwd, iconht, labelwd, wd, bframe, labelht;
    Widget toprow, bottomrow, iconw, labelw, btn;
    Position x, buttony;
    String buttons, p;
    char name[20];
    int i;

    /*
     * Destroy old copies of the children
     */
    if ($iconw) XtDestroyWidget($iconw);
    if ($labelw) XtDestroyWidget($labelw);
    for (i = 0; i < $num_buttons; i++) XtDestroyWidget($buttonw[i]);

    bframe = XfwfCallFrameWidth($outer);	/* Board's frame */
    if ($buttons) buttons = XtNewString($buttons); /* Temporary copy */

    iconw = XtVaCreateManagedWidget
	("icon", xfwfIconWidgetClass, $outer,
	 XtNx, bframe,
	 XtNy, bframe,
	 XtNimage, $icon,
	 XtNtraversalOn, False,
	 NULL);
    iconwd = $iconw$width;
    iconht = $iconw$height;

    labelw = XtVaCreateManagedWidget
	("label", xfwfLabelWidgetClass, $outer,
	 XtNx, bframe + iconwd,
	 XtNy, bframe,
	 XtNshrinkToFit, True,
	 XtNlabel, $message,
	 NULL);
    labelwd = $labelw$width;
    labelht = $labelw$height;

    buttony = bframe + max(iconht, labelht);
    x = bframe + iconwd;
    maxht = 0;
    $num_buttons = 0;
    if ($buttons) {
	i = 0;
	p = strtok(buttons, "|");
	while (p) {
	    $buttonw = myrealloc($buttonw, (i + 1) * sizeof(*$buttonw));
	    sprintf(name, "%d", i);
	    btn = XtVaCreateManagedWidget
		(name, xfwfButtonWidgetClass, $outer,
		 XtNx, x,
		 XtNy, buttony,
		 XtNshrinkToFit, True,
		 XtNlabel, p,
		 NULL);
	    wd = $btn$width;
	    ht = $btn$height;
	    XtAddCallback(btn, XtNactivate, click, (XtPointer) i);
	    maxht = max(maxht, ht);
	    x += wd;
	    $buttonw[i] = btn;
	    i++;
	    p = strtok(NULL, "|");
	    $num_buttons++;
	}
	$num_buttons = i;
    } else {
	$buttonw = mymalloc(2 * sizeof(*$buttonw));
	$num_buttons = 1;
	btn = XtVaCreateManagedWidget
	    ("0", xfwfButtonWidgetClass, $outer,
	     XtNx, x,
	     XtNy, buttony,
	     XtNshrinkToFit, True,
	     XtNlabel, " OK ",
	     NULL);
	wd = $btn$width;
	ht = $btn$height;
	XtAddCallback(btn, XtNactivate, click, 0);
	maxht = ht;
	x += wd;
	$buttonw[0] = btn;
    }
    if ($buttons) XtFree(buttons);

    /*
     * And finally resize the outer Board
     */
    XtResizeWidget($outer, max(x + bframe, iconwd + labelwd + 2 * bframe),
		   buttony + maxht + bframe, 0);

    $iconw = iconw;
    $labelw = labelw;
}
.fi

.hi
