.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfFoldingTree
.SH DESCRIPTION
The FoldingTree class is designed to show subtrees of widgets which
can be expanded and collapsed by the user.

The first child of each FoldingTree widget is used as a label, and is
shown immediately to the right of the control icon.  Only subsequent
children are [un]mapped when the control icon is activated.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFoldingTree
Name	Class	Type	Default
XtNexpanded	XtCExpanded	Boolean 	False 
XtNiconExpand	XtCIconExpand	Icon *	NULL 
XtNiconCollapse	XtCIconCollapse	Icon *	NULL 
XtNiconNoExpand	XtCIconNoExpand	Icon *	NULL 
XtNshrinkToFit	XtCShrinkToFit	Boolean 	True 
XtNlineWidth	XtCLineWidth	Dimension 	2 
XtNlineColor	XtCLineColor	Pixel 	"#000"
XtNchildSpace	XtCChildSpace	Dimension 	4 

.TE
.ps +2

.TP
.I "XtNexpanded"
The state of the tree

	

.hi
Boolean  expanded = False 
.eh

.TP
.I "XtNiconExpand"
Icons used to indicate the current state of the tree

	

.hi
Icon * iconExpand = NULL 
.eh

.TP
.I "XtNiconCollapse"

.hi
Icon * iconCollapse = NULL 
.eh

.TP
.I "XtNiconNoExpand"

.hi
Icon * iconNoExpand = NULL 
.eh

.TP
.I "XtNshrinkToFit"
Whether to shrink when the subtree is collapsed.

	

.hi
Boolean  shrinkToFit = True 
.eh

.TP
.I "XtNlineWidth"
The line width to use for the tree diagram

	

.hi
Dimension  lineWidth = 2 
.eh

.TP
.I "XtNlineColor"
The line color to use for the tree diagram

	

.hi
Pixel  lineColor = <String>"#000"
.eh

.TP
.I "XtNchildSpace"
The amount of vertical space to leave between child widgets

	

.hi
Dimension  childSpace = 4 
.eh

.TP
.I "XtNframeWidth"
The frame width to use for the whole tree widget

	

.hi
 frameWidth = 0 
.eh

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Translations"

.nf
<Key>plus: expand() 
.fi

.nf
<Key>minus: collapse() 
.fi

.hi
.SS "Actions"

.TP
.I "expand

.hi

.nf
void expand($, XEvent* event, String* params, Cardinal* num_params)
{
	expand_CB($, $, NULL);
}
.fi

.eh

.TP
.I "collapse

.hi

.nf
void collapse($, XEvent* event, String* params, Cardinal* num_params)
{
	collapse_CB($, $, NULL);
}
.fi

.eh

.TP
.I "toggle

.hi

.nf
void toggle($, XEvent* event, String* params, Cardinal* num_params)
{
	toggle_CB($, $, NULL);
}
.fi

.eh

.hi

.hi
.SH "Importss"

.nf

.B incl
 "plus.xpm"
.fi

.nf

.B incl
 "minus.xpm"
.fi

.nf

.B incl
 "dot.xpm"
.fi

.nf

.B incl
 <Xfwf/Board.h>
.fi

.nf

.B incl
 <Xfwf/Icon.h>
.fi

.nf

.B incl
 <X11/Xmu/Converters.h>
.fi

.nf

.B incl
 <Xfwf/Converters.h>
.fi

.hi

.hi
.SS "Private variables"

Child widget automatically created during initialization used as the
control for expanded and collapsing the widget tree

	

.nf
Widget  tree_icon
.fi

GC used to draw the tree diagram

	

.nf
GC  line_gc
.fi

Position arrays used for storing coordinates for use by the \fIredraw_lines\fP
function

	

.nf
Position * xpos
.fi

.nf
Position * ypos
.fi

.hi

.hi
.SS "Methods"

Registers type convertor for icons

.nf
class_initialize()
{
	static XtConvertArgRec args[] = {
		{ XtWidgetBaseOffset, 0, sizeof(Widget) }
	};

	XtSetTypeConverter(XtRString, "Icon", cvtStringToIcon,
		args, XtNumber(args), XtCacheNone, NULL);
}
.fi

Creates \fIiconExpand\fP, \fIiconCollapse\fP and \fIiconExpand\fP.
Creates \fItree_icon\fP control widget and calls \fIcreate_line_gc\fP
Allocates the \fIxpos\fP and \fIypos\fP arrays for storing line segments

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
	static char	trans[] = "<Btn1Down>,<Btn1Up>: activate()";

	/* Create default icons if neccesary */
	if (!icons_created) {
		create_icons(XtDisplay($));
		icons_created = True;
	}

	/* Create a GC */
	$line_gc = NULL;
	create_line_gc($);

	/* Allocate a couple of arrays for point storage */
	$xpos = (Position *)XtMalloc(2 * sizeof(Position));
	$ypos = (Position *)XtMalloc(2 * sizeof(Position));

	/* Copy over pointers to the default icons */
	if (!$iconExpand) $iconExpand = iconPlus;
	if (!$iconCollapse) $iconCollapse = iconMinus;
	if (!$iconNoExpand) $iconNoExpand = iconDot;

	/* Create the control widget */
	$tree_icon = XtVaCreateManagedWidget(
		"_icon", xfwfIconWidgetClass, $,
		XtNframeWidth, (XtArgVal)2,
		XtVaTypedArg, XtNtranslations,
			XtRString, trans, strlen(trans)+1,
		NULL);

	/* Add the control widget's callback */
	XtAddCallback($tree_icon, XtNactivate, toggle_CB, $);
}
.fi

Deallocates the dynamically allocated objects \fIline_gc\fP, \fIxpos\fP and \fIypos\fP

.nf
destroy($)
{
	XtReleaseGC($, $line_gc);
	XtFree((String)$xpos);
	XtFree((String)$ypos);
	#destroy($);
}
.fi

Inserts the child and then reallocates the \fIypos\fP array if there
are now more than two children

.nf
insert_child(Widget  child)
{
	#insert_child(child);
	if ($num_children > 2) {
		$ypos = (Position*)XtRealloc((void*)$ypos,
			$num_children * sizeof(Position));
	}
}
.fi

Repositions all of the children if one of them changes its management
state

.nf
change_managed($)
{
	$layout($, $shrinkToFit);
}
.fi

Calls the layout method, but doesn't bother shrinking the widget
 

.nf
resize($)
{
	$layout($, False);
}
.fi

Monitors changes to public class variables and calls the layout method
if neccesary

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
	Boolean redraw = False;
	Boolean dolayout = False;

	/* Recreate the line_gc if the width or color needs changing */
	if ($old$lineWidth != $lineWidth ||
	    $old$lineColor != $lineColor) {
		create_line_gc($);
		redraw = True;
	}

	/* Check whether any of the icons have changed */
	if ($old$iconExpand != $iconExpand ||
	    $old$iconCollapse != $iconCollapse ||
	    $old$iconNoExpand != $iconNoExpand) {
		dolayout = True;
		redraw = True;
	}

	/* Check whether any of the layout parameters have changed */
	if ($old$expanded != $expanded ||
	    $old$shrinkToFit != $shrinkToFit ||
	    $old$childSpace != $childSpace) {
		dolayout = True;
		redraw = True;
	}

	if (dolayout) {
		$layout($, $shrinkToFit);
	}

	return redraw;
}
.fi

Prohibits children from asking for a position change.

.nf
XtGeometryResult  geometry_manager(Widget  child, XtWidgetGeometry * request, XtWidgetGeometry * reply)
{
	Dimension	nw, nh, nb;

	if (request->request_mode  (CWX | CWY)) return XtGeometryNo;
	if (request->request_mode  XtCWQueryOnly) return XtGeometryYes;

	nw = request->request_mode  CWWidth ? request->width : $child$width;
	nh = request->request_mode  CWHeight ? request->height : $child$height;
	nb = request->request_mode  CWBorderWidth ?
		request->border_width : $child$border_width;

	if (nw == $child$width 
            nh == $child$height 
	    nb == $child$border_width) return XtGeometryNo;

	XtResizeWidget(child, nw, nh, nb);
	$layout($, $shrinkToFit);
	return XtGeometryDone;
}
.fi

Repositions all child windows depending on the requested state of
the tree and then calls the redraw_lines function to draw the actual
tree

.nf
layout($, int  shrink)
{
	Widget		icon = $tree_icon, child;
	Boolean		can_expand;
	Position	left, top;
	Dimension	width, height;
	Dimension	max_width = 0;	/* Largest child widget width */
	Position	y;		/* Current top of next widget */
	Dimension	dy;		/* Increment to next widget's position*/
	int		i;

	/* Find out what sort of icon should be in use */
	can_expand = ($num_children > 2);
	$expanded = can_expand;
	if (can_expand) {
		if ($expanded) {
			XtVaSetValues(icon, XtNimage, $iconCollapse,
				NULL);
		} else {
			XtVaSetValues(icon, XtNimage, $iconExpand,
				NULL);
		}
	} else {
		XtVaSetValues(icon, XtNimage, $iconNoExpand, NULL);
	}

	/* Find the widgets dimensions */
	$compute_inside($, left, top, width, height);

	/* xpos[0] = middle of the icon */
	$xpos[0] = left + $icon$border_width + $icon$width / 2;

	/* ypos[0] = bottom of the icon */
	$ypos[0] = top + 2 * $icon$border_width + $icon$height;
	
	/* xpos[1] = new left hand side of child icons */
	$xpos[1] = left + 2 * $icon$border_width +
			$icon$width + $childSpace;

	/* Current widget position is the top of the window */
	y = top;

	/* Loop over all children except the first (the control widget) */
	for (i = 1; i < $num_children; ++i) {
		child = $children[i];
		if (!XtIsManaged(child)) continue;

		/* Calculate first component if position step */
		dy = $child$height + 2 * $child$border_width;

		/* Check whether the control icon is taller than the
		   label widget */
		if (i == 1) {
			dy = max(dy, $icon$height + 
					2 * $icon$border_width);
			max_width = $child$width + 2 * $child$border_width;
		}

		/* Set visual stage of child widgets (unless it's the
		   label widget */
		if (i > 1) {
			XtSetMappedWhenManaged(child, $expanded);
		}

		/* Move the widget to it's place */
		XtMoveWidget(child, $xpos[1], y);

		/* Calculate position of tree line into this child widget
		   NB: If the child widget is itself a subtree then the
		   tree line points at the midpoint of the subtree's control
		   widget instead of the midpoint of the entire widget */

		if (XtIsSubclass(child, xfwfFoldingTreeWidgetClass)) {
			XfwfFoldingTreeWidget tmp =
				(XfwfFoldingTreeWidget)child;
			XfwfIconWidget icon =
				(XfwfIconWidget)$tmp$tree_icon;
			$ypos[i] = y + $child$border_width +
				$icon$height / 2;
		} else {
			$ypos[i] = y + $child$border_width + $child$height / 2;
		}

		/* Calculate the position of the next widget if the current
		   widget is visible */
		if (i == 1 || $expanded) {
			y += dy + $childSpace;
			max_width = max(max_width,
				$child$width + 2 * $child$border_width);
		}

	}

	/* Clear the old lines if neccesary */
	if (XtIsRealized($)) XClearWindow(XtDisplay($), XtWindow($));

	/* Redraw the tree lines */
	redraw_lines($);

	/* Shrink this widget if neccesary */
	if (shrink) {
		width = $xpos[1] + max_width;
		height = y - $childSpace;
		if (width != $width ||
		    height != $height) {
			XtVaSetValues($,
				XtNwidth, width,
				XtNheight, height,
				NULL);
		}
	}
}
.fi

Call the superclasses expose method and then draw the tree lines

.nf
expose($, XEvent * event, Region  region)
{
	#expose($, event, region);
	if (XtIsRealized($)) {
		redraw_lines($);
	}
}
.fi

.hi

.hi
.SH "Utilities"

Global variables for the three default icons

.nf
Boolean  icons_created = False 
.fi

.nf
Icon  iconPlus
.fi

.nf
Icon  iconMinus
.fi

.nf
Icon  iconDot
.fi

Callbacks to set the state of the tree

.nf
expand_CB(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
	Widget $ = (Widget) client_data;

	XtVaSetValues($, XtNexpanded, True, NULL);
	$layout($, $shrinkToFit);
}
.fi

.nf
collapse_CB(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
	Widget $ = (Widget) client_data;

	XtVaSetValues($, XtNexpanded, False, NULL);
	$layout($, $shrinkToFit);
}
.fi

.nf
toggle_CB(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
	Widget $ = (Widget) client_data;

	XtVaSetValues($, XtNexpanded, !$expanded, NULL);
	$layout($, $shrinkToFit);
}
.fi

Creates the GC for drawing the tree lines of the correct width

.nf
create_line_gc($)
{
	XtGCMask	mask = 0;
	XGCValues	values;

	if ($line_gc != NULL) XtReleaseGC($, $line_gc);
	values.line_width = $lineWidth;
	mask |= GCLineWidth;
	values.foreground = $lineColor;
	mask |= GCForeground;
	$line_gc = XtGetGC($, mask, values);
}
.fi

Redraws the tree lines

.nf
redraw_lines($)
{
	Widget		child;
	int		i;
	Window		w = XtWindow($);

	if (!XtIsRealized($) || !$expanded || !$xpos || !$ypos) return;

	for (i = 2; i < $num_children; ++i) {
		child = $children[i];
		if (!XtIsManaged(child)) continue;
		XDrawLine(XtDisplay($), w, $line_gc,
			$xpos[0], $ypos[i], $xpos[1], $ypos[i]);
	}
	XDrawLine(XtDisplay($), w, $line_gc,
		$xpos[0], $ypos[0], $xpos[0], $ypos[i - 1]);
}
.fi

Converts data bits into an Icon

.nf
data_to_icon(Display * display, char * data[], Icon * icon)
{
	int		 status;

	icon->attributes.valuemask = XpmSize;
	status = XpmCreatePixmapFromData(
		display, DefaultRootWindow(display), data,
		icon->pixmap, icon->mask,
		icon->attributes);
	switch (status) {
		case XpmNoMemory:
			XtError("Out of memory");
		case XpmColorFailed:
			XtError("Failed to allocate color for pixmap");
		case XpmColorError:
			XtWarning("Not all pixmap colors found");
		default: ; /* skip */
	}

}
.fi

Creates default state icons

.nf
create_icons(Display * display)
{
	data_to_icon(display, plus, iconPlus);
	data_to_icon(display, minus, iconMinus);
	data_to_icon(display, dot, iconDot);
}
.fi

.hi
