#include "lattice.h"

int nx, ny;
float *qexp,*qsin,*qigl;

void compute() {
  float (*aexp)[ny] = (float (*)[ny]) qexp;
  float (*asin)[ny] = (float (*)[ny]) qsin; 
  float (*aigl)[ny] = (float (*)[ny]) qigl;
  int x,y;
  for (x = 0; x < nx; x++) { 
    float xp = ((float) x)/nx - 0.5;  // Intervall [-0.5 .. +0.5]
    for (y = 0; y < ny; y++) { 
      float yp = ((float) y)/ny - 0.5;
      float r = sqrt(SQR(xp) + SQR(yp));    
      aexp[x][y] = exp (-10*r*r); // alle Funktionen auf 1.0 normiert
      asin[x][y] = .25 * (1.0 + cos(15*r)); // auf 0.5 normiert
      float rad = 1 - SQR(xp*2) - SQR(yp*3);
      aigl[x][y] = (rad < 0) ? 0 : sqrt(rad);
    } 
  }
}

lattice_manager *lm;

void selexp() { lm->qptr = qexp; lm->redraw();}
void selsin() { lm->qptr = qsin; lm->redraw();}
void seligl() { lm->qptr = qigl; lm->redraw();}

// only needed to have an action method for the radio_menu "nx"
class main_action_window : public main_window { 
public:
  main_action_window(char *Name, int w, int h) : main_window(Name,w,h) {}
  virtual void action(char *menu, char *value) 
    { nx = ny = atoi(value); 
      compute();
      lm->respace(nx, ny); // redraws the lattice
      lm->redraw_clones();
    } 
};

int main (int argc, char * argv[]) {
  int ww = 440, wh = 500, bh = 20;
  main_window * mainw = new main_action_window(argv[0], ww, wh);

  nx = ny = 10;
  qexp = new float[10000]; // [nx*ny];
  qsin = new float[10000]; // [nx*ny];
  qigl = new float[10000]; // [nx*ny];
  compute();
  menu_bar *mb = new menu_bar(*mainw,ww,bh,0,0,70,100,0);
  lm = new lattice_manager(*mainw,ww,wh-bh,0,bh,nx,ny,qexp);

  struct but_cb m_list[] = {{"gauss",selexp}, {"sin",selsin}, {"iglo",seligl}};
  button * menu = make_pulldown_menu(*mb,"menu",3,m_list);
  char *nx_list[] = {"3","5","10","15","20","25","30","40","50","60","80",0};
  make_radio_menu(*mb,"nx",nx_list,mainw);
  button *qu = new quit_button(*mb);

  mainw->main_loop();
}
