#include <stdlib.h>
#include <math.h>
#include "window.h"
#include "palette.h"

#define SQR(x) ((x)*(x))

extern "C" double sqrt(double);
extern int sqabs(XPoint p1, XPoint p2);

extern float grd2rad;            // Umrechnung grad -> radiant	
extern palette_popup *pal_win;   // das palette_window

class lattice_window : public coord_window {
  int *y_bot, *y_top;
protected:
  float ca,sa,cb,sb,dist,xp,yp,zmax,znorm;
  int *external_colors;     // um anstelle der aus dem Lichteinfall berechneten
                            // Farben user-definierte zu setzen (zb land use)

  int ncolors;  // Zahl der Farben fuer body && palette
  Bool flat_mode; // keine Perspektive

  void pline(XPoint a, XPoint b) // draws lines uncoditionally
   { line(a.x,a.y,b.x,b.y); }

  void cline(XPoint a, XPoint b, int lastp);
  void fill(XPoint a, XPoint b, int lastp, int inside);

  void xline(XPoint a, XPoint b, int lastp) { 
    if (opaque) cline(a,b, lastp);  else pline(a,b); }
  struct XPoint screen_project(float x, float y, float z);

public:
  struct XPoint *scptr; // Feld der transformierten Gitterpunkte als [nx][ny] 
  int ixstart,iystart,// die Startindizees fuer die Darstellung aus dem qq-Feld
      ixend, iyend;
  int xspan, yspan;  // die max Werte von x,y in org.
  int opaque; 
  int rand;  // 0 : Darstellung mit Randlinien
  int body;  // toggle between lattice and body display

  lattice_window(window & parent, int w, int h, int x, int y);

  ~lattice_window() { delete[] scptr;}
 
  // alpha, beta : Drehwinkel (hier rad!), gamma : z-Faktor,
  void make_lattice(int nx, int ny, float *FF, 
		    float alpha, float beta, float gamma, int opaque, 
		    float distance);

  void make_body(int nx, int ny, float *FF, 
		 float alpha, float beta, float gamma, int opaque, 
		 float distance, float al, float bl);
};

class lattice_manager;

class region_manager : public coord_window {
  int &nx,&ny;     //  referenzen auf lm->nx, lm->ny !!
  float xmax,ymax;
public:
  lattice_manager * lm;
  XPoint zc;   // zoom centre

  void init_region();
  void rise();
  void shrink();

  region_manager(window &parent, lattice_manager *lm);
  virtual void draw_interior();

  XPoint raster(int x, int y);
  XPoint p_window(float x, float y) ;
  void mark_rect(float x0, float y0, float dx, float dy) ;
  void Rectangle(GC gc, XPoint p1, XPoint p2); 

  XPoint pstart, pact, pmin, pmax;
  virtual void BPress_1_CB(XButtonEvent ev);

  virtual void BRelease_CB(XButtonEvent ev);
  
  virtual void Motion_CB(XMotionEvent ev);
};

// generates a lattice_window and the buttons to manage it
class lattice_manager : public lattice_window {
private:
  menu_bar *mb1,*mb2; // die beiden unteren menu_leisten
protected:
  main_window *light_win, // das popup fuer Lichteinfallwinkel
              *region_win;  // popup fuer region_manager 
  region_manager *region_int;  // das Bild im region_manager (fuer redraw-ops)
  lattice_manager * clone_lm;  // eine Liste von Kopien (resp. NULL)

public:
  int nx, ny; // die Gitterdimensionen
  float * qptr; // pointer auf 2-d array mit Gitter-Werten der Funktion
  float alpha, beta, a_light, b_light;
  float dist, gamma;

  void init_region() { ixstart = 0; ixend = nx; iystart = 0; iyend = ny; }

  void set_toggles(int pbody, int prand, int popaque, int pflat) 
    { body = pbody; rand = prand; opaque = popaque; flat_mode = pflat; } 

  void set_angles(float palhpa, float pbeta, float pgamma, float pdist)
    { alpha = palhpa; beta = pbeta; gamma = pgamma; dist = pdist; }

  void set_defaults();

  lattice_manager(window & parent, int w, int h, int x, int y, int nx, int ny,
		  float * q);
    
  ~lattice_manager() { 
    delete light_win; delete region_win; 
    if (clone_lm) delete clone_lm;
  }

  // Aenderung des Gitters 
  void respace(int nxp, int nyp) { 
    nx = nxp; ny = nyp;  
    init_region(); 
    if (clone_lm) clone_lm->respace(nxp,nyp);
  }

  void default_draw() { // for default button
     set_defaults(); redraw();
  } 

  virtual void redraw() {
    lattice_window::redraw();
    region_int->redraw(); // Originalbild restaurieren  
  }
  void redraw_clones() {
    redraw();
    if (clone_lm) clone_lm->redraw_clones();
  }
  void show_infos(int, int);
  void draw_interior();
  void action(char *menu, char *val) { }

  // Callback-functions von buttons aus
  void mult_float(float *val, float increment) 
    { *val *= increment; redraw(); }
   
  void inc_int(int *val, int increment) 
    { *val += increment; redraw(); }

  void inc_float(float *val, float increment) 
    { *val += increment; redraw(); }

  void toggle(int *ref, int v) { *ref ^= v; redraw();}

  // Mouse drawing of the cordinate system, for quick change of viewpoint
  virtual void BPress_1_CB(XButtonEvent ev);
  virtual void BPress_3_CB(XButtonEvent ev);

  virtual void Motion_CB(XMotionEvent ev);
  virtual void BRelease_CB(XButtonEvent ev);

  // the arrow-keys turn the image for 5 grd
  virtual void KeyPress_CB(XKeyEvent ev);

  // erzeugt ein popup mit gleichen Parametern
  lattice_manager* make_popup(char *Name, float *q);

  // erzeugt eine identische Kopie des Bildes mit demselben array
  void make_clone();
  void delete_clone();
};

class light_popup : public main_window {
 public:
  lattice_manager *lm; // der zugehoerige lattice_manager
  int immediate;
  scrollbar *sc_alpha, *sc_beta;
  light_popup(lattice_manager *latm, int w);
};
