# Makefile : Builds wxWindows library wx.lib for Windows 3.1
# for Symantec C++ 6.0

### system configuration section ##########################################

# directories:

WXDIR = $(WX)
SRCDIR = $(WXDIR)\src
INCDIR = $(WXDIR)\include
LIBDIR = $(WXDIR)\lib
DOCDIR = $(WXDIR)\docs
MSWSRC = $(SRCDIR)\msw
MSWINC = $(INCDIR)\msw
BASESRC = $(SRCDIR)\base
BASEINC = $(INCDIR)\base

# compiler and flags (consider -g for debugging, etc.)

CC = sc
CFLAGS = -o -ml -W -Dwx_msw

INCLUDE = $(BASEINC);$(MSWINC);$(WXDIR)\contrib\fafa

LIBTARGET = $(LIBDIR)\wx.lib

# Miscellaneous wxWindows source options. Hopefully we can keep these
# options settable in wxWindows library compilation only, and not
# have to set them in each application's makefile. I.e. keep these
# #ifdefs in source files only, not header files.
#
# Zero or more of:
# -DCTL3D          (CTL3D support; see docs\install.txt for instructions)
# -DNO_COPYRIGHT   (no non-AIAI code) // Not implemented
# -DFAFA_LIB       (Contributed bitmap/new look control stuff; requires
#                  that you compile FAFA lib too)
# -DENHANCED_FONTS (Define to have predefined fonts in wxEhDialogBox)

# OPTIONS = -DCTL3D
# OPTIONS = -DFAFA_LIB
OPTIONS =

# Default is to output RTF for WinHelp
WINHELP = -winhelp

### end of system configuration section ###################################

MSWOBJS = msw\wx_win.obj msw\wx_frame.obj msw\wx_panel.obj \
msw\wx_utils.obj msw\wx_main.obj msw\wx_item.obj msw\wx_text.obj \
msw\wx_gdi.obj msw\wx_dialg.obj msw\wx_canvs.obj msw\wx_dc.obj \
msw\wx_mf.obj msw\wx_ipc.obj msw\wx_timer.obj msw\wx_clipb.obj

BASEOBJS = base\wb_win.obj base\wb_frame.obj base\wb_panel.obj \
base\wb_utils.obj base\wb_main.obj  base\wb_item.obj base\wb_list.obj \
base\wb_obj.obj base\wb_ps.obj base\wb_text.obj base\wb_gdi.obj \
base\wb_dialg.obj base\wb_canvs.obj base\wb_dc.obj base\wb_mf.obj \
base\wb_hash.obj base\wb_ipc.obj  base\wb_form.obj base\wb_timer.obj \
base\wb_help.obj base\wx_enhdg.obj base\wb_sysev.obj  base\wb_stdev.obj \
base\wb_types.obj base\wb_mgstr.obj

OBJS = $(MSWOBJS) $(BASEOBJS)


all:    base msw $(LIBTARGET)

base:
	cd $(BASESRC)
	*make -f makefile.sc 'CC=$(CC)' 'CFLAGS=$(CFLAGS)' \
'INCLUDE=$(INCLUDE)' 'OPTIONS=$(OPTIONS)'
	cd $(SRCDIR)

msw:
	cd $(MSWSRC)
	*make -f makefile.sc 'CC=$(CC)' 'CFLAGS=$(CFLAGS)' \
'INCLUDE=$(INCLUDE)' 'OPTIONS=$(OPTIONS)'
	cd $(SRCDIR)

$(LIBTARGET): $(OBJS)
	-del $(LIBTARGET)
	*lib $(LIBTARGET) y $(OBJS), nul;

# Making documents
docs:   hlp
hlp:    $(DOCDIR)/wx.hlp
rtf:    $(DOCDIR)/wx.rtf

alldocs: allhlp
allhlp:
	make -f makefile.sc hlp
	cd $(WXDIR)\utils\toolbar\src
	make -f makefile.sc 'WINHELP=$(WINHELP)' hlp
	cd $(WXDIR)\utils\hytext\src
	make -f makefile.sc 'WINHELP=$(WINHELP)' hlp
	cd $(WXDIR)\utils\wxclips\src
	make -f makefile.sc 'WINHELP=$(WINHELP)' hlp
	cd $(WXDIR)\utils\wxhelp\src
	make -f makefile.sc 'WINHELP=$(WINHELP)' hlp
	cd $(WXDIR)\utils\prologio\src
	make -f makefile.sc 'WINHELP=$(WINHELP)' hlp
	cd $(WXDIR)\utils\tex2rtf\src
	make -f makefile.sc 'WINHELP=$(WINHELP)' hlp
	cd $(WXDIR)\utils\wxgraph\src
	make -f makefile.sc 'WINHELP=$(WINHELP)' hlp
	cd $(WXDIR)\utils\wxtree\src
	make -f makefile.sc 'WINHELP=$(WINHELP)' hlp
	cd $(SRCDIR)

$(DOCDIR)/wx.hlp:         $(DOCDIR)/wx.rtf $(DOCDIR)/wx.hpj
	cd $(DOCDIR)
	-erase wx.ph
	hc wx
	cd $(SRCDIR)

$(DOCDIR)/wx.rtf:         $(DOCDIR)/classes.tex $(DOCDIR)/body.tex $(DOCDIR)/manual.tex
	cd $(DOCDIR)
	tex2rtf $(DOCDIR)/manual.tex $(DOCDIR)/wx.rtf -twice $(WINHELP)
	cd $(SRCDIR)

clean:
	cd $(BASESRC)
	make -f makefile.sc clean
	cd $(MSWSRC)
	make -f makefile.sc clean
	-del $(LIBTARGET)
	cd $(SRCDIR)

