# Symantec C++ makefile for the toolbar library

WXDIR = $(WX)
WXLIB = $(WXDIR)\lib\wx.lib
INCDIR = $(WXDIR)\include
MSWINC = $(INCDIR)\msw
BASEINC = $(INCDIR)\base

CTL3DLIB = $(WXDIR)\contrib\ctl3d\ctl3d.lib
FAFALIB = $(WXDIR)\contrib\fafa\fafa.lib

TOOLBARDIR = $(WXDIR)\utils\toolbar
TOOLBARINC = $(TOOLBARDIR)\src
TOOLBARLIB = $(TOOLBARDIR)\lib\toolbar.lib

DOCDIR = $(TOOLBARDIR)\docs
SRCDIR = $(TOOLBARDIR)\src

# Default is to output RTF for WinHelp
WINHELP=-winhelp

CC=sc
RC=rc
CFLAGS = -o -ml -W -Dwx_msw
LDFLAGS = -ml -W

INCLUDE=$(BASEINC);$(MSWINC)

LIBS=$(TOOLBARLIB) $(WXLIB) libw.lib commdlg.lib shell.lib $(FAFALIB) # $(CTL3DLIB)

.cc.obj:
	*$(CC) -c $(CFLAGS) -I$(INCLUDE) $<

.rc.res:
	*$(RC) -r -I$(INCLUDE) $<

$(TOOLBARLIB): wx_tbar.obj
 	-del $(TOOLBARLIB)
	*lib $(TOOLBARLIB) y wx_tbar.obj, nul;

wx_tbar.obj: wx_tbar.h wx_tbar.cc

test.exe: test.obj test.def test.res
	*$(CC) $(LDFLAGS) -o$@ test.obj test.def $(LIBS)
	*$(RC) -k test.res

# Making documents
docs:   $(DOCDIR)/toolbar.hlp
rtf:    $(DOCDIR)/toolbar.rtf
hlp:    $(DOCDIR)/toolbar.hlp

$(DOCDIR)/toolbar.hlp:         $(DOCDIR)/toolbar.rtf $(DOCDIR)/toolbar.hpj
        cd $(DOCDIR)
        -erase toolbar.ph
        hc toolbar
        cd $(SRCDIR)

$(DOCDIR)/toolbar.rtf:         $(DOCDIR)/classes.tex $(DOCDIR)/manual.tex
        cd $(DOCDIR)
        -wx tex2rtf $(DOCDIR)\manual.tex $(DOCDIR)\toolbar.rtf -twice $(WINHELP)
        cd $(SRCDIR)

clean:
        -del *.obj
	-del *.exe
	-del *.res
	-del *.map
	-del $(TOOLBARLIB)
