/*
 * File:	wx_dcps.h
 * Purpose:	PostScript device context
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "@(#)wx_dcps.h	1.2 5/9/94" */


#ifndef wx_dcpsh
#define wx_dcpsh

#ifdef __GNUG__
#pragma interface
#endif

#include "wx_dc.h"
#if USE_POSTSCRIPT

#ifdef IN_CPROTO
typedef       void    *wxPostScriptDC ;
#else

class wxPostScriptDC: public wxDC
{
 public:
  int yorigin;          // For EPS
  ofstream *pstream;    // PostScript output stream
  char *filename;
  unsigned char currentRed;
  unsigned char currentGreen;
  unsigned char currentBlue;

  // Create a compatible DC from an existing one
  wxPostScriptDC(wxPostScriptDC *old_dc);

  // Create a printer DC
  wxPostScriptDC(char *output, Bool interactive = TRUE);

  ~wxPostScriptDC(void);

  virtual void BeginDrawing(void) {} ;
  virtual void EndDrawing(void) {} ;

  void FloodFill(float x1, float y1, wxColour *col, int style=wxFLOOD_SURFACE) ;
  Bool GetPixel(float x1, float y1, wxColour *col) ;

  void DrawLine(float x1, float y1, float x2, float y2);
  void IntDrawLine(int x1, int y1, int x2, int y2);
  void CrossHair(int x, int y) ;
  void DrawArc(float x1,float y1,float x2,float y2,float xc,float yc);
  void DrawPoint(float x, float y);
  void DrawLines(int n, wxPoint points[], float xoffset = 0, float yoffset = 0);
  void DrawLines(int n, wxIntPoint points[], int xoffset = 0, int yoffset = 0);
  void DrawPolygon(int n, wxPoint points[], float xoffset = 0, float yoffset = 0, int fillStyle=wxODDEVEN_RULE);
  void DrawRectangle(float x, float y, float width, float height);
  void DrawRoundedRectangle(float x, float y, float width, float height, float radius = 20);
  void DrawEllipse(float x, float y, float width, float height);
  // Splines
  // 3-point spline
  void DrawSpline(float x1, float y1, float x2, float y2, float x3, float y3);
  // Any number of control points - a list of pointers to wxPoints
  void DrawSpline(wxList *points);
  void DrawSpline(int n, wxPoint points[]);
  void DrawIcon(wxIcon *icon, float x, float y);
  void DrawText(const char *text, float x, float y);

  void Clear(void);
  void SetFont(wxFont *font);
  void SetPen(wxPen *pen);
  void SetBrush(wxBrush *brush);
  void SetLogicalFunction(int function);
  void SetBackground(wxBrush *brush);
  void SetClippingRegion(float x, float y, float width, float height);
  void DestroyClippingRegion(void);

  Bool StartDoc(char *message);
  void EndDoc(void);
  void StartPage(void);
  void EndPage(void);

  float GetCharHeight(void);
  float GetCharWidth(void);
  void GetTextExtent(const char *string, float *x, float *y,
                     float *descent = NULL, float *externalLeading = NULL);
  void SetMapMode(int mode);
  void SetUserScale(float x, float y);
  float DeviceToLogicalX(int x);
  float DeviceToLogicalY(int y);
  float DeviceToLogicalXRel(int x);
  float DeviceToLogicalYRel(int y);
  int LogicalToDeviceX(float x);
  int LogicalToDeviceY(float y);
  int LogicalToDeviceXRel(float x);
  int LogicalToDeviceYRel(float y);
  Bool Blit(float xdest, float ydest, float width, float height,
            wxCanvasDC *source, float xsrc, float ysrc, int rop = wxCOPY);
};

// Print Orientation (Should also add Left, Right)
enum {
  PS_PORTRAIT,
  PS_LANDSCAPE
};// ps_orientation = PS_PORTRAIT;

// Print Actions
enum {
  PS_PREVIEW,
  PS_FILE,
  PS_PRINTER
};// ps_action = PS_PREVIEW;

// PostScript printer settings
void wxSetPrinterCommand(char *cmd);
void wxSetPrintPreviewCommand(char *cmd);
void wxSetPrinterOptions(char *flags);
void wxSetPrinterOrientation(int orientation);
void wxSetPrinterScaling(float x, float y);
void wxSetPrinterTranslation(float x, float y);
void wxSetPrinterMode(int mode);
void wxSetPrinterFile(char *f);

// Get current values
char *wxGetPrinterCommand(void);
char *wxGetPrintPreviewCommand(void);
char *wxGetPrinterOptions(void);
Bool wxGetPrinterOrientation(void);
void wxGetPrinterScaling(float *x, float *y);
void wxGetPrinterTranslation(float *x, float *y);
int wxGetPrinterMode(void);
char *wxGetPrinterFile(void);

#endif // IN_CPROTO
#endif // USE_POSTSCRIPT
#endif // wx_dcpsh

