/*
 * File:	wx_utils.h
 * Purpose:	Miscellaneous utilities
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wxb_utilsh
#define wxb_utilsh

#ifdef __GNUG__
#pragma interface
#endif

#include "wx_setup.h"
#include "wx_obj.h"
#include "wx_list.h"
#include "wx_win.h"

#ifdef wx_x
#include <dirent.h>
#include <unistd.h>
#endif

// sprintf is often needed, but we don't always want to include the whole
// of stdio.h!
#ifdef wx_msw
extern "C" int sprintf(char *, const char *, ...);
#elif defined(wx_x)
#include <stdio.h>
#endif

// Forward declaration
class wxFrame;

// Stupid ASCII macros
#define   wxToUpper(C)      (((C) >= 'a' && (C) <= 'z')? (C) - 'a' + 'A': (C))
#define   wxToLower(C)      (((C) >= 'A' && (C) <= 'Z')? (C) - 'A' + 'a': (C))

// Make a copy of this string using 'new'
char *copystring(const char *s);

// Generate a unique ID
long NewId(void);

// Ensure subsequent IDs don't clash with this one
void RegisterId(long id);

// Useful buffer
extern char *wxBuffer;

// Various conversions
void StringToFloat(char *s, float *number);
char *FloatToString(float number);
void StringToDouble(char *s, double *number);
char *DoubleToString(double number);
void StringToInt(char *s, int *number);
void StringToLong(char *s, long *number);
char *IntToString(int number);
char *LongToString(long number);

// Matches string one within string two regardless of case
#ifndef IN_CPROTO
Bool StringMatch(char *one, char *two, Bool subString = TRUE, Bool exact = FALSE);
#endif

// Some file utilities

#ifdef IN_CPROTO
typedef       void    *wxPathList ;
typedef       void    *wxLogClass;
#else
// Path searching
class wxPathList: public wxList
{
  public:

  void AddEnvList(char *envVariable);    // Adds all paths in environment variable
  void Add(char *path);
  char *FindValidPath(char *filename);   // Find the first full path
                                         // for which the file exists
  void EnsureFileAccessible(char *path); // Given full path and filename,
                                         // add path to list
  Bool Member(char *path);
};

Bool FileExists(const char *filename);
Bool DirExists(const char *dir);
Bool IsAbsolutePath(const char *filename);

// Get filename
char *FileNameFromPath(char *path);

// Get directory
char *PathOnly(char *path);

void Dos2UnixFilename(char *s);
void Unix2DosFilename(char *s);

// Get a temporary filename, opening and closing the file.
char *wxGetTempFileName(const char *prefix, char *buf = NULL);

// Get first file name matching given wild card.
// Flags are reserved for future use.
char *wxFindFirstFile(const char *spec, int flags = 0);
char *wxFindNextFile(void);

// Does the pattern contain wildcards?
Bool wxIsWild(const char *pattern);

// Does the pattern match the text (usually a filename)?
// If dot_special is TRUE, doesn't match * against . (eliminating
// `hidden' dot files)
Bool wxMatchWild(const char *pattern,  const char *text, Bool dot_special = TRUE);

// Execute another program. Returns FALSE if there was an error.
Bool wxExecute(char **argv, Bool Async = FALSE);
Bool wxExecute(const char *command, Bool Async = FALSE);

// Execute a command in an interactive shell window
// If no command then just the shell
Bool wxShell(const char *command = NULL);

// Concatenate two files to form third
Bool wxConcatFiles(const char *file1, const char *file2, const char *file3);

// Copy file1 to file2
Bool wxCopyFile(const char *file1, const char *file2);

// Remove file
Bool wxRemoveFile(const char *file);

// Rename file
Bool wxRenameFile(const char *file1, const char *file2);

// Get current working directory.
// If buf is NULL, allocates space using new, else
// copies into buf.
char *wxGetWorkingDirectory(char *buf = NULL, int sz = 1000);

// Sleep for nSecs seconds under UNIX, do nothing under Windows
void wxSleep(int nSecs);

// Get free memory in bytes, or -1 if cannot determine amount (e.g. on UNIX)
long wxGetFreeMemory(void);

// Consume all events until no more left
void wxFlushEvents(void);

// Make directory
Bool wxMkdir(const char *dir);

/*
 * Network and username functions.
 *
 */

// Get eMail address
Bool wxGetEmailAddress(char *buf, int maxSize);

// Get hostname.
Bool wxGetHostName(char *buf, int maxSize);

// Get user ID e.g. jacs
Bool wxGetUserId(char *buf, int maxSize);

// Get user name e.g. Julian Smart
Bool wxGetUserName(char *buf, int maxSize);

/*
 * Strip out any menu codes
 */
void wxStripMenuCodes(char *in, char *out);

// Find the window/widget with the given title or label.
// Pass a parent to begin the search from, or NULL to look through
// all windows.
wxWindow *wxFindWindowByLabel(wxWindow *parent, char *title);

// Returns menu item id or -1 if none.
int wxFindMenuItemId(wxFrame *frame, char *menuString, char *itemString);

// Debug Log
#ifdef DEBUGLOG
#include <fstream.h>
class wxLogClass
{
  ofstream *the_stream;
  char *log_file;
  public:
    wxLogClass(const char *file);
    ~wxLogClass();
    void Open(void);
    void Close(void);

    wxLogClass& operator << (char *s);
    wxLogClass& operator << (int i);
    wxLogClass& operator << (double i);
};

extern wxLogClass wxLog;
#endif

#if (!defined(__MINMAX_DEFINED) && !defined(max))
#define max(a,b)            (((a) > (b)) ? (a) : (b))
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#define __MINMAX_DEFINED 1
#endif

// Format a message on the standard error (UNIX) or the debugging
// stream (Windows)
void wxDebugMsg(const char *fmt ...) ;
 
// Sound the bell
void wxBell(void) ;
  
// Get OS version
int wxGetOsVersion(int *majorVsn=NULL,int *minorVsn=NULL) ;
 
// Set the cursor to the busy cursor for all windows
class wxCursor;
extern wxCursor *wxHOURGLASS_CURSOR;
void wxBeginBusyCursor(wxCursor *cursor = wxHOURGLASS_CURSOR);
 
// Restore cursor to normal
void wxEndBusyCursor(void);
 
// TRUE if we're between the above two calls
Bool wxIsBusy(void);
  
/* Error message functions used by wxWindows */

// Non-fatal error (continues) 
void wxError(const char *msg, const char *title = "wxWindows Internal Error");

// Fatal error (exits)
void wxFatalError(const char *msg, const char *title = "wxWindows Fatal Error");

// Reading and writing resources (eg WIN.INI, .Xdefaults)
#if USE_RESOURCES
Bool wxWriteResource(const char *section, const char *entry, char *value, const char *file = NULL);
Bool wxWriteResource(const char *section, const char *entry, float value, const char *file = NULL);
Bool wxWriteResource(const char *section, const char *entry, long value, const char *file = NULL);
Bool wxWriteResource(const char *section, const char *entry, int value, const char *file = NULL);

Bool wxGetResource(const char *section, const char *entry, char **value, const char *file = NULL);
Bool wxGetResource(const char *section, const char *entry, float *value, const char *file = NULL);
Bool wxGetResource(const char *section, const char *entry, long *value, const char *file = NULL);
Bool wxGetResource(const char *section, const char *entry, int *value, const char *file = NULL);
#endif // USE_RESOURCES

// X (UNIX) only
#ifdef wx_x
char *wxGetHomeDir(char *dest);
#endif

#endif // IN_CPROTO
#endif // wxb_utilsh
