/*
 * File:	wxstring.h
 * Purpose:	String class
 * Author:	Julian Smart
 * Created:	1994
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_stringh
#define wx_stringh

#ifdef __GNUG__
#pragma interface
#endif

#include "common.h"
#include "wx_obj.h"

/*
 * String
 *
 */
 
class wxString: public wxObject
{
 private:
  char *stringData;
 public:
  wxString(const char *s = NULL);
  wxString(wxString& s);
  ~wxString(void);

  void operator =(wxString& s);
  Bool operator ==(wxString& s);
  Bool operator !=(wxString& s);
  wxString operator +(wxString& s);
  inline int Compare(wxString& s) { return strcmp(stringData, s.GetData()); };

  inline char *GetData(void) { return stringData; }
  void SetData(char *s);
  inline size_t Length(void) { return strlen(stringData); }

  wxString SubString(size_t from, size_t to);
  wxString UpperCase(void);
  wxString LowerCase(void);
};

#endif // wx_stringh
