/*
 * File:	wx_gdi.h
 * Purpose:	Declaration of various graphics objects - fonts, pens, icons etc.
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "@(#)wx_gdi.h	1.2 5/9/94" */


#ifndef wx_gdih
#define wx_gdih

#include "wb_gdi.h"

#ifdef IN_CPROTO
typedef       void    *wxFont ;
typedef       void    *wxColourMap;
typedef       void    *wxPen;
typedef       void    *wxBrush;
typedef       void    *wxIcon;
typedef       void    *wxCursor;
typedef       void    *wxBitmap;
#else

// Font
class wxFont: public wxbFont
{
 public:
  HFONT cfont;

  wxFont(void);
  wxFont(int PointSize, int Family, int Style, int Weight, Bool underlined = FALSE);
  ~wxFont(void);
  void BuildInternalFont(HDC dc) ;
  HFONT GetInternalFont(HDC dc) ;
};

class wxColourMap: public wxbColourMap
{
 public:
 HPALETTE ms_palette;
  wxColourMap(void);
  ~wxColourMap(void);
  Bool Create(const int n, const unsigned char *red, const unsigned char *green, const unsigned char *blue);
  int GetPixel(const unsigned char red, const unsigned char green, const unsigned char blue);
  Bool GetRGB(const int pixel, unsigned char *red, unsigned char *green, unsigned char *blue);
};

#define wxColorMap wxColourMap

// Pen
class wxPen: public wxbPen
{
 public:
  int old_width;
  int old_style;
  int old_join ;
  int old_cap ;
  int old_nb_dash ;
  wxDash *old_dash ;
  wxBitmap *old_stipple ;
  COLORREF old_color ;

  HPEN cpen;
  HPEN my_old_cpen ;

  wxPen(void);
  wxPen(wxColour& col, int width, int style);
  wxPen(const char *col, int width, int style);
  ~wxPen(void);

  void ChangePen() ;
  HPEN SelectPen(HDC dc) ;

};

int wx2msPenStyle(int wx_style);

// Brush
class wxBrush: public wxbBrush
{
 public:
  HBRUSH cbrush;
  HBRUSH my_old_cbrush ;
  int old_style;
  wxBitmap *old_stipple ;
  COLORREF old_color ;


  wxBrush(void);
  wxBrush(wxColour& col, int style);
  wxBrush(const char *col, int style);
  ~wxBrush(void);

  void ChangeBrush() ;
  HBRUSH SelectBrush(HDC dc) ;
};

// Icon
class wxIcon: public wxbIcon
{
 public:
  HICON ms_icon;
  wxIcon(void);
  wxIcon(char bits[], int width, int height);
  wxIcon(const char *name);
  ~wxIcon(void);
};

// Cursor
class wxCursor: public wxbCursor
{
 public:
  HCURSOR ms_cursor;
  wxCursor(void);
  wxCursor(char bits[], int width, int height);
  wxCursor(const char *name);
  wxCursor(int cursor_type);
  ~wxCursor(void);
};

// Bitmap
class wxDC;
class wxBitmap: public wxbBitmap
{
 public:
  HBITMAP ms_bitmap;
  wxDC *selectedInto; // So bitmap knows whether it's been selected into
                      // a device context (for error checking)

  wxBitmap(void); // Platform-specific
  wxBitmap(char bits[], int width, int height, int depth = 1);
  wxBitmap(char *name);
  // If depth is omitted, will create a bitmap compatible with the display
  wxBitmap(int width, int height, int depth = -1);
  ~wxBitmap(void);
};

#endif // IN_CPROTO
#endif // wx_gdih
