/*
 * File:	wx_item.h
 * Purpose:	Declares base panel item class
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "@(#)wx_item.h	1.2 5/9/94" */

#ifndef wx_itemh
#define wx_itemh

#include "wb_item.h"

#ifdef IN_CPROTO
typedef       void    *wxItem ;
#else

// General item class
class wxItem: public wxbItem
{
 protected:
   Bool isFafa ;      // because we can mix Fafa/non-Fafa controls
 public:
   wxList subControls; // For controls like radiobuttons which are really composite
   FARPROC oldWndProc; // For subclassed controls
   wxBrush *backBrush ;
   wxItem(void);
   ~wxItem(void);

   void GetSize(int *width, int *height);
   void GetPosition(int *x, int *y);
   void SetSize(int x, int y, int width, int height);
   void SetClientSize(int width, int height);
   void SetFocus(void);
   void SetLabel(char *label);
   char *GetLabel(void);

   void Show(Bool show);
   float GetCharHeight(void);
   float GetCharWidth(void);
   void GetTextExtent(const char *string, float *x, float *y,
                      float *descent = NULL, float *externalLeading = NULL,
                      wxFont *the_font=NULL);

  virtual void SetBackgroundColour(wxColour*col) { backColour = col; };
  virtual void SetLabelColour(wxColour*col) { labelColour = col ; };
  virtual void SetButtonColour(wxColour*col) { buttonColour = col ; };

};

#endif // IN_CPROTO
#endif // wx_itemh
