/*
 * File:	wx_dc.h
 * Purpose:	wxDC device context declaration (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "@(#)wx_dc.h	1.2 5/9/94" */


#ifndef wx_dch
#define wx_dch

#ifdef __GNUG__
#pragma interface
#endif

#ifndef IN_CPROTO
#include <fstream.h>
#endif
#include "common.h"
#include "wx_frame.h"
#include "wx_gdi.h"
#include "wb_dc.h"

#ifdef IN_CPROTO
typedef       void    *wxDC ;
#else

class wxDC: public wxbDC
{
 public:
  wxDC(void) {}
  ~wxDC(void) {}
};

/*
 * X
 * Ok, so all this isn't neat, but it about works.
 */

// Logical to device
// Absolute
#define XLOG2DEV(x) (int)(((x) - logical_origin_x)*logical_scale_x*user_scale_x + device_origin_x + 0.5)
#define YLOG2DEV(y) (int)(((y) - logical_origin_y)*logical_scale_y*user_scale_y + device_origin_y + 0.5)

// Logical to device without the device translation
#define XLOG2DEV_2(x) (int)(((x) - logical_origin_x)*logical_scale_x*user_scale_x + 0.5)
#define YLOG2DEV_2(y) (int)(((y) - logical_origin_y)*logical_scale_y*user_scale_y + 0.5)

// Relative
#define XLOG2DEVREL(x) (int)((x)*logical_scale_x*user_scale_x + 0.5)
#define YLOG2DEVREL(y) (int)((y)*logical_scale_y*user_scale_y + 0.5)

// Device to logical
// Absolute
#define XDEV2LOG(x) (int)(((x) - device_origin_x)/(logical_scale_x*user_scale_x) + logical_origin_x)

#define YDEV2LOG(y) (int)(((y) - device_origin_y)/(logical_scale_y*user_scale_y) + logical_origin_y)

// Relative
#define XDEV2LOGREL(x) (int)((float)(x)/(logical_scale_x*user_scale_x))
#define YDEV2LOGREL(y) (int)((float)(y)/(logical_scale_y*user_scale_y))

#endif // IN_CPROTO
#endif // wx_dch
