/*
 * File:	wx_item.h
 * Purpose:	Declares panel items (controls/widgets) for X
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "@(#)wx_item.h	1.2 5/9/94" */

#ifndef wx_itemh
#define wx_itemh

#ifdef __GNUG__
#pragma interface
#endif

#include "common.h"
#include "wx_win.h"
#include "wx_panel.h"
#include "wb_item.h"

#ifdef wx_motif
#include <Xm/Label.h>
#include <Xm/Form.h>
#endif

#ifdef IN_CPROTO
typedef       void    *wxItem ;
#else

// General item class
class wxItem: public wxbItem
{
 public:
    wxItem(void);
   ~wxItem(void);
#ifdef wx_motif
   // Each item is a form/rowcol widget, optional label widget, plus a specific
   // widget
   Widget formWidget;
   Widget labelWidget;
   int itemOrientation;
   int rowNumber;
   int colNumber;
   void AttachWidget(wxPanel *panel, Widget formWidget,
                     int x, int y, int width, int height);
#endif

   void GetSize(int *width, int *height);
   void GetPosition(int *x, int *y);
   void SetSize(int x, int y, int width, int height);
   void SetFocus(void);
   void SetLabel(char *label);
   char *GetLabel(void);

   void Show(Bool show);
   void Enable(Bool enable);
   float GetCharHeight(void);
   float GetCharWidth(void);
   void GetTextExtent(const char *string, float *x, float *y,
                      float *descent = NULL, float *externalLeading = NULL,
                      wxFont *the_font = NULL);

  virtual void SetBackgroundColour(wxColour*col)
          { backColour = col; ChangeColour(); }
  virtual void SetLabelColour(wxColour*col)
          { labelColour = col ; ChangeColour(); }
  virtual void SetButtonColour(wxColour*col)
          { buttonColour = col ; ChangeColour(); }
  virtual void ChangeColour(void) {} ;

};

// Find the letter corresponding to the mnemonic, for Motif
char wxFindMnemonic(char *s);
#ifdef wx_motif
char *wxFindAccelerator(char *s) ;
XmString wxFindAcceleratorText(char *s) ;
#endif

#endif // IN_CPROTO
#endif // wx_itemh
