/*
 * File:	wx_panel.h
 * Purpose:	wxPanel subwindow, for panel items (widgets/controls)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "@(#)wx_panel.h	1.2 5/9/94" */

#ifndef wx_panelh
#define wx_panelh

#ifdef __GNUG__
#pragma interface
#endif

#include "common.h"
#include "wb_panel.h"

#ifdef wx_motif
#include <Xm/Xm.h>
#endif

#define PANEL_HSPACING  14
#define PANEL_VSPACING  12
#define PANEL_LEFT_MARGIN 4
#define PANEL_TOP_MARGIN  4

#ifdef IN_CPROTO
typedef       void    *wxPanel ;
#else

class wxItem;
class wxFrame;
class wxPanel: public wxbPanel
{
 public:
#ifdef wx_motif
  // For panel item positioning.
  int cursor_x;
  int cursor_y;
  int max_width;
  int max_height;
  int max_line_height;
  wxWindow *last_created ;

  Widget borderWidget;
  Widget panelWidget;
  Widget lastWidget;
  Widget firstRowWidget;
  Bool allRelative;  // If TRUE, all widgets are relatively placed so we can do
                     // some Motif-specific things to space them better
  int currentRow;
  int currentCol;
#endif
#ifdef wx_xview
   int x_create ;
   int y_create ;  // Where creation occurs in my father
#endif

  wxPanel(void);
  wxPanel(wxFrame *frame,
          int x=-1, int y=-1, int width=-1, int height=-1, long style=0,
          char *name = "panel");
  wxPanel(wxPanel *panel,
          int x=-1, int y=-1, int width=-1, int height=-1, long style=0,
          char *name = "panel" );

  ~wxPanel(void);

  Bool Create(wxFrame *frame,
          int x=-1, int y=-1, int width=-1, int height=-1, long style=0,
          char *name = "panel");
  Bool Create(wxPanel *panel,
          int x=-1, int y=-1, int width=-1, int height=-1, long style=0,
          char *name = "panel");

  void SetSize(int x, int y, int width, int height);
  void SetClientSize(int w, int h);
  void GetPosition(int *x, int *y);
  void Centre(int direction) ;
  virtual void Enable(Bool Flag) ;
  void AddChild(wxObject *child) ;

  // Start a new line
  void NewLine(void);
  void NewLine(int pixels);
#ifdef wx_motif
  void RealNewLine(void) ;
#endif
  // Tab specified number of pixels
  void Tab(void);
  void Tab(int pixels);

  void GetCursor(int *x, int *y);

  // Set/get horizontal spacing
  void SetHorizontalSpacing(int sp);
  int GetHorizontalSpacing(void);

  // Set/get vertical spacing
  void SetVerticalSpacing(int sp);
  int GetVerticalSpacing(void);

  // Fits the panel around the items
  void Fit(void);

  // Update next cursor position
  void AdvanceCursor(wxWindow *item);
#if wx_motif
  void RealAdvanceCursor(void);
#endif
  // If x or y are not specified (i.e. < 0), supply
  // values based on left to right, top to bottom layout.
  // Internal use only.
  void GetValidPosition(int *x, int *y);

#ifdef wx_motif
  void OptimizeLayout(void);
  void AttachWidget(wxPanel *panel, Widget formWidget,
                    int x, int y, int width, int height) ;
#endif
#ifdef wx_xview
  virtual void DragAcceptFiles(Bool accept = TRUE);
#endif

  void SetBackgroundColour(wxColour*col)
          { backColour = col; ChangeColour(); }
  void SetLabelColour(wxColour*col)
          { labelColour = col ; ChangeColour(); }
  void SetButtonColour(wxColour*col)
          { buttonColour = col ; ChangeColour(); }
  void ChangeColour(void) ;


};

#endif // IN_CPROTO
#endif // wx_panelh
