/*
 * File:	wxstring.cc
 * Purpose:	Very simple string class
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	August 1994
 * RCS_ID:      $Id: wxstring.cc,v 1.3 1994/08/14 21:34:01 edz Exp $
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifdef __GNUG__
#pragma implementation
#endif

#include "common.h"

// If not MS C++, don't include wx.h: we'll just include
// the minimum set of files.
// If MS C++, we'll use a precompiled header instead.
#if !defined(_MSC_VER) && !defined(wx_wxh)
#define wx_wxh
#endif

#include "wx.h"
#include "string.h"
#include "wxstring.h"
#include <ctype.h>

extern char *copystring(const char *);


wxString::wxString(const char *s)
{
  stringData = copystring(s ? s : "");
}

wxString::wxString(wxString& s)
{
  char *oldData = s.GetData();
  stringData = oldData ? copystring(oldData) : NULL;
}

wxString::~wxString(void)
{
  if (stringData)
    delete[] stringData;
}

void wxString::operator =(wxString& s)
{
  if (stringData)
    delete[] stringData;

  char *oldData = s.GetData();
  stringData = copystring(oldData ? oldData : "");
}

Bool wxString::operator ==(wxString& s)
{
  if (stringData && s.GetData())
    return (strcmp(stringData, s.GetData()) == 0);
  return FALSE;
}

Bool wxString::operator !=(wxString& s)
{
  if (stringData && s.GetData())
    return (strcmp(stringData, s.GetData()) != 0);
  return FALSE;
}

wxString wxString::operator +(wxString& s)
{
  char *s2 = s.GetData();

  if (s2 && stringData) {
    size_t len_s2 = strlen(s2);
    size_t len_stringData = strlen(stringData);

    char *s3 = new char[len_s2 + len_stringData + 1];
    memcpy(s3, stringData, len_stringData); // strcpy
    memcpy(s3 + len_stringData, s2, len_s2 + 1); // strcat

    wxString string;
    string.SetData(s3);
    return string;
  } else if (s2 == NULL && stringData) {
    wxString string(stringData);
    return string;
  } else if (s2 && stringData == NULL) {
    wxString string(s2);
    return string;
  } else  { // !s2 && !stringData
    wxString string;
    return string;
  }
}

void wxString::SetData(char *s)
{
  if (stringData)
    delete[] stringData;
  stringData = s ? s : copystring("");
}

wxString wxString::SubString(size_t from, size_t to)
{
  wxString string;

  if (stringData) {
    size_t len = strlen(stringData);

    if (from < len) {
      if (to >= len) to = len - 1;
      char *buf = new char[to - from + 2];
      for (int i = from; i <= to; i++)
        buf[i] = stringData[i];
      buf[i] = '\0';
      string.SetData(buf);
    }
  }
  return string;
}

wxString wxString::UpperCase(void)
{
  wxString string(stringData);
  if (stringData) {
    for (char *s = string.GetData(); *s; s++)
      *s = toupper(*s);	// Depends in LC_CTYPE 
  }
  return string;
}

wxString wxString::LowerCase(void)
{
  wxString string(stringData);
  if (stringData) {
    for(char *s = string.GetData(); *s; s++)
      *s = tolower(*s);	// Depends on LC_CTYPE
  }
  return string;
}
