# Symantec C++ makefile for the msw objects
# called from src\makefile.sc

# configuration section (see src\makefile.sc) ###########################

WXDIR = $(WXWIN)
INCDIR = $(WXDIR)\include
MSWINC = $(INCDIR)\msw
BASEINC = $(INCDIR)\base

# default values overridden by src\makefile.sc

CC=sc
CFLAGS = -o -ml -W -Dwx_msw

INCLUDE=$(BASEINC);$(MSWINC);$(WXDIR)\contrib\fafa;$(WXDIR)\contrib\itsybits

OPTIONS=

# end of configuration section ##########################################

.cc.obj:
	*$(CC) -c $(CFLAGS) -I$(INCLUDE) $(OPTIONS) $<

OBJS = wx_win.obj wx_frame.obj wx_panel.obj wx_utils.obj wx_main.obj \
wx_item.obj wx_text.obj wx_gdi.obj wx_dialg.obj wx_canvs.obj wx_dc.obj \
wx_mf.obj wx_ipc.obj wx_timer.obj wx_clipb.obj

all: $(OBJS)

wx_obj.obj: $(BASEINC)\wx_obj.h

wx_win.obj: $(BASEINC)\common.h $(MSWINC)\wx_win.h \
$(BASEINC)\wx_obj.h $(BASEINC)\wx_utils.h wx_win.cc \
$(MSWINC)\wx_gdi.h $(MSWINC)\wx_privt.h

wx_main.obj: $(BASEINC)\common.h $(BASEINC)\wx_obj.h \
$(MSWINC)\wx_frame.h $(BASEINC)\wx_utils.h

wx_frame.obj: $(BASEINC)\common.h $(MSWINC)\wx_win.h $(BASEINC)\wx_obj.h \
$(BASEINC)\wx_utils.h $(MSWINC)\wx_frame.h wx_frame.cc \
$(BASEINC)\wx_stdev.h $(MSWINC)\wx_privt.h

wx_panel.obj: $(BASEINC)\common.h $(MSWINC)\wx_win.h $(BASEINC)\wx_obj.h \
$(BASEINC)\wx_utils.h $(MSWINC)\wx_frame.h $(MSWINC)\wx_panel.h \
wx_panel.cc $(BASEINC)\wx_stdev.h $(MSWINC)\wx_privt.h

wx_text.obj: $(BASEINC)\common.h $(MSWINC)\wx_win.h $(BASEINC)\wx_obj.h \
$(BASEINC)\wx_utils.h $(MSWINC)\wx_frame.h $(MSWINC)\wx_text.h \
wx_text.cc $(BASEINC)\wx_stdev.h $(MSWINC)\wx_privt.h

wx_canvs.obj: $(BASEINC)\common.h $(MSWINC)\wx_win.h $(BASEINC)\wx_obj.h \
$(BASEINC)\wx_utils.h $(MSWINC)\wx_frame.h $(MSWINC)\wx_canvs.h \
wx_canvs.cc $(BASEINC)\wx_stdev.h $(MSWINC)\wx_gdi.h $(MSWINC)\wx_dc.h \
$(MSWINC)\wx_privt.h

wx_dc.obj: $(BASEINC)\common.h $(MSWINC)\wx_win.h $(BASEINC)\wx_obj.h \
$(BASEINC)\wx_utils.h $(MSWINC)\wx_frame.h $(MSWINC)\wx_canvs.h wx_dc.cc \
$(BASEINC)\wx_stdev.h $(MSWINC)\wx_gdi.h $(MSWINC)\wx_dc.h \
$(MSWINC)/wx_dccan.h $(MSWINC)/wx_dcmem.h

wx_mf.obj: $(BASEINC)\common.h $(MSWINC)\wx_win.h $(BASEINC)\wx_obj.h \
wx_mf.cc $(BASEINC)\wx_stdev.h $(MSWINC)\wx_gdi.h $(MSWINC)\wx_mf.h

wx_item.obj: $(BASEINC)\common.h $(MSWINC)\wx_win.h $(BASEINC)\wx_obj.h \
$(BASEINC)\wx_utils.h $(MSWINC)\wx_frame.h $(MSWINC)\wx_item.h \
wx_item.cc $(BASEINC)\wx_stdev.h $(MSWINC)\wx_privt.h

wx_utils.obj: $(BASEINC)\common.h $(BASEINC)\wx_obj.h \
$(BASEINC)\wx_utils.h wx_utils.cc

wx_ipc.obj: $(BASEINC)\common.h $(BASEINC)\wx_obj.h \
$(BASEINC)\wx_utils.h $(MSWINC)\wx_ipc.h wx_ipc.cc

wx_gdi.obj: $(BASEINC)\common.h $(MSWINC)\wx_gdi.h $(BASEINC)\wx_utils.h \
wx_gdi.cc

wx_dialg.obj: $(BASEINC)\common.h wx_dialg.cc $(MSWINC)\wx_dialg.h \
$(MSWINC)\wx_win.h $(BASEINC)\wx_utils.h $(MSWINC)\wx_panel.h \
$(MSWINC)\wx_privt.h

wx_timer.obj: $(BASEINC)\common.h wx_timer.cc $(MSWINC)\wx_timer.h

wx_clipb.obj: $(BASEINC)\common.h wx_clipb.cc $(BASEINC)\wx_clipb.h

$(MSWINC)/wx_win.h:  $(BASEINC)/wb_win.h
$(MSWINC)/wx_main.h:  $(BASEINC)/wb_main.h
$(MSWINC)/wx_frame.h:  $(BASEINC)/wb_frame.h
$(MSWINC)/wx_panel.h:  $(BASEINC)/wb_panel.h
$(MSWINC)/wx_text.h:  $(BASEINC)/wb_text.h
$(MSWINC)/wx_dialg.h:  $(BASEINC)/wb_dialg.h
$(MSWINC)/wx_ipc.h:  $(BASEINC)/wb_ipc.h
$(MSWINC)/wx_gdi.h:  $(BASEINC)/wb_gdi.h
$(MSWINC)/wx_event.h:  $(BASEINC)/wb_event.h
$(MSWINC)/wx_canvs.h:  $(BASEINC)/wb_canvs.h
$(MSWINC)/wx_mf.h:  $(BASEINC)/wb_mf.h
$(MSWINC)/wx_item.h:  $(BASEINC)/wb_item.h
$(MSWINC)/wx_buttn.h:  $(BASEINC)/wb_buttn.h
$(MSWINC)/wx_messg.h:  $(BASEINC)/wb_messg.h
$(MSWINC)/wx_choic.h:  $(BASEINC)/wb_choic.h
$(MSWINC)/wx_check.h:  $(BASEINC)/wb_check.h
$(MSWINC)/wx_lbox.h:  $(BASEINC)/wb_lbox.h
$(MSWINC)/wx_txt.h:  $(BASEINC)/wb_txt.h
$(MSWINC)/wx_mtxt.h:  $(BASEINC)/wb_mtxt.h
$(MSWINC)/wx_slidr.h:  $(BASEINC)/wb_slidr.h
$(MSWINC)/wx_menu.h:  $(BASEINC)/wb_menu.h

clean:
	-del *.obj
