/*
 * File:	wx_timer.cc
 * Purpose:	wxTimer implementation
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	August 1994
 * RCS_ID:      $Id: wx_timer.cc,v 1.1 1994/08/14 21:59:17 edz Exp $
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include "wx.h"
#pragma hdrstop
#include "wx_timer.h"
#include <time.h>
#include <sys/types.h>
#ifndef __SC__
#include <sys/timeb.h>
#endif
#ifdef WIN32
#define _EXPORT /**/
#else
#define _EXPORT _export
#endif

wxList wxTimerList(wxKEY_INTEGER);
UINT WINAPI _EXPORT wxTimerProc(HWND hwnd, WORD, int idTimer, DWORD);

wxTimer::wxTimer(void)
{
  id = 0;
}

wxTimer::~wxTimer(void)
{
  Stop();

  wxTimerList.DeleteObject(this);
}

Bool wxTimer::Start(int milliseconds,Bool mode)
{
  oneShot = mode ;
  if (milliseconds < 0)
    milliseconds = lastMilli;

  if (milliseconds <= 0)
    return FALSE;

  lastMilli = milli = milliseconds;

  wxTimerList.DeleteObject(this);
  TIMERPROC wxTimerProcInst = (TIMERPROC) MakeProcInstance((FARPROC)wxTimerProc,
                                          wxhInstance);

  id = SetTimer(NULL, (UINT)(id ? id : 1), (UINT)milliseconds, wxTimerProcInst);
  if (id > 0)
  {
    wxTimerList.Append(id, this);
    return TRUE;
  }
  else return FALSE;
}

void wxTimer::Stop(void)
{
  if (id) {
    KillTimer(NULL, (UINT)id);
    wxTimerList.DeleteObject(this); /* @@@@ */
  }
  id = 0 ;
  milli = 0 ;
}

UINT WINAPI _EXPORT wxTimerProc(HWND hwnd, WORD, int idTimer, DWORD)
{
  wxNode *node = wxTimerList.Find((long)idTimer);
  if (node)
  {
    wxTimer *timer = (wxTimer *)node->Data();
    if (timer->id==0)
      return(0) ; // Avoid to process spurious timer events
    timer->Notify();
    if (timer->oneShot)
      timer->Stop() ;
  }
  return 0;
}

