/*
 * File:      wx_panel.cc
 * Purpose:     wxPanel class implementation (X version)
 * Author:      Julian Smart
 * Created:     1993
 * Updated:	August 1994
 * RCS_ID:      $Id: wx_panel.cc,v 1.3 1994/08/14 21:28:43 edz Exp $
 * Copyright:   (c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "@(#)wx_panel.cc	1.2 5/9/94";

#ifdef __GNUG__
#pragma implementation
#endif

#include "common.h"
#include "wx_panel.h"
#include "wx_frame.h"
#include "wx_utils.h"
#include "wx_privt.h"

#ifdef wx_motif
#include <Xm/Form.h>
#include <Xm/BulletinB.h>
#include <Xm/PushB.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
extern int wxComputeColors (wxColour * backColour, wxColour * buttonColour);
#endif

#ifdef wx_xview
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/dragdrop.h>
extern void wxPanelEventProc (Panel panel, Event * event);	// See wx_item.cc
#endif

// Constructor
wxPanel::wxPanel (void)
{
  new_line = FALSE;
  label_position = wxHORIZONTAL;

  hSpacing = PANEL_HSPACING;
  vSpacing = PANEL_VSPACING;
  initial_hspacing = hSpacing;
  initial_vspacing = vSpacing;
  current_hspacing = hSpacing;
  current_vspacing = vSpacing;

  labelFont = NULL;
  buttonFont = NULL;
  backColour = NULL;
  labelColour = NULL;
  buttonColour = NULL;

#ifdef wx_motif
  // For absolute-positioning auto layout
  cursor_x = PANEL_LEFT_MARGIN;
  cursor_y = PANEL_TOP_MARGIN;
  max_height = 0;
  max_line_height = 0;
  max_width = 0;
  last_created = 0;
  borderWidget = 0;
  new_line = FALSE;		// @@@@

  firstRowWidget = NULL;
  lastWidget = NULL;
  panelWidget = NULL;
  allRelative = TRUE;
  currentRow = 0;
  currentCol = 0;
  handle = NULL;
#endif
#ifdef wx_xview
  x_create = 0;
  y_create = 0;
#endif
  has_child = FALSE;
}

wxPanel::wxPanel (wxFrame * frame, int x, int y, int width, int height,
	 long style, char *name):
wxbPanel (frame, x, y, width, height, style, name)
{
  Create (frame, x, y, width, height, style, name);
}

wxPanel::wxPanel (wxPanel * panel, int x, int y, int width, int height,
	 long style, char *name):
wxbPanel (panel, x, y, width, height, style, name)
{
  Create (panel, x, y, width, height, style, name);
}

Bool wxPanel::
Create (wxFrame * frame, int x, int y, int width, int height,
	long style, char *name)
{
  new_line = FALSE;
  label_position = wxHORIZONTAL;

  if (!frame)
    return FALSE;

  window_parent = frame;

  has_child = FALSE;
  windowStyle = style;

  hSpacing = PANEL_HSPACING;
  vSpacing = PANEL_VSPACING;

  initial_hspacing = hSpacing;
  initial_vspacing = vSpacing;

  current_hspacing = hSpacing;
  current_vspacing = vSpacing;

  labelFont = NULL;
  buttonFont = NULL;
  backColour = NULL;
  labelColour = NULL;
  buttonColour = NULL;

#ifdef wx_motif
  windowName = copystring (name);

  // For absolute-positioning auto layout
  cursor_x = PANEL_LEFT_MARGIN;
  cursor_y = PANEL_TOP_MARGIN;
  max_height = 0;
  max_line_height = 0;
  max_width = 0;

  borderWidget = 0;

  firstRowWidget = NULL;
  lastWidget = NULL;
  allRelative = TRUE;

  currentRow = 0;
  currentCol = 0;

  last_created = 0;

  // Must create panel big for Motif to resize properly later
  if (width == -1)
    width = 1000;
  if (height == -1)
    height = 1000;

  if (style & wxBORDER)
    {
      borderWidget = XtVaCreateManagedWidget ("panelBorder",
				      xmFrameWidgetClass, frame->clientArea,
					      XmNshadowType, XmSHADOW_IN,
					      XmNmarginHeight, 0,
					      XmNmarginWidth, 0,
					      XmNwidth, width,	// 9/3/94 JACS
					       XmNheight, height,
					      NULL);
    }

  panelWidget = XtVaCreateManagedWidget (windowName,
                            xmBulletinBoardWidgetClass,
			    borderWidget ? borderWidget : frame->clientArea,
/*
   XmNresizePolicy, XmRESIZE_NONE,
   XmNmarginHeight, 0,
   XmNmarginWidth, 0,
 */
					 XmNwidth, width,	// 9/3/94 JACS
					  XmNheight, height,
					 NULL);

/* JACS 9/3/94
   XtVaSetValues(panelWidget,
   XmNresizePolicy, XmRESIZE_NONE,
   NULL) ;
 */

  if (style & wxFLAT)
    XtVaSetValues (panelWidget,
		   XmNborderWidth, 1,
		   NULL);

  handle = (char *) panelWidget;

  if (wxWidgetHashTable->Get ((long) panelWidget))
    {
      wxError ("Widget table clash in wx_panel.cc");
    }

  wxWidgetHashTable->Put ((long) panelWidget, this);

  XtTranslations ptr;
  XtOverrideTranslations (panelWidget,
		   ptr = XtParseTranslationTable ("<Configure>: resize()"));

  XtFree ((char *) ptr);

  SetSize (x, y, width, height);
#endif
#ifdef wx_xview
  int real_y = frame->y_offset;
  if (y > -1)
    real_y = y + frame->y_offset;	// Allow for possible menu bar

  Bool scrollable = style & wxVSCROLL;

  Frame x_frame = (Frame) (frame->GetHandle ());
  Panel x_panel = (Panel) xv_create (x_frame, scrollable ? SCROLLABLE_PANEL : PANEL,
				     PANEL_BACKGROUND_PROC, wxPanelEventProc,
				     PANEL_ACCEPT_KEYSTROKE, TRUE,
				     WIN_CLIENT_DATA, (char *) this,
			     PANEL_LAYOUT, PANEL_HORIZONTAL, XV_SHOW, FALSE,
				     NULL);
  Scrollbar sb;
  if (scrollable)
    sb = xv_create (x_panel, SCROLLBAR,
		    NULL);

  if (x > -1)
    {
      xv_set (x_panel, XV_X, x, NULL);
      x_create = x;
    }
  else
    x_create = 0;

  if (y > -1)
    xv_set (x_panel, XV_Y, real_y, NULL);

  y_create = real_y;

  // If width = -1, will extend to edge of frame
  xv_set (x_panel, XV_WIDTH, width, NULL);

  if (height > -1)
    xv_set (x_panel, XV_HEIGHT, height, NULL);

  xv_set (x_panel, XV_SHOW, TRUE, NULL);

  handle = (char *) x_panel;
#endif
  if (frame)
    frame->AddChild (this);
  return TRUE;
}

Bool wxPanel::
Create (wxPanel * frame, int x, int y, int width, int height, long style, char *name)
{
  if (frame)
    {
      frame->AddChild (this);
    }

  new_line = FALSE;
  label_position = wxHORIZONTAL;

  window_parent = frame;

  has_child = FALSE;

  hSpacing = PANEL_HSPACING;
  vSpacing = PANEL_VSPACING;

  initial_hspacing = hSpacing;
  initial_vspacing = vSpacing;

  current_hspacing = hSpacing;
  current_vspacing = vSpacing;

  labelFont = frame->labelFont;
  buttonFont = frame->buttonFont;
  backColour = frame->backColour;
  labelColour = frame->labelColour;
  buttonColour = frame->buttonColour;

#ifdef wx_motif
  windowName = copystring (name);
  borderWidget = 0;
  firstRowWidget = NULL;
  lastWidget = NULL;
  allRelative = TRUE;
  currentRow = 0;
  currentCol = 0;

  last_created = 0;

  if (style & wxBORDER)
    {
      borderWidget = XtVaCreateManagedWidget ("main_window",
				     xmFrameWidgetClass, frame->panelWidget,
					      XmNshadowType, XmSHADOW_IN,
					      XmNmarginHeight, 0,
					      XmNmarginWidth, 0,
					      NULL);
    }
  else if (style & wxFLAT)
    {
      borderWidget = XtVaCreateManagedWidget ("main_window",
				 xmRowColumnWidgetClass, frame->panelWidget,
					      XmNpacking, XmPACK_NONE,
					      XmNmarginHeight, 0,
					      XmNmarginWidth, 0,
					      XmNborderWidth, 1,
					      NULL);
    }

  panelWidget = XtVaCreateManagedWidget (windowName,
                           xmBulletinBoardWidgetClass,
			   borderWidget ? borderWidget : frame->panelWidget,
					 NULL);

  XtVaSetValues (panelWidget,
		   XmNresizePolicy, XmRESIZE_NONE,
		   NULL);

  handle = (char *) panelWidget;


  frame->AdvanceCursor (this);

  AttachWidget (frame, borderWidget ? borderWidget : panelWidget, x, y, width, height);
  //SetSize(x, y, width, height);
  ChangeColour ();
#endif
#ifdef wx_xview

  // Compute my creation pos.
  wxPanel *father = (wxPanel *) GetParent ();
  father->GetCursor (&x_create, &y_create);
  if (y > -1)
    y_create += y;
  if (x > -1)
    x_create += x;

  int x_orig, y_orig;
  x_orig = x_create;
  y_orig = y_create;
  while (!wxSubType (father->__type, wxTYPE_FRAME))
    {
      x_orig += father->x_create;
      y_orig += father->y_create;
      father = (wxPanel *) (father->GetParent ());
    }

  Bool scrollable = style & wxVSCROLL;

  Frame x_frame = (Frame) (father->GetHandle ());
  Panel x_panel = (Panel) xv_create (x_frame, scrollable ? SCROLLABLE_PANEL : PANEL,
				     PANEL_BACKGROUND_PROC, wxPanelEventProc,
				     PANEL_ACCEPT_KEYSTROKE, TRUE,
				     WIN_CLIENT_DATA, (char *) this,
			     PANEL_LAYOUT, PANEL_HORIZONTAL, XV_SHOW, FALSE,
				     NULL);
  Scrollbar sb;
  if (scrollable)
    sb = xv_create (x_panel, SCROLLBAR,
		    NULL);

  xv_set (x_panel, XV_X, x_orig, NULL);

  xv_set (x_panel, XV_Y, y_orig, NULL);

  // If width = -1, will extend to edge of frame
  xv_set (x_panel, XV_WIDTH, width, NULL);

  if (height > -1)
    xv_set (x_panel, XV_HEIGHT, height, NULL);

  xv_set (x_panel, XV_SHOW, TRUE, NULL);

  handle = (char *) x_panel;
#endif
  return TRUE;

}


wxPanel::~wxPanel (void)
{
#ifdef wx_motif
  if (borderWidget)
    {
      // This patch come from Torsten. (lier@lier1)
      // I do not know if it is needed in j1 version??
      wxWidgetHashTable->Delete ((long) borderWidget);
      XtDestroyWidget (borderWidget);
    }
#endif
}

void wxPanel:: SetSize (int x, int y, int w, int h)
{
#ifdef wx_motif
  Dimension yy1, yy2;
  // Test
  XtVaGetValues (panelWidget, XmNheight, &yy2, NULL);

  Widget ancestor = borderWidget ? borderWidget : panelWidget;

  // Experimental... seems to vastly improve panel placement
  // after the first SetSize.
  XtUnmanageChild (borderWidget ? borderWidget : panelWidget);

  if (x > -1)
    {
      if (XtIsSubclass (ancestor, xmFormWidgetClass))
	XtVaSetValues (ancestor,
		       XmNx, x,
		       XmNleftAttachment, XmATTACH_SELF,
		       NULL);
      else
	XtVaSetValues (ancestor,
		       XmNx, x,
		       NULL);

/*
   XtVaSetValues(borderWidget ? borderWidget : panelWidget,
   XmNx, x, 
   NULL);
 */
    }
  if (y > -1)
    {
      if (XtIsSubclass (ancestor, xmFormWidgetClass))
	XtVaSetValues (ancestor,
		       XmNy, y,
		       XmNtopAttachment, XmATTACH_SELF,
		       NULL);
      else
	XtVaSetValues (ancestor,
		       XmNy, y,
		       NULL);

/*
   XtVaSetValues(borderWidget ? borderWidget : panelWidget,
   XmNy, y,
   NULL);
 */
    }

  if (w > -1)
    {
      // I can't remember why, but order of setting is important!
      if (borderWidget)
	XtVaSetValues (borderWidget, XmNwidth, w, NULL);
      XtVaSetValues (panelWidget, XmNwidth, w, NULL);
      // Test
      XtVaGetValues (panelWidget, XmNheight, &yy2, NULL);
    }

  if (h > -1)
    {
      // Test
      XtVaGetValues (panelWidget, XmNheight, &yy2, NULL);
      // I can't remember why, but order of setting is important!
      if (borderWidget)
	XtVaSetValues (borderWidget, XmNheight, h, NULL);

      // Test
      XtVaGetValues (panelWidget, XmNheight, &yy2, NULL);

      XtVaSetValues (panelWidget, XmNheight, h, NULL);

      // Test
      XtVaGetValues (panelWidget, XmNheight, &yy1, NULL);
    }

  // Experimental...
  XtManageChild (borderWidget ? borderWidget : panelWidget);
  // Again, can't remember why, but this call must be done.
  wxWindow::SetClientSize (w, h);
//  XtVaGetValues(panelWidget, XmNheight, &yy1, NULL);
#endif
#ifdef wx_xview
  if (x == -1 || y == -1)
    {
      int xx, yy;
      GetPosition (&xx, &yy);
      if (x == -1)
	x = xx;
      if (y == -1)
	y = yy;
    }

  if (w == -1 || h == -1)
    {
      int ww, hh;
      GetSize (&ww, &hh);
      if (w == -1)
	w = ww;
      if (h == -1)
	h = hh;
    }

  int real_y = y;

  if (window_parent && wxSubType (window_parent->__type, wxTYPE_FRAME))
    real_y += ((wxFrame *) window_parent)->y_offset;	// Allow for possible menu bar

  Xv_opaque object = (Xv_opaque) handle;

  (void) xv_set (object, XV_X, x, XV_Y, real_y, NULL);

  (void) xv_set (object, XV_WIDTH, w, XV_HEIGHT, h, NULL);
#endif
  OnSize (w, h);
}

void wxPanel:: SetClientSize (int w, int h)
{
#ifdef wx_motif
  SetSize (-1, -1, w, h);
#endif
#ifdef wx_xview
  wxWindow::SetClientSize (w, h);
#endif
}

void wxPanel:: GetPosition (int *x, int *y)
{
#ifdef wx_motif
  Dimension xx, yy;
  XtVaGetValues (borderWidget ? borderWidget : (Widget) handle,
		 XmNx, &xx, XmNy, &yy, NULL);
  *x = xx;
  *y = yy;
#else
  wxWindow::GetPosition (x, y);

  if (window_parent && wxSubType (window_parent->__type, wxTYPE_FRAME))
    *y = *y - ((wxFrame *) window_parent)->y_offset;	// Allow for menu bar
#endif
}

/*****************************************************************
 * ITEM PLACEMENT FUNCTIONS
 *****************************************************************/


// Start a new line
#ifdef wx_motif
void wxPanel:: RealNewLine (void)
{
  //cursor_x = PANEL_LEFT_MARGIN;
  cursor_x = initial_hspacing;
  if (max_line_height == 0)
    {
      cursor_y += current_vspacing;
    }
  else
    cursor_y += current_vspacing + max_line_height;
  max_line_height = 0;
  new_line = FALSE;
}
#endif

void wxPanel:: NewLine (void)
{
#ifdef wx_motif
  if (new_line)
    current_vspacing += vSpacing;
  else
    current_vspacing = vSpacing;
  new_line = TRUE;
#endif
#ifdef wx_xview
  Panel panel = (Panel) handle;
  if (new_line)
    {
      (void) xv_create (panel, PANEL_MESSAGE,
			PANEL_LAYOUT, PANEL_HORIZONTAL,
			PANEL_NEXT_ROW, vSpacing, NULL);
    }
  new_line = TRUE;
#endif
}

void wxPanel:: NewLine (int pixels)
{
#ifdef wx_motif
  if (new_line)
    current_vspacing += pixels;
  else
    current_vspacing = pixels;
  new_line = TRUE;
#endif
#ifdef wx_xview
  Panel panel = (Panel) handle;
  if (new_line)
    {
      (void) xv_create (panel, PANEL_MESSAGE,
			PANEL_LAYOUT, PANEL_HORIZONTAL,
			PANEL_NEXT_ROW, pixels, NULL);
    }
  new_line = TRUE;
#endif
}

void wxPanel:: Tab (void)
{
#ifdef wx_motif
  // If we're doing a newline on a bulletin board, we work this
  // out ourselves.
  cursor_x += hSpacing;
  if (cursor_x > max_width)
    max_width = cursor_x;
#endif
#ifdef wx_xview
  current_hspacing += hSpacing;
  Panel panel = (Panel) handle;
  (void) xv_set (panel, PANEL_ITEM_X_GAP, current_hspacing, NULL);
#endif
}

void wxPanel:: Tab (int pixels)
{
#ifdef wx_motif
  // If we're doing a newline on a bulletin board, we work this
  // out ourselves.
  cursor_x += pixels;
  if (cursor_x > max_width)
    max_width = cursor_x;
#endif
#ifdef wx_xview
  current_hspacing += pixels;
  Panel panel = (Panel) handle;

/*
   (void) xv_create(panel, PANEL_MESSAGE,
   PANEL_LAYOUT, PANEL_HORIZONTAL,
   XV_WIDTH, pixels,
   NULL);
 */
  (void) xv_set (panel, PANEL_ITEM_X_GAP, current_hspacing, NULL);
#endif
}

void wxPanel:: GetCursor (int *x, int *y)
{
#ifdef wx_motif
  *x = cursor_x;
  *y = cursor_y;
#endif
#ifdef wx_xview
  Xv_opaque object = (Xv_opaque) handle;
  *x = (int) xv_get (object, PANEL_ITEM_X);
  *y = (int) xv_get (object, PANEL_ITEM_Y);
#endif
}

// Set/get horizontal spacing
void wxPanel:: SetHorizontalSpacing (int sp)
{
#ifdef wx_motif
  hSpacing = sp;
  current_hspacing = sp;
/*
   XtVaSetValues((Widget)handle,
   XmNmarginWidth, sp,
   NULL);
 */
#endif
#ifdef wx_xview
  Xv_opaque object = (Xv_opaque) handle;
  (void) xv_set (object, PANEL_ITEM_X_GAP, sp, NULL);
#endif
}

int wxPanel:: GetHorizontalSpacing (void)
{
#ifdef wx_motif
  return hSpacing;
#endif
#ifdef wx_xview
  Xv_opaque object = (Xv_opaque) handle;
  return (int) xv_get (object, PANEL_ITEM_X_GAP);
#endif
}

// Set/get vertical spacing
void wxPanel:: SetVerticalSpacing (int sp)
{
#ifdef wx_motif
  vSpacing = sp;
  current_vspacing = sp;
/*
   XtVaSetValues((Widget)handle,
   XmNmarginHeight, sp,
   NULL);
 */
#endif
#ifdef wx_xview
  Xv_opaque object = (Xv_opaque) handle;
  (void) xv_set (object, PANEL_ITEM_Y_GAP, sp, NULL);
#endif
}

int wxPanel:: GetVerticalSpacing (void)
{
#ifdef wx_motif
  return vSpacing;
#endif
#ifdef wx_xview
  Xv_opaque object = (Xv_opaque) handle;
  return (int) xv_get (object, PANEL_ITEM_Y_GAP);
#endif
}

// Fits the panel around the items
void wxPanel:: Fit (void)
{
#ifdef wx_motif
  RealAdvanceCursor ();
  SetClientSize (max_width + initial_hspacing, max_height + initial_vspacing);
#endif
#ifdef wx_xview
//  Xv_opaque object = (Xv_opaque)handle;
  // Pre-fit
  //  window_fit(object); // Doesn't seem to work always
  int maxX = 0;
  int maxY = 0;
  for(wxNode *node = GetChildren ()->First (); node; node = node->Next())
    {
      wxWindow *win = (wxWindow *) node->Data ();
      if ((wxSubType (win->__type, wxTYPE_PANEL) &&
	   !wxSubType (win->__type, wxTYPE_DIALOG_BOX)) ||
	  wxSubType (win->__type, wxTYPE_TEXT_WINDOW) ||
	  wxSubType (win->__type, wxTYPE_ITEM) ||
	  wxSubType (win->__type, wxTYPE_CANVAS))
	{
	  int x, y, w, h;
	  win->GetPosition (&x, &y);
	  win->GetSize (&w, &h);
	  if ((x + w) > maxX)
	    maxX = x + w;
	  if ((y + h) > maxY)
	    maxY = y + h;
	}
    }

  // Add subpanels
  wxNode *child = children->First ();
//  int ww,hh ;
  //  GetSize(&ww,&hh) ;
  while (child)
    {
      wxPanel *panel = (wxPanel *) child->Data ();
      child = child->Next ();
      if (!wxSubType (panel->__type, wxTYPE_PANEL))
	continue;
      panel->Fit ();
      int cw, ch;
      GetSize (&cw, &ch);
      cw += panel->x_create;
      ch += panel->y_create;
      if (cw > maxX)
	maxX = cw;
      if (ch > maxY)
	maxY = ch;
    }
  SetClientSize (maxX, maxY);
#endif
}

#ifdef wx_motif
// Update next cursor position
void wxPanel:: RealAdvanceCursor (void)
{
  wxWindow *item = last_created;
  if (item)
    {
      int width, height;
      int x, y;
      item->GetSize (&width, &height);
      item->GetPosition (&x, &y);

      if ((x + width) > max_width)
	max_width = x + width;
      if ((y + height) > max_height)
	max_height = y + height;
      if (height > max_line_height)
	max_line_height = height;
/*
   fprintf(stderr,"maxwidth %d maxheight %d maklineheight %d\n",
   max_width,max_height,max_line_height);
   fprintf(stderr,"Newline %d\n",new_line) ;
 */
      cursor_x = x + width + current_hspacing;
      cursor_y = y;
      last_created = NULL;
    }
  // Don't give a newline if we're starting the top row
  if (new_line)
    RealNewLine ();
}
#endif

// Update next cursor position
void wxPanel:: AdvanceCursor (wxWindow * item)
{
#ifdef wx_motif
  // For calculating positions on a bulletin board.
  /*
     int width, height;
     int x, y;
     item->GetSize(&width, &height);
     item->GetPosition(&x, &y);

     if ((x + width) > max_width)
     max_width = x + width;
     if ((y + height) > max_height)
     max_height = y + height;
     if (height > max_line_height)
     max_line_height = height;

     cursor_x = x + width + hSpacing;
     cursor_y = y;
   */
  last_created = item;
#endif
#ifdef wx_xview
#endif
}

// If x or y are not specified (i.e. < 0), supply
// values based on left to right, top to bottom layout.
// Internal use only.
void wxPanel:: GetValidPosition (int *x, int *y)
{
#ifdef wx_motif
  // For calculating positions on a bulletin board.
  if (*x < 0)
    *x = cursor_x;

  if (*y < 0)
    *y = cursor_y;
#endif
#ifdef wx_xview
#endif
}

#ifdef wx_xview
void wxPanel:: DragAcceptFiles (Bool accept)
{

/*
   if (accept)
   {
   if (dropSite)
   xv_destroy(dropSite);

   Xv_Window pw = xv_get((Panel)handle, PANEL_FIRST_PAINT_WINDOW, NULL);
   dropSite = xv_create(pw, DROP_SITE_ITEM,
   DROP_SITE_ID, NewId(),
   DROP_SITE_REGION, xv_get(pw, WIN_RECT),
   DROP_SITE_EVENT_MASK, DND_ENTERLEAVE,
   NULL);
   }
   else if (dropSite) xv_destroy(dropSite);
 */
}
#endif


#ifdef wx_motif
void wxPanel::
AttachWidget (wxPanel * panel, Widget formWidget,
	      int x, int y, int width, int height)
{

//fprintf(stderr,"Subpanel %x Panel %x\n",this,panel) ;
  //fprintf(stderr,"Panel: ih %d iv %d ch %d cv %d hs %d vs %d\n",
  //      panel->initial_hspacing,panel->initial_vspacing,
  //      panel->current_hspacing,panel->current_vspacing,
  //      panel->hSpacing,panel->vSpacing) ;

  if ((x > -1) || (y > -1))
    panel->allRelative = FALSE;

  //itemOrientation = panel->label_position;

  wxWidgetHashTable->Put ((long) formWidget, this);
  XtTranslations ptr;
  XtOverrideTranslations (formWidget,
		   ptr = XtParseTranslationTable ("<Configure>: resize()"));
  XtFree ((char *) ptr);

  SetSize (x, y, width, height);
}
#endif

void wxPanel:: Centre (int direction)
{
  int x, y, width, height, panel_width, panel_height, new_x, new_y;

  wxPanel *father = (wxPanel *) GetParent ();
  if (!father)
    return;

  father->GetClientSize (&panel_width, &panel_height);
  GetSize (&width, &height);
  GetPosition (&x, &y);

  new_x = -1;
  new_y = -1;

  if (direction & wxHORIZONTAL)
    new_x = (int) ((panel_width - width) / 2);

  if (direction & wxVERTICAL)
    new_y = (int) ((panel_height - height) / 2);

  SetSize (new_x, new_y, -1, -1);

}

void wxPanel:: Enable (Bool Flag)
{
#ifdef wx_motif
  if (panelWidget)
    XtSetSensitive (panelWidget, Flag);
#endif
}

void wxPanel:: AddChild (wxObject * child)
{

  if (!has_child)
    {
      initial_hspacing = hSpacing;
      initial_vspacing = vSpacing;
#ifdef wx_motif
/*
   if (borderWidget)
   {
   XtVaSetValues(borderWidget,
   XmNmarginHeight,initial_vspacing,
   XmNmarginWidth,initial_hspacing,
   NULL) ;
   initial_hspacing = 0 ;
   initial_vspacing = 0 ;
   }
 */
#endif
    }
  has_child = TRUE;

#ifdef wx_motif
  cursor_x = hSpacing;
  cursor_y = vSpacing;
  RealAdvanceCursor ();
#endif

  current_hspacing = hSpacing;
  current_vspacing = vSpacing;

  children->Append (child);
}

void wxPanel:: ChangeColour (void)
{
#ifdef wx_motif
  int change = wxComputeColors (backColour, buttonColour);

  if (change == wxBACK_COLORS)
    {
      if (borderWidget)
	XtVaSetValues (panelWidget,
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       XmNborderColor, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      XtVaSetValues (panelWidget,
		     XmNbackground, itemColors[wxBACK_INDEX].pixel,
		     XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		     XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     XmNborderColor, itemColors[wxFORE_INDEX].pixel,
		     NULL);
    }
  else if (change == wxFORE_COLORS)
    {
      if (borderWidget)
	XtVaSetValues (panelWidget,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       XmNborderColor, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      XtVaSetValues (panelWidget,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     XmNborderColor, itemColors[wxFORE_INDEX].pixel,
		     NULL);
    }

#endif
}
