/*
 * File:	bgdi.h
 * Purpose:	wxWindows GUI builder -- GDI stuff
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef bgdih
#define bgdih

#include "bwin.h"

class BuildFontData: public wxObject
{
 public:
  char *fontName;
  char *fontFamily;
  char *fontStyle;
  char *fontWeight;
  int fontSize;
  wxFont *font;
  
  BuildFontData(void);
  ~BuildFontData(void);

  wxFont *CreateFont(void);
  Bool Edit(void);
};

class FontManagerDialog: public wxDialogBox
{
 public:
  wxListBox *listbox;
  FontManagerDialog(wxFrame *frame, char *title, int x, int y, int w, int h);
};

class FontManager: public wxList
{
 public:
  FontManagerDialog *dialog;
  FontManager(void);
  ~FontManager(void);

  void Show(Bool show);
  void ReadFonts(PrologDatabase *database);
  void WriteFonts(PrologDatabase *database);
};

wxFont *FindFont(char *fontName);

void FontManagerProc(wxListBox& lbox, wxCommandEvent& event);
void FontOkProc(wxButton& but, wxCommandEvent& event);
void FontHelpProc(wxButton& but, wxCommandEvent& event);
void AddFontProc(wxButton& but, wxCommandEvent& event);
void DeleteFontProc(wxButton& but, wxCommandEvent& event);

extern FontManager TheFontManager;

#endif // bgdih

