/*
 * File:	btree.cc
 * Purpose:	wxWindows GUI builder: window hierarchy tree
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include "wx.h"
#include <ctype.h>
#include <stdlib.h>

#include "btree.h"
#include "bwin.h"
#include "bframe.h"

#ifdef wx_x
#include "bitmaps/treeicn.xbm"
#endif

wxList BuildWindowList;
BuilderTree *TheBuilderTree = NULL;
BuilderTreeFrame *TheBuilderTreeFrame = NULL;
float TopNodeX = 0.0;
float TopNodeY = 0.0;

void BuilderTree::MakeBuildWindowList(void)
{
  BuildWindowList.Clear();
  wxList children;
  children.Append((wxObject *)1);
  MakeBuildWindowList1(children);
}

void BuilderTree::MakeBuildWindowList1(wxList children)
{
  wxNode *node = children.First();
  while (node)
  {
    BuildWindowData *win = (BuildWindowData *)node->Data();
    BuildWindowList.Append(win);
    wxList children2;
    GetChildren((long)win, children2);
    MakeBuildWindowList1(children2);

    node = node->Next();
  }
}

void BuilderTree::GetChildren(long id, wxList& children)
{
  if (id == 1) // Root - get all main windows
  {
    wxNode *node = buildApp.topLevelWindows.First();
    while (node)
    {
      BuildWindowData *win = (BuildWindowData *)node->Data();
      children.Append(win);
      node = node->Next();
    }
  }
  else
  {
    BuildWindowData *win = (BuildWindowData *)id;
  
    wxNode *node = win->children.First();
    while (node)
    {
      BuildWindowData *child = (BuildWindowData *)node->Data();
      children.Append(child);
      node = node->Next();
    }
    if (win->windowType == wxTYPE_FRAME)
    {
      BuildFrameData *frame = (BuildFrameData *)win;
//      children.Append((wxObject *)frame->buildMenuBar);
      if (frame->toolbar)
        children.Append((wxObject *)frame->toolbar);
    }
  }
}

char *BuilderTree::GetNodeName(long id)
{
  if (id == 1)
    return buildApp.appClass;
  BuildWindowData *win = (BuildWindowData *)id;
  if (win->windowType == wxTYPE_MENU_BAR)
    return "Menu bar";
  else
  {
    if (win->name)
      return win->name;
  }
  return "<unknown name>";
}

long BuilderTree::GetNextNode(long id)
{
  wxNode *node = BuildWindowList.Member((wxObject *)id);
  if (node)
  {
    wxNode *next = node->Next();
    if (next)
      return (long)next->Data();
    else return -1;
  }
  else return -1;
}

long BuilderTree::GetNodeParent(long id)
{
  if (id == 1)
    return -1;

  BuildWindowData *win = (BuildWindowData *)id;
  if (win->buildParent)
    return (long)win->buildParent;
  else
    return 1;
}

float BuilderTree::GetNodeX(long id)
{
  if (id == -1)
    return 0.0;
  if (id == 1)
    return TopNodeX;

  BuildWindowData *win = (BuildWindowData *)id;
  return win->treeX;
}

float BuilderTree::GetNodeY(long id)
{
  if (id == -1)
    return 0.0;
  if (id == 1)
    return TopNodeY;

  BuildWindowData *win = (BuildWindowData *)id;
  return win->treeY ;
}

void BuilderTree::GetNodeSize(long id, float *x, float *y)
{
  if (id == -1)
    return;
  if (!TheBuilderTree)
  {
    wxTreeLayout::GetNodeSize(id, x, y);
    return;
  }
  char *name = GetNodeName(id);
  TheBuilderTreeFrame->canvas->GetDC()->GetTextExtent(name, x, y);
}

void BuilderTree::SetNodeX(long id, float x)
{
  if (id == -1)
    return;
  if (id == 1)
  {
    TopNodeX = x;
    return;
  }

  BuildWindowData *win = (BuildWindowData *)id;
  win->treeX = x;
}

void BuilderTree::SetNodeY(long id, float y)
{
  if (id == -1)
    return;
  if (id == 1)
  {
    TopNodeY = y;
    return;
  }

  BuildWindowData *win = (BuildWindowData *)id;
  win->treeY = y;
}

long BuilderTree::NodeHitTest(float x, float y)
{
  wxNode *node = BuildWindowList.First();
  while (node)
  {
    long id = (long)node->Data();
    float xpos = GetNodeX(id);
    float ypos = GetNodeY(id);
    float w, h;
    GetNodeSize(id, &w, &h);
    if ((x >= xpos) && (y >= ypos) && (x <= (xpos + w)) && (y <= ypos + h))
      return id;

    node = node->Next();
  }
  return -1;
}

void ClearTree(void)
{
  if (TheBuilderTreeFrame)
  {
    TheBuilderTreeFrame->canvas->GetDC()->Clear();
    TheBuilderTree->SetTopNode(-1);
    BuildWindowList.Clear();
  }
}

void DisplayTree(Bool show)
{
  if (!TheBuilderTreeFrame)
  {
    if (!show)
      return;

    TheBuilderTreeFrame = new BuilderTreeFrame(NULL, "Window Hierarchy",
      buildApp.treeX, buildApp.treeY, buildApp.treeWidth, buildApp.treeHeight,
      wxSDI | wxDEFAULT_FRAME);
  }

  if (!TheBuilderTree)
  {
    TheBuilderTree = new BuilderTree(TheBuilderTreeFrame->canvas->GetDC());
    TheBuilderTree->SetSpacing(20, 20);
    TheBuilderTree->SetMargins(20, 20);
  }
  TheBuilderTree->SetDC(TheBuilderTreeFrame->canvas->GetDC());
  BuildWindowList.Clear();
  TheBuilderTree->SetTopNode(1);
  TheBuilderTree->MakeBuildWindowList();
  TheBuilderTree->DoLayout((long)1);
  TheBuilderTreeFrame->Show(TRUE);
  if (show)
    TheBuilderTreeFrame->Iconize(FALSE);
  TheBuilderTree->Draw();
}

void CloseTreeFrame(void)
{
  if (TheBuilderTreeFrame)
  {
    wxFrame *fr = TheBuilderTreeFrame;
    fr->OnClose();
    delete fr;
  }
}

BuilderTreeCanvas::BuilderTreeCanvas(wxFrame *frame, int x, int y, int w, int h, long style):
  wxCanvas(frame, x, y, w, h, style)
{
}

BuilderTreeFrame::BuilderTreeFrame(wxFrame *frame, char *title, int x, int y, int w, int h, long style):
  wxFrame(frame, title, x, y, w, h, style)
{
  canvas = new BuilderTreeCanvas(this, 0, 0, 200, 200, wxRETAINED);
  canvas->SetScrollbars(20, 20, 50, 50, 4, 4);
  canvas->SetFont(SmallButtonFont);
  // Give it an icon
#ifdef wx_msw
  wxIcon *icon = new wxIcon("treeicn");
#endif
#ifdef wx_x
  wxIcon *icon = new wxIcon(treeicn_bits, treeicn_width, treeicn_height);
#endif
  SetIcon(icon);
#ifdef wx_x
  // X needs a helping hand...
  OnSize(w, h);
#endif  
}

Bool BuilderTreeFrame::OnClose(void)
{
  if (!Iconized())
  {
    GetPosition(&buildApp.treeX, &buildApp.treeY);
    GetSize(&buildApp.treeWidth, &buildApp.treeHeight);
  }
  TheBuilderTreeFrame = NULL;
  return TRUE;
}

void BuilderTreeCanvas::OnPaint(void)
{
  if (TheBuilderTree)
    TheBuilderTree->Draw();
}

void BuilderTreeCanvas::OnEvent(wxMouseEvent& event)
{
  if (!TheBuilderTree)
    return;

  if (event.LeftDown())
  {
    long id = TheBuilderTree->NodeHitTest(event.x, event.y);
    if (id > -1)
    {
      if (id != 1)
      {
        BuildWindowData *win = (BuildWindowData *)id;
        if (wxSubType(win->windowType, wxTYPE_DIALOG_BOX) ||
            wxSubType(win->windowType, wxTYPE_FRAME))
        {
          wxBeginBusyCursor();
          buildApp.ShowObjectEditor(win);
          wxEndBusyCursor();
        }
      }
    }
  }
  else if (event.RightDown())
  {
    long id = TheBuilderTree->NodeHitTest(event.x, event.y);
    if (id > -1)
    {
      if (id == 1)
      {
        ShowAppEditor();
      }
      else
      {
        BuildWindowData *win = (BuildWindowData *)id;
        win->EditAttributes();
        MakeModified();
        if (win->userWindow)
        {
          win->DestroyRealWindow();
          win->MakeRealWindow();
        }
      }
    }
  }
}
