#!/bin/sh
#
# script to install the defines file and C_P_args.h throughout
#
cp defines.imake defines.sav

#
# remove the old copies
#
find . -name defines.imake -exec rm -f {} \;

#
# put them back
#
mv defines.sav defines.imake

#
# loop through the directories
#
for i in \
./tiff \
./tiff/libtiff \
./tiff/tools \
./tiff/man \
./tiff/X11tools \
./widgets \
./widgets/network \
./widgets/smraster \
./widgets/samples \
./widgets/samples/xnet \
./widgets/samples/xsmraster \
./ipc \
./ipc/remote \
./ipc/sockets \
./xtent \
./xtent/lib \
./xtent/main
do
	ln defines.imake $i/defines.imake
done

#
# script to install the defines file throughout
#
cp C_P_args.h C_P_args.sav

#
# remove the old copies
#
find . -name C_P_args.h -exec rm -f {} \;

#
# put them back
#
mv C_P_args.sav C_P_args.h

#
# loop through the directories
#
for i in \
./tiff/X11tools \
./widgets/network \
./widgets/smraster \
./widgets/samples/xnet \
./widgets/samples/xsmraster \
./ipc/remote \
./ipc/sockets \
./xtent/lib \
./xtent/main
do
	ln C_P_args.h $i/C_P_args.h
done

#
# make sure that the docs are links
#
rm -rf docs
mkdir docs
cd docs
ln -s ../ipc/doc ipc
ln -s ../widgets/network/doc network
ln -s ../xtent/doc xtent
