.de CW
.sp 0.1i
.DS L N
.in 0.25i
.ft CW
..
.de CN
.ft P
.in -0.25i
.sp 0.1i
.DE
..
'	\" Parameters for .iS and .iE macros.
.nr iI 0.150i
.nr iO 0.075i
.nr iL \n(.lu-\n(iIu-\n(iIu+\n(iOu+\n(iOu
'
'	\" .iS title [1] [1] [1]
'	\" If $2 != 1, print the title in the upper RH corner.
'	\" If $3 == 1, use DF instead of DS.
'	\" If $4 == 1, print line numbers.
.de iS
.nr iX 0
.ds i1 \\$1
.nr i2 \\$2
.nr i3 \\$3
.nr i4 \\$4
.if \\n(i4=1 .nr iX \w'\f(CW00000\fP'
.br
.nf
.ft CW
.if \\n(i4=1 .nm 1 5 2
.di nG
..
.de iE
.if \\n(i4=1 .nm
.ft R
.fi
.br
.di
.nr || \\n(dnu+1v
.if \\n(||u>=\\n(.tu .bp
.ds iT "\|\|\f(CW\\*(i1\fR\|\|
.nr iG \w'\\*(iT'u
.if \\n(i4=1 .nr iL \\n(iL+\\n(iI
.if !\\n(i3=1 .br
.if !\\n(i3=1 .if !\\n(i2=1 .if (\\n(.i+\\n(.n+\\n(iG)<(\\n(.l-1.25i) .sp -.5
.if !\\n(i3=1 .DS
.if \\n(i3=1 .DF
.if !\\n(i4=1 .in +\n(iIu
.if !\\n(i2=1 \{\
.sp
\h'\\n(iLu-\n(iOu-\\n(iGu'\v'-0.075v'\\*(iT\v'0.075v'\h'-\\n(iGu'\L'-1'\l'\\n(iGu\(ul'\L'1'\}
.mk iS
.nG
.sp .15v
.mk iE
.nr iH \\n(iEu-\\n(iSu
.sp -1
\h'-\n(iOu+\\n(iXu'\L'-\\n(iHu'\l'(\\n(iLu-\\n(iXu)\(ul'\L'\\n(iHu'\l'(-\\n(iLu+\\n(iXu)\(ul'
.if !\\n(i4=1 .in -\n(iIu
.DE
.if \\n(i4=1 .nr iL \\n(iL-\\n(iI
..
.nr Cl 5
.PH ""
.PF ""
.S 24 26
.ce 4
A Simple IPC
for Talking to X* Widgets
and Keeping Workstations Busy
(draft)
.sp
.PH "''- \\\\nP -''"
.S 16 18
.I
.ce 5
Doug Blewett
Margaret Kilduff

AT&T Bell Laboratoris
Murray Hill, New Jersey
.sp
.S 10 12
.FS *
X Toolkit (Xt) and X Window System are trademarks of the Massachusetts
Institute of Technology.
.FE
.H 1 "Introduction"
AT&T Bell Laboratories there is a long history of creating
applications from collections of processes.  With the advent of low
cost workstations there has grown a desire to create distributed
multi-process, applications.  Application developers can do this today
to some extent using the pipe metaphor and the UC Berkeley style
remote shell and remote login facilities.  A common set of problems
that one finds using rlogin and rsh and pipes is that the granularity
of control is often too coarse and the communication over pipes is
inherently uni-directional and lumpy.  Pipes commonly have a high
water mark of five or ten thousand bytes.  Any application that
demonstrates some form of feedback loop immediately runs into problems
if it is implemented using pipes.  A multi-process/software tools
scheme is undeniably the way we want to solve our distributed
problems, but pipes may not be the best solution for these new
applications.
.P
The Berkeley rsh and rlogin commands found on most popular
workstations use some form of socket to handle the inter-process
communication (IPC).  Although the world has embraced sockets, sockets
have proven themselves to be a less than elegant solution to the
problem.  To produce a good non-blocking client/server library using
sockets requires between 500 and 1500 lines of code.  This is more
than the average application developer wants to spend on a support
library.  It is surprising that there has not arisen a high level
library comparable to standard I/O for handling IPC.  We are now
seeing socket emulation libraries on operating systems that do not
directly support sockets.  One has to wonder if it is wise to
propagate such an awkward model of the world.
.P
For the last few years we have been working on problems that require a
simple and efficient IPC system.  We have been interested in creating
graphics applications from collections of processes.  Using processes
allows me to easily add graphics to existing applications.  We have
also been interrested in using collections of processors to handle
computationally expensive tasks such as searching large databases or
compiling large systems.  We have a large collection of workstations
that sit idle a fair amount of the time.  Distributed compiles seem to
be a natural use of this resource.
.P
To support our distributed applications we have written a portable
IPC library.  The model for constructing applications that is embedded
in the IPC is very much a client/server event oriented scheme.
Application inner loops are similar to the popular two line X main
loop: \f(CWXtNextEvent(&event); XtDispatchEvent(&event);\fP.  Much
like X, the messages are datagram like, typed, messages.  The message
body is (within bounds) of arbitrary length and messages are
transmitted asynchronously.  Good performance is achieved through the
usual set of tricks; for example minimizing data movement (AKA
copying) and maximizing buffering.
.P
There are two implementations of the library.  One implementation is
based on sockets.  Sockets, although not the cleanest of models, is
supported on more UNIX\(tm systems than any other form of
inter-processor IPC.  The socket model is a good porting base.  The
other implementation of our IPC is based entirely on the X protocol.
At first glance this seems to be an odd way to implement IPC, but it
has a number of advantages, foremost of which is portability.  We have
a number of odd hardware configurations that support X.  Some of
these, for example on our more exotic computers, are not supported
directly via sockets.  Riding on top of the X protocol allows the
application developer to benefit from other people's work in porting
and improving X's performance.  The Kerberose security system being
done at MIT for the X protocol will be picked up for free by our X
based applications.  As the library has a small number of entry points
it should be easy to port our IPC model to most any other IPC system.
.P
In this paper we will first describe a minimal client/server
application that is based on the library and then we will present a
terse user manual style description of the functions in the library.
.H 1 "Sample programs"
A recent edition of the Sun Software Technical Bulletin included a
sample client/server application.  The code was for a server that
blocked on write requests and did no buffering; a minimal sort of
socket application.  The code was six pages of well commented code.
In this section we will present a minimal client server application
using our library.  The client and server applications are each
considerably under one page of code.  The pieces we will present are
real programs that we use for debugging and timing.  The code is
presented here more as an example for line counting than as a
tutorial.  We hope that the reader can get a fair idea about the flavor
of the system from this example.
.P
.ne 40
The first piece of code is the sample server.  Initialization is two
steps, setting up the server and disabling errors.  Errors are
disabled so that death of a client does not result in death of the
server.  The main loop of the server monitors or waits for a message
to arrive, reads or receives the message, and then processes the
message.  The four functions that are used in the sample server are
all from of the XIpc library.  It should be noticed that there are no
explicit calls to memory allocation routines, for example malloc() or
free().  The library avoids dynamically allocating memory in the main
loop and attempts to reuse buffers when possible, much like standard
I/O.
.iS "\fBSample Server\fP"
#include "XIpc.h"

main ()
{
	XIpcMessage *message;
	XIpcServer *server;

	if ((server = XIpcSetupServer ((char *) NULL, (caddr_t) NULL,
				       (caddr_t) NULL, (char *) NULL))
	     == NULL)
	{
		fprintf (stderr, "%s: Could not initialize the server.\\en",
			 argv[0]);
		exit (1);
	}

	XIpcCatchErrors (TRUE, NULL);

	for (;;)
	{
		switch (XIpcServerMonitor (server, XIPC_MONITOR_MESSAGES,
					   -1))
		{
		case XIPC_MONITOR_MESSAGES:
			message = XIpcRecvFromClients (server);
			if (message == NULL)
				continue;
			XIpcServerProcessMessage (server, message);
			continue;
		}
	}
}
.iE
.sp
.P
The following piece of code is a complete client that is used in
conjunction with the sample server for debugging and performing timing
and performance studies.  This code exercises a bit more of the
library.  After setting up the application, the sample client turns
off synchronized messaging.  This enables the XIpc message buffering
and improves message passing performance.  The program then sends 20
messages with the first 15 messages being buffered.  The messages that
are sent are set to be echoed back to this client process.  The second
loop reads in the messages and exits.  The functions
local_create_message() and local_process_message() are application
specific and not provided by the XIpc library.  XIpc does provide an X
toolkit message processor, but, as one would expect, most applications
require their own message handling routines.
.iS "\fBSample Client\fP"
#include "XIpc.h"

main ()
{
	XIpcClient *client;
	XIpcMessage *message;
	int i;

	if ((client = XIpcSetupClient ((char *) NULL, (caddr_t) NULL,
				       (caddr_t) NULL)) == NULL)
	{
		fprintf (stderr, "%s: Cannot establish ipc links.\\en",
			 argv[0]);
		exit (1);
	}

	XIpcSynchronize (client, FALSE);	/* enable buffering */

	message = local_create_function ();
	message -> type = XIPC_SERVER_PING;
	for (i = 0; i < 20; i++)		/* send 20 messages */
	{
		XIpcSendToServer (client, message);
		if (i > 15)
			XIpcFlushClient (client);
	}

	XIpcSynchronize (client, TRUE);	/* disable buffering */

	for (i = 0; i < 20; )			/* recv. 20 messages */
	{
		switch (XIpcClientMonitor (client, XIPC_MONITOR_MESSAGES,
			-1))
		{
		case XIPC_MONITOR_MESSAGES:
			message = XIpcRecvFromServer (client);
			if (message == NULL)
				continue;
			local_process_message (message);
			i++;
			continue;
		}
	}

	XIpcCloseClient (client);
}
.iE
The sample client code is somewhat atypical.  Most applications that we
have seen intermix sending and receiving messages.
.H 1 "XIpc Application Interface"
The XIpc package provides a simple client server model for use in
creating distributed applications.  There are four data types that are
used in the XIpc system; message, client ID, client structure, and
server structure.  Applications treat the client and server structures
essentially as opaque handles.  The application program is completely
insulated from the structures specific to the underlying transport
mechanism.
.P
The XIpc function call library is also a terse interface.  Client and
server applications each have five functions for handling open, close,
send, receive, and monitoring of the XIpc connections.  The details of
setting up the connections are handled entirely by the library.  And,
of course, the library transparently setups connections between
processors.
.P
In the following sections we will describe the data structures and then
the application interface provided by the library.  We will start with
the data structure discussion.
.H 2 "XIpc Data Structures"
.H 3 "The XIpcMessage Structure"
Data that is communicated between processes uses the XIpcMessage data
structure shown in the following figure.  Messages contain four
fields, type, client_id, length, and buffer.  The buffer is an array
of bytes and its length is specified in the length field.*
.FS *
The buffer may be any length greater than or equal to zero and less
than XIPC_MAX_MESSAGE_SIZE.  XIPC_MAX_MESSAGE_SIZE is defined so that
the entire message will always fit within BUFSIZ bytes.  BUFSIZ must
always be less than the size of the maximum unsigned short, usually
65535.  For performance reasons, the length of the transmitted message
is always rounded to the next word boundary.
.FE
.iS 0 1
typedef struct
{
	unsigned short type;
	unsigned short client_id;
	unsigned short length;
	unsigned char buffer[1];	/* arbitrary length strings */
} XIpcMessage;
.ce 1
.FG "Message data structure"
.iE
.P
The type field is used to specify the purpose of the message.  The
library contains a server message handler that defines a number of
message types.  These include client management operations and
debugging commands, otherwise the semantics of this field are entirely
application dependent.  The client_id field is used by the server
software as an index for quickly identifying clients.  The message
send functions guarantee that the correct client id index is included
in each message.
.H 3 "The XIpcClient Structure"
The client structure is used by the server to represent each connected
client.  In the client process the structure is used to represent the
connection to the server.  There are four public fields in the
structure.  The client_id field is set by the XIpc package and may be
read by the application software.  The data and malloc_data fields may
be read or written by the application.  These data field are provided
solely for the convenience of the application.  They are commonly used
in servers for storing data, for example a symbolic name, that is
associated with each client.  Client structures are cleaned up
whenever the underlying transport mechanism signals that the client
has died.  The malloc_data is freed and data is zeroed out.  If a
cleanup procedure is provided by the application it will be called
prior to deallocating these slots.
.iS 0 1
typedef struct
{
	/* id by which the client is known */
	unsigned short client_id;

	/* application supplied data */
	caddr_t data;
	caddr_t malloc_data;
	void (*cleanup) ();

	/*
	 * private data
	 */
	...
} XIpcClient;
.ce 1
.FG "Client data structure"
.iE
.H 3 "The XIpcServer Structure"
The third and last data structure is the server struct.  It contains
two publicly accessible fields, a server client struct and an array of
clients.  As expected, the array of clients contains one client struct
for each connected client.  The server client struct contains the
client information maintained for the server process itself.  As with
the client struct the server struct also contains data that is private
to the package and should not be tampered with by the application.
.iS 0 1
typedef struct
{
	/* this server */
	XIpcClient server;

	/* connected clients */
	XIpcClient *clients;

	/*
	 * private data
	 */
	...
} XIpcServer;
.ce 1
.FG "Server data structure"
.iE
.H 2 "XIpc Function Library"
The application interface in terms of function calls is quite simple.
The package has three parts; for supporting the server process, the
client process, and general operations on messages and connections.
The server and client sections each have five functions for handling
open, close, send, receive, and monitoring of the XIpc connections.
The general operation section is a grab bag of five functions that are
useful for writing and debugging both server and client applications.
The functions are displayed in the following order server, client, and
then general purpose functions.
.H 3 "Server Process Functions"
.iS XIpcSetupServer 0
XIpcServer *XIpcSetupServer (server_display_name, server_display,
	server_window, environment_name)
char * server_display_name;
caddr_t server_display;
caddr_t server_window;
char *environment_name;
.iE
This function initializes the server.  This initialization includes
setting the shell variable that identifies this server.  The value of
of this environmental variable may be used by clients to connect to
the server (see XIpcSetupClient() below).  The server_display_name
argument, if it is non-null, is used to override the default hostname
or X display name, for socket and X based implementations
respectively.  If server_display and server_window are not equal to
zero they is used in the X implementation in lieu of establishing a
new connection to the X server and creating a message window.
.P
These threefour arguments may be safely replaced by NULLs for many
applications.  XIpcServerSetup() provides reasonable defaults values.
server_display_name defaults to the value of the DISPLAY environment
variable or the hostname for X and socket based applications.  If
server_display and server_window are NULL a new connection is setup
and a new window created.  If no environmental variable name is
provided XIPC is used.
.P
XIpcSetupServer returns a pointer to a server structure.  This pointer
is required for all other server functions.  If the server XIpc cannot
be established a NULL pointer will be returned.
.P
.iS XIpcCloseServer 0
void XIpcCloseServer (server)
XIpcServer *server;
.iE
This function shuts down the server and closes all connections to
client processes.
.P
.iS XIpcSendToClient 0
int XIpcSendToClient (server, client_id, message)
XIpcServer *server;
unsigned short client_id;
XIpcMessage *message;
.iE
This function sends the specified message to the client specified via
the client_id.  The client_id is used to look up the correct client
structure.  If the message cannot be sent, the function returns FALSE,
otherwise TRUE.
.P
.iS XIpcRecvFromClients 0
XIpcMessage *XIpcRecvFromClients (server)
XIpcServer *server;
.iE
This function returns the next available message from the list of
connected clients.  If there are no further messages available or the
message was a notification for internal use only a NULL message will
be returned.  This function should be called after being notified of
an incoming message from XIpcServerMonitor().
.P
.iS XIpcServerMonitor 0
int XIpcServerMonitor (server, which, timeout)
XIpcServer *server;
int which;
int timeout;
.iE
This function is used to monitor the keyboard and XIpc connections.  It
is essentially a glossy interface to the select() kernel call plus a
bit of bookkeeping.  which is a bitmask that may assume one of the
following constant values:
.CW
	XIPC_MONITOR_KEYBOARD
	XIPC_MONITOR_MESSAGES
	XIPC_MONITOR_BOTH
.CN
The timeout value is the number of seconds XIpcServerMonitor should
wait for XIpc or keyboard activity.  A timeout value of -1 means the
call should block until the specified activity occurs.
.P
XIpcServerMonitor will return one of the following:
.CW
	XIPC_MONITOR_TIMEOUT
	XIPC_MONITOR_KEYBOARD
	XIPC_MONITOR_MESSAGES
	XIPC_MONITOR_ERROR
.CN
XIPC_MONITOR_TIMEOUT means that the timeout value was reached without
any keyboard or XIpc activity.  XIPC_MONITOR_KEYBOARD means that there
is data ready to be read from standard input.  XIPC_MONITOR_MESSAGES
is returned when there is XIpc activity.  XIpcRecvFromClients() may be
used to read the incoming messages.  XIPC_MONITOR_ERROR implies that a
transport level error has occurred.  This may include the death of a
client process.  Errors may be safely ignored.
.P
.iS XIpcServerProcessMessage 0
void XIpcServerProcessMessage (server, message)
XIpcServer *server;
XIpcMessage *message;
.iE
This function is used to process incoming requests from connected
clients.  The message is most often an incoming message read with 
XIpcRecvFromClients().  XIpcServerProcessMessage() verifies that the
client id specified in the message refers to a valid client and then
carries out one of the following commands:
.CW
	XIPC_SERVER_NEW_CLIENT
	XIPC_SERVER_DELETE_CLIENT
	XIPC_SERVER_ECHO
	XIPC_SERVER_PING
	XIPC_SERVER_EXEC
	XIPC_SERVER_EXIT
.CN
XIPC_SERVER_NEW_CLIENT is sent by XIpcSetupClient() (described below)
to initialize the XIpc connection.  XIPC_SERVER_DELETE_CLIENT
essentially logs the client out of the XIpc connection.  In practice
most applications simply exit and allow the XIpc package to cleanup
the dead connections.  XIPC_SERVER_ECHO prints the message using
XIpcPrintMessage() described below.  XIPC_SERVER_PING causes
XIpcServerProcessMessage() to send the message back to the client.
With XIPC_SERVER_EXEC XIpcServerProcessMessage() performs a call to
system() using the buffer element of the message as the only argument.
XIPC_SERVER_EXIT causes the server to exit.
.P
.iS XIpcFlushServer 0
void XIpcFlushServer (server)
XIpcServer *server;
.iE
This function flushes all outgoing messages to the connected clients.
Messages may be queued because the server is buffering messages (see
XIpcSynchronize() below) or because the receiving client has fallen
behind in reading incoming messages.  The server will queue a message
rather than block sending it.
.P
.iS XIpcServerCloseClient 0
void XIpcServerCloseClient (server, client_id);
XIpcServer *server;
unsigned short client_id;
.iE
This function closes down the connection between the server and the
client specified by the client id.  This function is called internally
when the server is notified that the client has dropped its end of the
connection (usually when the client process exits).
.H 3 "Client Process Functions"
.iS XIpcSetupClient 0
XIpcClient *XIpcSetupClient (xipc_name, client_display, client_window)
char *xipc_name;
caddr_t client_display;
caddr_t client_window;
.iE
This function initializes the client connection to the server.  The
server may be specified in xipc_name.  If xipc_name is NULL, then the
shell variable XIPC will be used to locate the server.  If
client_display and client_window are not equal to zero, they are used
in the X implementation in lieu of establishing a new connection to
the X server and creating a new message window.
.P
XIpcSetuptClient() returns a pointer to a client structure.  This
pointer is required for all other client functions.  If a connection
to the server cannot be established a NULL pointer is returned.
.P
.iS XIpcCloseClient 0
void XIpcCloseClient (client)
XIpcClient *client;
.iE
This function shuts down the client connection to the server process.
.P
.iS XIpcSendToServer 0
int XIpcSendToServer (client, message)
XIpcClient *client;
XIpcMessage *message;
.iE
This function sends the specified message to the server.  If the
message cannot be sent, the function returns FALSE, otherwise TRUE.
.P
.iS XIpcRecvFromServer 0
XIpcMessage *XIpcRecvFromServer (client)
XIpcClient *client;
.iE
This function returns the next available message from the server
process.  If there are no further messages available or the message
was a notification for internal use only a NULL message will be
returned.  This function should be called after being notified of an
incoming message from XIpcClientMonitor().
.P
.iS XIpcClientMonitor 0
int XIpcClientMonitor (client, which, timeout)
XIpcClient *client;
int which;
int timeout;
.iE
This function is used to monitor the keyboard and incoming XIpc
connection.  This definition is almost word for word the same as that
of XIpcServerMonitor().  XIpcClientMonitor() is essentially a glossy
interface to the select() kernel call plus a bit of bookkeeping.
which is a bitmask that may assume one of the following constant
values:
.CW
	XIPC_MONITOR_KEYBOARD
	XIPC_MONITOR_MESSAGES
	XIPC_MONITOR_BOTH
.CN
The timeout value is the number of seconds XIpcClientMonitor() should
wait for XIpc or keyboard activity.  A timeout value of -1 means the
call should block until the specified activity occurs.
.P
XIpcClientMonitor() will return one of the following:
.CW
	XIPC_MONITOR_TIMEOUT
	XIPC_MONITOR_KEYBOARD
	XIPC_MONITOR_MESSAGES
	XIPC_MONITOR_ERROR
.CN
XIPC_MONITOR_TIMEOUT is returned when the timeout value was reached
without any keyboard or XIpc activity.  XIPC_MONITOR_KEYBOARD means
that there is data ready to be read from standard input.
XIPC_MONITOR_MESSAGES is returned when there is XIpc activity.
XIpcRecvFromServer() may be used to read the incoming messages.
XIPC_MONITOR_ERROR implies that a transport level error has occurred.
This error may be safely ignored.
.P
.iS XIpcFlushClient 0
void XIpcFlushClient (client)
XIpcClient *client;
.iE
This function flushes all outgoing messages to the connected server
process.  Messages may be queued because the client is buffering
messages (see XIpcSynchronize() below).
.H 3 "Server and Client Process General Support Functions"
.iS XIpcPrintMessage 0
void XIpcPrintMessage (fp, title, message)
FILE *fp;
char *title;
XIpcMessage *message;
.iE
This function prints the fields of the supplied message to the
specified standard I/O stream.  The title string is used to decorate
each output line.  This function is useful for debugging.
.P
.iS XIpcCopyMessage 0
XIpcMessage *XIpcCopyMessage (message)
XIpcMessage *message;
.iE
The XIpc package does a minimum of copying and attempts to avoid using
malloc().  The space allocated for incoming messages is reused.  If a
message is to be used through subsequent receive message function
calls then the message must be copied into space that is manged by the
application.  XIpcCopyMessage() creates a copy of the specified
message using malloc().  The message structure and contents are
created as a contiguous block.  Messages created with
XIpcCopyMessage() maybe released with one call to free().
.P
.iS XIpcSynchronize 0
int XIpcSynchronize (client, type)
XIpcClient *client;
int type;
.iE
This function enables (type == FALSE) or disables (type == TRUE)
buffering of outgoing messages for the specified client.  Buffering
may significantly improve the performance of a multi-process
application.  Care must be taken when buffering is enabled, that
important messages are followed by a call to the appropriate server or
client flush function.  By default all connections are setup with
buffering disabled (type == TRUE).
.P
.iS XIpcCatchErrors 0
void XIpcCatchErrors (type, user_routine)
int type, void (*user_routine);
.iE
If process A sends a message to a process that has exited, then
process A will normally exit with an XIpc or X window error.  This is
usually a desirable feature for clients.  However, Server processes
(and some clients) often want to avoid exiting on this sort of soft
error.  XIpcCatchErrors() will cause these errors to be caught and
ignored if type is TRUE.  If type is FALSE the error will not be
caught and the process will exit.  If user_routine is non-null it will
be used instead of the package supplied error handler.
.P
.iS XIpcClientAndServerMonitor 0
int XIpcClientAndServerMonitor (client, which_client,
		server, which_server, timeout,
		client_return, server_return)
XIpcClient *client;
int which_client;
XIpcServer *server;
int which_server;
int timeout;
int *client_return;
int *server_return;
.iE
This function allows the application to be both a client of a server
and a server itself.  The function behaves as a combined version of
XIpcClientMonitor() and XIpcServerMonitor().  The return values are
set in client_return and server_return.
.P
.iS XIpcIsClientActive 0
int XIpcIsClientActive (client)
XIpcClient *client;
.iE
This function returns TRUE if the specified client is connected to a
server process.
.H 1 "Keeping Workstations Busy"
The following is a description of an interesting prototype.  Please
remember that it is a quick prototype, and not a real system.  Most
workstation computing cycles are lost.  Most workstations sit idle a
large percentage of every day, even while they are being used
intermittently.  Workstation cycles are a resource that is difficult
to share.  With the move from timesharing systems to workstations
complete in many industries, there is a tremendous untapped source of
computing power currently in place.
.P
Recently we have seen the price of workstations dip below that of
comparably equipped personal computers.  When this happened, Ken
Church and we began discussing ways to make effective use of pools
workstations as compute servers.  We have a number of tasks that can
be easily broken up into sections that can be run in parallel.
.P
The idea was to provide a command that will transparently distribute
tasks.  The distribution has to be reliable, quick, and manageable
without having to have access to root privileges.  We also wanted a
system that would make it easy to add and remove processors from the
pool.  Using the XIpc library, we have built a prototype system that
meets all of these requirements.  The four processes that compose the
system total less than 1000 lines of very rudimentary C code.  The
code is heavily commented and contains less than 400 semicolons.  The
lesson here is that a facility of this type can be easy to write and
be very effective.
.P
The end user interaction with the the task distribution system is
controlled via a command called remote.  remote hands its arguments off
to a server for distribution and echos the output from the remotely
executed command.  remote also exits with the exit code obtained from
the remote task.  The notion is that commands can be remotely executed
by prepending the remote command.  cc becomes remote cc.
.P
Utilizing a pool of processors in parallel can be easily achieved by
running the remote commands as background processes or by utilizing
one of the new parallel make facilities.  Of course, in UNIX\(tm
environments make is the tool of choice for describing collections of
tasks (AKA building programs).  There are a number of make like
facilities that have parallel execution features.  Andrew Hume's mk
successor to make and Richard Stallman's gnu make both support this
sort of parallel execution feature.  The idea is a fairly simple thing
to add to any make.  make does not call wait() after each fork() and
exec(), but instead continues to fire off more processes until some
number of processes is reached.  When wait() is eventually called exit
codes are paired up with processes via the process ID returned from
wait().  This does a nice job of getting a lot of processes running
but it does not help to get the processes distributed.
.P
Good makefiles these days are written defining $(CC)=cc and where ever
the C compiler is required the macro is used, for example $(CC)\ -c\
one.c.  By replacing the CC definition with $(CC)=remote cc the
makefile is converted to use our system.  The redefinition of CC can
also be done when make is invoked via command line arguments.
.P
Figure 4 is a schematic diagram of how the remote execution facility
operates.
.DS CB
.if t
.PS < remote.pic
..

.ce 1
.FG "A schematic view of the process distribution system."
.DE
.P
The user of the system starts up the Server (as shown in the diagram)
as a normal process in their computing environment.  Machines may be
entered into the pool at start up by giving the machine names as
arguments to the Server.  After the Server is running Client-Server's
may be added by remotely executing the Client-Server process.  The
Server detects when a Client-Server dies and removes it from the pool.
Client-Servers (and the other parts of the system) may be killed at
any time without disrupting the system.
.P
When remote is executed it hands it argument list and current working
directory off to the Server.  The Server looks through its list of
available Client_Server's and hands the command off.  The
Client-Server then then starts up a Client.  The Client is responsible
for running the command in the correct directory and returning the
output and exit code.  The output and exit code are forwarded back
through the Client-Server and Server to the remote process.  One is
tempted to say local, remote process.  This process echoes the output
and exits with the correct exit code.
.P
None of the processes in the system run setuid root.  And they all run
at normal priority levels.  As the processors are losely coupled, the
remote system gives a fairly linear increase in performance as more
processors are added to the pool.
