#include "XIpc.h"
#include "remote.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

C_PROTOS_END_EXTERN

/*
 * LoadAvg - gets the load average for a ClientServer
 */
void
main (argc, argv)
int argc;
char **argv;
{
    extern char *getenv ();
    static char local_buffer[BUFSIZ];
    XIpcMessage *message = (XIpcMessage *) local_buffer;
    XIpcClient *client;
    double load_average;

    /*
     * check the argument count
     */
    if (argc != 1)
    {
	fprintf (stderr,
		 "usage: %s <No Args!>\n",
		 argv[0]);
	exit (1);
    }

    /*
     * connect to the remote server
     */
    if ((client = XIpcSetupClient (getenv (REMOTE_SERVER_ENV_NAME),
				   (caddr_t) NULL, (caddr_t) NULL))
	== NULL)
    {
	fprintf (stderr, "%s: Cannot establish ipc links.\n", argv[0]);
	exit (1);
    }

    /*
     * loop calculating the load average and sending it off
     */
    for (;;)
    {
	/*
	 * Calculate the load average - from X11
	 */
	GetLoadPoint ((caddr_t) NULL, (caddr_t) NULL,
		      &load_average);

	/*
	 * send the off the new load average
	 */
	message -> type = REMOTE_LOAD;
	sprintf (message -> buffer, "%f", load_average);
	message -> length = strlen ((char *) message -> buffer) + 1;
	XIpcSendToServer (client, message);

	if (XIpcIsClientActive (client) == FALSE)
	{
	    fprintf (stderr,
		     "%s: Lost the connection to the server\n",
		     argv[0]);
	    exit (1);
	}

	/*
	 * wait for 50 seconds or a message
	 */
	if (XIpcClientMonitor (client, XIPC_MONITOR_MESSAGES, 50) ==
	    XIPC_MONITOR_MESSAGES)
	{
	    message = XIpcRecvFromServer (client);
	    if (message == (XIpcMessage *) NULL)
		continue;
	    if (message -> type == REMOTE_EXIT)
	    {
		int i;

		i = atoi (message -> buffer);
		XIpcCloseClient (client);
		fflush (stdout);
		exit (i);
	    }
	}
    }
}
