#ifdef GETWD_AVAILABLE
#define GETWD_AVAILABLE
extern char *getwd ();
#include <sys/param.h>
#endif

#include "XIpc.h"
#include "remote.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv, char **envp));

C_PROTOS_END_EXTERN

typedef struct StopEntry
{
    char *string;
    int length;
    struct StopEntry *next;
} StopEntry;

/*
 * remote command
 */
void
main (argc, argv, envp)
int argc;
char **argv;
char **envp;
{
    extern char *getenv ();
    static char local_buffer[XIPCBUFSIZ];
    XIpcMessage *message = (XIpcMessage *) local_buffer;
    register char *ptr1, *ptr2;
    register char *buffer_end = (char *) message -> buffer +
	XIPC_MAX_MESSAGE_SIZE;
    register char **local_envp;
    int i;
    XIpcClient *client;
    StopEntry *stop_list = (StopEntry *) NULL;
    StopEntry *entry;
    char *TooLong = "%s: The command is too long: %s.\n";
    char *EnvVar = "too many environment variables";
    char *CommandVar = "check the argument and environment lists";

    /*
     * check the argument count
     */
    if (argc < 2)
    {
	fprintf (stderr,
		 "usage: %s <command to be run remotely>\n",
		 argv[0]);
	exit (1);
    }

    /*
     * connect to the remote server
     */
    ptr1 = getenv (REMOTE_SERVER_ENV_NAME);
    if (ptr1 == (char *) NULL)
    {
	FILE *fp;

	if ((fp = fopen (REMOTE_ID_FILE, "r")) != NULL)
	{
	    ptr1 = fgets (local_buffer, XIPCBUFSIZ, fp);
	    fclose (fp);
	}
    }
    if (ptr1 == (char *) NULL)
    {
	fprintf (stderr, "%s: the shell variable %s is not defined.\n",
		 argv[0], REMOTE_SERVER_ENV_NAME);
	fprintf (stderr, "%s:  and the file %s is not readable.\n",
		 argv[0], REMOTE_ID_FILE);
	exit (1);
    }

    if ((client = XIpcSetupClient (ptr1,
				   (caddr_t) NULL, (caddr_t) NULL))
	== NULL)
    {
	fprintf (stderr, "%s: Cannot establish ipc links.\n", argv[0]);
	exit (1);
    }

    /*
     * get the current working directory
     */
#ifdef GETWD_AVAILABLE
    {
	static char pathname[MAXPATHLEN];
	char *error_ptr;

	error_ptr = "%s: Cannot get the current directory\n";
	if (getwd (pathname) == NULL)
	{
	    fprintf (stderr, error_ptr, argv[0]);
	    exit (1);
	}
	if (*pathname == '\0')
	{
	    fprintf (stderr, error_ptr, argv[0]);
	    exit (1);
	}
	ptr1 = (char *) message -> buffer;
	ptr2 = pathname;
	while (*ptr1++ = *ptr2++)
	    ;
	*(ptr1 - 1) = ';';
    }
#else
    {
	FILE *fp;
	char *error_ptr;

	error_ptr = "%s: Cannot get the current directory\n";
	if ((fp = popen ("pwd", "r")) == NULL)
	{
	    fprintf (stderr, error_ptr, argv[0]);
	    exit (1);
	}
	if (fgets (message -> buffer, XIPC_MAX_MESSAGE_SIZE, fp) == NULL)
	{
	    fprintf (stderr, error_ptr, argv[0]);
	    pclose (fp);
	    exit (1);
	}
	pclose (fp);
	i = strlen ((char *) message -> buffer);
	if (i == 0)
	{
	    fprintf (stderr, error_ptr, argv[0]);
	    exit (1);
	}
	ptr1 = (char *) &message -> buffer[i - 1];
	if (*ptr1 != '\n')
	    ptr1++;
	*ptr1++ = ';';
   }
#endif

    /*
     * quote the entire command
     */
    *ptr1++ = '\"';

    /*
     * add the environment - check for a skip list
     *   REMOTESKIP=TERMCAP TERM foo 
     */
    local_envp = envp;
    while (*local_envp)
    {
	if (strncmp (*local_envp, "REMOTESKIP=", 11) == 0)
	{
	    char *ptr_top;

	    ptr2 = *local_envp + 11;
	    while (*ptr2 == ' ' || *ptr2 == ':')
		ptr2++;
	    ptr_top = ptr2;
	    for (;;)
	    {
		if (*ptr2 == ' ' || *ptr2 == ':' ||
		    *ptr2 == '\0')
		{
		    entry = (StopEntry *)
			malloc (sizeof (StopEntry));
		    if (entry == (StopEntry *) NULL)
		    {
			fprintf (stderr,
				 "%s: Cannot allocate memory.\n",
				 argv[0]);
			exit (1);
		    }
		    entry -> string = ptr_top;
		    entry -> length = ptr2 - ptr_top;
		    entry -> next = stop_list;
		    stop_list = entry;
		    if (*ptr2 == '\0')
			break;
		    *ptr2++ = '\0';
		    ptr_top = ptr2;
		}
		else
		    ptr2++;
	    }
	}
	local_envp++;
    }

    /*
     * process each environment entry
     */
    local_envp = envp;
    while (*local_envp)
    {
	register equal_flag;
		
	if (stop_list)
	{
	    entry = stop_list;
	    while (entry)
	    {
		if (strncmp (*local_envp, entry -> string,
			     entry -> length) == 0)
		    break;

		entry = entry -> next;
	    }
	    if (entry)
	    {
		local_envp++;
		continue;
	    }
	}

	ptr2 = *local_envp++;
	equal_flag = TRUE;	/* check for the equal sign */
	while (*ptr1 = *ptr2++)
	{
	    if (equal_flag && *ptr1 == '=')
	    {
		*++ptr1 = '\'';
		equal_flag = FALSE;
	    }

	    if (++ptr1 >= buffer_end)
	    {
		fprintf (stderr, TooLong, argv[0], EnvVar);
		exit (1);
	    }
	}
	if (ptr1 + 2 >= buffer_end)
	{
	    fprintf (stderr, TooLong, argv[0], EnvVar);
	    exit (1);
	}
	*ptr1++ = '\'';
	*ptr1++ = ' ';
    }

    /*
     * add the argument list to the working directory
     */
    for (i = 1; i < argc; i++)
    {
	ptr2 = argv[i];
	*ptr1 = ' ';
	if (++ptr1 >= buffer_end)
	{
	    fprintf (stderr, TooLong, argv[0], CommandVar);
	    exit (1);
	}
	while (*ptr1 = *ptr2++)
	{
	    if (++ptr1 >= buffer_end)
	    {
		fprintf (stderr, TooLong, argv[0], CommandVar);
		exit (1);
	    }
	}
    }

    /*
     * end quoting the command
     */
    *ptr1 = '\"';
    if (++ptr1 >= buffer_end)
    {
	fprintf (stderr, TooLong, argv[0], EnvVar);
	exit (1);
    }
    *ptr1 = '\0';

    /*
     * send the command off to be executed remotely
     */
    message -> type = REMOTE_EXEC;
    message -> length = ptr1 - (char *) message -> buffer;
    XIpcSendToServer (client, message);

    /*
     * loop echoing the output from the command and waiting for
     * the exit value
     */
    for (;;)
    {
	if (XIpcIsClientActive (client) == FALSE)
	{
	    fprintf (stderr,
		     "%s: Lost the connection to the server\n",
		     argv[0]);
	    exit (1);
	}

	switch (XIpcClientMonitor (client, XIPC_MONITOR_MESSAGES, -1))
	{
	case XIPC_MONITOR_MESSAGES:
	    message = XIpcRecvFromServer (client);
	    if (message == (XIpcMessage *) NULL)
		continue;
	    switch (message -> type)
	    {
	    case REMOTE_ECHO:
		fwrite (message -> buffer, 1,
			message -> length, stdout);
		continue;
	    case REMOTE_EXIT:
		i = atoi (message -> buffer);
		XIpcCloseClient (client);
		fflush (stdout);
		exit (i);
	    }
	}
    }
}
