static char TMXtHdXIpcTCl_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include "XIpc.h"

/*
 * this file contains a sample XIpc message handler.  This is probably
 * best used as an example for creating application specific handlers.
 * This function is installed with XtAddXIpc().
 */

/*
 * function prototypes in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
XtHandleIpcToClient C_P_ARGS((XIpcClient *client));

static XrmQuark
ResourceToResourceType C_P_ARGS((WidgetClass widget_class, Widget widget,
				 XrmQuark name_quark));

C_PROTOS_END_EXTERN


#define MSG_MAX		XIPCBUFSIZ

/*
 * message sample handler routine for widget based XIpc clients.
 */
void
XtHandleIpcToClient (client)
XIpcClient *client;
{
    Widget toplevel = (Widget) client -> data;
    XrmDatabase db = XtDatabase(XtDisplay(toplevel));
    static char argname[MSG_MAX]; /* keep it off of the stack */
    static char argvalue[MSG_MAX];
    register char *subfield, *ptr1, *ptr2;
    int x1, y1, x2, y2, ignore;
    Arg args[2];
    Widget w;
    XrmQuark rc;
    XrmValue from_value, to_value;
    XIpcMessage *message;
    XIpcMessage *ret_message;
    int rc_monitor;
    XrmValue value_return;
    XrmString type;

    while (XIpcClientMonitor (client, XIPC_MONITOR_MESSAGES, 0) ==
	   XIPC_MONITOR_MESSAGES)
    {
	if ((message = XIpcRecvFromServer (client)) ==
	    (XIpcMessage *) NULL)
	{
	    if (XIpcIsClientActive (client) == FALSE)
	    {
		fprintf (stderr,
			 "The connection to the IPC server has been lost.\n");
		exit (1);
	    }
	    continue;
	}

	switch (message -> type)
	{
	case XIPC_CLIENT_EXIT:	/* Exit */
	    XIpcCloseClient (client);
	    exit (0);
	case XIPC_CLIENT_MOVEANDRESIZE:	/* Move & Resize */
	    if (sscanf ((char *) message -> buffer, "%d,%d,%d,%d",
			&x1, &y1, &x2, &y2) != 4)
		break;
	    XMoveResizeWindow (XtDisplay (toplevel),
			       XtWindow (toplevel),
			       x1, y1, x2, y2);
	    XSync (XtDisplay (toplevel), 0);
	    break;
	case XIPC_CLIENT_MOVE:	/* Move */
	    if (sscanf ((char *) message -> buffer, "%d,%d", &x1, &y1) != 2)
		break;
	    XMoveWindow (XtDisplay (toplevel),
			 XtWindow (toplevel),
			 x1, y1);
	    XSync (XtDisplay (toplevel), 0);
	    break;
	case XIPC_CLIENT_RESIZE: /* Resize */
	    if (sscanf ((char *) message -> buffer, "%d,%d", &x1, &y1) != 2)
		break;
	    XResizeWindow (XtDisplay (toplevel),
			   XtWindow (toplevel),
			   x1, y1);
	    XSync (XtDisplay (toplevel), 0);
	    break;
	case XIPC_CLIENT_RAISE:	/* Raise */
	    XRaiseWindow (XtDisplay (toplevel),
			  XtWindow (toplevel));
	    XSync (XtDisplay (toplevel), 0);
	    break;
	case XIPC_CLIENT_LOWER:	/* Lower */
	    XLowerWindow (XtDisplay (toplevel),
			  XtWindow (toplevel));
	    XSync (XtDisplay (toplevel), 0);
	    break;
	case XIPC_CLIENT_MAP:	/* Map */
	    XMapWindow (XtDisplay (toplevel),
			XtWindow (toplevel));
	    XSync (XtDisplay (toplevel), 0);
	    break;
	case XIPC_CLIENT_UNMAP:	/* Unmap */
	    XUnmapWindow (XtDisplay (toplevel),
			  XtWindow (toplevel));
	    XSync (XtDisplay (toplevel), 0);
	    break;
	case XIPC_CLIENT_FOCUS:	/* Focus - warp pointer */
	    XWarpPointer (XtDisplay (toplevel), None,
			  XtWindow (toplevel), 0, 0, 0, 0, 0, 0);
	    XSync (XtDisplay (toplevel), 0);
	    break;
	case XIPC_CLIENT_PUT_RESOURCE:
	    /* RAD - Need to pass addr of db as defined in proto */
	    XrmPutLineResource (&db,
				(char *) message -> buffer);
	    break;
	case XIPC_CLIENT_GET_RESOURCE:
	    ptr1 = (char *) message -> buffer;
	    while (*ptr1 && *ptr1 != ' ')
		ptr1++;
	    if (*ptr1 == ' ')
		*ptr1++ = '\0';
			
	    if (XrmGetResource (db,
				(char *) message -> buffer,
				"Program.Name",
				&type, &value_return) == FALSE)
		break;
	    /* send the message back */
	    ret_message = (XIpcMessage *) argname;
	    ret_message -> type = XIPC_SERVER_INTERPRETER_MESSAGE;
	    sprintf ((char *) ret_message -> buffer, ptr1,
		     value_return.addr);
	    ret_message -> length = 
		strlen ((char *) ret_message -> buffer) + 1;
	    XIpcSendToServer (client, ret_message);
	    XSync (XtDisplay (toplevel), 0);
	    break;
	case XIPC_CLIENT_SETVALUE: /* Setvalue */
	    /* form.swindow.pushbutton.label value */
	    ptr1 = (char *) message -> buffer;
	    while (*ptr1 == '\0' || *ptr1 == ' ' || *ptr1 == '\t')
		ptr1++;
	    if (*ptr1 == '\0')
		break;
	    ptr2 = argname;
	    subfield = (char *) NULL;
	    while (*ptr1 != '\0' && *ptr1 != ' ' && *ptr1 != '\t')
	    {
		*ptr2 = *ptr1++;
		if (*ptr2 == '.')
		    subfield = ptr2;
		ptr2++;
	    }
	    if (*ptr1 == '\0')
		break;
	    *ptr2 = '\0';
	    if (subfield == (char *) NULL)
		break;
	    *subfield++ = '\0';

	    /* get the format string */
	    while (*ptr1 == '\0' || *ptr1 == ' ' || *ptr1 == '\t')
		ptr1++;
	    if (*ptr1 == '\0')
		break;

	    /* convert to internal widget and resource */
	    w = XtNameToWidget (toplevel, argname);
	    if (w == (Widget) NULL)
		break;
	    rc = ResourceToResourceType (XtClass (w), w,
					 XrmStringToQuark (subfield));

	    /* on failure assume it is a string */
	    if (rc == (XrmQuark) NULL ||
		strcmp (XrmQuarkToString (rc), "String") == 0)
	    {
		XtSetArg (args[0], subfield, ptr1);
		XtSetValues (w, args, 1);
		break;
	    }
	    from_value.addr = ptr1;
	    from_value.size = strlen (ptr1);
	    XtConvert (w, XtRString, &from_value,
		       XrmQuarkToString (rc), &to_value);
	    if (to_value.size && to_value.addr)
	    {
		XtSetArg (args[0], subfield,
			  *((long *)to_value.addr));
		XtSetValues (w, args, 1);
	    }
	    XSync (XtDisplay (toplevel), 0);
	    break;
	case XIPC_CLIENT_GETVALUE: /* Getvalue */
	    /* form.swindow.pushbutton.label format */
	    ptr1 = (char *) message -> buffer;
	    while (*ptr1 == '\0' || *ptr1 == ' ' || *ptr1 == '\t')
		ptr1++;
	    ptr2 = argname;
	    subfield = (char *) NULL;
	    while (*ptr1 != '\0' && *ptr1 != ' ' && *ptr1 != '\t')
	    {
		*ptr2 = *ptr1++;
		if (*ptr2 == '.')
		    subfield = ptr2;
		ptr2++;
	    }
	    *ptr2 = '\0';
	    if (subfield == (char *) NULL)
		break;
	    *subfield++ = '\0';

	    /* get the format string */
	    while (*ptr1 == '\0' || *ptr1 == ' ' || *ptr1 == '\t')
		ptr1++;
	    if (*ptr1 == '\0')
		break;

	    /* convert to internal widget and resource */
	    w = XtNameToWidget (toplevel, argname);
	    if (w == (Widget) NULL)
		break;

	    ret_message = (XIpcMessage *) argname;
	    ret_message -> type = XIPC_SERVER_INTERPRETER_MESSAGE;

	    rc = ResourceToResourceType (XtClass (w), w,
					 XrmStringToQuark (subfield));

	    /* on failure assume it is a string */
	    ptr2 = XrmQuarkToString (rc);
	    if (rc == (XrmQuark) NULL ||
		strcmp (ptr2, "String") == 0)
	    {
		caddr_t x = (char *) -1;

		XtSetArg (args[0], subfield, &x);
		XtGetValues (w, args, 1);
		if (x == (char *) -1)
		    break;
		ptr2 = x;
	    }
	    else
		if (strcmp (ptr2, "Int") == 0)
		{
		    int x = 0;

		    XtSetArg (args[0], subfield, &x);
		    XtGetValues (w, args, 1);
		    sprintf (argvalue, "%d", x);
		    ptr2 = argvalue;
		}
		else
		    if (strcmp (ptr2, "Float") == 0)
		    {
			float xf = 0.0;

			XtSetArg (args[0], subfield, &xf);
			XtGetValues (w, args, 1);
			sprintf (argvalue, "%f", xf);
			ptr2 = argvalue;
		    }
		    else
		    {
			long x = 0;

			XtSetArg (args[0], subfield, &x);
			XtGetValues (w, args, 1);
			from_value.addr = (char *) &x;
			from_value.size = sizeof (x);
			XtConvert (w,
				   XrmQuarkToString (rc), &from_value,
				   XtRString, &to_value);
			if (to_value.size && to_value.addr)
			    ptr2 = (char *) *((long *)to_value.addr);
			else
			    break;
		    }
	    /* send the message back */
	    sprintf ((char *) ret_message -> buffer, ptr1, ptr2);
	    ret_message -> length = 
		strlen ((char *) ret_message -> buffer) + 1;
	    XIpcSendToServer (client, ret_message);
	    XSync (XtDisplay (toplevel), 0);
	    break;
	case XIPC_CLIENT_GETGEOMETRY: /* GetGeometry */
	    /* format */
	    ret_message = (XIpcMessage *) argname;
	    ret_message -> type = XIPC_SERVER_INTERPRETER_MESSAGE;
	    XtSetArg (args[0], XtNwidth, &x2);
	    XtSetArg (args[1], XtNheight, &y2);
	    XtGetValues (toplevel, args, 2);
	    XTranslateCoordinates(XtDisplay (toplevel),
				  XtWindow (toplevel),
				  RootWindow (XtDisplay (toplevel),
					      DefaultScreen (XtDisplay (toplevel))),
				  0, 0,	/* src x,y */
				  &x1, &y1,
				  (Window *) &ignore);
	    sprintf ((char *) ret_message -> buffer, 
		     (char *) message -> buffer,
		     x1, y1, x2, y2);
	    ret_message -> length = 
		strlen ((char *) ret_message -> buffer) + 1;
	    XIpcSendToServer (client, ret_message);
	    XSync (XtDisplay (toplevel), 0);
	    break;
	} /* switch () */
    } /* while () */
}

/*
 * recursively determine the type of a resource for a given widget
 */
static XrmQuark
ResourceToResourceType (widget_class, widget, name_quark)
WidgetClass widget_class;
register Widget widget;
register XrmQuark name_quark;
{
    XrmQuark type_quark = (XrmQuark) NULL;
    register XrmResourceList *list =
	(XrmResourceList *) widget_class -> core_class.resources;
    register int i;

    /* scan for this class in the core class */
    for (i = 0; i < widget_class -> core_class.num_resources; i++)
    {
	if ((XrmQuark) list[i] -> xrm_name == name_quark)
	    return (XrmQuark) list[i] -> xrm_type;
    }

    /* scan resource names for the superclass */
    if (widget_class->core_class.superclass != NULL)
	type_quark = ResourceToResourceType
	    (widget_class -> core_class.superclass, widget,
	     name_quark);

    return type_quark;
}
