#include "XIpc.h"

/*
 * sample client routine to test XIpc
 */
void
main (argc, argv)
int argc;
char **argv;
{
    static unsigned char local_buffer[XIPCBUFSIZ];
    static unsigned char read_buffer[XIPCBUFSIZ];
    XIpcMessage *lmessage = (XIpcMessage *) local_buffer;
    XIpcMessage *message;
    int i, start_length;
    int j;
    int rc;
    unsigned char *ptr;
    XIpcClient *client;

    if (argc != 2)
    {
	fprintf (stderr,
		 "usage: %s <initial message size in bytes>\n",
		 argv[0]);
	exit (1);
    }

    if ((client = XIpcSetupClient ((char *) NULL, (caddr_t) NULL,
				   (caddr_t) NULL)) == (XIpcClient *) NULL)
    {
	fprintf (stderr, "%s: Cannot establish ipc links.\n", argv[0]);
	exit (1);
    }

    XIpcSynchronize (client, FALSE);

    for (i = 0; i < XIPC_MAX_MESSAGE_SIZE; i++)
	lmessage -> buffer[i] = 'A' + (i & 037);

    lmessage -> type = XIPC_SERVER_PING;
    start_length = lmessage -> length = atoi (argv[1]);
    if (lmessage -> length < 0)
	lmessage -> length = 0;

    for (i = 0; i < 20; i++)
    {
	/*
	   printf ("loop send %d\n", i);
	   */
	lmessage -> buffer[0] = '0' + (i % 10);
	XIpcSendToServer (client, lmessage);
	if (i > 15)
	    XIpcFlushClient (client);
	lmessage -> length += 1;
    }

    XIpcSynchronize (client, TRUE);

    for (i = 0; i < 20; )
    {
	if (XIpcIsClientActive (client) == FALSE)
	{
	    fprintf (stderr, "lost the connection\n");
	    exit (1);
	}

	switch (XIpcClientMonitor (client, XIPC_MONITOR_BOTH, -1))
	{
	case XIPC_MONITOR_MESSAGES:
	    message = XIpcRecvFromServer (client);
	    if (message == (XIpcMessage *) NULL)
	    {
		fprintf (stderr, "NULL message\n");
		continue;
	    }
	    ptr = lmessage -> buffer;
	    *ptr = '0' + (i % 10);

	    if (i + start_length != message -> length)
		fprintf (stderr, "error loop:%d len=%d\n",
			 i, message -> length);

	    for (j = 0; j < message -> length; j++)
	    {
		if (message -> buffer[j] != ptr[j])
		{
		    XIpcPrintMessage (stderr, "error",
				      message);
		    fprintf (stderr,
			     "error loop %d at #=%d: %c %c\n",
			     i, j,
			     message -> buffer[j],
			     ptr[j]);
		    break;
		}
	    }
	    i++;
	    continue;
	case XIPC_MONITOR_KEYBOARD:
	    rc = read (0, read_buffer, XIPCBUFSIZ);
	    if (rc <= 0)
		continue;
	    read_buffer[rc] = '\0';
	    printf ("read from kbd: %s", read_buffer);
	    fflush (stdout);
	    continue;
	case XIPC_MONITOR_TIMEOUT:
	    fprintf (stderr, "timeout.\n");
	    continue;
	default:
	    /* possibly a property delete message */
	    continue;
	}
    }

    XIpcCloseClient (client);
}
