#include "XIpc.h"

/*
 * sample client routine to test XIpc
 */
main (argc, argv)
int argc;
char **argv;
{
    static unsigned char local_buffer[XIPCBUFSIZ];
    static unsigned char read_buffer[XIPCBUFSIZ];
    XIpcMessage *lmessage = (XIpcMessage *) local_buffer;
    XIpcMessage *message;
    int i;
    int j;
    int rc;
    int reps;
    unsigned char *ptr;
    XIpcClient *client;

    if (argc != 3)
    {
	fprintf (stderr,
		 "usage: %s <initial message size in bytes> <reps>\n",
		 argv[0]);
	exit (1);
    }

    if ((client = XIpcSetupClient ((char *) NULL, (caddr_t) NULL,
				   (caddr_t) NULL)) == (XIpcClient *) NULL)
    {
	fprintf (stderr, "%s: Cannot establish ipc links.\n", argv[0]);
	exit (1);
    }

    for (i = 0; i < XIPC_MAX_MESSAGE_SIZE; i++)
	lmessage -> buffer[i] = 'A' + (i & 037);

    lmessage -> type = XIPC_SERVER_PING;
    lmessage -> length = atoi (argv[1]);
    if (lmessage -> length < 0)
	lmessage -> length = 0;

    reps = atoi (argv[2]);
    for (i = 0; i < reps; i++)
    {
	lmessage -> buffer[0] = '0' + (i % 10);
	XIpcSendToServer (client, lmessage);
    }

    for (i = 0; i < reps; )
    {
	if (XIpcIsClientActive (client) == FALSE)
	{
	    fprintf (stderr, "lost the connection\n");
	    exit (1);
	}

	switch (XIpcClientMonitor (client, XIPC_MONITOR_MESSAGES, -1))
	{
	case XIPC_MONITOR_MESSAGES:
	    message = XIpcRecvFromServer (client);
	    if (message == (XIpcMessage *) NULL)
	    {
		fprintf (stderr, "NULL message\n");
		continue;
	    }
	    i++;
	    continue;
	default:
	    /* possibly a property delete message */
	    continue;
	}
    }

    XIpcCloseClient (client);
}
