#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/StringDefs.h>
#include <Xw/Xw.h>
#include <Xw/XwP.h>
#include <Form.h>
#include <PButton.h>
#include <Xw/Arrow.h>
#include <Valuator.h>
#include <ScrollBar.h>
#include <SWindow.h>
#include <SRaster.h>
#include "XIpc.h"

/*
 * Command line options data
 */
static XrmOptionDescRec options[] =
{
	{"-type",      "type",       XrmoptionSepArg, NULL},
	{"-t",         "type",       XrmoptionSepArg, NULL},
	{"-message",   "message",       XrmoptionSepArg, NULL},
	{"-m",         "message",       XrmoptionSepArg, NULL},
};

typedef struct
{
	int type;
	char *message;
} app_resourceRec, *app_res;

app_resourceRec app_resources;

static XtResource resources[] =
{
	{
		"type", "Type",
		XtRInt, sizeof (int),
	        XtOffset (app_res, type),
		XtRString, "132"
	},
	{
		"message", "Message",
		XtRString, sizeof (String),
	        XtOffset (app_res, message),
		XtRString, (caddr_t) NULL
	},
};

/*
 * Report the syntax
 */
Syntax (program_name)
char *program_name;
{
    fprintf (stderr,
	     "%s: usage\n  %s message\nor\n  %s -message message\n",
	     program_name, program_name, program_name);
    exit (1);
}

Widget toplevel;

void
main (argc, argv)
int argc;
char **argv;
{
    extern void AppMessage();
    extern void XtHandleIpcToClient ();
    Widget Form, Message, ScrolledWindow, Image;
    XtCallbackRec toll_call[2];
    Arg args[20];
    int screen;
    Display *display;
    XImage *image;
    int i;

    toplevel = XtInitialize (argv[0], "Test",
			     options, XtNumber (options),
			     &argc, argv);
	
    XtGetApplicationResources (toplevel, &app_resources,
			       resources, XtNumber (resources),
			       NULL, 0);
	
    if (app_resources.message == (char *) NULL)
    {
	if (argc != 2)
	    Syntax (argv[0]);
	else
	    app_resources.message = argv[1];
    }
	
    display = XtDisplay (toplevel);
    screen =  XDefaultScreen (display);
	
    image = XGetImage (display, RootWindow (display, screen),
		       0, 0,
		       128, 128,
		       AllPlanes,
		       (DefaultDepth (display, screen) > 1) ?
		       ZPixmap : XYPixmap);
    if (image == (XImage *) NULL)
    {
	fprintf (stderr, "%s: Could not get the screen image.\n",
		 argv[0]);
	exit (1);
    }

    Form = XtCreateManagedWidget ("Form", XwformWidgetClass,
				  toplevel, NULL, 0);

    i = 0;
    XtSetArg (args[i], XtNxRefWidget, Form); i++;
    XtSetArg (args[i], XtNyRefWidget, Form); i++;
    XtSetArg (args[i], XtNxResizable, TRUE); i++;
    XtSetArg (args[i], XtNyResizable, FALSE); i++;
    XtSetArg (args[i], XtNyOffset, 5); i++;
    XtSetArg (args[i], XtNhighlightThickness, 2); i++;
    XtSetArg (args[i], XtNtraversalType, XwHIGHLIGHT_ENTER); i++;
    XtSetArg (args[i], XtNlabel, "Message"); i++;
    toll_call[0].callback = (XtCallbackProc) AppMessage;
    toll_call[0].closure = NULL;
    toll_call[1].callback = (XtCallbackProc) NULL;
    toll_call[1].closure = NULL;
    XtSetArg (args[i], XtNrelease, toll_call); i++;
    Message = XtCreateManagedWidget ("Message", XwpushButtonWidgetClass,
				     Form, args, i);

    i = 0;
    XtSetArg (args[i], XtNxRefWidget, Form); i++;
    XtSetArg (args[i], XtNyRefWidget, Message); i++;
    XtSetArg (args[i], XtNyAddHeight, TRUE); i++;
    XtSetArg (args[i], XtNxResizable, TRUE); i++;
    XtSetArg (args[i], XtNyResizable, TRUE); i++;
    XtSetArg (args[i], XtNyOffset, 5); i++;
    XtSetArg (args[i], XtNxAttachRight, TRUE); i++;
    XtSetArg (args[i], XtNyAttachBottom, TRUE); i++;
    XtSetArg (args[i], XtNwidth, image -> width); i++;
    XtSetArg (args[i], XtNheight, image -> height); i++;
    ScrolledWindow = XtCreateManagedWidget ("ScrolledWindow",
					    XwswindowWidgetClass,
					    Form, args, i);

    i = 0;
    XtSetArg (args[i], XtNsRimage, image); i++;
    Image = XtCreateManagedWidget (argv[0],
				   XwsrasterWidgetClass,
				   ScrolledWindow,
				   args, i);
	
    XtRealizeWidget (toplevel);
	
    XtAddXIpc (toplevel, (char *) NULL, XtHandleIpcToClient);
	
    XtMainLoop ();
}

static void
AppMessage (w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    extern XIpcClient *XtXIpcClient ();
    static unsigned char local_buffer[XIPCBUFSIZ];
    XIpcMessage *message = (XIpcMessage *) local_buffer;
    XIpcClient *client = XtXIpcClient ();

    message -> type = XIPC_SERVER_PING;
    sprintf (message -> buffer, "%d,%s", app_resources.type,
	     app_resources.message);
    message -> length = strlen (message -> buffer);
    XIpcSendToServer (client, message);
}
