#include <stdio.h>
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include "tiffio.h"
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static
CVTOldToNewTiffFile C_P_ARGS((char *program_name,
			      char *filein, char *fileout));

C_PROTOS_END_EXTERN

void
main(argc, argv)
int argc;
char **argv;
{
    if (argc != 3)
    {
	fprintf (stderr,
		 "%s usage:\n\t%s <input filename> <output filename>\n",
		 argv[0], argv[0]);
	exit (1);
    }

    CVTOldToNewTiffFile (argv[0], argv[1], argv[2]);
}

static
CVTOldToNewTiffFile (program_name, filein, fileout)
char *program_name;
char *filein;
char *fileout;
{
    TIFF *in, *out;
    long width, height;
    unsigned short orient;
    unsigned short compress;
    unsigned short config;
    unsigned short photo;
    unsigned short bitspersample, samplesperpixel;
    unsigned short *rm, *gm, *bm;
    unsigned char *data;
    int i, j;

    in = TIFFOpen (filein, "r");
    if (in == NULL)
    {
	fprintf (stderr, "%s: Cannot open input file: %s.\n",
		 program_name, filein);
	return;
    }

    out = TIFFOpen (fileout, "w");
    if (out == NULL)
    {
	fprintf (stderr, "%s: Cannot open output file: %s.\n",
		 program_name, fileout);
	return;
    }

    TIFFGetField (in, TIFFTAG_IMAGEWIDTH, &width);
    TIFFGetField (in, TIFFTAG_IMAGELENGTH, &height);
    TIFFGetField (in, TIFFTAG_ORIENTATION, &orient);
    TIFFGetField (in, TIFFTAG_COMPRESSION, &compress);
    TIFFGetField (in, TIFFTAG_PLANARCONFIG, &config);

    TIFFSetField (out, TIFFTAG_IMAGEWIDTH, width);
    TIFFSetField (out, TIFFTAG_IMAGELENGTH, height);
    TIFFSetField (out, TIFFTAG_ORIENTATION, orient);
    TIFFSetField (out, TIFFTAG_COMPRESSION, compress);
    TIFFSetField (out, TIFFTAG_PLANARCONFIG, config);
    TIFFSetField (out, TIFFTAG_RESOLUTIONUNIT, RESUNIT_NONE);

    TIFFGetField (in, TIFFTAG_BITSPERSAMPLE, &bitspersample);
    TIFFGetField (in, TIFFTAG_SAMPLESPERPIXEL, &samplesperpixel);

    TIFFSetField (out, TIFFTAG_BITSPERSAMPLE, bitspersample);
    TIFFSetField (out, TIFFTAG_SAMPLESPERPIXEL, samplesperpixel);

    TIFFGetField (in, TIFFTAG_PHOTOMETRIC, &photo);
    if (TIFFGetField (in, TIFFTAG_COLORMAP, &rm, &gm, &bm) &&
	photo == PHOTOMETRIC_RGB && bitspersample <= 8 && samplesperpixel == 1)
	photo = PHOTOMETRIC_PALETTE;
    TIFFSetField (out, TIFFTAG_PHOTOMETRIC, photo);
    TIFFSetField (out, TIFFTAG_COLORMAP, rm, gm, bm);

    data = (unsigned char *) malloc (TIFFScanlineSize (in));

    for (i = 0; i < height; i++)
    {
	TIFFReadScanline (in, data, i, 0);
	TIFFWriteScanline (out, data, i, 0);
    }

    TIFFClose (in);
    TIFFClose (out);
}
