#include <stdio.h>
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <fcntl.h>
#include "tiffio.h"

#include "C_P_args.h"


struct targaheader
{
	char    textSize;
	char    mapType;
	char    dataType;
	unsigned short   mapOrig;
	unsigned short   mapLength;
	char    CMapBits;
	unsigned short   XOffset;
	unsigned short   YOffset;
	unsigned short   x;
	unsigned short   y;
	unsigned short   dataBits, imType;
} targaheader;

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static void
GetPicHeader C_P_ARGS((int fd, struct targaheader *header, char *idField));

static void
swap C_P_ARGS((unsigned short int *s));

C_PROTOS_END_EXTERN

#define OVERBLOWN_EXTRA		(4 * 1024)

void
main (argc, argv)
int     argc;
char  **argv;
{
	int fdi;
	int rc;
	unsigned char *io_buffer;
	unsigned short *ioptr;
	unsigned char *work_buffer;
	unsigned char *wptr;
	unsigned short short_pixel;
	struct targaheader header;
	char id[128];
	int i, j, length, overblown_length;
	TIFF *out;

	if (argc != 3)
	{
		fprintf (stderr,
			 "usage: %s <targa file name> <output file name>\n",
			 argv[0]);
		exit (1);
	}
	if ((fdi = open (argv[1], O_RDONLY)) == -1)
	{
		fprintf (stderr, "Cannot open the input file: %s.\n", argv[1]);
		exit (1);
	}

	GetPicHeader (fdi, &header, id);
	fprintf (stderr, "width=%d height=%d\n", header.x, header.y);
	length = header.x * header.y;
	overblown_length = length * 2 + OVERBLOWN_EXTRA;

	io_buffer = (unsigned char *) malloc (overblown_length +
					      length * 3);
	if (io_buffer == (unsigned char *) NULL)
	{
		fprintf (stderr,
			 "Cannot allocate space for reading in the image.\n");
		exit (1);
	}
	work_buffer = io_buffer + overblown_length;
	memset (io_buffer, (char) 0, overblown_length);

	if ((rc = read (fdi, io_buffer, overblown_length)) < 1)
	{
		fprintf (stderr, "Cannot read input file: %s.\n", argv[1]);
		exit (1);
	}
	if (rc != length * 2)
	{
		fprintf (stderr, "The file has the wrong length.\n");
		fprintf (stderr,
			 "We read in %d bytes when we asked for %d bytes.\n",
			 rc, header.x * header.y * 2);
		if (rc > overblown_length)
		{
			fprintf (stderr, "File is too long to read.\n");
			exit (1);
		}
	}

	close (fdi);

	ioptr = (unsigned short *) (&io_buffer[rc]);
	wptr = work_buffer;

	for (i = 0; i < (int) header.y; i++)
	{
		ioptr -= header.x;
		for (j = 0; j < (int) header.x; j++)
		{
			/*
			 * assume that the overlay bit is the least
			 * significant bit.
			 */
			short_pixel = *ioptr >> 1;
/*
			  short_pixel = *ioptr;
*/
			/*
			 * red
			 */
			*wptr++ = (short_pixel & ((1 << 5) - 1)) << 3;
			short_pixel >>= 5;
			/*
			 * green
			 */
			*wptr++ = (short_pixel & ((1 << 5) - 1)) << 3;
			short_pixel >>= 5;
			/*
			 * blue
			 */
			*wptr++ = (short_pixel & ((1 << 5) - 1)) << 3;
			ioptr++;
		}
		ioptr -= header.x;
	}

	out = TIFFOpen(argv[2], "w");
	if (out == NULL)
	{
		fprintf (stderr, "Cannot open output file: %s.\n", argv[2]);
		exit (1);
	}
	TIFFSetField (out, TIFFTAG_PLANARCONFIG, PLANARCONFIG_CONTIG);
	TIFFSetField (out, TIFFTAG_PHOTOMETRIC, PHOTOMETRIC_RGB);
	TIFFSetField (out, TIFFTAG_SAMPLESPERPIXEL, 3);
	TIFFSetField (out, TIFFTAG_BITSPERSAMPLE, 8);
	TIFFSetField (out, TIFFTAG_IMAGEWIDTH, header.x);
	TIFFSetField (out, TIFFTAG_IMAGELENGTH, header.y);

	wptr = work_buffer;
	for (i = 0; i < (int) header.y; i++)
	{
		TIFFWriteScanline (out, wptr, i, 0);
		wptr += header.x * 3;
	}

	TIFFClose (out);
}

static void
GetPicHeader (fd, header, idField)
int     fd;
struct targaheader     *header;
char   *idField;
{
	header -> textSize = 0;
	header -> mapType = 0;
	header -> dataType = 0;
	header -> CMapBits = 0;
	header -> dataBits = 0;
	header -> imType = 0;

	read (fd, &header -> textSize, 1);
	read (fd, &header -> mapType, 1);
	read (fd, &header -> dataType, 1);
	read (fd, &header -> mapOrig, 2);
	swap (&header -> mapOrig);
	read (fd, &header -> mapLength, 2);
	swap (&header -> mapLength);
	read (fd, &header -> CMapBits, 1);
	read (fd, &header -> XOffset, 2);
	swap (&header -> XOffset);
	read (fd, &header -> YOffset, 2);
	swap (&header -> YOffset);
	read (fd, &header -> x, 2);
	swap (&header -> x);
	read (fd, &header -> y, 2);
	swap (&header -> y);
	read (fd, &header -> dataBits, 1);
	read (fd, &header -> imType, 1);

 /* 
  * read in the idfield if address offset != 0
  */
	if (idField == 0)
	{
		if (header -> textSize > 0)
			lseek (fd, (long) header -> textSize, 1);
	}
	else
	{
		if (header -> textSize != 0)
			read (fd, idField, header -> textSize);
		else
			*idField = 0;
	}
}

static void
swap (s)
unsigned short int     *s;
{
	unsigned short int t = *s;

	*s = ((0377 & t) << 8) | (0377 & (t >> 8));
}
