/* static char TMNetP_h[] = "<%W%	%D% %T%>"; */
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#ifndef _XtNetP_h
#define _XtNetP_h

#ifdef OPENLOOK

#undef XtNlabelType
#undef XtCLabelType

#include <Xol/OpenLook.h>
#include <Xol/OpenLookP.h>
#include <Xol/PrimitiveP.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/XwP.h>
#endif /* HP_WIDGETS */

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/XmP.h>
#include <Xm/PrimitiveP.h>
#endif /* MOTIF */

typedef struct
{
	/* no new procedures */
	int place_holder;
} _place_holder;

typedef _place_holder NetClassPart;
typedef struct _NetClassRec
{
	CoreClassPart core_class;
#ifdef OPENLOOK
	PrimitiveClassPart primitive_class;
#endif /* OPENLOOK */
#ifdef HP_WIDGETS
	XwPrimitiveClassPart primitive_class;
#endif /* HP_WIDGETS */
#ifdef MOTIF
	XmPrimitiveClassPart primitive_class;
#endif /* MOTIF */
	NetClassPart net_class;
} NetClassRec;

typedef _place_holder NetResourcesClassPart;
typedef struct _NetResourcesClassRec
{
	CoreClassPart core_class;
#ifdef OPENLOOK
	PrimitiveClassPart primitive_class;
#endif /* OPENLOOK */
#ifdef HP_WIDGETS
	XwPrimitiveClassPart primitive_class;
#endif /* HP_WIDGETS */
#ifdef MOTIF
	XmPrimitiveClassPart primitive_class;
#endif /* MOTIF */
	NetClassPart net_class;
	NetResourcesClassPart netresources_class;
} NetResourcesClassRec;

typedef struct _NetPart
{
/*
 * public
 */
	Pixel symbolforeground;
	Pixel titleforeground;
	Pixel linkforeground;

	XFontStruct *symbolfont_struct;	/* font for node symbols */
	XFontStruct *titlefont_struct; /* font for node titles */

	netNode *nodelist;		/* node list */
	netNode **addnodes, **removenodes;
	netNodePtr **updatenodes;
	netLink *linklist;		/* link list */
	netLink **addlinks, **removelinks;
	netLinkPtr **updatelinks;
	netMapPolygon *mappolygons; /* map */
	Boolean polygons_as_lines;

	XtCallbackList netProcPoint;
	XtCallbackList netProcDrag;
	XtCallbackList netProcUpdate;

	int internal_theight;	/* text padding text for title */
	int internal_twidth;
	int internal_sheight;	/* text padding text for symbol */
	int internal_swidth;

	Boolean draw_titlebackground;
	Boolean draw_symbolbackground;
	Pixmap symbolbackground_pixmap;
	Pixmap titlebackground_pixmap;

	XImage *net_image;

	/* START HGK addition - 5/9/90 */
	caddr_t application_ptr;	/* application data */
	/* END HGK addition - 5/9/90 */

	Boolean do_updates; /* for quick updates - disable */
/*
 * private
 */
	GC gcsymbols;			/* a gc for drawing symbol names */
	GC gcsymbols_xor;
	GC gcsymbols_background;
	GC gctitles;			/* a gc for drawing node names */
	GC gctitles_xor;
	GC gctitles_background;
	GC gclinks;			/* a gc for drawing link lines */
	GC gclinks_xor;
	GC gcbackground;		/* a gc for drawing the background */

	Boolean second_pass;		/* gcs created flag */
	Boolean allocated_symbolfont;
	Boolean allocated_titlefont;

	netCallbackData action_data;

	netNode *Node_List;		/* node list */
	netLink *Link_List;		/* link list */
	netMapPolygon *Map_Polygons;	/* polygon list */
	XImage *Net_Image;		/* background image */

} NetPart;

typedef struct _NetRec
{
	CorePart core;
#ifdef OPENLOOK
	PrimitivePart	primitive;
#endif /* OPENLOOK */
#ifdef HP_WIDGETS
	XwPrimitivePart primitive;
#endif /* HP_WIDGETS */
#ifdef MOTIF
	XmPrimitivePart primitive;
#endif /* MOTIF */
	NetPart net;
} NetRec;

typedef _place_holder NetResourcesPart;
typedef struct _NetResourcesRec
{
	CorePart core;
#ifdef OPENLOOK
	PrimitivePart	primitive;
#endif /* OPENLOOK */
#ifdef HP_WIDGETS
	XwPrimitivePart primitive;
#endif /* HP_WIDGETS */
#ifdef MOTIF
	XmPrimitivePart primitive;
#endif /* MOTIF */
	NetPart net;
	NetResourcesPart netresources;
} NetResourcesRec;


#define	netConverterReturn(type, toVal, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->size = sizeof(type);			\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    return True;					\
	}

#define	netConverterReturnString(toVal, value, length)		\
	{							\
		toVal->size = length;				\
		toVal->addr = (caddr_t) value;			\
		return True;					\
	}

#endif /* _XtNetP_h */
